/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.reverseengineering.parsingfacilities;

import java.util.Stack;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.expression.ExpressionFactory;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.StateHandler;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ITokenDescriptor;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateHandlerController {
    private Stack<HandlerData> m_StateHandlers = new Stack();
    private boolean m_KeepRoots;
    private ETList<StateHandler> m_Roots = new ETArrayList<StateHandler>();

    public StateHandlerController() {
    }

    public StateHandlerController(boolean bl) {
        this.m_KeepRoots = bl;
    }

    public void addStateHandler(String string, String string2) {
        HandlerData handlerData = new HandlerData();
        handlerData.stateName = string;
        handlerData.language = string2;
        if (this.m_StateHandlers.size() > 0) {
            HandlerData handlerData2 = this.m_StateHandlers.peek();
            if (handlerData2.handler != null) {
                handlerData.handler = handlerData2.handler.createSubStateHandler(string, string2);
                if (handlerData.handler != handlerData2.handler && handlerData.handler != null) {
                    handlerData.handler.initialize();
                }
            }
            this.m_StateHandlers.push(handlerData);
        } else {
            handlerData.handler = ExpressionFactory.getExpressionForState(string, string2);
            if (handlerData.handler != null) {
                handlerData.handler.initialize();
                this.m_StateHandlers.push(handlerData);
            }
        }
        if (this.getKeepRoots() && handlerData.handler != null) {
            this.m_Roots.add(handlerData.handler);
        }
    }

    public void removeStateHandler(String string) {
        if (this.m_StateHandlers.size() > 0) {
            HandlerData handlerData = this.m_StateHandlers.pop();
            if (handlerData.handler != null) {
                handlerData.handler.stateComplete(string);
            }
        }
    }

    public void processToken(ITokenDescriptor iTokenDescriptor, String string) {
        if (this.m_StateHandlers.size() > 0) {
            HandlerData handlerData = this.m_StateHandlers.peek();
            if (handlerData.handler != null) {
                handlerData.handler.processToken(iTokenDescriptor, string);
            }
        }
    }

    public StateHandler getCurrentState() {
        return this.m_StateHandlers.size() > 0 ? this.m_StateHandlers.peek().handler : null;
    }

    public boolean getKeepRoots() {
        return this.m_KeepRoots;
    }

    public ETList<StateHandler> getRootStateHandlers() {
        return this.m_Roots;
    }

    public int getNumberOfStateHandlers() {
        return this.m_StateHandlers.size();
    }

    private static class HandlerData {
        public StateHandler handler;
        public String stateName;
        public String language;

        private HandlerData() {
        }
    }
}

