/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.generativeframework;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.dom4j.Document;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.generativeframework.Formatter;
import org.netbeans.modules.uml.core.generativeframework.IExpansionResult;
import org.netbeans.modules.uml.core.generativeframework.IExpansionVariable;
import org.netbeans.modules.uml.core.generativeframework.ITemplateManager;
import org.netbeans.modules.uml.core.generativeframework.IVariableExpander;
import org.netbeans.modules.uml.core.generativeframework.VariableKind;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableExpander
implements IVariableExpander {
    private String m_Config;
    private static Document m_ConfigDoc;
    private ITemplateManager m_Manager;
    private Stack<List<IExpansionVariable>> m_VarStack = new Stack();
    private boolean m_Gathering;

    @Override
    public String getConfigFile() {
        return this.m_Config;
    }

    @Override
    public void setConfigFile(String string) {
        this.m_Config = string;
    }

    protected void loadConfigFile() {
        if (m_ConfigDoc == null && this.m_Config != null) {
            m_ConfigDoc = XMLManip.getDOMDocument(this.m_Config);
        }
    }

    @Override
    public Node retrieveVarNode(String string) {
        this.loadConfigFile();
        if (m_ConfigDoc != null) {
            String string2 = "//ExpansionVar[@name=\"" + string + "\"]";
            Node node = m_ConfigDoc.selectSingleNode(string2);
            return node;
        }
        return null;
    }

    @Override
    public ITemplateManager getManager() {
        return this.m_Manager;
    }

    @Override
    public void setManager(ITemplateManager iTemplateManager) {
        this.m_Manager = iTemplateManager;
    }

    @Override
    public String expand(String string, IExpansionVariable iExpansionVariable, Node node) {
        String string2 = null;
        String string3 = iExpansionVariable.expand(node);
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string3 != null && string3.length() > 0) {
            String string4 = this.convertNewLines(string, string3);
            stringBuffer.append(string4);
            if (stringBuffer.length() > 0) {
                string2 = stringBuffer.toString();
            }
        }
        if (this.m_VarStack.size() > 0) {
            this.m_VarStack.peek().add(iExpansionVariable);
        }
        return string2;
    }

    private String convertNewLines(String string, String string2) {
        return Formatter.convertNewLines(string, string2);
    }

    @Override
    public void beginGathering() {
        this.m_VarStack.push(new ArrayList());
    }

    @Override
    public boolean endGathering() {
        boolean bl = false;
        if (this.m_VarStack.size() > 0) {
            List<IExpansionVariable> list = this.m_VarStack.pop();
            for (IExpansionVariable object : list) {
                String string = object.getResults();
                if (string != null && string.length() > 0) {
                    bl = true;
                    continue;
                }
                int n = object.getKind();
                if (n != VariableKind.VK_BOOLEAN) continue;
                bl = object.getIsTrue();
            }
            if (this.m_VarStack.size() > 0) {
                List<IExpansionVariable> list2 = this.m_VarStack.peek();
                Iterator<IExpansionVariable> iterator = list.iterator();
                while (iterator.hasNext()) {
                    list2.add(iterator.next());
                }
            }
        }
        return bl;
    }

    @Override
    public void addResult(IExpansionResult iExpansionResult) {
    }

    @Override
    public void removeResult(IExpansionResult iExpansionResult) {
    }

    @Override
    public void appendResults(ETList<IExpansionResult> eTList) {
    }

    @Override
    public ETList<IExpansionResult> getExpansionResults() {
        return null;
    }

    @Override
    public void setExpansionResults(ETList<IExpansionResult> eTList) {
    }
}

