/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.generativeframework;

import java.util.Stack;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.generativeframework.Formatter;
import org.netbeans.modules.uml.core.generativeframework.IExpansionVariable;
import org.netbeans.modules.uml.core.generativeframework.ITemplateManager;
import org.netbeans.modules.uml.core.generativeframework.IVariableExpander;
import org.netbeans.modules.uml.core.generativeframework.IVariableFactory;
import org.netbeans.modules.uml.core.generativeframework.VariableExpander;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;

public class ExpansionVarLocator {
    private static final int PS_OPTIONAL = 0;
    private static final int PS_GATHERING = 1;
    private static final int PS_COMMENT = 2;
    private static final int PS_ESCAPE = 3;
    private static final int PS_VAR = 4;
    private Stack<String> m_CurVar = new Stack();
    private Stack<Integer> m_State = new Stack();
    private int m_CurIndex;
    private IElement m_ContextElement;
    private Node m_ContextNode;
    private StringBuffer m_FinalResults = new StringBuffer();
    private String m_OrigBuffer;
    private ITemplateManager m_Manager;
    private String m_Filename;

    public ExpansionVarLocator(ITemplateManager iTemplateManager, String string, String string2, IElement iElement) {
        this.m_Manager = iTemplateManager;
        this.m_Filename = string;
        this.m_OrigBuffer = string2;
        this.m_ContextElement = iElement;
        if (this.m_ContextElement != null) {
            this.m_ContextNode = this.m_ContextElement.getNode();
        }
        this.initialize();
    }

    public ExpansionVarLocator(ITemplateManager iTemplateManager, String string, String string2, Node node) {
        this.m_Manager = iTemplateManager;
        this.m_Filename = string;
        this.m_OrigBuffer = string2;
        this.m_ContextNode = node;
        this.initialize();
    }

    private void initialize() {
        this.m_State.push(new Integer(1));
        this.establishContext();
    }

    private void establishContext() {
        IVariableFactory iVariableFactory = this.getFactory();
        if (iVariableFactory != null) {
            String string = this.m_Manager.getConfigLocation();
            VariableExpander variableExpander = new VariableExpander();
            variableExpander.setConfigFile(string);
            variableExpander.setManager(this.m_Manager);
            iVariableFactory.setExecutionContext(variableExpander);
        }
    }

    private IVariableFactory getFactory() {
        return this.m_Manager != null ? this.m_Manager.getFactory() : null;
    }

    public String expandVars() {
        int n = this.m_OrigBuffer.length();
        while (this.m_CurIndex < n) {
            char c = this.m_OrigBuffer.charAt(this.m_CurIndex);
            switch (c) {
                case '!': {
                    if (this.lookAhead() != '%') break;
                    this.gatherOptionalVar();
                    break;
                }
                case '/': {
                    if (this.lookAhead() == '%') {
                        this.gatherComment();
                        break;
                    }
                    this.appendResult(c);
                    break;
                }
                case '\\': {
                    char c2 = this.lookAhead();
                    if ("%!/\\".indexOf(c2) != -1) {
                        ++this.m_CurIndex;
                        this.appendResult(c2);
                        break;
                    }
                    this.appendResult(c);
                    break;
                }
                case '%': {
                    char c2 = this.lookAhead();
                    switch (this.m_State.peek()) {
                        case 1: {
                            if (c2 != '%') break;
                            this.gatherVar();
                            break;
                        }
                        case 4: {
                            if (c2 != '%') break;
                            this.popVar();
                            break;
                        }
                        case 0: {
                            if (c2 == '!') {
                                this.popOptionalVar();
                                break;
                            }
                            if (c2 != '%') break;
                            this.gatherVar();
                        }
                    }
                    break;
                }
                default: {
                    this.appendResult(c);
                }
            }
            ++this.m_CurIndex;
        }
        return this.m_FinalResults.toString();
    }

    private void gatherComment() {
        ++this.m_CurIndex;
        int n = this.m_OrigBuffer.indexOf(10, this.m_CurIndex);
        if (n == -1) {
            n = this.m_OrigBuffer.length() - 1;
        }
        this.m_CurIndex = n + 1;
    }

    private void gatherOptionalVar() {
        this.m_State.push(new Integer(0));
        this.m_CurVar.push("");
        IVariableExpander iVariableExpander = this.getExecutionContext();
        if (iVariableExpander != null) {
            iVariableExpander.beginGathering();
        }
        this.eatMarkers();
    }

    private char lookAhead() {
        int n = this.m_CurIndex + 1;
        return n < this.m_OrigBuffer.length() ? this.m_OrigBuffer.charAt(n) : (char)'\u0000';
    }

    private void setResult(String string) {
        if (this.m_CurVar.size() > 0) {
            this.m_CurVar.pop();
            this.m_CurVar.push(string);
        } else {
            this.m_FinalResults = new StringBuffer(string);
        }
    }

    private void gatherVar() {
        this.m_State.push(new Integer(4));
        this.m_CurVar.push("");
        this.eatMarkers();
    }

    private void eatMarkers() {
        ++this.m_CurIndex;
    }

    private void popOptionalVar() {
        this.m_State.pop();
        ++this.m_CurIndex;
        String string = this.m_CurVar.pop();
        IVariableExpander iVariableExpander = this.getExecutionContext();
        if (iVariableExpander != null) {
            if (iVariableExpander.endGathering()) {
                this.appendResult(string);
            }
        } else {
            this.appendResult(string);
        }
    }

    private void popVar() {
        this.m_State.pop();
        ++this.m_CurIndex;
        String string = this.m_CurVar.pop();
        this.expandVariable(string);
    }

    private void expandVariable(String string) {
        String string2;
        String string3;
        IVariableExpander iVariableExpander;
        IExpansionVariable iExpansionVariable;
        IVariableFactory iVariableFactory;
        if (string != null && string.length() > 0 && this.m_Manager != null && (iVariableFactory = this.m_Manager.getFactory()) != null && (iExpansionVariable = iVariableFactory.createVariableWithText(string)) != null && (iVariableExpander = iVariableFactory.getExecutionContext()) != null && (string3 = iVariableExpander.expand(string2 = this.retrieveGatheredText(), iExpansionVariable, this.m_ContextNode)) != null && string3.length() > 0) {
            this.setResult(string3);
        }
    }

    private String retrieveGatheredText() {
        return this.m_CurVar.size() > 0 ? this.m_CurVar.peek() : this.m_FinalResults.toString();
    }

    private IVariableExpander getExecutionContext() {
        if (this.m_Manager != null) {
            IVariableFactory iVariableFactory = this.m_Manager.getFactory();
            return iVariableFactory != null ? iVariableFactory.getExecutionContext() : null;
        }
        return null;
    }

    private void appendResult(char c) {
        if (this.m_CurVar.size() > 0) {
            this.m_CurVar.push(this.m_CurVar.pop() + c);
        } else {
            this.m_FinalResults.append(c);
        }
    }

    private void appendResult(String string) {
        if (this.m_CurVar.size() > 0) {
            this.m_CurVar.push(Formatter.convertNewLines(this.m_CurVar.pop(), string));
        } else {
            this.m_FinalResults.append(Formatter.convertNewLines(this.m_FinalResults.toString(), string));
        }
    }

    public ITemplateManager getManager() {
        return this.m_Manager;
    }
}

