/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.coreapplication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.netbeans.modules.uml.core.coreapplication.IDesignCenterManager;
import org.netbeans.modules.uml.core.coreapplication.IDesignCenterSupport;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class DesignCenterManager
implements IDesignCenterManager {
    private HashMap<String, IDesignCenterSupport> mAddins = new HashMap();

    public DesignCenterManager() {
        this.initialize();
    }

    public void initialize() {
        IDesignCenterSupport[] iDesignCenterSupportArray;
        for (IDesignCenterSupport iDesignCenterSupport : iDesignCenterSupportArray = this.getDesignCenterAddins()) {
            String string = iDesignCenterSupport.getID();
            this.mAddins.put(string, iDesignCenterSupport);
        }
    }

    public IDesignCenterSupport[] getAddIns() {
        IDesignCenterSupport[] iDesignCenterSupportArray = null;
        Collection<IDesignCenterSupport> collection = this.mAddins.values();
        if (collection.size() > 0) {
            iDesignCenterSupportArray = new IDesignCenterSupport[collection.size()];
            collection.toArray(iDesignCenterSupportArray);
        } else {
            iDesignCenterSupportArray = new IDesignCenterSupport[]{};
        }
        return iDesignCenterSupportArray;
    }

    public IDesignCenterSupport getDesignCenterAddIn(String string) {
        IDesignCenterSupport iDesignCenterSupport = this.mAddins.get(string);
        if (iDesignCenterSupport != null && iDesignCenterSupport instanceof IDesignCenterSupport) {
            return iDesignCenterSupport;
        }
        return null;
    }

    protected IDesignCenterSupport[] getDesignCenterAddins() {
        return this.getAddinsFromRegistry("UML/designcenter");
    }

    protected IDesignCenterSupport[] getAddinsFromRegistry(String string) {
        IDesignCenterSupport[] iDesignCenterSupportArray;
        ArrayList<IDesignCenterSupport> arrayList = new ArrayList<IDesignCenterSupport>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        try {
            if (fileSystem != null && (iDesignCenterSupportArray = fileSystem.findResource(string)) != null) {
                FileObject[] fileObjectArray;
                for (FileObject fileObject : fileObjectArray = iDesignCenterSupportArray.getChildren()) {
                    try {
                        Object object;
                        InstanceCookie instanceCookie;
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        if (dataObject == null || (instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class)) == null || !((object = instanceCookie.instanceCreate()) instanceof IDesignCenterSupport)) continue;
                        arrayList.add((IDesignCenterSupport)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iDesignCenterSupportArray = new IDesignCenterSupport[arrayList.size()];
        arrayList.toArray(iDesignCenterSupportArray);
        return iDesignCenterSupportArray;
    }
}

