/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.diff.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HuntDiff {
    private HuntDiff() {
    }

    public static Difference[] diff(String[] stringArray, String[] stringArray2, boolean bl) {
        int n = stringArray.length;
        int n2 = stringArray2.length;
        String[] stringArray3 = stringArray;
        String[] stringArray4 = stringArray2;
        if (bl) {
            int n3;
            stringArray = new String[stringArray3.length];
            stringArray2 = new String[stringArray4.length];
            for (n3 = 0; n3 < stringArray3.length; ++n3) {
                stringArray[n3] = stringArray3[n3].trim();
            }
            for (n3 = 0; n3 < stringArray4.length; ++n3) {
                stringArray2[n3] = stringArray4[n3].trim();
            }
        }
        Line[] lineArray = new Line[n2 + 1];
        for (int i = 1; i <= n2; ++i) {
            lineArray[i] = new Line(i, stringArray2[i - 1]);
        }
        Arrays.sort(lineArray, 1, n2 + 1, new Comparator<Line>(){

            @Override
            public int compare(Line line, Line line2) {
                return line.line.compareTo(line2.line);
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        int[] nArray = new int[n2 + 1];
        boolean[] blArray = new boolean[n2 + 1];
        for (int i = 1; i <= n2; ++i) {
            Line line = lineArray[i];
            nArray[i] = line.lineNo;
            blArray[i] = i == n2 || !line.line.equals(lineArray[i + 1].line);
        }
        nArray[0] = 0;
        blArray[0] = true;
        int[] nArray2 = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            nArray2[i] = HuntDiff.findAssoc(stringArray[i - 1], lineArray, blArray);
        }
        lineArray = null;
        Candidate[] candidateArray = new Candidate[Math.min(n, n2) + 2];
        candidateArray[0] = new Candidate(0, 0, null);
        candidateArray[1] = new Candidate(n + 1, n2 + 1, null);
        int n4 = 0;
        for (int i = 1; i <= n; ++i) {
            if (nArray2[i] == 0) continue;
            n4 = HuntDiff.merge(candidateArray, n4, i, nArray, blArray, nArray2[i]);
        }
        int[] nArray3 = new int[n + 2];
        Candidate candidate = candidateArray[n4];
        while (candidate != null) {
            nArray3[((Candidate)candidate).a] = candidate.b;
            candidate = candidate.c;
        }
        List<Difference> list = HuntDiff.getDifferences(nArray3, stringArray3, stringArray4);
        HuntDiff.cleanup(list);
        return list.toArray(new Difference[0]);
    }

    private static int findAssoc(String string, Line[] lineArray, boolean[] blArray) {
        int n = HuntDiff.binarySearch(lineArray, string, 1, lineArray.length - 1);
        if (n < 1) {
            return 0;
        }
        int n2 = 0;
        while (n >= 1 && lineArray[n].line.equals(string)) {
            if (blArray[n - 1]) {
                n2 = n;
            }
            --n;
        }
        return n2;
    }

    private static int binarySearch(Line[] lineArray, String string, int n, int n2) {
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            String string2 = lineArray[n3].line;
            int n4 = string2.compareTo(string);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static int binarySearch(Candidate[] candidateArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = candidateArray[n4].b;
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    private static int merge(Candidate[] candidateArray, int n, int n2, int[] nArray, boolean[] blArray, int n3) {
        int n4 = 0;
        Candidate candidate = candidateArray[0];
        while (true) {
            int n5;
            int n6;
            if ((n6 = HuntDiff.binarySearch(candidateArray, n5 = nArray[n3], n4, n)) >= 0) {
                n6 = n + 1;
            } else if ((n6 = -n6 - 2) < n4 || n6 > n) {
                n6 = n + 1;
            }
            if (n6 <= n) {
                if (candidateArray[n6 + 1].b > n5) {
                    Candidate candidate2 = new Candidate(n2, n5, candidateArray[n6]);
                    candidateArray[n4] = candidate;
                    n4 = n6 + 1;
                    candidate = candidate2;
                }
                if (n6 == n) {
                    candidateArray[n + 2] = candidateArray[n + 1];
                    ++n;
                    break;
                }
            }
            if (blArray[n3]) break;
            ++n3;
        }
        candidateArray[n4] = candidate;
        return n;
    }

    private static List<Difference> getDifferences(int[] nArray, String[] stringArray, String[] stringArray2) {
        int n;
        AbstractStringBuilder abstractStringBuilder;
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        int n4 = 1;
        int n5 = 1;
        while (true) {
            if (n4 <= n2 && nArray[n4] == n5) {
                ++n4;
                ++n5;
                continue;
            }
            if (n4 > n2) break;
            if (nArray[n4] < n5) {
                abstractStringBuilder = new StringBuffer();
                ((StringBuffer)abstractStringBuilder).append(stringArray[n4 - 1]).append('\n');
                for (n = n4 + 1; n <= n2 && nArray[n] < n5; ++n) {
                    String string = stringArray[n - 1];
                    ((StringBuffer)abstractStringBuilder).append(string).append('\n');
                }
                arrayList.add(new Difference(0, n4, n - 1, n5 - 1, 0, ((StringBuffer)abstractStringBuilder).toString(), null));
                n4 = n;
            } else {
                n = nArray[n4];
                abstractStringBuilder = new StringBuffer();
                for (int i = n5; i < n; ++i) {
                    String string = stringArray2[i - 1];
                    ((StringBuffer)abstractStringBuilder).append(string).append('\n');
                }
                arrayList.add(new Difference(1, n4 - 1, 0, n5, n - 1, null, ((StringBuffer)abstractStringBuilder).toString()));
                n5 = n;
            }
            if (n4 > n2) break;
        }
        if (n5 <= n3) {
            abstractStringBuilder = new StringBuilder();
            ((StringBuilder)abstractStringBuilder).append(stringArray2[n5 - 1]).append('\n');
            for (n = n5 + 1; n <= n3; ++n) {
                String string = stringArray2[n - 1];
                ((StringBuilder)abstractStringBuilder).append(string).append('\n');
            }
            arrayList.add(new Difference(1, n2, 0, n5, n3, null, ((StringBuilder)abstractStringBuilder).toString()));
        }
        return arrayList;
    }

    private static void cleanup(List<Difference> list) {
        Difference difference = null;
        for (int i = 0; i < list.size(); ++i) {
            Difference difference2 = list.get(i);
            if (difference != null && (difference2.getType() == 1 && difference.getType() == 0 || difference2.getType() == 0 && difference.getType() == 1)) {
                Difference difference3;
                Difference difference4;
                if (1 == difference2.getType()) {
                    difference4 = difference2;
                    difference3 = difference;
                } else {
                    difference4 = difference;
                    difference3 = difference2;
                }
                int n = difference4.getFirstStart() - (difference3.getFirstEnd() - difference3.getFirstStart());
                int n2 = difference3.getFirstStart();
                if (n == n2) {
                    Difference difference5 = new Difference(2, n, difference3.getFirstEnd(), difference4.getSecondStart(), difference4.getSecondEnd(), difference3.getFirstText(), difference4.getSecondText());
                    list.set(i - 1, difference5);
                    list.remove(i);
                    --i;
                    difference2 = difference5;
                }
            }
            difference = difference2;
        }
    }

    private static class Candidate {
        private int a;
        private int b;
        private Candidate c;

        public Candidate(int n, int n2, Candidate candidate) {
            this.a = n;
            this.b = n2;
            this.c = candidate;
        }
    }

    private static class Line {
        public int lineNo;
        public String line;
        public int hash;

        public Line(int n, String string) {
            this.lineNo = n;
            this.line = string;
            this.hash = string.hashCode();
        }
    }
}

