/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

public class UIDManager {
    private final UIDStorage storage;
    private static final int UID_MANAGER_DEFAULT_CAPACITY = 1024;
    private static final int UID_MANAGER_DEFAULT_SLICED_NUMBER = 29;
    private static final UIDManager instance = new UIDManager();
    private final String lock = new String("lock in UIDManager");

    private UIDManager() {
        this.storage = new UIDStorage(29, 1024);
    }

    public static UIDManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID getSharedUID(CsmUID csmUID) {
        if (csmUID == null) {
            throw new NullPointerException("null string is illegal to share");
        }
        CsmUID csmUID2 = null;
        String string = this.lock;
        synchronized (string) {
            csmUID2 = this.storage.getSharedUID(csmUID);
        }
        assert (csmUID2 != null);
        assert (csmUID2.equals(csmUID));
        return csmUID2;
    }

    public final void dispose() {
        this.storage.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UIDStorage {
        private final WeakSharedSet<CsmUID>[] instances;
        private final int sliceNumber;
        private final int initialCapacity;

        private UIDStorage(int n, int n2) {
            this.sliceNumber = n;
            this.initialCapacity = n2;
            this.instances = new WeakSharedSet[n];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new WeakSharedSet(n2);
            }
        }

        private WeakSharedSet<CsmUID> getDelegate(CsmUID csmUID) {
            int n = csmUID.hashCode() % this.sliceNumber;
            if (n < 0) {
                n += this.sliceNumber;
            }
            return this.instances[n];
        }

        public final CsmUID getSharedUID(CsmUID csmUID) {
            return (CsmUID)this.getDelegate(csmUID).addOrGet((Object)csmUID);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                this.instances[i].clear();
                this.instances[i].resize(this.initialCapacity);
            }
        }
    }
}

