/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.modelimpl.cache.CacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.impl.services.ReferenceRepositoryImpl;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModel;
import org.netbeans.modules.cnd.modelimpl.trace.XRefResultSet;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.filesystems.FileUtil;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceXRef
extends TraceModel {
    private String refFile = "";
    private String declarationName = "";
    private int line = 0;
    private int column = 0;
    public static final Comparator<CsmOffsetable> FILE_NAME_START_OFFSET_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            CharSequence charSequence;
            if (object == object2) {
                return 0;
            }
            CsmOffsetable csmOffsetable = (CsmOffsetable)object;
            CsmOffsetable csmOffsetable2 = (CsmOffsetable)object2;
            CharSequence charSequence2 = csmOffsetable.getContainingFile().getAbsolutePath();
            int n = CharSequenceKey.Comparator.compare(charSequence2, charSequence = csmOffsetable2.getContainingFile().getAbsolutePath());
            if (n == 0) {
                int n2 = csmOffsetable.getStartOffset();
                int n3 = csmOffsetable2.getStartOffset();
                n = n2 - n3;
            }
            return n;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return 11;
        }
    };

    public static void main(String[] stringArray) {
        TraceXRef.setUp();
        TraceXRef traceXRef = new TraceXRef();
        traceXRef.test(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(String[] stringArray) {
        try {
            CsmObject csmObject;
            Object object;
            ReferenceRepositoryImpl referenceRepositoryImpl;
            this.processArguments(stringArray);
            this.doTest();
            long l = 0L;
            if (super.isShowTime()) {
                l = System.currentTimeMillis();
            }
            CsmDeclaration csmDeclaration = null;
            if (this.declarationName.length() > 0) {
                System.err.println("looking for object with name: " + this.declarationName);
                csmDeclaration = super.getProject().findDeclaration(this.declarationName);
                if (csmDeclaration == null) {
                    System.err.println("No object with name " + this.declarationName + " in model");
                }
            } else if (this.refFile.length() > 0 && this.line > 0 && this.column > 0) {
                System.out.println("looking for object on position: line=" + this.line + " column=" + this.column);
                System.out.println("in file:" + this.refFile);
                referenceRepositoryImpl = this.getCsmFile(this.refFile);
                if (!(referenceRepositoryImpl instanceof FileImpl)) {
                    System.err.println("No CsmFile was found with name: " + this.refFile);
                } else {
                    object = (FileImpl)((Object)referenceRepositoryImpl);
                    int n = ((FileImpl)object).getOffset(this.line, this.column);
                    if (n < 0) {
                        System.err.println("incorrect offset for position line=" + this.line + " col=" + this.column);
                    } else {
                        csmObject = CsmReferenceResolver.getDefault().findReference((CsmFile)object, n);
                        if (csmObject == null) {
                            System.err.println("no any references were found on position line=" + this.line + " col=" + this.column);
                        } else {
                            csmDeclaration = csmObject.getReferencedObject();
                        }
                    }
                }
            } else {
                System.err.println("To run xref tests start script with parameter:");
                System.err.println("should be --xref#file_path#1_based_line#1_based_column or --xref#name");
            }
            if (csmDeclaration == null) {
                System.out.println("Nothing to search");
            } else {
                System.out.println("TARGET OBJECT IS\n  " + CsmTracer.toString((CsmObject)csmDeclaration));
                if (CsmKindUtilities.isNamedElement((CsmObject)csmDeclaration)) {
                    System.out.println("NAME IS: " + ((CsmNamedElement)csmDeclaration).getName());
                }
                if (CsmKindUtilities.isDeclaration((CsmObject)csmDeclaration)) {
                    System.out.println("UNIQUE NAME IS: " + csmDeclaration.getUniqueName());
                }
                referenceRepositoryImpl = new ReferenceRepositoryImpl();
                object = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmDeclaration, (boolean)true);
                CsmObject csmObject2 = object[0];
                csmObject = object[1];
                Collection<CsmReference> collection = referenceRepositoryImpl.getReferences(csmObject2, (CsmProject)this.getProject(), (EnumSet<CsmReferenceKind>)CsmReferenceKind.ALL);
                if (super.isShowTime()) {
                    l = System.currentTimeMillis() - l;
                }
                TraceXRef.traceRefs(collection, csmObject2, csmObject, System.out);
                if (super.isShowTime()) {
                    System.out.println("search took " + l + "ms");
                }
            }
        }
        finally {
            super.shutdown();
            if (TraceFlags.USE_AST_CACHE) {
                CacheManager.getInstance().close();
            } else {
                APTDriver.getInstance().close();
            }
        }
    }

    private static void setUp() {
        FileUtil.setMIMEType((String)"cc", (String)"text/x-c++");
        FileUtil.setMIMEType((String)"h", (String)"text/x-c++");
        FileUtil.setMIMEType((String)"c", (String)"text/x-c");
        JEditorPane.registerEditorKitForContentType("text/x-c++", "org.netbeans.modules.cnd.editor.cplusplus.CCKit");
        JEditorPane.registerEditorKitForContentType("text/x-c", "org.netbeans.modules.cnd.editor.cplusplus.CKit");
    }

    private CsmFile getCsmFile(String string) {
        return super.getProject().findFile(new File(string).getAbsolutePath());
    }

    @Override
    protected boolean processFlag(String string) {
        String string2 = "xref";
        if (string.startsWith(string2)) {
            String[] stringArray = string.split("#");
            boolean bl = false;
            if (stringArray.length == 2) {
                this.declarationName = stringArray[1];
                bl = this.declarationName == null || this.declarationName.length() == 0;
            } else if (stringArray.length == 4) {
                this.refFile = stringArray[1];
                try {
                    this.line = Integer.parseInt(stringArray[2]);
                    this.column = Integer.parseInt(stringArray[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    DiagnosticExceptoins.register(numberFormatException);
                    this.line = 0;
                    this.column = 0;
                }
                boolean bl2 = bl = this.refFile == null || this.refFile.length() == 0 || this.line <= 0 || this.column <= 0;
            }
            if (bl) {
                this.declarationName = "";
                this.refFile = "";
                System.err.println("unexpected parameter " + string);
                System.err.println("should be --xref#file_path#1_based_line#1_based_column or --xref#name");
            }
            return true;
        }
        return false;
    }

    public static void traceProjectRefsStatistics(NativeProject nativeProject, PrintWriter printWriter, OutputWriter outputWriter, CsmProgressListener csmProgressListener) {
        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject);
        XRefResultSet xRefResultSet = new XRefResultSet();
        Collection collection = csmProject.getAllFiles();
        if (csmProgressListener != null) {
            csmProgressListener.projectFilesCounted(csmProject, collection.size());
        }
        for (CsmFile csmFile : collection) {
            if (csmProgressListener != null) {
                csmProgressListener.fileParsingStarted(csmFile);
            }
            TraceXRef.analyzeFile(csmFile, xRefResultSet, printWriter, outputWriter);
        }
        if (csmProgressListener != null) {
            csmProgressListener.projectParsingFinished(csmProject);
        }
        TraceXRef.traceStatistics(xRefResultSet, printWriter);
    }

    public static void traceRefs(Collection<CsmReference> collection, CsmObject csmObject, PrintStream printStream) {
        assert (csmObject != null);
        CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject, (boolean)true);
        CsmObject csmObject2 = csmObjectArray[0];
        CsmObject csmObject3 = csmObjectArray[1];
        assert (csmObject2 != null);
        TraceXRef.traceRefs(collection, csmObject2, csmObject3, printStream);
    }

    public static void traceRefs(Collection<CsmReference> collection, CsmObject csmObject, CsmObject csmObject2, PrintStream printStream) {
        if (collection.size() == 0) {
            printStream.println("REFERENCES ARE NOT FOUND");
        } else {
            printStream.println("REFERENCES ARE:");
            collection = TraceXRef.sortRefs(collection);
            for (CsmReference csmReference : collection) {
                printStream.println(TraceXRef.toString(csmReference, csmObject, csmObject2));
            }
        }
    }

    public static String toString(CsmReference csmReference, CsmObject csmObject, CsmObject csmObject2) {
        String string;
        String string2 = CsmTracer.getOffsetString((CsmObject)csmReference, (boolean)true);
        CsmReferenceKind csmReferenceKind = csmReference.getKind();
        if (csmReferenceKind == CsmReferenceKind.DECLARATION) {
            string = " (DECLARATION)";
        } else if (csmReferenceKind == CsmReferenceKind.DEFINITION) {
            string = " (DEFINITION)";
        } else if (CsmReferenceKind.ANY_USAGE.contains(csmReferenceKind)) {
            string = "";
        } else {
            System.err.println("unknown reference kind " + csmReferenceKind + " for " + csmReference);
            string = "";
        }
        return string2 + string;
    }

    public static Collection<CsmReference> sortRefs(Collection<CsmReference> collection) {
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(collection);
        Collections.sort(arrayList, FILE_NAME_START_OFFSET_COMPARATOR);
        return arrayList;
    }

    private static void analyzeFile(CsmFile csmFile, XRefResultSet xRefResultSet, PrintWriter printWriter, OutputWriter outputWriter) {
        long l = System.currentTimeMillis();
        TraceXRef.visitDeclarations(csmFile.getDeclarations(), xRefResultSet, printWriter, outputWriter);
        l = System.currentTimeMillis() - l;
        printWriter.println(csmFile.getAbsolutePath() + " took " + l + "ms");
    }

    private static void visitDeclarations(Collection<? extends CsmOffsetableDeclaration> collection, XRefResultSet xRefResultSet, PrintWriter printWriter, OutputWriter outputWriter) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
                TraceXRef.handleFunctionDefinition((CsmFunctionDefinition)csmOffsetableDeclaration, xRefResultSet, printWriter, outputWriter);
                continue;
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
                TraceXRef.visitDeclarations(((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), xRefResultSet, printWriter, outputWriter);
                continue;
            }
            if (!CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) continue;
            TraceXRef.visitDeclarations(((CsmClass)csmOffsetableDeclaration).getMembers(), xRefResultSet, printWriter, outputWriter);
        }
    }

    private static void handleFunctionDefinition(CsmFunctionDefinition csmFunctionDefinition, final XRefResultSet xRefResultSet, final PrintWriter printWriter, final OutputWriter outputWriter) {
        CsmCompoundStatement csmCompoundStatement = csmFunctionDefinition.getBody();
        if (csmCompoundStatement != null) {
            final XRefResultSet.ContextScope contextScope = TraceXRef.classifyFunctionScope((CsmFunction)csmFunctionDefinition, printWriter);
            final ObjectContext<CsmFunctionDefinition> objectContext = TraceXRef.createContextObject(csmFunctionDefinition, printWriter);
            final HashSet hashSet = new HashSet();
            xRefResultSet.incrementScopeCounter(contextScope);
            CsmFileReferences.getDefault().accept((CsmScope)csmCompoundStatement, new CsmFileReferences.Visitor(){

                public void visit(CsmReference csmReference) {
                    XRefResultSet.ContextEntry contextEntry = TraceXRef.createEntry(hashSet, csmReference, objectContext, printWriter, outputWriter);
                    if (contextEntry != null) {
                        xRefResultSet.addEntry(contextScope, contextEntry);
                    }
                }
            }, EnumSet.of(CsmReferenceKind.DIRECT_USAGE));
        } else {
            printWriter.println("function definition without body " + csmFunctionDefinition);
        }
    }

    private static XRefResultSet.ContextEntry createEntry(Set<CsmObject> set, CsmReference csmReference, ObjectContext<CsmFunctionDefinition> objectContext, PrintWriter printWriter, OutputWriter outputWriter) {
        XRefResultSet.ContextEntry contextEntry;
        CsmObject csmObject = csmReference.getReferencedObject();
        if (csmObject == null) {
            contextEntry = XRefResultSet.ContextEntry.UNRESOLVED;
            try {
                outputWriter.println("UNRESOLVED:" + csmReference, (OutputListener)new RefLink(csmReference), true);
            }
            catch (IOException iOException) {}
        } else {
            CsmReferenceKind csmReferenceKind = csmReference.getKind();
            if (csmReferenceKind == CsmReferenceKind.DIRECT_USAGE) {
                XRefResultSet.DeclarationKind declarationKind = TraceXRef.classifyDeclaration(csmObject, printWriter);
                XRefResultSet.DeclarationScope declarationScope = TraceXRef.classifyDeclarationScopeForFunction(declarationKind, csmObject, objectContext, printWriter);
                XRefResultSet.IncludeLevel includeLevel = TraceXRef.classifyIncludeLevel(csmObject, ((ObjectContext)objectContext).objFile, printWriter);
                XRefResultSet.UsageStatistics usageStatistics = XRefResultSet.UsageStatistics.FIRST_USAGE;
                if (set.contains(csmObject)) {
                    usageStatistics = XRefResultSet.UsageStatistics.NEXT_USAGE;
                } else {
                    set.add(csmObject);
                }
                contextEntry = new XRefResultSet.ContextEntry(declarationKind, declarationScope, includeLevel, usageStatistics);
            } else {
                contextEntry = null;
            }
        }
        return contextEntry;
    }

    private static XRefResultSet.ContextScope classifyFunctionScope(CsmFunction csmFunction, PrintWriter printWriter) {
        assert (csmFunction != null);
        XRefResultSet.ContextScope contextScope = XRefResultSet.ContextScope.UNRESOLVED;
        CsmScope csmScope = csmFunction.getScope();
        if (csmScope == null) {
            printWriter.println("ERROR: no scope for function " + csmFunction);
            return contextScope;
        }
        if (CsmKindUtilities.isConstructor((CsmObject)csmFunction)) {
            contextScope = CsmBaseUtilities.isInlineFunction((CsmFunction)csmFunction) ? XRefResultSet.ContextScope.INLINED_CONSTRUCTOR : XRefResultSet.ContextScope.CONSTRUCTOR;
        } else if (CsmKindUtilities.isMethod((CsmObject)csmFunction)) {
            contextScope = CsmBaseUtilities.isInlineFunction((CsmFunction)csmFunction) ? XRefResultSet.ContextScope.INLINED_METHOD : XRefResultSet.ContextScope.METHOD;
        } else if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            contextScope = XRefResultSet.ContextScope.FILE_LOCAL_FUNCTION;
        } else {
            CsmNamespace csmNamespace = CsmBaseUtilities.getFunctionNamespace((CsmFunction)csmFunction);
            if (csmNamespace != null) {
                XRefResultSet.ContextScope contextScope2 = contextScope = csmNamespace.isGlobal() ? XRefResultSet.ContextScope.GLOBAL_FUNCTION : XRefResultSet.ContextScope.NAMESPACE_FUNCTION;
            }
        }
        if (contextScope == XRefResultSet.ContextScope.UNRESOLVED) {
            printWriter.println("ERROR: non classified function " + csmFunction);
        }
        return contextScope;
    }

    private static XRefResultSet.DeclarationKind classifyDeclaration(CsmObject csmObject, PrintWriter printWriter) {
        XRefResultSet.DeclarationKind declarationKind = XRefResultSet.DeclarationKind.UNRESOLVED;
        if (CsmKindUtilities.isClassifier((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.CLASSIFIER;
        } else if (CsmKindUtilities.isEnumerator((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.ENUMERATOR;
        } else if (CsmKindUtilities.isParamVariable((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.PARAMETER;
        } else if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.VARIABLE;
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.FUNCTION;
        } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.NAMESPACE;
        } else if (CsmKindUtilities.isMacro((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.MACRO;
        } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObject)) {
            declarationKind = XRefResultSet.DeclarationKind.CLASS_FORWARD;
        } else if (csmObject != null) {
            printWriter.println("ERROR: non classified declaration " + csmObject);
        }
        return declarationKind;
    }

    private static XRefResultSet.IncludeLevel classifyIncludeLevel(CsmObject csmObject, CsmFile csmFile, PrintWriter printWriter) {
        XRefResultSet.IncludeLevel includeLevel = XRefResultSet.IncludeLevel.UNRESOLVED;
        CsmInclude csmInclude = null;
        CsmProject csmProject = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmFile csmFile2 = ((CsmOffsetable)csmObject).getContainingFile();
            if (csmFile.equals(csmFile2)) {
                includeLevel = XRefResultSet.IncludeLevel.THIS_FILE;
            } else {
                csmProject = csmFile2.getProject();
                csmInclude = TraceXRef.findFirstLevelInclude(csmFile, csmFile2);
            }
        } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
            CsmFile csmFile3;
            CsmNamespace csmNamespace = (CsmNamespace)csmObject;
            csmProject = csmNamespace.getProject();
            for (CsmNamespaceDefinition csmNamespaceDefinition : csmNamespace.getDefinitions()) {
                csmFile3 = csmNamespaceDefinition.getContainingFile();
                if (!csmFile.equals(csmFile3)) continue;
                includeLevel = XRefResultSet.IncludeLevel.THIS_FILE;
                break;
            }
            if (includeLevel != XRefResultSet.IncludeLevel.THIS_FILE) {
                for (CsmNamespaceDefinition csmNamespaceDefinition : csmNamespace.getDefinitions()) {
                    csmFile3 = csmNamespaceDefinition.getContainingFile();
                    CsmInclude csmInclude2 = TraceXRef.findFirstLevelInclude(csmFile, csmFile3);
                    if (csmInclude2 == null) continue;
                    csmInclude = csmInclude2;
                    break;
                }
            }
        } else {
            printWriter.println("ERROR: non classified declaration " + csmObject);
        }
        if (includeLevel != XRefResultSet.IncludeLevel.THIS_FILE) {
            includeLevel = csmInclude != null ? (csmInclude.isSystem() ? XRefResultSet.IncludeLevel.LIBRARY_DIRECT : XRefResultSet.IncludeLevel.PROJECT_DIRECT) : (csmFile.getProject().equals(csmProject) ? XRefResultSet.IncludeLevel.PROJECT_DEEP : XRefResultSet.IncludeLevel.LIBRARY_DEEP);
        }
        return includeLevel;
    }

    private static XRefResultSet.DeclarationScope classifyDeclarationScopeForFunction(XRefResultSet.DeclarationKind declarationKind, CsmObject csmObject, ObjectContext<CsmFunctionDefinition> objectContext, PrintWriter printWriter) {
        XRefResultSet.DeclarationScope declarationScope = XRefResultSet.DeclarationScope.UNRESOLVED;
        ObjectContext<CsmObject> objectContext2 = TraceXRef.createContextObject(csmObject, printWriter);
        switch (declarationKind) {
            case NAMESPACE: {
                declarationScope = TraceXRef.checkNamespaceContainers(objectContext2, objectContext);
                break;
            }
            case CLASSIFIER: {
                if (((ObjectContext)objectContext2).objClass != null) {
                    declarationScope = TraceXRef.checkClassContainers(objectContext2, objectContext);
                    break;
                }
                if (((ObjectContext)objectContext2).objNs != null) {
                    declarationScope = TraceXRef.checkNamespaceContainers(objectContext2, objectContext);
                    break;
                }
                if (CsmKindUtilities.isFunction((CsmObject)((ObjectContext)objectContext2).objScope) && ((CsmFunctionDefinition)((ObjectContext)objectContext).csmObject).equals(((ObjectContext)objectContext2).objScope)) {
                    declarationScope = XRefResultSet.DeclarationScope.FUNCTION_THIS;
                    break;
                }
                if (printWriter == null) break;
                printWriter.println("unknown classifier " + ((ObjectContext)objectContext2).csmObject + " in context of " + ((ObjectContext)objectContext).csmObject);
                break;
            }
            case FUNCTION: {
                declarationScope = TraceXRef.checkFileClassNamespaceContainers(objectContext2, objectContext, printWriter);
                break;
            }
            case MACRO: {
                declarationScope = TraceXRef.checkFileContainer(objectContext2, objectContext);
                break;
            }
            case PARAMETER: {
                declarationScope = XRefResultSet.DeclarationScope.FUNCTION_THIS;
                break;
            }
            case ENUMERATOR: 
            case VARIABLE: {
                int n = ((CsmOffsetable)csmObject).getStartOffset();
                if (((CsmFunctionDefinition)((ObjectContext)objectContext).csmObject).getStartOffset() < n && n < ((CsmFunctionDefinition)((ObjectContext)objectContext).csmObject).getEndOffset()) {
                    declarationScope = XRefResultSet.DeclarationScope.FUNCTION_THIS;
                    break;
                }
                declarationScope = TraceXRef.checkFileClassNamespaceContainers(objectContext2, objectContext, printWriter);
                break;
            }
            case UNRESOLVED: {
                break;
            }
            default: {
                printWriter.println("unhandled kind " + (Object)((Object)declarationKind) + " for object " + ((ObjectContext)objectContext2).csmObject);
            }
        }
        return declarationScope;
    }

    private static XRefResultSet.DeclarationScope checkFileContainer(ObjectContext<CsmObject> objectContext, ObjectContext<CsmFunctionDefinition> objectContext2) {
        XRefResultSet.DeclarationScope declarationScope = XRefResultSet.DeclarationScope.UNRESOLVED;
        declarationScope = ((ObjectContext)objectContext2).objFile.equals(((ObjectContext)objectContext).objFile) ? XRefResultSet.DeclarationScope.FILE_THIS : (((ObjectContext)objectContext2).objPrj.equals(((ObjectContext)objectContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_FILE : XRefResultSet.DeclarationScope.LIBRARY_FILE);
        return declarationScope;
    }

    private static XRefResultSet.DeclarationScope checkNamespaceContainers(ObjectContext<CsmObject> objectContext, ObjectContext<CsmFunctionDefinition> objectContext2) {
        XRefResultSet.DeclarationScope declarationScope = XRefResultSet.DeclarationScope.UNRESOLVED;
        if (((ObjectContext)objectContext).objNs != null) {
            boolean bl = false;
            if (!((ObjectContext)objectContext).objNs.isGlobal() && ((ObjectContext)objectContext2).objNs != null && !((ObjectContext)objectContext2).objNs.isGlobal()) {
                CsmNamespace csmNamespace = ((ObjectContext)objectContext2).objNs;
                if (csmNamespace.equals(((ObjectContext)objectContext).objNs)) {
                    declarationScope = XRefResultSet.DeclarationScope.NAMESPACE_THIS;
                    bl = true;
                } else {
                    while (csmNamespace != null && !csmNamespace.isGlobal()) {
                        if (csmNamespace.equals(((ObjectContext)objectContext).objNs)) {
                            declarationScope = XRefResultSet.DeclarationScope.NAMESPACE_PARENT;
                            bl = true;
                            break;
                        }
                        csmNamespace = csmNamespace.getParent();
                    }
                }
            }
            if (!bl) {
                declarationScope = ((ObjectContext)objectContext).objNs.isGlobal() ? (((ObjectContext)objectContext2).objPrj.equals(((ObjectContext)objectContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_GLOBAL : XRefResultSet.DeclarationScope.LIBRARY_GLOBAL) : (((ObjectContext)objectContext2).objPrj.equals(((ObjectContext)objectContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_NAMESPACE : XRefResultSet.DeclarationScope.LIBRARY_NAMESPACE);
            }
        }
        return declarationScope;
    }

    private static XRefResultSet.DeclarationScope checkClassContainers(ObjectContext<CsmObject> objectContext, ObjectContext<CsmFunctionDefinition> objectContext2) {
        XRefResultSet.DeclarationScope declarationScope = XRefResultSet.DeclarationScope.UNRESOLVED;
        if (((ObjectContext)objectContext).objClass != null) {
            boolean bl = false;
            if (((ObjectContext)objectContext2).objClass != null) {
                if (((ObjectContext)objectContext2).objClass.equals(((ObjectContext)objectContext).objClass)) {
                    declarationScope = XRefResultSet.DeclarationScope.CLASSIFIER_THIS;
                    bl = true;
                } else if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)((ObjectContext)objectContext).objClass, (CsmClass)((ObjectContext)objectContext2).objClass)) {
                    declarationScope = XRefResultSet.DeclarationScope.CLASSIFIER_PARENT;
                    bl = true;
                }
            }
            if (!bl) {
                declarationScope = ((ObjectContext)objectContext2).objPrj.equals(((ObjectContext)objectContext).objPrj) ? XRefResultSet.DeclarationScope.PROJECT_CLASSIFIER : XRefResultSet.DeclarationScope.LIBRARY_CLASSIFIER;
            }
        }
        return declarationScope;
    }

    private static XRefResultSet.DeclarationScope checkFileClassNamespaceContainers(ObjectContext<CsmObject> objectContext, ObjectContext<CsmFunctionDefinition> objectContext2, PrintWriter printWriter) {
        XRefResultSet.DeclarationScope declarationScope = XRefResultSet.DeclarationScope.UNRESOLVED;
        if (CsmKindUtilities.isFile((CsmObject)((ObjectContext)objectContext).objScope)) {
            declarationScope = TraceXRef.checkFileContainer(objectContext, objectContext2);
        } else if (((ObjectContext)objectContext).objClass != null) {
            declarationScope = TraceXRef.checkClassContainers(objectContext, objectContext2);
        } else if (((ObjectContext)objectContext).objNs != null) {
            declarationScope = TraceXRef.checkNamespaceContainers(objectContext, objectContext2);
        } else if (printWriter != null) {
            printWriter.println("unknown scope of " + ((ObjectContext)objectContext).csmObject + " in context of " + ((ObjectContext)objectContext2).csmObject);
        }
        return declarationScope;
    }

    private static CsmInclude findFirstLevelInclude(CsmFile csmFile, CsmFile csmFile2) {
        assert (csmFile != null) : "start file must be not null";
        assert (csmFile2 != null) : "search file must be not null";
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile3 = csmInclude.getIncludeFile();
            if (csmFile2.equals(csmFile3)) {
                return csmInclude;
            }
            if (csmFile3 == null || !csmFile3.getDeclarations().isEmpty()) continue;
            return TraceXRef.findFirstLevelInclude(csmFile3, csmFile2);
        }
        return null;
    }

    private static void traceStatistics(XRefResultSet xRefResultSet, PrintWriter printWriter) {
        Collection<XRefResultSet.ContextEntry> collection;
        printWriter.println("Number of analyzed contexts " + xRefResultSet.getNumberOfAllContexts());
        String string = "%20s\t|%6s\t| %2s |\n";
        String string2 = String.format(string, "Name", "Num", "%");
        printWriter.println(string2);
        Collection<XRefResultSet.ContextScope> collection2 = XRefResultSet.sortedContextScopes(xRefResultSet, false);
        for (XRefResultSet.ContextScope object : collection2) {
            Collection<XRefResultSet.ContextEntry> collection3 = xRefResultSet.getEntries(object);
            if (object == XRefResultSet.ContextScope.UNRESOLVED && collection3.isEmpty()) continue;
            string2 = String.format(string, new Object[]{object, xRefResultSet.getNumberOfContexts(object, false), xRefResultSet.getNumberOfContexts(object, true)});
            printWriter.print(string2);
        }
        printWriter.println("\nAnalyzed entries per scopes ");
        boolean bl = true;
        collection2 = XRefResultSet.sortedContextScopes(xRefResultSet, true);
        for (XRefResultSet.ContextScope contextScope : collection2) {
            collection = xRefResultSet.getEntries(contextScope);
            TraceXRef.traceEntriesStatistics(contextScope, collection, bl, printWriter);
            bl = false;
        }
        printWriter.println("\nNumbers for \"first\" items approach");
        bl = true;
        for (XRefResultSet.ContextScope contextScope : collection2) {
            collection = xRefResultSet.getEntries(contextScope);
            TraceXRef.traceFirstItemsStatistics(contextScope, collection, bl, printWriter);
            bl = false;
        }
        printWriter.println("\nDetails about file inclusion level");
        bl = true;
        for (XRefResultSet.ContextScope contextScope : collection2) {
            collection = xRefResultSet.getEntries(contextScope);
            TraceXRef.traceFileBasedEntriesStatistics(contextScope, collection, bl, printWriter);
            bl = false;
        }
        printWriter.println("\nDetails about scope of referenced declarations");
        bl = true;
        for (XRefResultSet.ContextScope contextScope : collection2) {
            collection = xRefResultSet.getEntries(contextScope);
            TraceXRef.traceUsedDeclarationScopeEntriesStatistics(contextScope, collection, bl, printWriter);
            bl = false;
        }
    }

    private static void traceFirstItemsStatistics(XRefResultSet.ContextScope contextScope, Collection<XRefResultSet.ContextEntry> collection, boolean bl, PrintWriter printWriter) {
        Object object;
        String string = "%20s\t|%10s\t|%20s\t|%20s\t|%20s\t|%20s\t|%20s\n";
        if (bl) {
            object = String.format(string, "scope name", "All", "local+cls+ns", "file+#incl-1", "local+cls+ns+#incl-1", "was usages", "context+used");
            printWriter.print((String)object);
        }
        if (contextScope == XRefResultSet.ContextScope.UNRESOLVED && collection.isEmpty()) {
            return;
        }
        object = EnumSet.of(XRefResultSet.IncludeLevel.THIS_FILE, XRefResultSet.IncludeLevel.PROJECT_DIRECT, XRefResultSet.IncludeLevel.LIBRARY_DIRECT);
        EnumSet<XRefResultSet.DeclarationScope[]> enumSet = EnumSet.of(XRefResultSet.DeclarationScope.FUNCTION_THIS, new XRefResultSet.DeclarationScope[]{XRefResultSet.DeclarationScope.CLASSIFIER_THIS, XRefResultSet.DeclarationScope.CLASSIFIER_PARENT, XRefResultSet.DeclarationScope.FILE_THIS, XRefResultSet.DeclarationScope.NAMESPACE_THIS, XRefResultSet.DeclarationScope.NAMESPACE_PARENT});
        EnumSet<XRefResultSet.DeclarationScope> enumSet2 = EnumSet.noneOf(XRefResultSet.DeclarationScope.class);
        EnumSet<XRefResultSet.IncludeLevel> enumSet3 = EnumSet.noneOf(XRefResultSet.IncludeLevel.class);
        EnumSet<XRefResultSet.UsageStatistics> enumSet4 = EnumSet.noneOf(XRefResultSet.UsageStatistics.class);
        EnumSet<XRefResultSet.UsageStatistics> enumSet5 = EnumSet.of(XRefResultSet.UsageStatistics.SECOND_USAGE, XRefResultSet.UsageStatistics.NEXT_USAGE);
        String string2 = String.format(string, new Object[]{contextScope, collection.size(), TraceXRef.getDeclScopeAndIncludeLevelInfo(collection, enumSet, enumSet3, enumSet4), TraceXRef.getDeclScopeAndIncludeLevelInfo(collection, enumSet2, (EnumSet<XRefResultSet.IncludeLevel>)object, enumSet4), TraceXRef.getDeclScopeAndIncludeLevelInfo(collection, enumSet, (EnumSet<XRefResultSet.IncludeLevel>)object, enumSet4), TraceXRef.getDeclScopeAndIncludeLevelInfo(collection, enumSet2, enumSet3, enumSet5), TraceXRef.getDeclScopeAndIncludeLevelInfo(collection, enumSet, (EnumSet<XRefResultSet.IncludeLevel>)object, enumSet5)});
        printWriter.print(string2);
    }

    private static void traceFileBasedEntriesStatistics(XRefResultSet.ContextScope contextScope, Collection<XRefResultSet.ContextEntry> collection, boolean bl, PrintWriter printWriter) {
        String string;
        String string2 = "%20s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\n";
        if (bl) {
            string = String.format(string2, "scope name", "this file", "direct \"\"", "direct <>", "project", "library", "unresolved", "All");
            printWriter.print(string);
        }
        if (contextScope == XRefResultSet.ContextScope.UNRESOLVED && collection.isEmpty()) {
            return;
        }
        string = String.format(string2, new Object[]{contextScope, TraceXRef.getIncludeLevelInfo(collection, XRefResultSet.IncludeLevel.THIS_FILE), TraceXRef.getIncludeLevelInfo(collection, XRefResultSet.IncludeLevel.PROJECT_DIRECT), TraceXRef.getIncludeLevelInfo(collection, XRefResultSet.IncludeLevel.LIBRARY_DIRECT), TraceXRef.getIncludeLevelInfo(collection, XRefResultSet.IncludeLevel.PROJECT_DEEP), TraceXRef.getIncludeLevelInfo(collection, XRefResultSet.IncludeLevel.LIBRARY_DEEP), TraceXRef.getIncludeLevelInfo(collection, XRefResultSet.IncludeLevel.UNRESOLVED), collection.size()});
        printWriter.print(string);
    }

    private static void traceUsedDeclarationScopeEntriesStatistics(XRefResultSet.ContextScope contextScope, Collection<XRefResultSet.ContextEntry> collection, boolean bl, PrintWriter printWriter) {
        String string;
        String string2 = "%20s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s\t|%10s|\n";
        if (bl) {
            string = String.format(string2, "scope name", "this fun", "this class", "parent class", "prj class", "lib class", "this ns", "parent ns", "prj ns", "lib ns", "this file", "prj file", "lib file", "project", "library", "unresolved", "All");
            printWriter.print(string);
        }
        if (contextScope == XRefResultSet.ContextScope.UNRESOLVED && collection.isEmpty()) {
            return;
        }
        string = String.format(string2, new Object[]{contextScope, TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.FUNCTION_THIS), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.CLASSIFIER_THIS), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.CLASSIFIER_PARENT), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.PROJECT_CLASSIFIER), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.LIBRARY_CLASSIFIER), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.NAMESPACE_THIS), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.NAMESPACE_PARENT), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.PROJECT_NAMESPACE), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.LIBRARY_NAMESPACE), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.FILE_THIS), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.PROJECT_FILE), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.LIBRARY_FILE), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.PROJECT_GLOBAL), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.LIBRARY_GLOBAL), TraceXRef.getDeclarationScopeInfo(collection, XRefResultSet.DeclarationScope.UNRESOLVED), collection.size()});
        printWriter.print(string);
    }

    private static String getDeclScopeAndIncludeLevelInfo(Collection<XRefResultSet.ContextEntry> collection, EnumSet<XRefResultSet.DeclarationScope> enumSet, EnumSet<XRefResultSet.IncludeLevel> enumSet2, EnumSet<XRefResultSet.UsageStatistics> enumSet3) {
        int n = 0;
        for (XRefResultSet.ContextEntry contextEntry : collection) {
            if (!enumSet.contains((Object)contextEntry.declarationScope) && !enumSet2.contains((Object)contextEntry.declarationIncludeLevel) && !enumSet3.contains((Object)contextEntry.usageStatistics)) continue;
            ++n;
        }
        return TraceXRef.toRelString(n, collection.size());
    }

    private static String getIncludeLevelInfo(Collection<XRefResultSet.ContextEntry> collection, XRefResultSet.IncludeLevel includeLevel) {
        int n = 0;
        for (XRefResultSet.ContextEntry contextEntry : collection) {
            if (contextEntry.declarationIncludeLevel != includeLevel) continue;
            ++n;
        }
        return TraceXRef.toRelString(n, collection.size());
    }

    private static String getDeclarationScopeInfo(Collection<XRefResultSet.ContextEntry> collection, XRefResultSet.DeclarationScope declarationScope) {
        int n = 0;
        for (XRefResultSet.ContextEntry contextEntry : collection) {
            if (contextEntry.declarationScope != declarationScope) continue;
            ++n;
        }
        return TraceXRef.toRelString(n, collection.size());
    }

    private static String getDeclarationKindInfo(Collection<XRefResultSet.ContextEntry> collection, XRefResultSet.DeclarationKind declarationKind) {
        int n = 0;
        for (XRefResultSet.ContextEntry contextEntry : collection) {
            if (contextEntry.declaration != declarationKind) continue;
            ++n;
        }
        return TraceXRef.toRelString(n, collection.size());
    }

    private static String toRelString(int n, int n2) {
        assert (n2 != 0 || n == 0);
        int n3 = n == 0 ? 0 : n * 100 / n2;
        return n3 + "%(" + n + ")";
    }

    private static void traceEntriesStatistics(XRefResultSet.ContextScope contextScope, Collection<XRefResultSet.ContextEntry> collection, boolean bl, PrintWriter printWriter) {
        String string = "%20s\t|%10s\t|%10s\t|%10s|\n";
        if (bl) {
            String string2 = String.format(string, "Entries for scope", "Num", "Resolved", "Unresolved");
            printWriter.print(string2);
        }
        if (contextScope == XRefResultSet.ContextScope.UNRESOLVED && collection.isEmpty()) {
            return;
        }
        int n = 0;
        for (XRefResultSet.ContextEntry contextEntry : collection) {
            if (contextEntry.declaration != XRefResultSet.DeclarationKind.UNRESOLVED) continue;
            ++n;
        }
        String string3 = String.format(string, new Object[]{contextScope, collection.size(), collection.size() - n, n});
        printWriter.print(string3);
    }

    private static <T extends CsmObject> ObjectContext<T> createContextObject(T t, PrintWriter printWriter) {
        T t2 = t;
        CsmClass csmClass = null;
        CsmFile csmFile = null;
        CsmProject csmProject = null;
        CsmNamespace csmNamespace = null;
        CsmScope csmScope = null;
        if (CsmKindUtilities.isOffsetable(t)) {
            csmFile = ((CsmOffsetable)t).getContainingFile();
            assert (csmFile != null);
            csmProject = csmFile.getProject();
        } else if (CsmKindUtilities.isNamespace(t)) {
            csmProject = ((CsmNamespace)t).getProject();
        } else {
            printWriter.println("not handled object " + t);
        }
        csmNamespace = CsmBaseUtilities.getObjectNamespace(t);
        csmClass = CsmBaseUtilities.getObjectClass(t);
        if (CsmKindUtilities.isEnumerator(t)) {
            csmScope = ((CsmEnumerator)t).getEnumeration().getScope();
        } else if (CsmKindUtilities.isScopeElement(t)) {
            csmScope = ((CsmScopeElement)t).getScope();
        }
        while (csmScope != null && !CsmKindUtilities.isNamespaceDefinition((CsmObject)csmScope) && !CsmKindUtilities.isClass((CsmObject)csmScope) && !CsmKindUtilities.isFunction((CsmObject)csmScope) && CsmKindUtilities.isScopeElement((CsmObject)csmScope)) {
            csmScope = ((CsmScopeElement)csmScope).getScope();
        }
        return new ObjectContext<T>(t2, csmClass, csmFile, csmProject, csmNamespace, csmScope);
    }

    private static final class RefLink
    implements OutputListener {
        private final CsmReference ref;

        RefLink(CsmReference csmReference) {
            this.ref = csmReference;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            CsmUtilities.openSource((CsmObject)this.ref);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObjectContext<T extends CsmObject> {
        private final T csmObject;
        private final CsmClass objClass;
        private final CsmFile objFile;
        private final CsmProject objPrj;
        private final CsmNamespace objNs;
        private final CsmScope objScope;

        public ObjectContext(T t, CsmClass csmClass, CsmFile csmFile, CsmProject csmProject, CsmNamespace csmNamespace, CsmScope csmScope) {
            this.csmObject = t;
            this.objClass = csmClass;
            this.objFile = csmFile;
            this.objPrj = csmProject;
            this.objNs = csmNamespace;
            this.objScope = csmScope;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Object: ").append(this.csmObject);
            stringBuilder.append("\nFile: ").append(this.objFile);
            stringBuilder.append("\nClass: ").append(this.objClass);
            stringBuilder.append("\nNS: ").append(this.objNs);
            stringBuilder.append("\nProject: ").append(this.objPrj);
            stringBuilder.append("\nScope: ").append(this.objScope);
            return stringBuilder.toString();
        }
    }
}

