/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryListenerImpl
implements RepositoryListener {
    private static final RepositoryListenerImpl instance = new RepositoryListenerImpl();
    private static final int IMPLICIT_CLOSE_INTERVAL = Integer.getInteger("cnd.implicit.close.interval", 20);
    private static final String TRACE_PROJECT_NAME = System.getProperty("cnd.repository.trace.project");
    private static final boolean TRACE_PROJECT = TRACE_PROJECT_NAME != null && TRACE_PROJECT_NAME.length() > 0;
    private Object lock = new String("Repository listener lock");
    private Map<String, UnitTimer> unitTimers = new HashMap<String, UnitTimer>();
    private Set<String> explicitelyOpened = new HashSet<String>();

    private RepositoryListenerImpl() {
        Runtime.getRuntime().addShutdownHook(new RepositoryShutdownHook());
    }

    public static RepositoryListenerImpl instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unitOpened(String string) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitOpened %s\n", string);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(string)) {
            this.trace("Watched project %s is opening\n", string);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.explicitelyOpened.contains(string)) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: implicit open !!! %s\n", string);
                }
                this.unitTimers.put(string, new UnitTimer(string, IMPLICIT_CLOSE_INTERVAL * 1000));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unitClosed(String string) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitClosed %s\n", string);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(string)) {
            this.trace("Watched project %s is explicitly closing\n", string);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(string);
            this.explicitelyOpened.remove(string);
        }
    }

    public void anExceptionHappened(String string, RepositoryException repositoryException) {
        assert (repositoryException != null);
        if (repositoryException.getCause() != null) {
            repositoryException.getCause().printStackTrace(System.err);
        }
        DiagnosticExceptoins.register(repositoryException.getCause());
    }

    private void killTimer(String string) {
        UnitTimer unitTimer = this.unitTimers.remove(string);
        if (unitTimer != null) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("RepositoryListener: killing timer for %s\n", string);
            }
            unitTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExplicitOpen(String string) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitOpen %s\n", string);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(string);
            this.explicitelyOpened.add(string);
        }
    }

    public void onExplicitClose(String string) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitClose %s\n", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutElapsed(String string) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: timeout elapsed for %s\n", string);
        }
        Object object = this.lock;
        synchronized (object) {
            UnitTimer unitTimer = this.unitTimers.remove(string);
            if (unitTimer != null) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: scheduling closure for %s\n", string);
                }
                unitTimer.cancel();
                this.scheduleClosing(string, Collections.EMPTY_SET);
            }
        }
    }

    private void scheduleClosing(final String string, Set<String> set) {
        if (this.explicitelyOpened.contains(string)) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("Cancelling closure (A) for implicitely opened unit %s\n", string);
            }
            return;
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = RepositoryListenerImpl.this.lock;
                synchronized (object) {
                    if (RepositoryListenerImpl.this.explicitelyOpened.contains(string)) {
                        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                            RepositoryListenerImpl.this.trace("Cancelling closure (B) for implicitely opened unit %s\n", new Object[]{string});
                        }
                        return;
                    }
                }
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    RepositoryListenerImpl.this.trace("RepositoryListener: closing implicitely opened unit %s\n", new Object[]{string});
                }
                if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(string)) {
                    RepositoryListenerImpl.this.trace("Watched project %s is implicitely closing\n", new Object[]{string});
                }
                RepositoryUtils.closeUnit(string, null);
            }
        }, "Closing implicitly opened project");
    }

    private void trace(String string, Object ... objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = System.currentTimeMillis();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i + 1] = objectArray[i];
        }
        System.err.printf("RepositoryListener [%d] " + string, objectArray2);
    }

    private class UnitTimer
    implements ActionListener {
        private String unitName;
        private Timer timer;

        public UnitTimer(String string, int n) {
            this.unitName = string;
            this.timer = new Timer(n, this);
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RepositoryListenerImpl.this.timeoutElapsed(this.unitName);
        }

        public void cancel() {
            this.timer.stop();
        }
    }

    private static class RepositoryShutdownHook
    extends Thread {
        public RepositoryShutdownHook() {
            this.setName("Repository Shutdown Hook Thread");
        }

        public void run() {
            RepositoryUtils.shutdown();
        }
    }
}

