/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;

abstract class OffsetableKey
extends ProjectFileNameBasedKey
implements Comparable {
    private final int startOffset;
    private final int endOffset;
    private final char kind;
    private final CharSequence name;

    protected OffsetableKey(CsmOffsetable csmOffsetable, String string, CharSequence charSequence) {
        super((FileImpl)csmOffsetable.getContainingFile());
        this.startOffset = csmOffsetable.getStartOffset();
        this.endOffset = csmOffsetable.getEndOffset();
        assert (string.length() == 1);
        this.kind = string.charAt(0);
        this.name = charSequence;
    }

    char getKind() {
        return this.kind;
    }

    CharSequence getName() {
        return this.name;
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.startOffset);
        dataOutput.writeInt(this.endOffset);
        dataOutput.writeChar(this.kind);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
    }

    protected OffsetableKey(DataInput dataInput) throws IOException {
        super(dataInput);
        this.startOffset = dataInput.readInt();
        this.endOffset = dataInput.readInt();
        this.kind = dataInput.readChar();
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
    }

    public String toString() {
        return this.name + "[" + this.kind + " " + this.startOffset + "-" + this.endOffset + "] {" + this.getFileNameSafe() + "; " + this.getProjectName() + "}";
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        OffsetableKey offsetableKey = (OffsetableKey)object;
        return this.startOffset == offsetableKey.startOffset && this.endOffset == offsetableKey.endOffset && this.kind == offsetableKey.kind && this.name.equals(offsetableKey.name);
    }

    public int hashCode() {
        int n = 17 * super.hashCode() + this.name.hashCode();
        n = 17 * n + this.kind;
        n = 17 * super.hashCode() + this.startOffset;
        n = 17 * n + this.endOffset;
        return n;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        OffsetableKey offsetableKey = (OffsetableKey)object;
        assert (this.kind == offsetableKey.kind);
        assert (this.unitIndex == offsetableKey.unitIndex);
        assert (this.fileNameIndex == offsetableKey.fileNameIndex);
        int n = this.startOffset;
        int n2 = offsetableKey.startOffset;
        if (n == n2) {
            return 0;
        }
        return n - n2;
    }

    public int getDepth() {
        return super.getDepth() + 2;
    }

    public CharSequence getAt(int n) {
        int n2 = super.getDepth();
        if (n < n2) {
            return super.getAt(n);
        }
        switch (n - n2) {
            case 0: {
                return new String(new char[]{this.kind});
            }
            case 1: {
                return this.name;
            }
        }
        throw new IllegalArgumentException("not supported level" + n);
    }

    public int getSecondaryDepth() {
        return 2;
    }

    public int getSecondaryAt(int n) {
        switch (n) {
            case 0: {
                return this.startOffset;
            }
            case 1: {
                return this.endOffset;
            }
        }
        throw new IllegalArgumentException("not supported level" + n);
    }
}

