/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.openide.util.NbBundle;

final class ParsingProgress {
    private ProgressHandle handle;
    private int curWorkedUnits = 0;
    private int maxWorkUnits = 0;
    private boolean started = false;
    private static final int INITIAL_DELAY = 1000;

    public ParsingProgress(NativeProject nativeProject) {
        String string = NbBundle.getMessage(ModelSupport.class, (String)"MSG_ParsingProgress", (Object)nativeProject.getProjectDisplayName());
        this.handle = ProgressHandleFactory.createHandle((String)string);
    }

    public ParsingProgress(CsmProject csmProject) {
        String string = NbBundle.getMessage(ModelSupport.class, (String)"MSG_ParsingProgress", (Object)csmProject.getName());
        this.handle = ProgressHandleFactory.createHandle((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (!this.started) {
                this.started = true;
                this.handle.setInitialDelay(1000);
                this.handle.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (this.started) {
                this.handle.finish();
                this.started = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextCsmFile(CsmFile csmFile) {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (!this.started) {
                return;
            }
            if (this.curWorkedUnits >= this.maxWorkUnits) {
                return;
            }
            try {
                this.handle.progress(((Object)csmFile.getName()).toString(), this.curWorkedUnits++);
            }
            catch (NullPointerException nullPointerException) {
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToDeterminate(int n) {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (!this.started) {
                return;
            }
            this.maxWorkUnits = n;
            this.handle.switchToDeterminate(n);
        }
    }
}

