/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.openide.filesystems.FileUtil;

public abstract class APTProjectFileBasedWalker
extends APTAbstractWalker {
    private final FileImpl file;
    private final ProjectBase startProject;
    private int mode = 0;

    public APTProjectFileBasedWalker(ProjectBase projectBase, APTFile aPTFile, FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
        super(aPTFile, aPTPreprocHandler);
        this.file = fileImpl;
        this.startProject = projectBase;
        assert (projectBase != null) : "null start project for " + fileImpl.getAbsolutePath();
    }

    protected void include(ResolvedPath resolvedPath, APTInclude aPTInclude) {
        FileImpl fileImpl = null;
        if (resolvedPath != null) {
            String string = resolvedPath.getPath();
            if (string.indexOf("..") > 0) {
                string = FileUtil.normalizeFile((File)new File(string)).getAbsolutePath();
                resolvedPath = new ResolvedPath(resolvedPath.getFolder(), string, resolvedPath.isDefaultSearchPath(), resolvedPath.getIndex());
            }
            if (this.getIncludeHandler().pushInclude(string, aPTInclude.getToken().getLine(), resolvedPath.getIndex())) {
                ProjectBase projectBase = this.getStartProject();
                if (projectBase != null) {
                    ProjectBase projectBase2 = LibraryManager.getInstance().resolveFileProjectOnInclude(projectBase, this.getFile(), resolvedPath);
                    try {
                        fileImpl = this.includeAction(projectBase2, string, this.mode, aPTInclude);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        APTUtils.LOG.log(Level.WARNING, "APTProjectFileBasedWalker: file {0} not found", new Object[]{string});
                        DiagnosticExceptoins.register(fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        APTUtils.LOG.log(Level.SEVERE, "APTProjectFileBasedWalker: error on including {0}:\n{1}", new Object[]{string, iOException});
                        DiagnosticExceptoins.register(iOException);
                    }
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "APTProjectFileBasedWalker: file {0} without project!!!", new Object[]{this.file});
                    this.getIncludeHandler().popInclude();
                }
            }
        }
        this.postInclude(aPTInclude, fileImpl);
    }

    protected abstract FileImpl includeAction(ProjectBase var1, String var2, int var3, APTInclude var4) throws IOException;

    protected void postInclude(APTInclude aPTInclude, FileImpl fileImpl) {
    }

    protected FileImpl getFile() {
        return this.file;
    }

    protected ProjectBase getStartProject() {
        return this.file.getProjectImpl();
    }

    protected void setMode(int n) {
        this.mode = n;
    }
}

