/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTElif;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTIf;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTDefinesCollectorWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.MacroInfo;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTFindMacrosWalker
extends APTDefinesCollectorWalker {
    private final List<CsmReference> references = new ArrayList<CsmReference>();

    public APTFindMacrosWalker(APTFile aPTFile, CsmFile csmFile, APTPreprocHandler aPTPreprocHandler) {
        super(aPTFile, csmFile, aPTPreprocHandler);
    }

    @Override
    protected void onDefine(APT aPT) {
        APTDefine aPTDefine = (APTDefine)aPT;
        APTToken aPTToken = (APTToken)aPTDefine.getName();
        this.addReference(aPTToken, new MacroInfo(this.csmFile, aPTDefine.getOffset(), aPTDefine.getEndOffset(), null));
        this.analyzeList(aPTDefine.getBody());
        super.onDefine(aPT);
    }

    protected boolean onIf(APT aPT) {
        this.analyzeStream(((APTIf)aPT).getCondition());
        return super.onIf(aPT);
    }

    protected boolean onElif(APT aPT, boolean bl) {
        this.analyzeStream(((APTElif)aPT).getCondition());
        return super.onElif(aPT, bl);
    }

    protected boolean onIfndef(APT aPT) {
        this.analyzeToken((Token)((APTToken)((APTIfndef)aPT).getMacroName()));
        return super.onIfndef(aPT);
    }

    protected boolean onIfdef(APT aPT) {
        this.analyzeToken((Token)((APTToken)((APTIfdef)aPT).getMacroName()));
        return super.onIfdef(aPT);
    }

    @Override
    protected void onUndef(APT aPT) {
        this.analyzeToken((Token)((APTToken)((APTUndefine)aPT).getName()));
        super.onUndef(aPT);
    }

    public List<CsmReference> getCollectedData() {
        return this.references;
    }

    public TokenStream getTokenStream() {
        TokenStream tokenStream = super.getTokenStream();
        this.analyzeStream(tokenStream);
        return null;
    }

    private void analyzeToken(Token token) {
        APTMacro aPTMacro;
        APTToken aPTToken = (APTToken)token;
        if (aPTToken != null && (aPTMacro = this.getMacroMap().getMacro((Token)aPTToken)) != null) {
            if (aPTMacro.isSystem()) {
                this.addSysReference(aPTToken, aPTMacro);
            } else {
                MacroInfo macroInfo = (MacroInfo)this.macroRefMap.get(aPTToken.getText());
                if (macroInfo != null) {
                    this.addReference(aPTToken, macroInfo);
                } else {
                    this.addSysReference(aPTToken, aPTMacro);
                }
            }
        }
    }

    private void analyzeList(List<Token> list) {
        if (list != null) {
            for (Token token : list) {
                this.analyzeToken(token);
            }
        }
    }

    private void analyzeStream(TokenStream tokenStream) {
        if (tokenStream != null) {
            try {
                Token token = tokenStream.nextToken();
                while (!APTUtils.isEOF((Token)token)) {
                    this.analyzeToken(token);
                    token = tokenStream.nextToken();
                }
            }
            catch (TokenStreamException tokenStreamException) {
                DiagnosticExceptoins.register(tokenStreamException);
            }
        }
    }

    private void addSysReference(APTToken aPTToken, APTMacro aPTMacro) {
        this.references.add(new SysMacroReference(this.csmFile, aPTToken, aPTMacro));
    }

    private void addReference(APTToken aPTToken, MacroInfo macroInfo) {
        if (aPTToken != null) {
            MacroReference macroReference = new MacroReference(this.csmFile, aPTToken, macroInfo);
            this.references.add(macroReference);
        }
    }

    private class MacroReference
    extends OffsetableBase
    implements CsmReference {
        private CsmObject ref;
        private final String macroName;
        private final MacroInfo mi;

        public MacroReference(CsmFile csmFile, APTToken aPTToken, MacroInfo macroInfo) {
            super(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
            this.macroName = aPTToken.getText();
            assert (this.macroName != null);
            this.mi = macroInfo;
        }

        public CsmObject getReferencedObject() {
            CsmFile csmFile;
            if (this.ref == null && this.mi != null && (csmFile = this.getTargetFile()) != null) {
                Collection collection = csmFile.getMacros();
                ArrayList arrayList = new ArrayList(collection);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    CsmMacro csmMacro = (CsmMacro)arrayList.get(i);
                    if (csmMacro == null || this.mi.startOffset != csmMacro.getStartOffset()) continue;
                    this.ref = csmMacro;
                    break;
                }
                if (this.ref == null) {
                    this.ref = csmFile instanceof Unresolved.UnresolvedFile ? MacroImpl.createSystemMacro(this.macroName, "", csmFile) : new MacroImpl(this.macroName, null, "", csmFile, new OffsetableBase(csmFile, this.mi.startOffset, this.mi.endOffset), false);
                }
            }
            return this.ref;
        }

        private CsmFile getTargetFile() {
            ProjectBase projectBase;
            CsmFile csmFile = UIDCsmConverter.UIDtoFile(this.mi.targetFile);
            if (this.mi.includePath != null && (projectBase = ((ProjectBase)csmFile.getProject()).findFileProject(this.mi.includePath)) != null) {
                csmFile = projectBase.getFile(new File(this.mi.includePath));
            }
            return csmFile;
        }

        public CsmObject getOwner() {
            return this.getTargetFile();
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DECLARATION;
        }
    }

    private static class SysMacroReference
    extends OffsetableBase
    implements CsmReference {
        private final CsmObject ref;

        public SysMacroReference(CsmFile csmFile, APTToken aPTToken, APTMacro aPTMacro) {
            super(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
            this.ref = MacroImpl.createSystemMacro(aPTToken.getText(), APTUtils.stringize((TokenStream)aPTMacro.getBody(), (boolean)false), ((ProjectBase)csmFile.getProject()).getUnresolvedFile());
        }

        public CsmObject getReferencedObject() {
            return this.ref;
        }

        public CsmObject getOwner() {
            return null;
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DECLARATION;
        }
    }
}

