/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFindMacrosWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFindUnusedBlocksWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoQueryImpl
extends CsmFileInfoQuery {
    public List<String> getSystemIncludePaths(CsmFile csmFile) {
        return this.getIncludePaths(csmFile, true);
    }

    public List<String> getUserIncludePaths(CsmFile csmFile) {
        return this.getIncludePaths(csmFile, false);
    }

    private List<String> getIncludePaths(CsmFile csmFile, boolean bl) {
        NativeFileItem nativeFileItem;
        List list = Collections.emptyList();
        if (csmFile instanceof FileImpl && (nativeFileItem = ProjectBase.getCompiledFileItem((FileImpl)csmFile)) != null) {
            if (nativeFileItem.getLanguage() == NativeFileItem.Language.C_HEADER) {
                NativeProject nativeProject = nativeFileItem.getNativeProject();
                if (nativeProject != null) {
                    list = bl ? nativeProject.getSystemIncludePaths() : nativeProject.getUserIncludePaths();
                }
            } else {
                list = bl ? nativeFileItem.getSystemIncludePaths() : nativeFileItem.getUserIncludePaths();
            }
        }
        return list;
    }

    public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile csmFile) {
        List<CsmOffsetable> list = Collections.emptyList();
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            try {
                APTFile aPTFile = APTDriver.getInstance().findAPTLight((APTFileBuffer)fileImpl.getBuffer());
                if (FileInfoQueryImpl.hasConditionalsDirectives(aPTFile)) {
                    APTFindUnusedBlocksWalker aPTFindUnusedBlocksWalker = new APTFindUnusedBlocksWalker(aPTFile, fileImpl, fileImpl.getPreprocHandler());
                    aPTFindUnusedBlocksWalker.visit();
                    list = aPTFindUnusedBlocksWalker.getBlocks();
                }
            }
            catch (IOException iOException) {
                System.err.println("skip getting unused blocks\nreason:" + iOException.getMessage());
                DiagnosticExceptoins.register(iOException);
            }
        }
        return list;
    }

    private static boolean hasConditionalsDirectives(APTFile aPTFile) {
        if (aPTFile == null) {
            return false;
        }
        for (APT aPT = aPTFile.getFirstChild(); aPT != null; aPT = aPT.getNextSibling()) {
            if (aPT.getType() == 7) {
                return true;
            }
            assert (aPT.getFirstChild() == null);
        }
        return false;
    }

    public List<CsmReference> getMacroUsages(CsmFile csmFile) {
        List<CsmReference> list = Collections.emptyList();
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            try {
                APTFile aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)fileImpl.getBuffer());
                if (aPTFile != null) {
                    APTFindMacrosWalker aPTFindMacrosWalker = new APTFindMacrosWalker(aPTFile, fileImpl, fileImpl.getPreprocHandler());
                    aPTFindMacrosWalker.getTokenStream();
                    list = aPTFindMacrosWalker.getCollectedData();
                }
            }
            catch (IOException iOException) {
                System.err.println("skip marking macros\nreason:" + iOException.getMessage());
                DiagnosticExceptoins.register(iOException);
            }
        }
        return list;
    }
}

