/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceRootContainer {
    private Map<String, Integer> projectRoots = new ConcurrentHashMap<String, Integer>();

    public boolean isMySource(String string) {
        return this.projectRoots.containsKey(string);
    }

    public void fixFolder(String string) {
        if (string != null) {
            this.projectRoots.put(string, new Integer(0x3FFFFFFF));
        }
    }

    public void addSources(List<NativeFileItem> list) {
        for (NativeFileItem nativeFileItem : list) {
            this.addFile(nativeFileItem.getFile());
        }
    }

    public void addFile(File file) {
        File file2 = FileUtil.normalizeFile((File)file).getParentFile();
        String string = file2.getAbsolutePath();
        this.addPath(string);
        try {
            String string2 = file2.getCanonicalPath();
            if (!string.equals(string2)) {
                this.addPath(string2);
            }
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
        }
    }

    private void addPath(String string) {
        Integer n = this.projectRoots.get(string);
        if (n == null) {
            this.projectRoots.put(string, new Integer(1));
        } else {
            this.projectRoots.put(string, new Integer(n + 1));
        }
    }

    public void removeSources(List<NativeFileItem> list) {
        for (NativeFileItem nativeFileItem : list) {
            this.removeFile(nativeFileItem.getFile());
        }
    }

    public void removeFile(File file) {
        String string = FileUtil.normalizeFile((File)file).getParent();
        Integer n = this.projectRoots.get(string);
        if (n != null) {
            if (n > 1) {
                this.projectRoots.put(string, new Integer(n - 1));
            } else {
                this.projectRoots.remove(string);
            }
        }
    }
}

