/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public final class ParserQueue {
    private static ParserQueue instance = new ParserQueue();
    private Queue queue = new Queue();
    private State state;
    private Object suspendLock = new String("suspendLock");
    private Map<ProjectBase, ProjectData> projectData = new HashMap<ProjectBase, ProjectData>();
    private Map<CsmProject, Object> projectLocks = new HashMap<CsmProject, Object>();
    private Object lock = new Object();
    private Diagnostic.StopWatch stopWatch = TraceFlags.TIMING ? new Diagnostic.StopWatch(false) : null;

    static String tracePreprocState(APTPreprocHandler.State state) {
        if (state == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        if (!state.isCleaned()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" cleaned, ");
        if (!state.isValid()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" valid, ");
        if (!state.isCompileContext()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" correct State]");
        return stringBuilder.toString();
    }

    private ParserQueue() {
    }

    public static ParserQueue instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(FileImpl fileImpl, APTPreprocHandler.State state) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: addLast " + fileImpl.getAbsolutePath());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.OFF) {
                return;
            }
            if (!this.needEnqueue(fileImpl)) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: do not addLast for parsing or parsed " + fileImpl.getAbsolutePath());
                }
                return;
            }
            Set set = this.getProjectFiles(fileImpl.getProjectImpl());
            Entry entry = null;
            if (set.contains(fileImpl)) {
                entry = this.queue.find(fileImpl);
                if (entry != null) {
                    entry.setPreprocStateIfNeed(state);
                }
            } else {
                assert (this.queue.find(fileImpl) == null) : "The queue should not contain the file " + this.traceState4File(fileImpl, set);
                set.add(fileImpl);
            }
            if (entry == null) {
                entry = new Entry(fileImpl, state);
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: added as Last with entry " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                }
                this.queue.addLast(entry);
            }
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileInvalidated(fileImpl);
    }

    private String traceState4File(FileImpl fileImpl, Set set) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        stringBuilder.append(fileImpl);
        stringBuilder.append("\n of project ").append(fileImpl.getProjectImpl());
        stringBuilder.append("\n content of projects files set:\n");
        stringBuilder.append(set);
        stringBuilder.append("\nqueue content is:\n");
        stringBuilder.append(this.queue.toString(false));
        stringBuilder.append("\nprojectData content is:\n");
        stringBuilder.append(this.projectData);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(FileImpl fileImpl, APTPreprocHandler.State state, boolean bl) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: addFirst " + fileImpl.getAbsolutePath());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.OFF) {
                return;
            }
            if (!this.needEnqueue(fileImpl)) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: do not addFirst for parsing or parsed " + fileImpl.getAbsolutePath());
                }
                return;
            }
            Set set = this.getProjectFiles(fileImpl.getProjectImpl());
            Entry entry = null;
            if (set.contains(fileImpl)) {
                entry = this.queue.find(fileImpl);
                if (entry != null) {
                    this.queue.remove(entry);
                    entry.setPreprocStateIfNeed(state);
                }
            } else {
                assert (this.queue.find(fileImpl) == null) : "The queue should not contain the file " + this.traceState4File(fileImpl, set);
                set.add(fileImpl);
            }
            if (entry == null) {
                entry = new Entry(fileImpl, state);
            }
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("ParserQueue: added as First with entry " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
            }
            this.queue.addFirst(entry);
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileInvalidated(fileImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waitReady() ...");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.queue.isEmpty() && this.state != State.OFF) {
                this.lock.wait();
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waiting finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: suspending");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: resuming");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.ON;
            this.suspendLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry poll() throws InterruptedException {
        boolean bl;
        boolean bl2;
        ProjectBase projectBase;
        Object object = this.suspendLock;
        synchronized (object) {
            while (this.state == State.SUSPENDED) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: waiting for resume");
                }
                this.suspendLock.wait();
            }
        }
        object = null;
        FileImpl fileImpl = null;
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.queue.poll();
            if (object == null) {
                return null;
            }
            fileImpl = ((Entry)object).getFile();
            projectBase = fileImpl.getProjectImpl();
            ProjectData projectData = this.getProjectData(projectBase, true);
            projectData.filesInQueue.remove(fileImpl);
            projectData.filesBeingParsed.add(fileImpl);
            boolean bl3 = bl2 = projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty();
            if (bl2) {
                this.removeProjectData(projectBase);
            }
            boolean bl4 = bl = bl2 && projectData.notifyListeners;
            if (TraceFlags.TIMING && this.stopWatch != null && !this.stopWatch.isRunning()) {
                this.stopWatch.start();
                System.err.println("=== Starting parser queue stopwatch");
            }
        }
        ProgressSupport.instance().fireFileParsingStarted(fileImpl);
        if (bl2) {
            projectBase.onParseFinish();
            if (bl) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: polling " + ((Entry)object).getFile().getAbsolutePath());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FileImpl fileImpl) {
        ProjectBase projectBase;
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            projectBase = fileImpl.getProjectImpl();
            ProjectData projectData = this.getProjectData(projectBase, true);
            if (projectData.filesInQueue.contains(fileImpl)) {
                Entry entry = this.queue.find(fileImpl);
                if (entry != null) {
                    this.queue.remove(entry);
                }
                projectData.filesInQueue.remove(fileImpl);
                boolean bl3 = bl = projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty();
                if (bl) {
                    this.removeProjectData(projectBase);
                }
                bl2 = bl && projectData.notifyListeners;
            }
        }
        if (bl) {
            projectBase.onParseFinish();
            if (bl2) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: clearing");
        }
        ArrayList<ProjectBase> arrayList = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.state = State.OFF;
            this.queue.clear();
            arrayList = new ArrayList<ProjectBase>(this.projectData.keySet());
            this.lock.notifyAll();
        }
        for (ProjectBase projectBase : arrayList) {
            ProgressSupport.instance().fireProjectParsingFinished(projectBase);
        }
    }

    public void startup() {
        this.state = State.ON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ProjectBase projectBase) {
        boolean bl;
        ProjectData projectData;
        Object object = this.lock;
        synchronized (object) {
            projectData = this.getProjectData(projectBase, true);
            this.queue.removeAll(projectData.filesInQueue);
            projectData.filesInQueue.clear();
            bl = projectData.filesBeingParsed.isEmpty();
            if (bl) {
                this.removeProjectData(projectBase);
            }
        }
        if (bl) {
            projectBase.onParseFinish();
            if (projectData.notifyListeners) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsing(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData projectData = this.getProjectData(projectBase, false);
            if (projectData != null) {
                return !projectData.filesBeingParsed.isEmpty();
            }
        }
        return false;
    }

    public boolean hasFiles(ProjectBase projectBase, FileImpl fileImpl) {
        return this.hasFiles(projectBase, fileImpl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFiles(ProjectBase projectBase, FileImpl fileImpl, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData projectData = this.getProjectData(projectBase, bl);
            if (projectData == null || projectData.isEmpty()) {
                return false;
            }
            if (fileImpl == null) {
                return true;
            }
            if (projectData.filesBeingParsed.contains(fileImpl) || projectData.filesInQueue.contains(fileImpl)) {
                return projectData.filesBeingParsed.size() + projectData.filesInQueue.size() > 1;
            }
            return !projectData.isEmpty();
        }
    }

    private Set getProjectFiles(ProjectBase projectBase) {
        return this.getProjectData((ProjectBase)projectBase, (boolean)true).filesInQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectData getProjectData(ProjectBase projectBase, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            ProjectBase projectBase2 = projectBase;
            ProjectData projectData = this.projectData.get(projectBase2);
            if (projectData == null && bl) {
                projectData = new ProjectData(false);
                this.projectData.put(projectBase2, projectData);
            }
            return projectData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProjectData(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            this.projectData.remove(projectBase);
        }
    }

    private boolean needEnqueue(FileImpl fileImpl) {
        return !fileImpl.isParsed() && !fileImpl.getProjectImpl().isDisposing();
    }

    public void onStartAddingProjectFiles(ProjectBase projectBase) {
        this.getProjectData((ProjectBase)projectBase, (boolean)true).notifyListeners = true;
        ProgressSupport.instance().fireProjectParsingStarted(projectBase);
    }

    public void onEndAddingProjectFiles(ProjectBase projectBase) {
        int n = this.getProjectFiles(projectBase).size();
        ProgressSupport.instance().fireProjectFilesCounted(projectBase, n);
        if (n == 0) {
            ProgressSupport.instance().fireProjectParsingFinished(projectBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFileParsingFinished(FileImpl fileImpl) {
        boolean bl;
        ProjectData projectData;
        ProjectBase projectBase;
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            projectBase = fileImpl.getProjectImpl();
            projectData = this.getProjectData(projectBase, true);
            projectData.filesBeingParsed.remove(fileImpl);
            boolean bl3 = bl = projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty();
            if (bl) {
                this.removeProjectData(projectBase);
                bl2 = this.projectData.isEmpty();
                if (TraceFlags.TIMING && this.stopWatch != null && this.stopWatch.isRunning()) {
                    this.stopWatch.stopAndReport("=== Stopping parser queue stopwatch: \t");
                }
            }
        }
        ProgressSupport.instance().fireFileParsingFinished(fileImpl);
        if (bl) {
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Last file in project " + projectBase.getName());
            }
            projectBase.onParseFinish();
            if (projectData.notifyListeners) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
            if (bl2) {
                ProgressSupport.instance().fireIdle();
            }
            this.notifyWaitEmpty(projectBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitEmpty(ProjectBase projectBase) {
        Object object;
        Object object2 = this.projectLocks;
        synchronized (object2) {
            object = this.projectLocks.remove(projectBase);
        }
        if (object != null) {
            object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitEmpty(ProjectBase projectBase) {
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Waiting Empty Project " + projectBase.getName());
        }
        while (this.hasFiles(projectBase, null, false)) {
            Object object;
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Waiting Empty Project 2 " + projectBase.getName());
            }
            Object object2 = this.projectLocks;
            synchronized (object2) {
                object = this.projectLocks.get(projectBase);
                if (object == null) {
                    object = new String(((Object)projectBase.getName()).toString());
                    this.projectLocks.put(projectBase, object);
                }
            }
            object2 = object;
            synchronized (object2) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Finished waiting on Empty Project " + projectBase.getName());
        }
    }

    public long getStopWatchTime() {
        return TraceFlags.TIMING ? this.stopWatch.getTime() : -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ON,
        OFF,
        SUSPENDED;

    }

    private static final class ProjectData {
        public Set filesInQueue = new HashSet();
        public Collection filesBeingParsed = new LinkedList();
        public boolean notifyListeners;

        ProjectData(boolean bl) {
            this.notifyListeners = bl;
        }

        public boolean isEmpty() {
            return this.filesInQueue.isEmpty() && this.filesBeingParsed.isEmpty();
        }

        public int size() {
            return this.filesInQueue.size();
        }
    }

    private static class Queue {
        private Map<FileImpl, Entry> storage = new HashMap<FileImpl, Entry>();
        private Entry head;
        private Entry tail;

        private Queue() {
        }

        private void link(Entry entry, Entry entry2) {
            if (entry != null) {
                entry.next = entry2;
            }
            if (entry2 != null) {
                entry2.prev = entry;
            }
        }

        public void addFirst(Entry entry) {
            Entry entry2 = this.storage.put(entry.file, entry);
            assert (entry2 == null) : "only one entry per file must be in queue " + Entry.access$200(entry);
            this.link(entry, this.head);
            this.head = entry;
            if (this.tail == null) {
                this.tail = this.head;
            }
            entry.prev = null;
        }

        public void addLast(Entry entry) {
            if (this.tail == null) {
                assert (this.head == null);
                this.addFirst(entry);
            } else {
                Entry entry2 = this.storage.put(entry.file, entry);
                assert (entry2 == null) : "only one entry per file must be in queue " + Entry.access$200(entry);
                this.link(this.tail, entry);
                this.tail = entry;
            }
            entry.next = null;
        }

        public void remove(Entry entry) {
            Entry entry2 = this.storage.remove(entry.file);
            assert (entry2 != null) : "there were no entry in queue for file " + Entry.access$200(entry);
            this.link(entry.prev, entry.next);
            if (this.head == entry) {
                this.head = entry.next;
            }
            if (this.tail == entry) {
                this.tail = entry.prev;
            }
            entry.prev = (entry.next = null);
        }

        public void removeAll(Collection collection) {
            Entry entry = this.head;
            while (entry != null) {
                Entry entry2 = entry.next;
                if (collection.contains(entry.getFile())) {
                    this.remove(entry);
                }
                entry = entry2;
            }
        }

        public void clear() {
            this.storage.clear();
            this.tail = null;
            this.head = null;
        }

        public Entry peek() {
            return this.head;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public Entry find(FileImpl fileImpl) {
            return this.storage.get(fileImpl);
        }

        public Entry poll() {
            Entry entry = this.head;
            if (this.head != null) {
                this.remove(this.head);
            }
            return entry;
        }

        public String toString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            Entry entry = this.head;
            while (entry != null) {
                stringBuilder.append(entry.toString(bl)).append("\n");
                entry = entry.next;
            }
            return stringBuilder.toString();
        }
    }

    public static class Entry {
        private FileImpl file;
        private APTPreprocHandler.State ppState;
        private Entry prev;
        private Entry next;

        private Entry(FileImpl fileImpl, APTPreprocHandler.State state) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("creating entry for " + fileImpl.getAbsolutePath() + " as " + ParserQueue.tracePreprocState(state));
            }
            this.file = fileImpl;
            this.ppState = state;
        }

        public FileImpl getFile() {
            return this.file;
        }

        public APTPreprocHandler.State getPreprocState() {
            return this.ppState;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ParserQueue.Entry " + this.file + " of project " + this.file.getProject());
            if (bl) {
                stringBuilder.append("\nwith PreprocState:\n" + this.ppState);
            }
            return stringBuilder.toString();
        }

        public void setPreprocStateIfNeed(APTPreprocHandler.State state) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("setPreprocStateIfNeed for " + this.file.getAbsolutePath() + " as " + ParserQueue.tracePreprocState(state) + " with current " + ParserQueue.tracePreprocState(this.ppState));
            }
            if (this.file.isNeedReparse(this.ppState, state)) {
                this.ppState = state;
            }
        }
    }
}

