/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

class ClassifierContainer
implements Persistent,
SelfPersistent {
    private Map<CharSequence, CsmUID<CsmClassifier>> classifiers = new ConcurrentHashMap<CharSequence, CsmUID<CsmClassifier>>();
    private Map<CharSequence, CsmUID<CsmClassifier>> typedefs = new ConcurrentHashMap<CharSequence, CsmUID<CsmClassifier>>();

    public ClassifierContainer() {
    }

    public ClassifierContainer(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public CsmClassifier getClassifier(CharSequence charSequence) {
        CsmUID<CsmClassifier> csmUID = this.classifiers.get(charSequence = CharSequenceKey.create((CharSequence)charSequence));
        if (csmUID == null) {
            csmUID = this.typedefs.get(charSequence);
        }
        CsmClassifier csmClassifier = UIDCsmConverter.UIDtoDeclaration(csmUID);
        return csmClassifier;
    }

    public boolean putClassifier(CsmClassifier csmClassifier) {
        CharSequence charSequence = csmClassifier.getQualifiedName();
        Map<CharSequence, CsmUID<CsmClassifier>> map = this.isTypedef((CsmDeclaration)csmClassifier) ? this.typedefs : this.classifiers;
        if (!map.containsKey(charSequence)) {
            CsmUID<CsmClassifier> csmUID = UIDCsmConverter.declarationToUID(csmClassifier);
            assert (csmUID != null);
            map.put(charSequence, csmUID);
            assert (UIDCsmConverter.UIDtoDeclaration(csmUID) != null);
            return true;
        }
        return false;
    }

    public void removeClassifier(CsmDeclaration csmDeclaration) {
        Map<CharSequence, CsmUID<CsmClassifier>> map = this.isTypedef(csmDeclaration) ? this.typedefs : this.classifiers;
        CsmUID<CsmClassifier> csmUID = map.remove(csmDeclaration.getQualifiedName());
        assert (csmUID == null || UIDCsmConverter.UIDtoCsmObject(csmUID) != null) : " no object for UID " + csmUID;
    }

    public void clearClassifiers() {
        this.classifiers.clear();
        this.typedefs.clear();
    }

    private boolean isTypedef(CsmDeclaration csmDeclaration) {
        return CsmKindUtilities.isTypedef((CsmObject)csmDeclaration);
    }

    public void write(DataOutput dataOutput) throws IOException {
        UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.classifiers, dataOutput, false);
        UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.typedefs, dataOutput, false);
    }

    private void read(DataInput dataInput) throws IOException {
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.classifiers, dataInput, QualifiedNameCache.getManager());
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.typedefs, dataInput, QualifiedNameCache.getManager());
    }
}

