/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassEnumBase<T>
extends OffsetableDeclarationBase<T>
implements Disposable,
CsmCompoundClassifier<T>,
CsmMember<T> {
    private final CharSequence name;
    private CharSequence qualifiedName;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private boolean isValid = true;
    private boolean _static = false;
    private CsmVisibility visibility = CsmVisibility.PRIVATE;
    private final List<CsmUID<CsmTypedef>> enclosingTypdefs = Collections.synchronizedList(new ArrayList());

    protected ClassEnumBase(String string, CsmFile csmFile, AST aST) {
        super(aST, csmFile);
        this.name = string == null ? CharSequenceKey.empty() : NameCache.getManager().getString((CharSequence)string);
    }

    public CharSequence getName() {
        return this.name;
    }

    protected void init(CsmScope csmScope, AST aST) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null) : "null UID for class scope " + csmScope;
            this.scopeRef = null;
        } else {
            this.scopeRef = csmScope;
        }
        CharSequence charSequence = this.getQualifiedNamePostfix();
        this.qualifiedName = CsmKindUtilities.isNamespace((CsmObject)csmScope) ? Utils.getQualifiedName(((Object)charSequence).toString(), (CsmNamespace)csmScope) : (CsmKindUtilities.isClass((CsmObject)csmScope) ? ((CsmClass)csmScope).getQualifiedName() + "::" + charSequence : charSequence);
        this.qualifiedName = QualifiedNameCache.getManager().getString(this.qualifiedName);
    }

    public abstract CsmDeclaration.Kind getKind();

    protected void register(CsmScope csmScope, boolean bl) {
        RepositoryUtils.put(this);
        boolean bl2 = bl;
        if (ProjectBase.canRegisterDeclaration((CsmDeclaration)this)) {
            this.registerInProject();
            bl2 = true;
        }
        if (bl2 && this.getContainingClass() == null && CsmKindUtilities.isNamespace((CsmObject)csmScope)) {
            ((NamespaceImpl)csmScope).addDeclaration(this);
        }
    }

    private void registerInProject() {
        ((ProjectBase)this.getContainingFile().getProject()).registerDeclaration(this);
    }

    private void unregisterInProject() {
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration((CsmDeclaration)this);
        this.cleanUID();
    }

    public NamespaceImpl getContainingNamespaceImpl() {
        CsmScope csmScope = this.getScope();
        return csmScope instanceof NamespaceImpl ? (NamespaceImpl)csmScope : null;
    }

    public CharSequence getQualifiedName() {
        return this.qualifiedName;
    }

    public CsmScope getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (csmScope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return csmScope;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.getContainingNamespaceImpl() != null) {
            this.getContainingNamespaceImpl().removeDeclaration(this);
        }
        this.unregisterInProject();
        this.isValid = false;
    }

    private void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public boolean isValid() {
        return this.isValid && this.getContainingFile().isValid();
    }

    public CsmClass getContainingClass() {
        CsmScope csmScope = this.getScope();
        return CsmKindUtilities.isClass((CsmObject)csmScope) ? (CsmClass)csmScope : null;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(CsmVisibility csmVisibility) {
        this.visibility = csmVisibility;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean bl) {
        this._static = bl;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeBoolean(this.isValid);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        assert (this.qualifiedName != null);
        dataOutput.writeUTF(((Object)this.qualifiedName).toString());
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
        dataOutput.writeBoolean(this._static);
        assert (this.visibility != null);
        PersistentUtils.writeVisibility(this.visibility, dataOutput);
        if (this.getName().length() == 0) {
            super.writeUID(dataOutput);
        }
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enclosingTypdefs, dataOutput, true);
    }

    protected ClassEnumBase(DataInput dataInput) throws IOException {
        super(dataInput);
        this.isValid = dataInput.readBoolean();
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.qualifiedName != null);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeRef = null;
        this._static = dataInput.readBoolean();
        this.visibility = PersistentUtils.readVisibility(dataInput);
        assert (this.visibility != null);
        if (this.getName().length() == 0) {
            super.readUID(dataInput);
        }
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enclosingTypdefs, dataInput);
    }

    public Collection<CsmTypedef> getEnclosingTypedefs() {
        return UIDCsmConverter.UIDsToDeclarations(this.enclosingTypdefs);
    }

    public void addEnclosingTypedef(CsmTypedef csmTypedef) {
        this.enclosingTypdefs.add((CsmUID<CsmTypedef>)csmTypedef.getUID());
    }
}

