/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import antlr.TokenStream;
import antlr.collections.AST;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.cache.CacheManager;
import org.netbeans.modules.cnd.modelimpl.cache.FileCache;
import org.netbeans.modules.cnd.modelimpl.cache.impl.FileCacheImpl;
import org.netbeans.modules.cnd.modelimpl.cache.impl.FileCacheWeakImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;

final class FileCacheSyncBridge {
    private FileCacheWeakImpl storage;
    private boolean astMaybeOnDisk;
    private boolean aptMaybeOnDisk;
    private boolean aptLightMaybeOnDisk;
    private CsmUID<CsmFile> fileUID;
    private String absPath;
    private boolean validCache = true;
    private Object createAPTLock = new Object(){

        public String toString() {
            return "APT creating lock for " + FileCacheSyncBridge.this._getAbsolutePath();
        }
    };
    private Object loadLock = new Object();
    private String aptLock;
    private String aptLightLock;
    private String astLock;

    public FileCacheSyncBridge(FileImpl fileImpl) {
        assert (fileImpl != null);
        this.storage = new FileCacheWeakImpl();
        if (fileImpl.getBuffer().isFileBased()) {
            this.astMaybeOnDisk = true;
            this.aptMaybeOnDisk = true;
            this.aptLightMaybeOnDisk = true;
        } else {
            this.astMaybeOnDisk = false;
            this.aptMaybeOnDisk = false;
            this.aptLightMaybeOnDisk = false;
        }
        this._setFile(fileImpl);
        this.initLocks(this._getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APTFile findAPT() {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: findAPT for " + this._getAbsolutePath());
        }
        APTFile aPTFile = null;
        String string = this.aptLock;
        synchronized (string) {
            aPTFile = this.storage.getAPT();
            if (aPTFile == null && this.validCache) {
                if (this.aptMaybeOnDisk) {
                    Object object = this.loadLock;
                    synchronized (object) {
                        aPTFile = this.storage.getAPT();
                        if (aPTFile == null && this.validCache && this.aptMaybeOnDisk) {
                            FileCache fileCache;
                            if (TraceFlags.TRACE_CACHE) {
                                System.err.println("CACHE: findAPT loading from disk for " + this._getAbsolutePath());
                            }
                            if ((fileCache = this.loadValidCache()) != null) {
                                if (TraceFlags.TRACE_CACHE) {
                                    System.err.println("CACHE: findAPT loaded from disk for " + this._getAbsolutePath());
                                }
                                aPTFile = fileCache.getAPT();
                            }
                        }
                    }
                    if (aPTFile == null) {
                        this.aptMaybeOnDisk = false;
                    }
                }
                if (aPTFile == null) {
                    aPTFile = this.createAPTFull();
                }
            }
            this.storage.setAPT(null);
        }
        return aPTFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APTFile findAPTLight() {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: findAPTLight for " + this._getAbsolutePath());
        }
        APTFile aPTFile = null;
        String string = this.aptLightLock;
        synchronized (string) {
            aPTFile = this.storage.getAPTLight();
            if (aPTFile == null && this.validCache) {
                if (this.aptLightMaybeOnDisk) {
                    Object object = this.loadLock;
                    synchronized (object) {
                        aPTFile = this.storage.getAPTLight();
                        if (aPTFile == null && this.validCache && this.aptLightMaybeOnDisk) {
                            FileCache fileCache;
                            if (TraceFlags.TRACE_CACHE) {
                                System.err.println("CACHE: findAPTLight loading from disk for " + this._getAbsolutePath());
                            }
                            if ((fileCache = this.loadValidCache()) != null) {
                                if (TraceFlags.TRACE_CACHE) {
                                    System.err.println("CACHE: findAPTLight loaded from disk for " + this._getAbsolutePath());
                                }
                                aPTFile = fileCache.getAPTLight();
                            }
                        }
                    }
                    if (aPTFile == null) {
                        this.aptLightMaybeOnDisk = false;
                    }
                }
                if (aPTFile == null) {
                    aPTFile = this.createAPTLight();
                }
            }
        }
        if (TraceFlags.TRACE_CACHE && aPTFile == null) {
            System.err.println("CACHE: WARNING!!! No APT Light for " + this._getAbsolutePath());
        }
        return aPTFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileCache findCacheWithAST(APTPreprocHandler aPTPreprocHandler) {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: findCacheWithAST for " + this._getAbsolutePath());
        }
        AST aST = null;
        APTFile aPTFile = null;
        APTFile aPTFile2 = null;
        FileCache fileCache = null;
        String string = this.astLock;
        synchronized (string) {
            aST = this.storage.getAST(aPTPreprocHandler);
            if (aST == null) {
                if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: findCacheWithAST AST not in memory for " + this._getAbsolutePath());
                }
                if (this.validCache && this.astMaybeOnDisk) {
                    Object object = this.loadLock;
                    synchronized (object) {
                        aST = this.storage.getAST(aPTPreprocHandler);
                        if (aST == null && this.validCache && this.astMaybeOnDisk) {
                            if (TraceFlags.TRACE_CACHE) {
                                System.err.println("CACHE: findCacheWithAST loading AST for " + this._getAbsolutePath());
                            }
                            if ((fileCache = this.loadValidCache()) != null) {
                                aST = fileCache.getAST(aPTPreprocHandler);
                                if (TraceFlags.TRACE_CACHE) {
                                    System.err.println("CACHE: findCacheWithAST loaded AST from disk for " + this._getAbsolutePath());
                                }
                            }
                        }
                    }
                } else if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: findCacheWithAST not necessary load cache, because AST not in it for " + this._getAbsolutePath());
                }
                if (fileCache == null) {
                    aPTFile2 = this.storage.getAPT();
                    if (aPTFile2 == null) {
                        if (TraceFlags.TRACE_CACHE) {
                            System.err.println("CACHE: findCacheWithAST (AST preparation) creating APT for " + this._getAbsolutePath());
                        }
                        if ((aPTFile2 = this.createAPT(true)) != null) {
                            aPTFile = this.storage.getAPTLight();
                            assert (aPTFile != null);
                        } else {
                            aPTFile = null;
                        }
                    } else {
                        if (TraceFlags.TRACE_CACHE) {
                            System.err.println("CACHE: findCacheWithAST (AST preparation) got APT from memory for " + this._getAbsolutePath());
                        }
                        aPTFile = this.storage.getAPTLight();
                    }
                }
            } else {
                aPTFile = this.storage.getAPTLight();
            }
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: findCacheWithAST clear APT and AST after request to AST");
            }
            this.storage.setAPT(null);
            this.storage.setAST(null, null);
            this.astMaybeOnDisk = fileCache == null ? aST != null : fileCache.getAST(null) != null;
        }
        if (TraceFlags.TRACE_CACHE && aPTFile == null && fileCache == null) {
            System.err.println("CACHE: no APT light while getting AST for " + this._getAbsolutePath());
        }
        return fileCache == null ? new FileCacheImpl(aPTFile, aPTFile2, aST) : fileCache;
    }

    void invalidate() {
        this.validCache = false;
    }

    public void updateStorage(FileCache fileCache) {
        APTFile aPTFile = fileCache.getAPTLight();
        if (aPTFile != null) {
            this.storage.setAPTLight(aPTFile);
            this.aptLightMaybeOnDisk = true;
        }
        if (fileCache.getAPT() != null) {
            this.aptMaybeOnDisk = true;
        }
        if (fileCache.getAST(null) != null) {
            this.astMaybeOnDisk = true;
        }
    }

    private APTFile createAPTFull() {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: creating full APT for " + this._getAbsolutePath());
        }
        return this.createAPT(true);
    }

    private APTFile createAPTLight() {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: creating APT light for " + this._getAbsolutePath());
        }
        return this.createAPT(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private APTFile createAPT(boolean bl) {
        Object object = this.createAPTLock;
        synchronized (object) {
            APTFile aPTFile;
            APTFile aPTFile2 = aPTFile = bl ? this.storage.getAPT() : this.storage.getAPTLight();
            if (aPTFile != null) return aPTFile;
            String string = this._getAbsolutePath();
            Reader reader = null;
            reader = this._getFile().getBuffer().getReader();
            TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream((String)string, (Reader)reader);
            APTFile aPTFile3 = APTBuilder.buildAPT((String)string, (TokenStream)tokenStream);
            if (aPTFile3 != null) {
                this.storage.setAPT(aPTFile3);
                APTFile aPTFile4 = (APTFile)APTBuilder.buildAPTLight((APT)aPTFile3);
                assert (aPTFile4 != null);
                this.storage.setAPTLight(aPTFile4);
                APTFile aPTFile5 = aPTFile = bl ? aPTFile3 : aPTFile4;
            }
            if (reader == null) return aPTFile;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                APTUtils.LOG.log(Level.INFO, "closing stream: {0}", new Object[]{iOException.getMessage()});
                DiagnosticExceptoins.register(iOException);
            }
            {
            }
            catch (IOException iOException) {
                try {
                    APTUtils.LOG.log(Level.INFO, "create stream: {0}", new Object[]{iOException.getMessage()});
                    DiagnosticExceptoins.register(iOException);
                    if (reader == null) return aPTFile;
                }
                catch (Throwable throwable) {
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {
                        APTUtils.LOG.log(Level.INFO, "closing stream: {0}", new Object[]{iOException2.getMessage()});
                        DiagnosticExceptoins.register(iOException2);
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException iOException3) {
                    APTUtils.LOG.log(Level.INFO, "closing stream: {0}", new Object[]{iOException3.getMessage()});
                    DiagnosticExceptoins.register(iOException3);
                }
                {
                }
            }
            return aPTFile;
        }
    }

    private FileCache loadValidCache() {
        FileCache fileCache = CacheManager.getInstance().loadValidCache(this._getFile());
        if (fileCache != null) {
            this.storage.setAPT(fileCache.getAPT());
            this.aptMaybeOnDisk = fileCache.getAPT() != null;
            this.storage.setAPTLight(fileCache.getAPTLight());
            this.aptLightMaybeOnDisk = fileCache.getAPTLight() != null;
            this.storage.setAST(fileCache.getAST(null), null);
            this.astMaybeOnDisk = fileCache.getAST(null) != null;
        }
        return fileCache;
    }

    private String _getAbsolutePath() {
        return this.absPath;
    }

    private void _setFile(FileImpl fileImpl) {
        this.absPath = fileImpl.getAbsolutePath();
        this.fileUID = UIDCsmConverter.fileToUID(fileImpl);
    }

    private FileImpl _getFile() {
        FileImpl fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile(this.fileUID);
        assert (fileImpl != null);
        return fileImpl;
    }

    private void initLocks(String string) {
        this.aptLock = new String("APT lock for " + string);
        this.aptLightLock = new String("APT Light lock for " + string);
        this.astLock = new String("AST lock for " + string);
    }
}

