/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.cache.FileCache;
import org.netbeans.modules.cnd.modelimpl.cache.impl.FileCacheSyncBridge;
import org.netbeans.modules.cnd.modelimpl.cache.impl.MasterIndex;
import org.netbeans.modules.cnd.modelimpl.cache.impl.ProjectCache;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public final class CacheManagerImpl {
    private String cacheDir;
    private WeakHashMap projectCache = new WeakHashMap();
    private MasterIndex index = new MasterIndex();
    private Map<CharSequence, Object> fileLocks = new HashMap<CharSequence, Object>();
    private boolean loaded = false;
    private final String loadLock = new String("CacheManagerImpl load lock");

    public CacheManagerImpl() {
        this.cacheDir = ParserThreadManager.instance().isStandalone() ? System.getProperty("java.io.tmpdir") : System.getProperty("netbeans.user");
        this.cacheDir = this.cacheDir + File.separatorChar + "var" + File.separatorChar + "cache" + File.separatorChar + "cndcache";
        new File(this.cacheDir).mkdirs();
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: Cache dir:" + this.cacheDir);
        }
        this.load();
    }

    public APTFile findAPT(CsmFile csmFile) {
        return this.getSyncCacheBridge((FileImpl)csmFile).findAPT();
    }

    public APTFile findAPTLight(CsmFile csmFile) {
        return this.getSyncCacheBridge((FileImpl)csmFile).findAPTLight();
    }

    public FileCache findCacheWithAST(CsmFile csmFile, APTPreprocHandler aPTPreprocHandler) {
        return this.getSyncCacheBridge((FileImpl)csmFile).findCacheWithAST(aPTPreprocHandler);
    }

    public void projectOpened(CsmProject csmProject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed(CsmProject csmProject) {
        if (this.projectCache == null || this.index == null) {
            return;
        }
        String string = this.loadLock;
        synchronized (string) {
            ProjectCache projectCache = null;
            Object object = this.projectCache;
            synchronized (object) {
                projectCache = (ProjectCache)this.projectCache.remove(csmProject);
            }
            if (projectCache != null) {
                assert (this.index != null);
                object = this.index.getProjectDir(csmProject);
                assert (object != null);
                projectCache.close(this.cacheDir + File.separatorChar + (String)object);
            }
        }
    }

    public void modelChanged(CsmChangeEvent csmChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFile(CsmFile csmFile) {
        Object object = this.fileLocks;
        synchronized (object) {
            this.fileLocks.remove(csmFile.getAbsolutePath());
        }
        object = this.getProjectCache(csmFile.getProject(), false);
        if (object != null) {
            ((ProjectCache)object).invalidateFile(((Object)csmFile.getAbsolutePath()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllFiles(String string) {
        ProjectCache[] projectCacheArray = this.fileLocks;
        synchronized (this.fileLocks) {
            this.fileLocks.remove(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            projectCacheArray = this.getProjectCaches();
            for (int i = 0; i < projectCacheArray.length; ++i) {
                ProjectCache projectCache = projectCacheArray[i];
                projectCache.invalidateFile(string);
            }
            return;
        }
    }

    public void changeDir(String string) {
        this.cacheDir = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectCache getProjectCache(CsmProject csmProject, boolean bl) {
        this.load();
        assert (csmProject != null);
        ProjectCache projectCache = null;
        WeakHashMap weakHashMap = this.projectCache;
        synchronized (weakHashMap) {
            projectCache = (ProjectCache)this.projectCache.get(csmProject);
            if (projectCache == null && bl) {
                String string;
                if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: creating Project cache for " + csmProject.getName());
                }
                if ((string = this.index.getProjectDir(csmProject)) == null) {
                    string = this.index.putProject(csmProject);
                }
                projectCache = new ProjectCache(this.cacheDir + File.separatorChar + string);
                this.projectCache.put(csmProject, projectCache);
            }
        }
        assert (projectCache != null || !bl);
        return projectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectCache[] getProjectCaches() {
        this.load();
        ProjectCache[] projectCacheArray = null;
        WeakHashMap weakHashMap = this.projectCache;
        synchronized (weakHashMap) {
            Collection collection = this.projectCache.values();
            projectCacheArray = collection.toArray(new ProjectCache[collection.size()]);
        }
        assert (projectCacheArray != null);
        return projectCacheArray;
    }

    private FileCacheSyncBridge getSyncCacheBridge(FileImpl fileImpl) {
        return this.getProjectCache(fileImpl.getProject(), true).getSyncCacheBridge(fileImpl);
    }

    private File getValidCacheFile(CsmFile csmFile, boolean bl) {
        assert (csmFile != null);
        assert (this.cacheDir != null);
        String string = this.index.getProjectDir(csmFile.getProject());
        File file = null;
        if (string != null) {
            String string2 = this.cacheDir + File.separatorChar + string;
            CharSequence charSequence = this.getProjectCache(csmFile.getProject(), true).getValidCacheFileName((FileImpl)csmFile, bl);
            if (charSequence != null) {
                file = new File(string2, ((Object)charSequence).toString());
            }
        } else if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: no cache dir for project " + csmFile.getProject().getName());
        }
        return file;
    }

    public FileCache loadValidCache(CsmFile csmFile) {
        FileCache fileCache = null;
        File file = this.getValidCacheFile(csmFile, false);
        if (file != null) {
            fileCache = this.loadFile(file);
            if (TraceFlags.TRACE_CACHE && fileCache == null) {
                System.err.println("CACHE: Failed load cache " + file.getAbsolutePath() + " for:" + csmFile.getAbsolutePath());
            }
        } else if (TraceFlags.TRACE_CACHE) {
            if (((FileImpl)csmFile).getBuffer().isFileBased()) {
                System.err.println("CACHE: not found valid cache for:" + csmFile.getAbsolutePath());
            } else {
                System.err.println("CACHE: do not load cache for document based file-buffer:" + csmFile.getAbsolutePath());
            }
        }
        return fileCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileCache loadFile(File file) {
        assert (file != null);
        FileCache fileCache = null;
        ObjectInputStream objectInputStream = null;
        Object object = this.getCacheFileLock(file);
        assert (object != null);
        Object object2 = object;
        synchronized (object2) {
            try {
                InputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    inputStream = new BufferedInputStream(inputStream);
                    objectInputStream = new ObjectInputStream(inputStream);
                }
                finally {
                    if (inputStream != null && objectInputStream == null) {
                        inputStream.close();
                    }
                }
                if (objectInputStream != null) {
                    fileCache = (FileCache)objectInputStream.readObject();
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                DiagnosticExceptoins.register(classNotFoundException);
                APTUtils.LOG.log(Level.SEVERE, "load cache file: {0}", new Object[]{classNotFoundException.getMessage()});
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return fileCache;
    }

    public void saveCache(CsmFile csmFile, FileCache fileCache) {
        Object var3_3 = null;
        File file = this.getValidCacheFile(csmFile, true);
        FileCacheSyncBridge fileCacheSyncBridge = this.getSyncCacheBridge((FileImpl)csmFile);
        assert (file != null);
        if (this.save2File(file, fileCache)) {
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: saved cache for:" + csmFile.getAbsolutePath());
            }
            fileCacheSyncBridge.updateStorage(fileCache);
        } else if (TraceFlags.TRACE_CACHE) {
            if (((FileImpl)csmFile).getBuffer().isFileBased()) {
                System.err.println("CACHE: FAILED saving cache " + file.getAbsolutePath() + " for:" + csmFile.getAbsolutePath());
            } else {
                System.err.println("CACHE: do not save cache for document based file-buffer:" + csmFile.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save2File(File file, FileCache fileCache) {
        assert (file != null);
        ObjectOutputStream objectOutputStream = null;
        Object object = this.getCacheFileLock(file);
        assert (object != null);
        Object object2 = object;
        synchronized (object2) {
            block23: {
                boolean bl;
                try {
                    OutputStream outputStream = null;
                    try {
                        outputStream = new FileOutputStream(file);
                        outputStream = new BufferedOutputStream(outputStream);
                        objectOutputStream = new ObjectOutputStream(outputStream);
                    }
                    finally {
                        if (outputStream != null && objectOutputStream == null) {
                            outputStream.close();
                        }
                    }
                    if (objectOutputStream == null) return false;
                    objectOutputStream.writeObject(fileCache);
                    bl = true;
                }
                catch (IOException iOException) {
                    break block23;
                }
                return bl;
                finally {
                    if (objectOutputStream != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCacheFileLock(File file) {
        Object object = null;
        Map<CharSequence, Object> map = this.fileLocks;
        synchronized (map) {
            String string = file.getAbsolutePath();
            object = this.fileLocks.get(string);
            if (object == null) {
                object = new FileLock(string);
                this.fileLocks.put(string, object);
            }
        }
        assert (object != null);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (!this.loaded) {
            String string = this.loadLock;
            synchronized (string) {
                this.index = new MasterIndex();
                this.loadIndex(this.cacheDir);
                this.fileLocks = new HashMap<CharSequence, Object>();
                this.projectCache = new WeakHashMap();
                this.loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        if (TraceFlags.TRACE_CACHE) {
            System.err.println("CACHE: saving cache manager data in " + this.cacheDir);
        }
        String string = this.loadLock;
        synchronized (string) {
            this.storeIndex(this.cacheDir);
            this.saveProjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        String string = this.loadLock;
        synchronized (string) {
            this.store();
            this.loaded = false;
            this.projectCache = new WeakHashMap();
            this.index = new MasterIndex();
        }
    }

    private void loadIndex(String string) {
        File file = this.getMasterIndexFile(string);
        boolean bl = this.index.load(file);
        if (TraceFlags.TRACE_CACHE) {
            if (bl) {
                System.err.println("CACHE: loaded master index:" + file.getAbsolutePath());
                System.err.println("CACHE: index value" + this.index);
            } else {
                System.err.println("CACHE: master index not found:" + file.getAbsolutePath());
            }
        }
    }

    private void storeIndex(String string) {
        if (this.index == null) {
            return;
        }
        File file = this.getMasterIndexFile(string);
        boolean bl = this.index.save(file);
        if (TraceFlags.TRACE_CACHE) {
            if (bl) {
                System.err.println("CACHE: saved master index:" + file.getAbsolutePath());
                System.err.println("index value:" + this.index.toString());
            } else {
                System.err.println("CACHE: errors on saving master index:" + file.getAbsolutePath());
            }
        }
    }

    private File getMasterIndexFile(String string) {
        String string2 = string + File.separatorChar + "index.dat";
        File file = new File(string2);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProjects() {
        HashMap hashMap = new HashMap();
        WeakHashMap weakHashMap = this.projectCache;
        synchronized (weakHashMap) {
            hashMap.putAll(this.projectCache);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            CsmProject csmProject = (CsmProject)entry.getKey();
            String string = this.index.getProjectDir(csmProject);
            if (string != null) {
                String string2 = this.cacheDir + File.separatorChar + string;
                ProjectCache projectCache = (ProjectCache)entry.getValue();
                assert (projectCache != null);
                projectCache.store(string2);
                continue;
            }
            System.err.println("SEVERE: CACHE (saveProjects): not found cache directory for project " + csmProject.getName());
        }
    }

    private static class FileLock {
        String path;

        private FileLock(String string) {
            this.path = string;
        }

        public String toString() {
            return "read/write cache lock for " + this.path;
        }
    }
}

