/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchNodeChildren;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.Kit;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.NodeOperation2;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public final class BranchSelector
implements Runnable {
    private CVSRoot root;
    private String module;
    private File file;
    private Node rootNode;
    private BranchNodeChildren rootKids;

    public String selectTag(File file) {
        this.file = file;
        return this.showSelector();
    }

    public String selectTag(CVSRoot cVSRoot, String string) {
        this.root = cVSRoot;
        this.module = string;
        return this.showSelector();
    }

    private String showSelector() {
        this.rootKids = new BranchNodeChildren();
        this.rootNode = new AbstractNode((Children)this.rootKids);
        RequestProcessor.getDefault().post((Runnable)this);
        try {
            NodeOperation2 nodeOperation2 = new NodeOperation2();
            nodeOperation2.setIconsVisible(false);
            nodeOperation2.setRootVisible(false);
            nodeOperation2.setHelpCtx(new HelpCtx(BranchSelector.class));
            Node[] nodeArray = nodeOperation2.select(NbBundle.getMessage(BranchSelector.class, (String)"BK2012"), NbBundle.getMessage(BranchSelector.class, (String)"BK2013"), NbBundle.getMessage(BranchSelector.class, (String)"ACSD_BranchSelect"), this.rootNode, NbBundle.getMessage(BranchSelector.class, (String)"ACSN_BranchesTree"), NbBundle.getMessage(BranchSelector.class, (String)"ACSD_BranchesTree"), new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodeArray) {
                    if (nodeArray.length != 1) {
                        return false;
                    }
                    return nodeArray[0].getLookup().lookup(String.class) != null;
                }
            });
            Node node = nodeArray[0];
            String string = (String)node.getLookup().lookup(String.class);
            return string;
        }
        catch (UserCancelException userCancelException) {
            return null;
        }
    }

    private File[] getLoggableFiles(String string) throws CommandException, AuthenticationException {
        Object object;
        Client client;
        File[] fileArray;
        File file;
        GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
        if (this.root != null) {
            globalOptions.setCVSRoot(this.root.toString());
        }
        if ((file = Kit.createTmpFolder()) == null) {
            this.error(NbBundle.getMessage(BranchSelector.class, (String)"BK2015"));
            return new File[0];
        }
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        checkoutCommand.setRecursive(false);
        if (".".equals(string)) {
            int n;
            fileArray = Kit.createClient(this.root);
            client = ModuleSelector.listRepositoryPath((Client)fileArray, this.root, "");
            int n2 = n = client.size();
            object = new Random();
            while (n2-- > 0) {
                int n3 = ((Random)object).nextInt(n);
                String string2 = (String)client.get(n3);
                if ("CVSROOT".equals(string2)) continue;
                string = string2;
                break;
            }
        }
        checkoutCommand.setModule(string);
        fileArray = new File[]{file};
        checkoutCommand.setFiles(fileArray);
        client = Kit.createClient(this.root);
        client.setLocalPath(file.getAbsolutePath());
        client.executeCommand((Command)checkoutCommand, globalOptions);
        File file2 = new File(file, string);
        if (!file2.isDirectory()) {
            file2 = file;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File object2 : file2.listFiles()) {
            if ("CVSROOT".equals(object2.getName()) || "CVS".equals(object2.getName())) continue;
            arrayList.add(object2);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new File[arrayList.size()]);
        }
        client = Kit.createClient(this.root);
        object = ModuleSelector.listRepositoryPath(client, this.root, string);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string2 = string + "/" + string3;
            File[] fileArray2 = this.getLoggableFiles(string2);
            if (fileArray2.length <= 0) continue;
            return fileArray2;
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        File file;
        block17: {
            block16: {
                GlobalOptions globalOptions = CvsVersioningSystem.createGlobalOptions();
                if (this.root != null) {
                    globalOptions.setCVSRoot(this.root.toString());
                }
                file = null;
                try {
                    try {
                        Object object;
                        File file2;
                        File[] fileArray;
                        if (this.file == null) {
                            fileArray = this.getLoggableFiles(this.module);
                            file2 = fileArray.length > 0 ? fileArray[0].getParentFile() : null;
                        } else if (this.file.isDirectory()) {
                            fileArray = this.file.listFiles();
                            file2 = this.file;
                        } else {
                            fileArray = new File[]{this.file};
                            file2 = this.file.getParentFile();
                        }
                        ArrayList arrayList = new ArrayList(fileArray.length);
                        this.fillLogFiles(fileArray, arrayList);
                        if (arrayList.isEmpty()) {
                            this.tagsLoaded(Collections.EMPTY_SET, Collections.EMPTY_SET);
                            Object var13_10 = null;
                            break block16;
                        }
                        LogCommand logCommand = new LogCommand();
                        logCommand.setHeaderOnly(true);
                        File[] fileArray2 = arrayList.toArray(new File[arrayList.size()]);
                        logCommand.setFiles(fileArray2);
                        if (this.root == null) {
                            for (int i = 0; i < fileArray2.length; ++i) {
                                try {
                                    this.root = CVSRoot.parse((String)Utils.getCVSRootFor(fileArray2[i]));
                                    break;
                                }
                                catch (IOException iOException) {
                                    object = ErrorManager.getDefault();
                                    object.annotate((Throwable)iOException, "Can not find CVSROOT for " + fileArray2[i]);
                                    object.notify(1, (Throwable)iOException);
                                    continue;
                                }
                            }
                        }
                        Client client = Kit.createClient(this.root);
                        TreeSet treeSet = new TreeSet();
                        object = new TreeSet();
                        EventManager eventManager = client.getEventManager();
                        eventManager.addCVSListener(new CVSListener((Set)object, treeSet){
                            final /* synthetic */ Set val$branches;
                            final /* synthetic */ Set val$tags;
                            {
                                this.val$branches = set;
                                this.val$tags = set2;
                            }

                            public void messageSent(MessageEvent messageEvent) {
                            }

                            public void messageSent(BinaryMessageEvent binaryMessageEvent) {
                            }

                            public void fileAdded(FileAddedEvent fileAddedEvent) {
                            }

                            public void fileToRemove(FileToRemoveEvent fileToRemoveEvent) {
                            }

                            public void fileRemoved(FileRemovedEvent fileRemovedEvent) {
                            }

                            public void fileUpdated(FileUpdatedEvent fileUpdatedEvent) {
                            }

                            public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
                                LogInformation logInformation = (LogInformation)fileInfoEvent.getInfoContainer();
                                List list = logInformation.getAllSymbolicNames();
                                for (LogInformation.SymName symName : list) {
                                    if (symName.isBranch()) {
                                        this.val$branches.add(symName.getName());
                                        continue;
                                    }
                                    this.val$tags.add(symName.getName());
                                }
                            }

                            public void commandTerminated(TerminationEvent terminationEvent) {
                            }

                            public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
                            }
                        });
                        client.setLocalPath(file2.getAbsolutePath());
                        client.executeCommand((Command)logCommand, globalOptions);
                        this.tagsLoaded((Collection)object, treeSet);
                        Kit.deleteRecursively(file);
                        break block17;
                    }
                    catch (CommandException commandException) {
                        this.error(NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)commandException, NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
                        errorManager.notify((Throwable)commandException);
                        Object var13_12 = null;
                        Kit.deleteRecursively(file);
                        return;
                    }
                    catch (AuthenticationException authenticationException) {
                        this.error(NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
                        ErrorManager errorManager = ErrorManager.getDefault();
                        errorManager.annotate((Throwable)authenticationException, NbBundle.getMessage(BranchSelector.class, (String)"BK2016"));
                        errorManager.notify((Throwable)authenticationException);
                        Object var13_13 = null;
                        Kit.deleteRecursively(file);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    Kit.deleteRecursively(file);
                    throw throwable;
                }
            }
            Kit.deleteRecursively(file);
            return;
        }
        Object var13_11 = null;
        Kit.deleteRecursively(file);
    }

    private void fillLogFiles(File[] fileArray, List list) {
        int n;
        if (fileArray == null) {
            return;
        }
        if (!list.isEmpty()) {
            return;
        }
        for (n = 0; n < fileArray.length; ++n) {
            FileInformation fileInformation;
            if (!fileArray[n].isFile() || ((fileInformation = CvsVersioningSystem.getInstance().getStatusCache().getStatus(fileArray[n])).getStatus() & 0xFF8) == 0) continue;
            list.add(fileArray[n]);
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory()) continue;
            this.fillLogFiles(fileArray[n].listFiles(), list);
        }
    }

    private void tagsLoaded(Collection collection, Collection collection2) {
        this.rootKids.setBranches(collection);
        this.rootKids.setTags(collection2);
    }

    private void error(String string) {
        this.rootNode.setDisplayName(string);
    }
}

