/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.TooltipWindow;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionAction;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener {
    private static final double DARKEN_FACTOR = 0.95;
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;

    public SummaryView(SearchHistoryPanel searchHistoryPanel, List list) {
        this.master = searchHistoryPanel;
        this.dispResults = SummaryView.expandResults(list);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fontColorSettings.getFontColors("highlight-search");
        this.message = searchHistoryPanel.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        searchHistoryPanel.addComponentListener(this);
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.onPopup(Utils.getPositionForPopup((JList)SummaryView.this.resultsList));
            }
        });
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int[] nArray = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(nArray);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private static List expandResults(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (Object e : list) {
            Object object;
            if (e instanceof SearchHistoryPanel.ResultsContainer) {
                arrayList.add(e);
                object = (SearchHistoryPanel.ResultsContainer)e;
                for (SearchHistoryPanel.DispRevision dispRevision : ((SearchHistoryPanel.ResultsContainer)object).getRevisions()) {
                    if (dispRevision.getRevision().getNumber() == "" || dispRevision.isBranchRoot()) continue;
                    arrayList.add(dispRevision);
                }
                for (SearchHistoryPanel.DispRevision dispRevision : ((SearchHistoryPanel.ResultsContainer)object).getRevisions()) {
                    SummaryView.addResults(arrayList, dispRevision, 1);
                }
                continue;
            }
            object = (SearchHistoryPanel.DispRevision)e;
            if (((SearchHistoryPanel.DispRevision)object).getRevision().getNumber() != "" && !((SearchHistoryPanel.DispRevision)object).isBranchRoot()) {
                arrayList.add(object);
            }
            SummaryView.addResults(arrayList, (SearchHistoryPanel.DispRevision)object, 0);
        }
        return arrayList;
    }

    private static void addResults(ArrayList arrayList, SearchHistoryPanel.DispRevision dispRevision, int n) {
        dispRevision.setIndentation(n);
        List list = dispRevision.getChildren();
        if (list != null) {
            for (SearchHistoryPanel.DispRevision dispRevision2 : list) {
                if (dispRevision2.isBranchRoot()) continue;
                arrayList.add(dispRevision2);
            }
            for (SearchHistoryPanel.DispRevision dispRevision2 : list) {
                SummaryView.addResults(arrayList, dispRevision2, n + 1);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.diffPrevious(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + n)) != null && rectangle2.contains(point)) {
            this.associatedChangesInProject(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + n)) != null && rectangle2.contains(point)) {
            this.associatedChangesInOpenProjects(n);
        }
        if ((rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-tagsLink-" + n)) != null && rectangle2.contains(point)) {
            this.showAlltags(mouseEvent.getPoint(), n);
        }
    }

    public static void showAllTags(Window window, Point point, SearchHistoryPanel.DispRevision dispRevision) {
        Object object;
        List<String> list;
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setBackground(SummaryView.darker(UIManager.getColor("List.background")));
        jTextPane.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 0));
        jTextPane.setEditable(false);
        Style style = jTextPane.addStyle("headerStyle", null);
        StyleConstants.setBold(style, true);
        Style style2 = jTextPane.addStyle("unmodifiedBranchStyle", null);
        StyleConstants.setForeground(style2, Color.GRAY);
        String string = dispRevision.getRevision().getBranches();
        Document document = jTextPane.getDocument();
        try {
            document.insertString(document.getLength(), NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_BranchesLabel") + "\n", style);
            list = dispRevision.getBranches();
            for (String iterator2 : list) {
                if (string == null || string.indexOf(iterator2.substring(iterator2.indexOf("(") + 1, iterator2.indexOf(")"))) == -1) {
                    document.insertString(document.getLength(), iterator2 + "\n", style2);
                    continue;
                }
                document.insertString(document.getLength(), iterator2 + "\n", null);
            }
            if (list.size() == 0) {
                document.insertString(document.getLength(), NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_NoBranchesLabel") + "\n", style2);
            }
            document.insertString(document.getLength(), "\n" + NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_TagsLabel") + "\n", style);
            object = new StringBuilder();
            list = dispRevision.getTags();
            for (String string2 : list) {
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append('\n');
            }
            document.insertString(document.getLength(), ((StringBuilder)object).toString(), null);
            if (list.size() == 0) {
                document.insertString(document.getLength(), NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_NoTagsLabel"), style2);
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(SummaryView.class.getName()).log(Level.WARNING, "Internal error creating tag list", badLocationException);
        }
        list = jTextPane.getPreferredSize();
        jTextPane.setPreferredSize(new Dimension(((Dimension)((Object)list)).width * 7 / 6, ((Dimension)((Object)list)).height));
        object = new JScrollPane(jTextPane);
        ((JComponent)object).setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        TooltipWindow tooltipWindow = new TooltipWindow(window, (JComponent)object);
        tooltipWindow.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                jTextPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        tooltipWindow.show(point);
    }

    private void showAlltags(Point point, int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SwingUtilities.convertPointToScreen(point, this.resultsList);
            point.x += 10;
            SummaryView.showAllTags(SwingUtilities.windowForComponent(this.scrollPane), point, (SearchHistoryPanel.DispRevision)e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.resultsList.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        Rectangle rectangle = this.resultsList.getCellBounds(n, n);
        Point point = new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y);
        Rectangle rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        rectangle2 = (Rectangle)this.resultsList.getClientProperty("Summary-tagsLink-" + n);
        if (rectangle2 != null && rectangle2.contains(point)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onPopup(MouseEvent mouseEvent) {
        this.onPopup(mouseEvent.getPoint());
    }

    private void onPopup(Point point) {
        String string;
        int[] nArray = this.resultsList.getSelectedIndices();
        if (nArray.length == 0) {
            int n = this.resultsList.locationToIndex(point);
            if (n == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(n);
            nArray = new int[]{n};
        }
        final int[] nArray2 = nArray;
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string2 = null;
        SearchHistoryPanel.ResultsContainer resultsContainer = null;
        SearchHistoryPanel.DispRevision dispRevision = null;
        Object e = this.dispResults.get(nArray2[0]);
        if (e instanceof SearchHistoryPanel.ResultsContainer) {
            resultsContainer = (SearchHistoryPanel.ResultsContainer)this.dispResults.get(nArray2[0]);
        } else {
            dispRevision = (SearchHistoryPanel.DispRevision)this.dispResults.get(nArray2[0]);
            string2 = org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(dispRevision.getRevision().getNumber().trim());
        }
        if (resultsContainer != null) {
            string = resultsContainer.getEldestRevision();
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_Diff", (Object)string, (Object)resultsContainer.getNewestRevision())){

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        } else if (string2 != null) {
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)string2)){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.diffPrevious(nArray2[0]);
                }
            }));
        }
        jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(string);
                this.setEnabled(SummaryView.this.someRevisions(nArray2));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryView.this.rollbackChange(nArray2);
            }
        }));
        if (dispRevision != null) {
            if (!"dead".equals(dispRevision.getRevision().getState())) {
                jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)dispRevision.getRevision().getNumber())){
                    {
                        super(string);
                        this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        SummaryView.this.rollback(nArray2[0]);
                    }
                }));
                jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View", (Object)dispRevision.getRevision().getNumber())){
                    {
                        super(string);
                        this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                SummaryView.this.view(nArray2[0]);
                            }
                        });
                    }
                }));
            }
            if ((string = this.master.getProject(dispRevision.getRevision().getLogInfoHeader().getFile())) != null) {
                String string3 = ProjectUtils.getInformation((Project)string).getDisplayName();
                jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_AssociateChangesInProject", (Object)string3)){
                    {
                        super(string);
                        this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        SummaryView.this.associatedChangesInProject(nArray2[0]);
                    }
                }));
            }
            jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_AssociateChangesInOpenProjects")){
                {
                    super(string);
                    this.setEnabled(nArray2.length == 1 && SummaryView.this.dispResults.get(nArray2[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SummaryView.this.associatedChangesInOpenProjects(nArray2[0]);
                }
            }));
        }
        jPopupMenu.show(this.resultsList, point.x, point.y);
    }

    private boolean someRevisions(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Object e = this.dispResults.get(nArray[i]);
            if (!(e instanceof SearchHistoryPanel.DispRevision)) continue;
            return true;
        }
        return false;
    }

    private void rollbackChange(int[] nArray) {
        ArrayList<LogInformation.Revision> arrayList = new ArrayList<LogInformation.Revision>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            Object e = this.dispResults.get(n);
            if (!(e instanceof SearchHistoryPanel.DispRevision)) continue;
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            arrayList.add(dispRevision.getRevision());
        }
        SummaryView.rollbackChanges(arrayList.toArray(new LogInformation.Revision[arrayList.size()]));
    }

    private static void rollbackChange(LogInformation.Revision revision, ExecutorGroup executorGroup) {
        File file = revision.getLogInfoHeader().getFile();
        if (file.getParentFile().exists()) {
            UpdateCommand updateCommand = new UpdateCommand();
            updateCommand.setFiles(new File[]{file});
            updateCommand.setMergeRevision1(revision.getNumber());
            updateCommand.setMergeRevision2(org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(revision.getNumber()));
            executorGroup.addExecutors(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), null, null));
        } else {
            try {
                File file2 = VersionsCache.getInstance().getRemoteFile(file, org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(revision.getNumber()), null);
                if (file2 != null) {
                    file.getParentFile().mkdirs();
                    FileObject fileObject = FileUtil.toFileObject((File)file.getParentFile());
                    fileObject = fileObject.createData(file.getName());
                    Utils.copyStreamsCloseAll((OutputStream)fileObject.getOutputStream(), (InputStream)new FileInputStream(file2));
                }
            }
            catch (Exception exception) {
                Logger.getLogger(SummaryView.class.getName()).log(Level.SEVERE, "Unable to rollback changes", exception);
            }
        }
    }

    static void rollbackChanges(LogInformation.Revision[] revisionArray) {
        ExecutorGroup executorGroup = new ExecutorGroup(NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView_RollingBackChange"));
        for (int i = 0; i < revisionArray.length; ++i) {
            SummaryView.rollbackChange(revisionArray[i], executorGroup);
        }
        executorGroup.execute();
    }

    private void rollback(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            String string = dispRevision.getRevision().getNumber().trim();
            File file = dispRevision.getRevision().getLogInfoHeader().getFile();
            GetCleanAction.rollback(file, string);
        }
    }

    private void view(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            try {
                ViewRevisionAction.view(dispRevision.getRevision().getLogInfoHeader().getFile(), dispRevision.getRevision().getNumber(), null);
            }
            catch (Exception exception) {
                Logger.getLogger(SummaryView.class.getName()).log(Level.INFO, exception.getMessage(), exception);
            }
        }
    }

    private void diffPrevious(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            this.master.showDiff(dispRevision);
        } else {
            SearchHistoryPanel.ResultsContainer resultsContainer = (SearchHistoryPanel.ResultsContainer)e;
            this.master.showDiff(resultsContainer);
        }
    }

    private void associatedChangesInOpenProjects(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            int n2 = projectArray.length;
            SearchHistoryAction.openSearch(n2 == 1 ? ProjectUtils.getInformation((Project)projectArray[0]).getDisplayName() : NbBundle.getMessage(SummaryView.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n2)), dispRevision.getRevision().getMessage().trim(), dispRevision.getRevision().getAuthor(), dispRevision.getRevision().getDate());
        }
    }

    private void associatedChangesInProject(int n) {
        Object e = this.dispResults.get(n);
        if (e instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision dispRevision = (SearchHistoryPanel.DispRevision)e;
            File file = dispRevision.getRevision().getLogInfoHeader().getFile();
            Project project = this.master.getProject(file);
            Context context = org.netbeans.modules.versioning.system.cvss.util.Utils.getProjectContext(this.master.getProject(file), file);
            SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), dispRevision.getRevision().getMessage().trim(), dispRevision.getRevision().getAuthor(), dispRevision.getRevision().getDate());
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    List<Object> getSelection() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int n : this.resultsList.getSelectedIndices()) {
            arrayList.add(this.dispResults.get(n));
        }
        return arrayList;
    }

    public static Color darker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.95), 0), Math.max((int)((double)color.getGreen() * 0.95), 0), Math.max((int)((double)color.getBlue() * 0.95), 0));
    }

    private String getBranch(SearchHistoryPanel.DispRevision dispRevision) {
        String string = dispRevision.getRevision().getNumber();
        int n = string.lastIndexOf(46);
        if (n == string.indexOf(46)) {
            return null;
        }
        int n2 = string.lastIndexOf(46, n - 1);
        String string2 = string.substring(0, n2) + ".0" + string.substring(n2, n);
        List list = dispRevision.getRevision().getLogInfoHeader().getSymNamesForRevision(string2);
        if (list.size() != 1) {
            return null;
        }
        return ((LogInformation.SymName)list.get(0)).getName();
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String string, Color color, Color color2) {
            StringBuilder stringBuilder = new StringBuilder(100);
            if (color.equals(UIManager.getColor("List.foreground"))) {
                stringBuilder.append("<html><a href=\"\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            } else {
                stringBuilder.append("<html><a href=\"\" style=\"color:");
                stringBuilder.append("rgb(");
                stringBuilder.append(color.getRed());
                stringBuilder.append(",");
                stringBuilder.append(color.getGreen());
                stringBuilder.append(",");
                stringBuilder.append(color.getBlue());
                stringBuilder.append(")");
                stringBuilder.append("\">");
                stringBuilder.append(string);
                stringBuilder.append("</a>");
            }
            this.setText(stringBuilder.toString());
            this.setBackground(color2);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private Style selectedStyle;
        private Style normalStyle;
        private Style branchStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private final JPanel tagsPanel;
        private final JPanel actionsPanel;
        private DateFormat defaultFormat;
        private int index;
        private final HyperlinkLabel tagsLink;
        private final HyperlinkLabel diffLink;
        private final HyperlinkLabel acpLink;
        private final HyperlinkLabel acopLink;
        private final JLabel tagsLabel;
        private final JLabel diffToLabel;
        private final JLabel findCommitInLabel;
        private final JLabel commaLabel;

        public SummaryCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.branchStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.branchStyle, Color.GRAY);
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (color != null) {
                StyleConstants.setBackground(this.hiliteStyle, color);
            }
            if ((color = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, color);
            }
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new BorderLayout());
            this.actionsPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.tagsPanel = new JPanel();
            this.tagsPanel.setLayout(new FlowLayout(3, 2, 5));
            this.actionsPanel = new JPanel();
            this.actionsPanel.setLayout(new FlowLayout(4, 2, 5));
            this.actionsPane.add((Component)this.tagsPanel, "West");
            this.actionsPane.add(this.actionsPanel);
            this.tagsLabel = new JLabel();
            this.tagsLink = new HyperlinkLabel();
            this.tagsPanel.add(this.tagsLabel);
            this.tagsLabel.setBorder(BorderFactory.createEmptyBorder(0, 48, 0, 0));
            this.tagsPanel.add(this.tagsLink);
            this.diffToLabel = new JLabel(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_DiffTo"));
            this.actionsPanel.add(this.diffToLabel);
            this.diffLink = new HyperlinkLabel();
            this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPanel.add(this.diffLink);
            this.acopLink = new HyperlinkLabel();
            this.acpLink = new HyperlinkLabel();
            this.findCommitInLabel = new JLabel(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_FindCommitIn"));
            this.actionsPanel.add(this.findCommitInLabel);
            this.actionsPanel.add(this.acpLink);
            this.commaLabel = new JLabel(",");
            this.actionsPanel.add(this.commaLabel);
            this.actionsPanel.add(this.acopLink);
            this.textPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SearchHistoryPanel.ResultsContainer) {
                this.renderContainer((SearchHistoryPanel.ResultsContainer)object, n, bl);
            } else {
                this.renderRevision(jList, (SearchHistoryPanel.DispRevision)object, n, bl);
            }
            return this;
        }

        private void renderContainer(SearchHistoryPanel.ResultsContainer resultsContainer, int n, boolean bl) {
            Style style;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            if (bl) {
                this.textPane.setBackground(UIManager.getColor("List.selectionBackground"));
                this.actionsPane.setBackground(UIManager.getColor("List.selectionBackground"));
                style = this.selectedStyle;
            } else {
                Color color = UIManager.getColor("List.background");
                this.textPane.setBackground((n & 1) == 0 ? color : SummaryView.darker(color));
                this.actionsPane.setBackground((n & 1) == 0 ? color : SummaryView.darker(color));
                style = this.normalStyle;
            }
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                styledDocument.insertString(0, resultsContainer.getName(), null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + resultsContainer.getPath(), null);
                styledDocument.setCharacterAttributes(0, styledDocument.getLength(), style, false);
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            this.actionsPane.setVisible(false);
        }

        private void renderRevision(JList jList, SearchHistoryPanel.DispRevision dispRevision, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            int n5;
            Project[] projectArray;
            Object object;
            Style style;
            Color color;
            Color color2;
            StyledDocument styledDocument = this.textPane.getStyledDocument();
            this.index = n;
            if (bl) {
                color2 = UIManager.getColor("List.selectionForeground");
                color = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                color2 = UIManager.getColor("List.foreground");
                color = UIManager.getColor("List.background");
                color = (n & 1) == 0 ? color : SummaryView.darker(color);
                style = this.normalStyle;
            }
            this.textPane.setBackground(color);
            this.actionsPane.setBackground(color);
            this.tagsPanel.setBackground(color);
            this.actionsPanel.setBackground(color);
            LogInformation.Revision revision = dispRevision.getRevision();
            String string = revision.getMessage();
            if (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            int n6 = dispRevision.getIndentation();
            try {
                styledDocument.remove(0, styledDocument.getLength());
                styledDocument.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                if (n6 == 0) {
                    styledDocument.insertString(0, dispRevision.getRevision().getLogInfoHeader().getFile().getName(), style);
                    styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.filenameStyle, false);
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + dispRevision.getName().substring(0, dispRevision.getName().lastIndexOf(47)) + "\n", style);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(revision.getNumber());
                stringBuilder.append(FIELDS_SEPARATOR);
                stringBuilder.append(this.defaultFormat.format(revision.getDate()));
                stringBuilder.append(FIELDS_SEPARATOR);
                stringBuilder.append(revision.getAuthor());
                object = SummaryView.this.getBranch(dispRevision);
                projectArray = stringBuilder.toString();
                styledDocument.insertString(styledDocument.getLength(), (String)projectArray, style);
                if (object != null) {
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + (String)object, this.branchStyle);
                }
                if ("dead".equalsIgnoreCase(dispRevision.getRevision().getState())) {
                    styledDocument.insertString(styledDocument.getLength(), FIELDS_SEPARATOR + NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView_DeadState"), style);
                }
                styledDocument.insertString(styledDocument.getLength(), "\n", style);
                styledDocument.insertString(styledDocument.getLength(), string, style);
                if (SummaryView.this.message != null && !bl && (n5 = revision.getMessage().indexOf(SummaryView.this.message)) != -1) {
                    n4 = string.length();
                    n3 = styledDocument.getLength();
                    styledDocument.setCharacterAttributes(n3 - n4 + n5, SummaryView.this.message.length(), this.hiliteStyle, false);
                }
                if (n6 > 0) {
                    styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.indentStyle, false);
                } else {
                    styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.noindentStyle, false);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            if (string != null && (n2 = SummaryView.this.master.getWidth()) > 0) {
                object = jList.getFontMetrics(jList.getFont());
                projectArray = ((FontMetrics)object).getStringBounds(string, this.textPane.getGraphics());
                n5 = -1;
                n4 = 0;
                while (n4 != -1) {
                    n4 = string.indexOf(10, n4 + 1);
                    ++n5;
                }
                if (n6 == 0) {
                    ++n5;
                }
                n3 = (int)(projectArray.getWidth() / (double)(n2 - 80) + 1.0);
                int n7 = ((FontMetrics)object).getHeight() * (n3 + n5 + 1) + 4;
                this.textPane.setPreferredSize(new Dimension(n2 - 50, n7));
            }
            this.actionsPane.setVisible(true);
            ArrayList<String> arrayList = new ArrayList<String>(dispRevision.getBranches());
            arrayList.addAll(dispRevision.getTags());
            if (arrayList.size() > 0) {
                this.tagsLabel.setVisible(true);
                object = (String)arrayList.get(0);
                this.tagsLabel.setForeground(bl ? color2 : Color.GRAY);
                if (arrayList.size() > 1) {
                    object = (String)object + ",";
                    this.tagsLink.setVisible(true);
                    this.tagsLink.set("...", color2, color);
                } else {
                    this.tagsLink.setVisible(false);
                }
                this.tagsLabel.setText((String)object);
            } else {
                this.tagsLabel.setVisible(false);
                this.tagsLink.setVisible(false);
            }
            object = org.netbeans.modules.versioning.system.cvss.util.Utils.previousRevision(dispRevision.getRevision().getNumber());
            if (object != null) {
                this.diffToLabel.setVisible(true);
                this.diffLink.setVisible(true);
                this.diffToLabel.setForeground(color2);
                this.diffLink.set((String)object, color2, color);
            } else {
                this.diffToLabel.setVisible(false);
                this.diffLink.setVisible(false);
            }
            projectArray = OpenProjects.getDefault().getOpenProjects();
            if (projectArray.length > 0) {
                this.acopLink.setVisible(true);
                this.acopLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_FindCommitInOpenProjects"), color2, color);
            } else {
                this.acopLink.setVisible(false);
            }
            Project project = SummaryView.this.master.getProject(dispRevision.getRevision().getLogInfoHeader().getFile());
            if (project != null) {
                String string2 = ProjectUtils.getInformation((Project)project).getDisplayName();
                this.acpLink.setVisible(true);
                this.acpLink.set("\"" + string2 + "\"", color2, color);
            } else {
                this.acpLink.setVisible(false);
            }
            if (this.acpLink.isVisible() || this.acopLink.isVisible()) {
                this.findCommitInLabel.setVisible(true);
                this.findCommitInLabel.setForeground(color2);
                if (this.acopLink.isVisible() && this.acopLink.isVisible()) {
                    this.commaLabel.setVisible(true);
                    this.commaLabel.setForeground(color2);
                } else {
                    this.commaLabel.setVisible(false);
                }
            } else {
                this.commaLabel.setVisible(false);
                this.findCommitInLabel.setVisible(false);
            }
        }

        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle;
            super.paintComponent(graphics);
            Rectangle rectangle2 = this.actionsPane.getBounds();
            Rectangle rectangle3 = this.actionsPanel.getBounds();
            if (this.diffLink.isVisible()) {
                rectangle = this.diffLink.getBounds();
                rectangle.setBounds(rectangle.x + rectangle3.x, rectangle.y + rectangle2.y + rectangle3.y, rectangle.width, rectangle.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, rectangle);
            }
            if (this.acpLink.isVisible()) {
                rectangle = this.acpLink.getBounds();
                rectangle.setBounds(rectangle.x + rectangle3.x, rectangle.y + rectangle2.y + rectangle3.y, rectangle.width, rectangle.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acp-" + this.index, rectangle);
            }
            if (this.acopLink.isVisible()) {
                rectangle = this.acopLink.getBounds();
                rectangle.setBounds(rectangle.x + rectangle3.x, rectangle.y + rectangle2.y + rectangle3.y, rectangle.width, rectangle.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acop-" + this.index, rectangle);
            }
            if (this.tagsLink.isVisible()) {
                rectangle = this.tagsPanel.getBounds();
                Rectangle rectangle4 = this.tagsLink.getBounds();
                rectangle4.setBounds(rectangle4.x + rectangle.x, rectangle4.y + rectangle2.y + rectangle.y, rectangle4.width, rectangle4.height);
                SummaryView.this.resultsList.putClientProperty("Summary-tagsLink-" + this.index, rectangle4);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int n) {
            return SummaryView.this.dispResults.get(n);
        }
    }
}

