/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Util {
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    public static final String XSD_FILE_EXTENSION = "xsd";
    public static final String BPEL_FILE_EXTENSION = "bpel";
    public static final String FOUND_VALIDATION_ERRORS = "Found validation error(s).";

    public static String getError(File file, int column, int line, String description, String type) {
        StringBuffer buffer = new StringBuffer();
        if (file != null) {
            buffer.append(file.getPath());
            if (line != -1) {
                buffer.append(":");
                buffer.append(line);
            }
            if (column != -1) {
                buffer.append(": ");
                buffer.append(column);
            }
        }
        buffer.append("\n" + type + ": " + description);
        return buffer.toString();
    }

    public static String getRelativePath(File home, File f) {
        List homelist = Util.getPathList(home);
        List filelist = Util.getPathList(f);
        String s = Util.matchPathLists(homelist, filelist);
        return s;
    }

    public static int getLineNumber(Component component) {
        AbstractDocument doc = Util.getAbstractDocument(component);
        int position = Util.findPosition((AbstractDocumentModel)component.getModel(), ((AbstractDocumentComponent)component).getPeer());
        return Util.findLineNumber(doc, position) + 1;
    }

    public static int getColumnNumber(Component component) {
        AbstractDocument doc = Util.getAbstractDocument(component);
        int position = Util.findPosition((AbstractDocumentModel)component.getModel(), ((AbstractDocumentComponent)component).getPeer());
        return Util.findColumnNumber(doc, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists() || !source.isFile()) {
            throw new IOException("Source is not valid for copying.");
        }
        if (!destination.exists()) {
            destination.getParentFile().mkdirs();
            destination.createNewFile();
        }
        File realDest = destination.isDirectory() ? new File(destination, source.getName()) : destination;
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(source);
            output = new FileOutputStream(realDest);
            byte[] buffer = new byte[4096];
            while (input.available() > 0) {
                output.write(buffer, 0, input.read(buffer));
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private static javax.swing.text.Element findLineRootElement(AbstractDocument doc) {
        javax.swing.text.Element element = doc.getParagraphElement(0).getParentElement();
        if (element == null) {
            element = doc.getDefaultRootElement();
        }
        return element;
    }

    private static int findLineNumber(AbstractDocument doc, int argInt) {
        javax.swing.text.Element paragraphsParent = Util.findLineRootElement(doc);
        return paragraphsParent.getElementIndex(argInt);
    }

    private static int findColumnNumber(AbstractDocument doc, int argInt) {
        javax.swing.text.Element paragraphsParent = Util.findLineRootElement(doc);
        int indx = paragraphsParent.getElementIndex(argInt);
        return argInt - paragraphsParent.getElement(indx).getStartOffset();
    }

    private static AbstractDocument getAbstractDocument(Component component) {
        return (AbstractDocument)component.getModel().getModelSource().getLookup().lookup(AbstractDocument.class);
    }

    private static int findPosition(AbstractDocumentModel model, Node node) {
        Element root = model.getRootComponent().getPeer();
        Document doc = model.getBaseDocument();
        try {
            String buf = doc.getText(0, doc.getLength());
            if (node instanceof Element) {
                return Util.findPosition((Element)node, buf, root, Util.getRootElementPosition(buf, root));
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return -1;
    }

    private static int getRootElementPosition(String buf, Element root) {
        Node n;
        NodeList children = root.getOwnerDocument().getChildNodes();
        int pos = 0;
        for (int i = 0; i < children.getLength() && (n = children.item(i)) != root; ++i) {
            String s = n.getNodeValue();
            if (s == null) continue;
            pos += s.length();
        }
        pos = buf.indexOf(root.getTagName(), pos);
        assert (pos > 0) : "Root element position should be greater than 0";
        return pos;
    }

    private static int findPosition(Element target, String buf, Element base, Integer fromPos) {
        if (target == base) {
            return fromPos;
        }
        NodeList children = base.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) {
                String s = node.getNodeValue();
                if (s == null) {
                    s = node.getTextContent();
                }
                if (s == null) continue;
                fromPos = fromPos + s.length();
                continue;
            }
            Element current = (Element)children.item(i);
            String tag = "<" + current.getTagName();
            fromPos = buf.indexOf(tag, (int)fromPos);
            if (current == target) {
                return fromPos;
            }
            int found = Util.findPosition(target, buf, current, fromPos);
            if (found <= -1) continue;
            return found;
        }
        return -1;
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List r, List f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    private Util() {
    }

    public static class WsdlFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            boolean result = false;
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension != null && fileExtension.equalsIgnoreCase(Util.WSDL_FILE_EXTENSION)) {
                result = true;
            }
            return result;
        }
    }

    public static class BpelFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            boolean result = false;
            if (pathname.isDirectory()) {
                return true;
            }
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension != null && fileExtension.equalsIgnoreCase(Util.BPEL_FILE_EXTENSION)) {
                result = true;
            }
            return result;
        }
    }

    public static class ProjectFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            boolean result = false;
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension != null && (fileExtension.equalsIgnoreCase(Util.WSDL_FILE_EXTENSION) || fileExtension.equalsIgnoreCase(Util.XSD_FILE_EXTENSION))) {
                result = true;
            }
            return result;
        }
    }
}

