/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.cli;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.project.anttasks.cli.CliBpelCatalogModel;
import org.netbeans.modules.bpel.project.anttasks.util.Consumer;
import org.netbeans.modules.bpel.project.anttasks.util.Provider;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CliJbiGenerator {
    private Logger logger = Logger.getLogger(CliJbiGenerator.class.getName());
    private static final String PARTNER_ROLE = "partnerRole";
    private static final String MY_ROLE = "myRole";
    private List mSourceDirs;
    private File mBuildDir = null;
    private List mProviderList = new ArrayList();
    private List mConsumerList = new ArrayList();
    private Map mNameSpacePrefix = new HashMap();
    public static final String JBI_ELEM_NAME = "jbi";
    public static final String SERVICES_ELEM_NAME = "services";
    public static final String PROVIDES_ELEM_NAME = "provides";
    public static final String CONSUMES_ELEM_NAME = "consumes";
    public static final String BINDING_ATTR_NAME = "binding-component";
    public static final String INTERFACE_ATTR_NAME = "interface-name";
    public static final String ENDPOINT_ATTR_NAME = "endpoint-name";
    public static final String SERVICE_ATTR_NAME = "service-name";
    public static final String VERSION_ATTR_NAME = "version";
    public static final String VERSION_ATTR_VALUE = "1.0";
    public static final String NS_ATTR_NAME = "xmlns";
    public static final String NS_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi";
    public static final String NS_XSI_ATTR_NAME = "xmlns:xsi";
    public static final String NS_XSI_ATTR_VALUE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_ATTR_NAME = "xsi:schemaLocation";
    public static final String XSI_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi jbi.xsd";
    public static final String JBI_EXT_NS = "http://www.sun.com/jbi/descriptor/service-unit";
    public static final String JBI_EXT_DISPLAY_NAME = "display-name";
    public static final String JBI_EXT_PROC_NAME_ATTR = "process-name";
    public static final String JBI_EXT_FILE_PATH_ATTR = "file-path";
    public static final String NAMESPACE_PREFIX = "ns";

    public CliJbiGenerator() {
    }

    public CliJbiGenerator(List sourceDirs) {
        this.mSourceDirs = sourceDirs;
    }

    void process() {
        if (this.mSourceDirs != null && this.mSourceDirs.size() != 0) {
            this.processSourceDirs(this.mSourceDirs);
        }
    }

    public void generate(File buildDir) {
        this.mBuildDir = buildDir;
        this.process();
        try {
            File cnfFile = new File(buildDir, "META-INF");
            if (!cnfFile.exists()) {
                cnfFile.mkdirs();
            }
            File jbiFile = new File(cnfFile, "jbi.xml");
            this.populateNamespace(JBI_EXT_NS);
            this.generateJbiXml(jbiFile);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Failed to create jbi.xml", ex);
        }
    }

    protected void populateProviderConsumer(BpelModel bpelModel, File file, File sourceDir) {
        if (bpelModel == null) {
            return;
        }
        if (bpelModel.getProcess() == null) {
            return;
        }
        if (bpelModel.getProcess().getPartnerLinkContainer() == null) {
            return;
        }
        if (bpelModel.getProcess().getPartnerLinkContainer().getPartnerLinks() == null) {
            return;
        }
        PartnerLink[] pLinks = bpelModel.getProcess().getPartnerLinkContainer().getPartnerLinks();
        Provider provider = null;
        Consumer consumer = null;
        String processName = bpelModel.getProcess().getName();
        String filePath = Util.getRelativePath(sourceDir, file);
        for (int index = 0; index < pLinks.length; ++index) {
            WSDLReference myPartnerRoleRef;
            PartnerLink pLink = pLinks[index];
            String partnerLinkName = pLink.getName();
            WSDLReference partnerLinkTypeWSDLRef = pLinks[index].getPartnerLinkType();
            String partnerLinkNameSpaceURI = pLinks[index].getBpelModel().getProcess().getTargetNamespace();
            String partnerLinkNSPrefix = this.populateNamespace(partnerLinkNameSpaceURI);
            PartnerLinkType pLTypeForPLinkType = (PartnerLinkType)partnerLinkTypeWSDLRef.get();
            String portName = null;
            String portNameNS = null;
            String portNameNSPrefix = null;
            WSDLReference myRoleWSDLRef = pLinks[index].getMyRole();
            if (pLTypeForPLinkType == null) {
                this.logger.log(Level.SEVERE, "Problem encountered while processing partnerLinkType of \"" + partnerLinkName + "\"");
                throw new RuntimeException("PartnerLink Type is Null!");
            }
            if (myRoleWSDLRef != null) {
                String myRoleName = null;
                Role myRole = (Role)myRoleWSDLRef.get();
                if (myRole != null) {
                    PortType pt;
                    myRoleName = myRole.getName();
                    NamedComponentReference portTypeRef = myRole.getPortType();
                    if (portTypeRef != null && (pt = (PortType)portTypeRef.get()) != null) {
                        portName = pt.getName();
                        portNameNS = pt.getModel().getDefinitions().getTargetNamespace();
                        portNameNSPrefix = this.populateNamespace(portNameNS);
                    }
                }
                if (portName == null) {
                    this.logger.log(Level.SEVERE, "Problem encountered while processing portType   PartnerLink =  \"" + partnerLinkName + "\"");
                    throw new RuntimeException("Problem encountered while processing portType !");
                }
                provider = new Provider(partnerLinkName, portName, partnerLinkNameSpaceURI, portNameNS, myRoleName, partnerLinkNSPrefix, portNameNSPrefix, processName, filePath);
                if (!this.mProviderList.contains(provider)) {
                    this.mProviderList.add(provider);
                }
            }
            if ((myPartnerRoleRef = pLinks[index].getPartnerRole()) == null) continue;
            String partnerRoleName = null;
            Role partnerRole = (Role)myPartnerRoleRef.get();
            if (partnerRole != null) {
                PortType pt;
                partnerRoleName = partnerRole.getName();
                NamedComponentReference portTypeRef = partnerRole.getPortType();
                if (portTypeRef != null && (pt = (PortType)portTypeRef.get()) != null) {
                    portName = pt.getName();
                    portNameNS = pt.getModel().getDefinitions().getTargetNamespace();
                    portNameNSPrefix = this.populateNamespace(portNameNS);
                }
            }
            if (portName == null) {
                this.logger.log(Level.SEVERE, "Problem encountered while processing portType   PartnerLink =  \"" + partnerLinkName + "\"");
                throw new RuntimeException("Problem encountered while processing portType !");
            }
            consumer = new Consumer(partnerLinkName, portName, partnerLinkNameSpaceURI, portNameNS, partnerRoleName, partnerLinkNSPrefix, portNameNSPrefix, processName, filePath);
            if (this.mConsumerList.contains(consumer)) continue;
            this.mConsumerList.add(consumer);
        }
    }

    private String populateNamespace(String namespaceURI) {
        String namespacePrefix = null;
        namespacePrefix = (String)this.mNameSpacePrefix.get(namespaceURI);
        if (namespacePrefix == null) {
            namespacePrefix = NAMESPACE_PREFIX + this.mNameSpacePrefix.size();
            this.mNameSpacePrefix.put(namespaceURI, namespacePrefix);
        }
        return namespacePrefix;
    }

    private void addNamespaceToRoot(Element root) {
        Set nameSpaceSet = this.mNameSpacePrefix.entrySet();
        for (Map.Entry entry : nameSpaceSet) {
            root.setAttribute("xmlns:" + (String)entry.getValue(), (String)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJbiXml(File jbiFile) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElement(JBI_ELEM_NAME);
        root.setAttribute(VERSION_ATTR_NAME, VERSION_ATTR_VALUE);
        root.setAttribute(NS_ATTR_NAME, NS_ATTR_VALUE);
        this.addNamespaceToRoot(root);
        HashMap map = new HashMap();
        document.appendChild(root);
        Element services = document.createElement(SERVICES_ELEM_NAME);
        services.setAttribute(BINDING_ATTR_NAME, "false");
        root.appendChild(services);
        int psize = this.mProviderList.size();
        for (int i = 0; i < psize; ++i) {
            String PT;
            Provider provider = (Provider)this.mProviderList.get(i);
            if (provider == null || (PT = provider.getPartnerLinkName()) == null) continue;
            Element portMapNode = document.createElement(PROVIDES_ELEM_NAME);
            portMapNode.setAttribute(INTERFACE_ATTR_NAME, provider.getPortNameNamespacePrefix() + ":" + provider.getPortName());
            portMapNode.setAttribute(SERVICE_ATTR_NAME, provider.getPartnerLinkNamespacePrefix() + ":" + provider.getPartnerLinkName());
            portMapNode.setAttribute(ENDPOINT_ATTR_NAME, provider.getMyRoleName() + "_" + MY_ROLE);
            Element extensionElement = document.createElementNS(JBI_EXT_NS, this.populateNamespace(JBI_EXT_NS) + ":" + JBI_EXT_DISPLAY_NAME);
            extensionElement.setTextContent(provider.getPartnerLinkName());
            portMapNode.appendChild(extensionElement);
            extensionElement = document.createElementNS(JBI_EXT_NS, this.populateNamespace(JBI_EXT_NS) + ":" + JBI_EXT_PROC_NAME_ATTR);
            extensionElement.setTextContent(provider.getProcessName());
            portMapNode.appendChild(extensionElement);
            extensionElement = document.createElementNS(JBI_EXT_NS, this.populateNamespace(JBI_EXT_NS) + ":" + JBI_EXT_FILE_PATH_ATTR);
            extensionElement.setTextContent(provider.getFilePath());
            portMapNode.appendChild(extensionElement);
            services.appendChild(portMapNode);
        }
        int csize = this.mConsumerList.size();
        for (int i = 0; i < csize; ++i) {
            String PT;
            Consumer consumer = (Consumer)this.mConsumerList.get(i);
            if (consumer == null || (PT = consumer.getPartnerLinkName()) == null) continue;
            Element portMapNode = document.createElement(CONSUMES_ELEM_NAME);
            portMapNode.setAttribute(INTERFACE_ATTR_NAME, consumer.getPortNameNamespacePrefix() + ":" + consumer.getPortName());
            portMapNode.setAttribute(SERVICE_ATTR_NAME, consumer.getPartnerLinkNamespacePrefix() + ":" + consumer.getPartnerLinkName());
            portMapNode.setAttribute(ENDPOINT_ATTR_NAME, consumer.getPartnerRoleName() + "_" + PARTNER_ROLE);
            Element extensionElement = document.createElementNS(JBI_EXT_NS, this.populateNamespace(JBI_EXT_NS) + ":" + JBI_EXT_DISPLAY_NAME);
            extensionElement.setTextContent(consumer.getPartnerLinkName());
            portMapNode.appendChild(extensionElement);
            extensionElement = document.createElementNS(JBI_EXT_NS, this.populateNamespace(JBI_EXT_NS) + ":" + JBI_EXT_PROC_NAME_ATTR);
            extensionElement.setTextContent(consumer.getProcessName());
            portMapNode.appendChild(extensionElement);
            extensionElement = document.createElementNS(JBI_EXT_NS, this.populateNamespace(JBI_EXT_NS) + ":" + JBI_EXT_FILE_PATH_ATTR);
            extensionElement.setTextContent(consumer.getFilePath());
            portMapNode.appendChild(extensionElement);
            services.appendChild(portMapNode);
        }
        String key = null;
        String value = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            key = (String)iterator.next();
            if (key == null) continue;
            value = (String)map.get(key);
            root.setAttribute("xmlns:" + key, value);
        }
        PrintWriter pw = null;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setAttribute("indent-number", new Integer(4));
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            pw = new PrintWriter(jbiFile, "UTF-8");
            StreamResult result = new StreamResult(pw);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (Exception ex) {
        }
        finally {
            if (pw != null) {
                try {
                    pw.flush();
                }
                catch (Exception ex) {}
                try {
                    pw.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void processFileObject(File file, File sourceDir) {
        if (file.isDirectory()) {
            this.processFolder(file, sourceDir);
        } else {
            this.processFile(file, sourceDir);
        }
    }

    private void processFolder(File fileDir, File sourceDir) {
        File[] children = fileDir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            this.processFileObject(children[i], sourceDir);
        }
    }

    protected void processFile(File file, File sourceDir) {
        String fileName = file.getName();
        String fileExtension = null;
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1) {
            fileExtension = fileName.substring(dotIndex + 1);
        }
        if (fileExtension != null && fileExtension.equalsIgnoreCase("bpel")) {
            BpelModel bpelModel = null;
            try {
                bpelModel = CliBpelCatalogModel.getDefault().getBPELModel(file.toURI());
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error while creating BPEL Model ", ex);
                throw new RuntimeException("Error while creating BPEL Model ", ex);
            }
            try {
                this.populateProviderConsumer(bpelModel, file, sourceDir);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error encountered while processing BPEL file - " + file.getAbsolutePath());
                throw new RuntimeException(ex);
            }
        }
    }

    private void processSourceDirs(List sourceDirs) {
        for (File sourceDir : sourceDirs) {
            this.processSourceDir(sourceDir);
        }
    }

    private void processSourceDir(File sourceDir) {
        this.processFileObject(sourceDir, sourceDir);
    }
}

