/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.ui.tree;

import java.awt.Image;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.ruby.ui.tree.FolderTreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;

public class SourceGroupTreeElement
implements TreeElement {
    private WeakReference<SourceGroup> sg;
    private FileObject dir;
    private Icon icon;
    private String displayName;
    private static String PACKAGE_BADGE = "org/netbeans/modules/ruby/rubyproject/ui/packageBadge.gif";

    SourceGroupTreeElement(SourceGroup sourceGroup) {
        this.sg = new WeakReference<SourceGroup>(sourceGroup);
        this.dir = sourceGroup.getRootFolder();
        this.icon = sourceGroup.getIcon(false);
        if (this.icon == null) {
            try {
                Image image = DataObject.find((FileObject)sourceGroup.getRootFolder()).getNodeDelegate().getIcon(1);
                image = Utilities.mergeImages((Image)image, (Image)Utilities.loadImage((String)PACKAGE_BADGE), (int)7, (int)7);
                this.icon = new ImageIcon(image);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        this.displayName = sourceGroup.getDisplayName();
    }

    public TreeElement getParent(boolean bl) {
        return TreeElementFactory.getTreeElement((Object)FileOwnerQuery.getOwner((FileObject)this.dir));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean bl) {
        return this.displayName;
    }

    public Object getUserObject() {
        SourceGroup sourceGroup = (SourceGroup)this.sg.get();
        if (sourceGroup == null) {
            sourceGroup = FolderTreeElement.getSourceGroup(this.dir);
        }
        return sourceGroup;
    }
}

