/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.ModificationResult;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.WorkingCopy;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RubyRefactoringPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin,
CancellableTask<CompilationController> {
    private Phase whatRun = Phase.DEFAULT;
    private Problem problem;
    protected volatile boolean cancelRequest = false;
    private volatile CancellableTask currentTask;

    protected abstract Problem preCheck(CompilationController var1) throws IOException;

    protected abstract Problem checkParameters(CompilationController var1) throws IOException;

    protected abstract Problem fastCheckParameters(CompilationController var1) throws IOException;

    protected abstract Source getRubySource(Phase var1);

    public void cancel() {
    }

    public final void run(CompilationController compilationController) throws Exception {
        switch (this.whatRun) {
            case PRECHECK: {
                this.problem = this.preCheck(compilationController);
                break;
            }
            case CHECKPARAMETERS: {
                this.problem = this.checkParameters(compilationController);
                break;
            }
            case FASTCHECKPARAMETERS: {
                this.problem = this.fastCheckParameters(compilationController);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public Problem preCheck() {
        return this.run(Phase.PRECHECK);
    }

    public Problem checkParameters() {
        return this.run(Phase.CHECKPARAMETERS);
    }

    public Problem fastCheckParameters() {
        return this.run(Phase.FASTCHECKPARAMETERS);
    }

    private Problem run(Phase phase) {
        this.whatRun = phase;
        this.problem = null;
        Source source = this.getRubySource(phase);
        if (source == null) {
            return null;
        }
        try {
            source.runUserActionTask((CancellableTask)this, true);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return this.problem;
    }

    public void cancelRequest() {
        this.cancelRequest = true;
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    protected ClasspathInfo getClasspathInfo(AbstractRefactoring abstractRefactoring) {
        ClasspathInfo classpathInfo = (ClasspathInfo)abstractRefactoring.getContext().lookup(ClasspathInfo.class);
        if (classpathInfo == null) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Missing scope (ClasspathInfo), using default scope (all open projects)");
            classpathInfo = RetoucheUtils.getClasspathInfoFor(new FileObject[]{null});
            abstractRefactoring.getContext().add((Object)classpathInfo);
        }
        return classpathInfo;
    }

    protected static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    private Iterable<? extends List<FileObject>> groupByRoot(Iterable<? extends FileObject> iterable) {
        HashMap<FileObject, LinkedList<FileObject>> hashMap = new HashMap<FileObject, LinkedList<FileObject>>();
        for (FileObject fileObject : iterable) {
            FileObject fileObject2;
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null || (fileObject2 = classPath.findOwnerRoot(fileObject)) == null) continue;
            LinkedList<FileObject> linkedList = (LinkedList<FileObject>)hashMap.get(fileObject2);
            if (linkedList == null) {
                linkedList = new LinkedList<FileObject>();
                hashMap.put(fileObject2, linkedList);
            }
            linkedList.add(fileObject);
        }
        return hashMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Collection<ModificationResult> processFiles(Set<FileObject> set, CancellableTask<WorkingCopy> cancellableTask) {
        this.currentTask = cancellableTask;
        LinkedList<ModificationResult> linkedList = new LinkedList<ModificationResult>();
        try {
            Source source;
            HashSet<FileObject> hashSet = new HashSet<FileObject>(2 * set.size());
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>(2 * set.size());
            for (FileObject fileObject : set) {
                if (RubyUtils.isRubyFile((FileObject)fileObject)) {
                    hashSet.add(fileObject);
                    continue;
                }
                if (!RubyUtils.isRhtmlFile((FileObject)fileObject)) continue;
                hashSet2.add(fileObject);
            }
            Iterable<? extends List<FileObject>> iterable = this.groupByRoot(hashSet);
            for (List list : iterable) {
                source = Source.create((ClasspathInfo)ClasspathInfo.create((FileObject)((FileObject)list.get(0))), (Collection)list);
                try {
                    linkedList.add(source.runModificationTask(cancellableTask));
                }
                catch (IOException iOException) {
                    throw (RuntimeException)new RuntimeException().initCause(iOException);
                }
            }
            iterable = this.groupByRoot(hashSet2);
            for (List<FileObject> list : iterable) {
                source = Source.create((ClasspathInfo)ClasspathInfo.create((FileObject)list.get(0)), list);
                try {
                    linkedList.add(source.runModificationTask(cancellableTask));
                }
                catch (IOException iOException) {
                    throw (RuntimeException)new RuntimeException().initCause(iOException);
                    return linkedList;
                }
            }
        }
        finally {
            this.currentTask = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TransformTask
    implements CancellableTask<WorkingCopy> {
        private SearchVisitor visitor;
        private RubyElementCtx treePathHandle;

        public TransformTask(SearchVisitor searchVisitor, RubyElementCtx rubyElementCtx) {
            this.visitor = searchVisitor;
            this.treePathHandle = rubyElementCtx;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            this.visitor.setWorkingCopy(workingCopy);
            this.visitor.scan();
            RubyRefactoringPlugin.this.fireProgressListenerStep();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Phase {
        PRECHECK,
        FASTCHECKPARAMETERS,
        CHECKPARAMETERS,
        PREPARE,
        DEFAULT;

    }
}

