/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.vmd.api.flow.FlowSupport;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.PointsCategoryCD;
import org.netbeans.modules.vmd.midp.components.points.MobileDeviceCD;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterActions;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterBuilt;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterCode;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterCustom;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterDisplayables;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterElements;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItems;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterResources;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterSVG;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;
import org.netbeans.modules.vmd.midp.converter.wizard.XMLUtil;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter {
    public static ArrayList<String> convert(final FileObject fileObject, FileObject fileObject2, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            AntProjectHelper antProjectHelper;
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject.getParent());
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            final StyledDocument styledDocument = editorCookie.openDocument();
            Node node = XMLUtil.getRootNode(fileObject2);
            if (!"1.3".equals(XMLUtil.getAttributeValue(node, "version"))) {
                Debug.warning((Object[])new Object[]{NbBundle.getMessage(Converter.class, (String)"Convert.oldDesign.error")});
                arrayList.add(NbBundle.getMessage(Converter.class, (String)"Convert.oldDesign.error"));
                return arrayList;
            }
            final List<ConverterItem> list = Converter.getConverterItems(node);
            DataObject dataObject2 = DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Templates/MIDP/ConverterVisualMIDlet.java"));
            final DataObject dataObject3 = dataObject2.createFromTemplate(dataFolder, string);
            DocumentSerializer documentSerializer = IOSupport.getDocumentSerializer((DataObject)dataObject3);
            documentSerializer.waitDocumentLoaded();
            final DesignDocument designDocument = documentSerializer.getDocument();
            EditorCookie editorCookie2 = (EditorCookie)dataObject3.getCookie(EditorCookie.class);
            final StyledDocument styledDocument2 = editorCookie2.openDocument();
            ConverterCustom.loadItemsToRegistry(list, designDocument);
            final HashMap<String, ConverterItem> hashMap = new HashMap<String, ConverterItem>();
            for (ConverterItem object2 : list) {
                hashMap.put(object2.getID(), object2);
            }
            designDocument.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    for (ConverterItem converterItem : list) {
                        Converter.convert(hashMap, converterItem, designDocument);
                    }
                    try {
                        ConverterCode.convertCode(list, styledDocument, styledDocument2, designDocument, fileObject.getName(), dataObject3.getPrimaryFile().getName());
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            for (ConverterItem converterItem : list) {
                if (converterItem.isUsed()) continue;
                Debug.warning((Object[])new Object[]{"Unrecognized component: " + converterItem.getTypeID()});
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    designDocument.getTransactionManager().writeAccess(new Runnable(){

                        public void run() {
                            FlowScene flowScene = FlowSupport.getFlowSceneForDocument((DesignDocument)designDocument);
                            for (FlowNodeDescriptor flowNodeDescriptor : flowScene.getNodes()) {
                                Widget widget = flowScene.findWidget((Object)flowNodeDescriptor);
                                if (widget == null) continue;
                                widget.setPreferredLocation(null);
                            }
                        }
                    });
                }
            });
            IOSupport.forceUpdateCode((DataObject)dataObject3);
            CloneableEditorSupport cloneableEditorSupport = IOSupport.getCloneableEditorSupport((DataObject)dataObject3);
            cloneableEditorSupport.saveDocument();
            cloneableEditorSupport.close();
            final String[] stringArray = new String[2];
            JavaSource.forDocument((Document)styledDocument).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassTree classTree = ConverterCode.findMainClass(compilationController);
                    TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(TreePath.getPath(compilationController.getCompilationUnit(), (Tree)classTree));
                    stringArray[0] = typeElement.getQualifiedName().toString();
                }
            }, true);
            JavaSource.forDocument((Document)styledDocument2).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassTree classTree = ConverterCode.findMainClass(compilationController);
                    TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(TreePath.getPath(compilationController.getCompilationUnit(), (Tree)classTree));
                    stringArray[1] = typeElement.getQualifiedName().toString();
                }
            }, true);
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project != null && (antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class)) != null) {
                J2MEProjectGenerator.copyMIDletProperty((Project)project, (AntProjectHelper)antProjectHelper, (String)stringArray[0], (String)stringArray[1]);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return arrayList;
    }

    private static List<ConverterItem> getConverterItems(Node node) {
        ArrayList<ConverterItem> arrayList = new ArrayList<ConverterItem>();
        Node node2 = XMLUtil.getChild(node, "DesignDocument");
        for (Node node3 : XMLUtil.getChildren(node2, "DesignComponent")) {
            String string = XMLUtil.getAttributeValue(node3, "typeid");
            string = Converter.convertTypeIDFromString(string);
            ConverterItem converterItem = new ConverterItem(XMLUtil.getAttributeValue(node3, "uid"), XMLUtil.getAttributeValue(node3, "id"), string);
            for (Node node4 : XMLUtil.getChildren(node3, "Property")) {
                converterItem.addProperty(XMLUtil.getAttributeValue(node4, "name"), XMLUtil.getAttributeValue(node4, "value"));
            }
            for (Node node4 : XMLUtil.getChildren(node3, "ContainerProperty")) {
                String string2 = XMLUtil.getAttributeValue(node4, "name");
                converterItem.initContainerProperty(string2);
                for (Node node5 : XMLUtil.getChildren(node4, "ContainerPropertyItem")) {
                    converterItem.addContainerPropertyItem(string2, XMLUtil.getAttributeValue(node5, "value"));
                }
            }
            arrayList.add(converterItem);
        }
        return arrayList;
    }

    private static String convertTypeIDFromString(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        if (string.charAt(0) == '#') {
            n = 1;
            while (true) {
                char c;
                if (n >= string.length()) {
                    n2 = 0;
                    break;
                }
                if ((c = string.charAt(n++)) == '#') break;
                if (!Character.isDigit(c)) {
                    n2 = 0;
                    break;
                }
                n2 = n2 * 10 + (c - 48);
            }
            if (n2 > 0) {
                string = string.substring(n);
            }
        }
        return (n = string.indexOf(58)) >= 0 ? string.substring(n + 1) : string;
    }

    private static void convert(HashMap<String, ConverterItem> hashMap, ConverterItem converterItem, DesignDocument designDocument) {
        if (converterItem.isUsed()) {
            return;
        }
        String string = converterItem.getID();
        String string2 = converterItem.getTypeID();
        if ("javax.microedition.lcdui.Command".equals(string2)) {
            ConverterResources.convertCommand(converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Alert".equals(string2)) {
            ConverterDisplayables.convertAlert(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Form".equals(string2)) {
            ConverterDisplayables.convertForm(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.List".equals(string2)) {
            ConverterDisplayables.convertList(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.TextBox".equals(string2)) {
            ConverterDisplayables.convertTextBox(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.ChoiceGroup".equals(string2)) {
            ConverterItems.convertChoiceGroup(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.DateField".equals(string2)) {
            ConverterItems.convertDateField(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Gauge".equals(string2)) {
            ConverterItems.convertGauge(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Gauge-AlertIndicator_Helper".equals(string2)) {
            ConverterItems.convertAlertIndicator(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.ImageItem".equals(string2)) {
            ConverterItems.convertImageItem(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Spacer".equals(string2)) {
            ConverterItems.convertSpacer(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.StringItem".equals(string2)) {
            ConverterItems.convertStringItem(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.TextField".equals(string2)) {
            ConverterItems.convertTextField(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Font".equals(string2)) {
            ConverterResources.convertFont(converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Ticker".equals(string2)) {
            ConverterResources.convertTicker(converterItem, designDocument);
        } else if ("javax.microedition.lcdui.Image".equals(string2)) {
            ConverterResources.convertImage(converterItem, designDocument);
        } else if ("GROUP-org.netbeans.modules.mvd.model.midp2.Midp2ChoiceElementDC".equals(string2)) {
            ConverterElements.convertChoiceElement(hashMap, converterItem, designDocument);
        } else if ("GROUP-org.netbeans.modules.mvd.model.midp2.Midp2ListElementDC".equals(string2)) {
            ConverterElements.convertListElement(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.util.SimpleCancellableTask".equals(string2)) {
            ConverterBuilt.convertSimpleCancellableTask(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.lcdui.SimpleTableModel".equals(string2)) {
            ConverterBuilt.convertSimpleTableModel(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.lcdui.SplashScreen".equals(string2)) {
            ConverterBuilt.convertSplashScreen(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.lcdui.TableItem".equals(string2)) {
            ConverterBuilt.convertTableItem(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.lcdui.WaitScreen".equals(string2)) {
            ConverterBuilt.convertWaitScreen(hashMap, converterItem, designDocument);
        } else if ("javax.microedition.m2g.SVGImage".equals(string2)) {
            ConverterSVG.convertImage(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.svg.SVGAnimatorWrapper".equals(string2)) {
            ConverterSVG.convertPlayer(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.svg.SVGMenu".equals(string2)) {
            ConverterSVG.convertMenu(hashMap, converterItem, designDocument);
        } else if ("GROUP-org.netbeans.modules.vmd.components.svg.SvgMenuElementDC".equals(string2)) {
            ConverterSVG.convertMenuElement(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.svg.SVGSplashScreen".equals(string2)) {
            ConverterSVG.convertSplashScreen(hashMap, converterItem, designDocument);
        } else if ("org.netbeans.microedition.svg.SVGWaitScreen".equals(string2)) {
            ConverterSVG.convertWaitScreen(hashMap, converterItem, designDocument);
        } else if ("$MobileDevice".equals(string)) {
            DesignComponent designComponent = MidpDocumentSupport.getCategoryComponent((DesignDocument)designDocument, (TypeID)PointsCategoryCD.TYPEID);
            List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designComponent, (TypeID)MobileDeviceCD.TYPEID);
            DesignComponent designComponent2 = (DesignComponent)list.get(0);
            Converter.convertObject(converterItem, designComponent2);
        } else if ("$StartPoint".equals(string)) {
            DesignComponent designComponent = MidpDocumentSupport.getCategoryComponent((DesignDocument)designDocument, (TypeID)PointsCategoryCD.TYPEID);
            List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designComponent, (TypeID)MobileDeviceCD.TYPEID);
            DesignComponent designComponent3 = (DesignComponent)list.get(0);
            DesignComponent designComponent4 = designComponent3.readProperty("start").getComponent();
            Converter.convertObject(converterItem, designComponent4);
            ConverterActions.convertCommandActionHandler(hashMap, converterItem, designComponent4);
        } else if (ConverterCustom.isClassComponent(converterItem)) {
            ConverterCustom.convertCustom(hashMap, converterItem, designDocument);
        }
    }

    static ConverterItem convertConverterItem(HashMap<String, ConverterItem> hashMap, String string, DesignDocument designDocument) {
        ConverterItem converterItem = hashMap.get(string);
        if (converterItem != null) {
            Converter.convert(hashMap, converterItem, designDocument);
            if (converterItem.isUsed()) {
                return converterItem;
            }
        }
        return null;
    }

    static DesignComponent convertConverterItemComponent(HashMap<String, ConverterItem> hashMap, String string, DesignDocument designDocument) {
        ConverterItem converterItem = Converter.convertConverterItem(hashMap, string, designDocument);
        return converterItem != null ? converterItem.getRelatedComponent() : null;
    }

    static void convertObject(ConverterItem converterItem, DesignComponent designComponent) {
        converterItem.setUsed(designComponent);
    }

    static void convertClass(ConverterItem converterItem, DesignComponent designComponent) {
        Converter.convertObject(converterItem, designComponent);
        converterItem.setClass();
        designComponent.writeProperty("instanceName", MidpTypes.createStringValue((String)converterItem.getID()));
        Boolean bl = ConverterUtil.getBoolean(converterItem.getPropertyValue("lazyInitialized"));
        designComponent.writeProperty("lazyInit", MidpTypes.createBooleanValue((bl == null || bl != false ? 1 : 0) != 0));
    }
}

