/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class AddInstanceVisualDirectoryPanel
extends JPanel {
    private final boolean createPersonalInstance;
    private final Set listeners = new HashSet(1);
    private JTextField adminPortDisplay;
    private JLabel adminPortLabel;
    private JLabel description;
    private JLabel detectedLabel;
    private JTextField instanceDirectory;
    private JLabel instanceDirectoryLabel;
    private JButton openInstanceDirectorySelector;
    private JLabel spaceHack;

    public AddInstanceVisualDirectoryPanel(boolean bl) {
        this.initComponents();
        this.setAdminPort("");
        this.createPersonalInstance = bl;
        if (bl) {
            this.description.setText(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"TXT_instanceDirectoryDescription2"));
        }
        this.adminPortLabel.setVisible(!bl);
        this.adminPortDisplay.setVisible(!bl);
        this.instanceDirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AddInstanceVisualDirectoryPanel.this.locationChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AddInstanceVisualDirectoryPanel.this.locationChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AddInstanceVisualDirectoryPanel.this.locationChanged();
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"StepName_EnterDomainDirectory");
    }

    void setAdminPort(String string) {
        if (!this.createPersonalInstance) {
            this.adminPortDisplay.setText(string);
            this.detectedLabel.setVisible(string.length() > 0);
        }
    }

    String getInstanceDirectory() {
        return this.instanceDirectory.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    void locationChanged() {
        this.fireChangeEvent();
    }

    private String browseDomainLocation() {
        String string = null;
        JFileChooser jFileChooser = this.createPersonalInstance ? new JFileChooser() : new DomainChooser();
        Util.decorateChooser(jFileChooser, this.instanceDirectory.getText(), NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_Choose_Domain"));
        int n = jFileChooser.showDialog(this, NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_Choose_Button"));
        if (n == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return string;
    }

    private void initComponents() {
        this.description = new JLabel();
        this.instanceDirectoryLabel = new JLabel();
        this.instanceDirectory = new JTextField();
        this.openInstanceDirectorySelector = new JButton();
        this.adminPortLabel = new JLabel();
        this.adminPortDisplay = new JTextField();
        this.detectedLabel = new JLabel();
        this.spaceHack = new JLabel();
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(new Dimension(0, 0));
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle");
        this.description.setText(resourceBundle.getString("TXT_instanceDirectoryDescription1"));
        this.description.setEnabled(false);
        this.description.setFocusable(false);
        this.description.setMaximumSize(null);
        this.description.setMinimumSize(null);
        this.description.setPreferredSize(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.description, gridBagConstraints);
        this.instanceDirectoryLabel.setLabelFor(this.instanceDirectory);
        Mnemonics.setLocalizedText((JLabel)this.instanceDirectoryLabel, (String)NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_instanceDirectoryLabel"));
        this.instanceDirectoryLabel.setMaximumSize(null);
        this.instanceDirectoryLabel.setMinimumSize(null);
        this.instanceDirectoryLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.instanceDirectoryLabel, gridBagConstraints);
        this.instanceDirectory.setMaximumSize(null);
        this.instanceDirectory.setMinimumSize(null);
        this.instanceDirectory.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.instanceDirectory, gridBagConstraints);
        this.instanceDirectory.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_instanceDirectory"));
        Mnemonics.setLocalizedText((AbstractButton)this.openInstanceDirectorySelector, (String)NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_openInstanceDirectorySelector"));
        this.openInstanceDirectorySelector.setMaximumSize(null);
        this.openInstanceDirectorySelector.setMinimumSize(null);
        this.openInstanceDirectorySelector.setPreferredSize(null);
        this.openInstanceDirectorySelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddInstanceVisualDirectoryPanel.this.openInstanceDirectorySelectorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 6, 0);
        this.add((Component)this.openInstanceDirectorySelector, gridBagConstraints);
        this.openInstanceDirectorySelector.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("DSC_openInstanceDirectorySelector"));
        this.adminPortLabel.setLabelFor(this.adminPortDisplay);
        Mnemonics.setLocalizedText((JLabel)this.adminPortLabel, (String)NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_adminlPortLabel"));
        this.adminPortLabel.setMaximumSize(null);
        this.adminPortLabel.setMinimumSize(null);
        this.adminPortLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this.adminPortLabel, gridBagConstraints);
        this.adminPortDisplay.setEditable(false);
        this.adminPortDisplay.setMaximumSize(null);
        this.adminPortDisplay.setMinimumSize(null);
        this.adminPortDisplay.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 6);
        this.add((Component)this.adminPortDisplay, gridBagConstraints);
        this.adminPortDisplay.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"ACSD_ADMIN_PORT"));
        this.detectedLabel.setText(resourceBundle.getString("LBL_detectedLabel"));
        this.detectedLabel.setFocusable(false);
        this.detectedLabel.setMaximumSize(null);
        this.detectedLabel.setMinimumSize(null);
        this.detectedLabel.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 6);
        this.add((Component)this.detectedLabel, gridBagConstraints);
        this.spaceHack.setEnabled(false);
        this.spaceHack.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spaceHack, gridBagConstraints);
    }

    private void openInstanceDirectorySelectorActionPerformed(ActionEvent actionEvent) {
        String string = this.browseDomainLocation();
        if (null != string && string.length() >= 1) {
            this.instanceDirectory.setText(string);
        }
    }

    private static class DomainChooser
    extends JFileChooser {
        private DomainChooser() {
        }

        public void approveSelection() {
            File file = FileUtil.normalizeFile((File)this.getSelectedFile());
            String string = Util.rootOfUsableDomain(file);
            if (null == string) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(file);
            }
        }
    }
}

