/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.editor.Registry;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.utilities.OutputParameter;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceUtils {
    private static final Logger LOGGER = Logger.getLogger(SourceUtils.class.getName());
    private static final FileObject[] NOFILES = new FileObject[0];
    private static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String VM_CONSTRUCTUR_SIG = "<init>";
    private static final String VM_INITIALIZER_SIG = "<clinit>";
    private static final String[] APPLET_CLASSES = new String[]{"java.applet.Applet", "javax.swing.JApplet"};
    private static final String[] TEST_CLASSES = new String[]{"junit.framework.TestCase", "junit.framework.TestSuite"};
    private static final DeclaredTypeResolver declaredTypeResolver = new DeclaredTypeResolver();

    public static boolean isApplet(FileObject fileObject) {
        return SourceUtils.isJavaFile(fileObject) && SourceUtils.isInstanceOf(fileObject, APPLET_CLASSES, false);
    }

    public static ClientUtils.SourceCodeSelection[] getClassConstructors(FileObject fileObject) {
        HashSet hashSet = new HashSet();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return null;
        }
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePathScanner<Void, Void> treePathScanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitMethod(MethodTree methodTree, Void void_) {
                            ExecutableElement executableElement = (ExecutableElement)compilationController.getTrees().getElement(this.getCurrentPath());
                            Void void_2 = (Void)super.visitMethod(methodTree, void_);
                            return void_2;
                        }
                    };
                    treePathScanner.scan(compilationController.getCompilationUnit(), null);
                }
            }, true);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            iOException.printStackTrace();
        }
        return hashSet.toArray(new ClientUtils.SourceCodeSelection[hashSet.size()]);
    }

    public static FileObject getCurrentFileInEditor() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null) {
            return (FileObject)topComponent.getLookup().lookup(FileObject.class);
        }
        return null;
    }

    public static int getCurrentLineInEditor() {
        return SourceUtils.getLineForOffsetInEditor(SourceUtils.getCurrentOffsetInEditor());
    }

    public static int getCurrentOffsetInEditor() {
        JTextComponent jTextComponent = Registry.getMostActiveComponent();
        if (jTextComponent != null && jTextComponent.getCaret() != null) {
            return jTextComponent.getCaretPosition();
        }
        return -1;
    }

    public static boolean isCurrentOffsetValid() {
        return SourceUtils.isOffsetValid(SourceUtils.getCurrentFileInEditor(), SourceUtils.getCurrentOffsetInEditor());
    }

    public static Project getCurrentProjectInEditor() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null) {
            return (Project)topComponent.getLookup().lookup(Project.class);
        }
        return null;
    }

    public static JavaSource getCurrentSourceInEditor() {
        FileObject fileObject = SourceUtils.getCurrentFileInEditor();
        if (fileObject != null) {
            return JavaSource.forFileObject((FileObject)fileObject);
        }
        return null;
    }

    public static Collection<String> getDefaultPackageClassNames(Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JavaSource javaSource = SourceUtils.getSources(project);
        Set<ElementHandle<TypeElement>> set = SourceUtils.getProjectTypes(project, javaSource);
        for (ElementHandle<TypeElement> elementHandle : set) {
            int n = elementHandle.getQualifiedName().indexOf(46);
            if (n > 0) continue;
            arrayList.add(elementHandle.getQualifiedName().substring(n + 1));
        }
        return arrayList;
    }

    public static String getEnclosingClassName(FileObject fileObject, final int n) {
        final OutputParameter outputParameter = new OutputParameter(null);
        if (SourceUtils.isJavaFile(fileObject)) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                return null;
            }
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            return;
                        }
                        TypeElement typeElement = compilationController.getTreeUtilities().scopeFor(n).getEnclosingClass();
                        if (typeElement != null) {
                            outputParameter.setValue((Object)ElementUtilities.getBinaryName((TypeElement)typeElement));
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return (String)outputParameter.getValue();
    }

    public static boolean isExecutableMethod(ExecutableElement executableElement) {
        if (executableElement == null) {
            return false;
        }
        Set<Modifier> set = executableElement.getModifiers();
        return !set.contains((Object)Modifier.ABSTRACT) && !set.contains((Object)Modifier.NATIVE);
    }

    public static boolean isInstanceOf(FileObject fileObject, String string) {
        return SourceUtils.isInstanceOf(fileObject, new String[]{string}, true);
    }

    public static boolean hasAnnotation(FileObject fileObject, final String string) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(final CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePathScanner<Void, Void> treePathScanner = new TreePathScanner<Void, Void>(){

                        @Override
                        public Void visitAnnotation(AnnotationTree annotationTree, Void void_) {
                            TypeElement typeElement;
                            if (atomicBoolean.get()) {
                                return null;
                            }
                            TypeMirror typeMirror = compilationController.getTrees().getTypeMirror(this.getCurrentPath());
                            if (typeMirror != null && (typeElement = (TypeElement)compilationController.getTypes().asElement(typeMirror)) != null) {
                                atomicBoolean.set(atomicBoolean.get() || string.equals(ElementUtilities.getBinaryName((TypeElement)typeElement)));
                            }
                            return null;
                        }
                    };
                    treePathScanner.scan(compilationController.getCompilationUnit(), null);
                    countDownLatch.countDown();
                }
            }, true);
            countDownLatch.await();
            return atomicBoolean.get();
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public static boolean isInstanceOf(FileObject fileObject, final String[] stringArray, final boolean bl) {
        final boolean[] blArray = new boolean[]{false};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement;
                    if (compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    Elements elements = compilationController.getElements();
                    Trees trees = compilationController.getTrees();
                    Types types = compilationController.getTypes();
                    ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
                    for (String object : stringArray) {
                        typeElement = elements.getTypeElement(object);
                        if (typeElement == null) continue;
                        arrayList.add(typeElement);
                    }
                    if (arrayList.isEmpty()) {
                        blArray[0] = false;
                        return;
                    }
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    List<? extends Tree> list = compilationUnitTree.getTypeDecls();
                    for (Tree tree : list) {
                        TypeElement typeElement2;
                        Set<Modifier> set;
                        if (tree.getKind() != Tree.Kind.CLASS || (typeElement = (TypeElement)trees.getElement(TreePath.getPath(compilationUnitTree, tree))) == null || !(set = typeElement.getModifiers()).contains((Object)Modifier.PUBLIC) || arrayList == null) continue;
                        boolean bl2 = bl;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext() && ((typeElement2 = (TypeElement)iterator.next()) == null || !(bl ? !(bl2 = bl2 && types.isSubtype(typeElement.asType(), typeElement2.asType())) : (bl2 = bl2 || types.isSubtype(typeElement.asType(), typeElement2.asType()))))) {
                        }
                        blArray[0] = bl2;
                        if (!bl2) continue;
                        break;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            iOException.printStackTrace();
        }
        return blArray[0];
    }

    public static boolean isJavaClass(Node node) {
        if (node == null) {
            return false;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            return SourceUtils.isJavaFile(dataObject.getPrimaryFile());
        }
        return false;
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static int getLineForOffsetInEditor(int n) {
        EditorCookie editorCookie;
        if (n == -1) {
            return -1;
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && (editorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class)) != null) {
            return NbDocument.findLineNumber((StyledDocument)editorCookie.getDocument(), (int)n);
        }
        return -1;
    }

    public static boolean isOffsetValid(FileObject fileObject, int n) {
        if (fileObject == null) {
            return false;
        }
        return SourceUtils.validateOffset(fileObject, n) != -1;
    }

    public static boolean isRunnable(FileObject fileObject) {
        if (SourceUtils.isTest(fileObject) || SourceUtils.isApplet(fileObject)) {
            return true;
        }
        if (SourceUtils.isJavaFile(fileObject)) {
            return !org.netbeans.api.java.source.SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
        }
        return false;
    }

    public static int[] getSelectionOffsets() {
        EditorCookie editorCookie;
        int[] nArray = new int[]{-1, -1};
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && (editorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class)) != null) {
            for (JEditorPane jEditorPane : editorCookie.getOpenedPanes()) {
                int n = jEditorPane.getSelectionStart();
                if (n <= -1) continue;
                nArray[0] = n;
                nArray[1] = jEditorPane.getSelectionEnd();
                break;
            }
        }
        return nArray;
    }

    public static String[] getSubclassesNames(final String string, Project project) {
        final HashSet hashSet = new HashSet();
        final JavaSource javaSource = SourceUtils.getSources(project);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    TypeElement typeElement = SourceUtils.resolveClassByName(string, compilationController);
                    if (typeElement != null && typeElement.getKind() == ElementKind.INTERFACE) {
                        hashSet.addAll(SourceUtils.findImplementorsResolved(javaSource.getClasspathInfo(), string));
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
        }
        int n = 0;
        String[] stringArray = new String[hashSet.size()];
        for (TypeElement typeElement : hashSet) {
            stringArray[n++] = SourceUtils.getVMClassName(typeElement);
        }
        return stringArray;
    }

    public static boolean isTest(FileObject fileObject) {
        return SourceUtils.isJavaFile(fileObject) && (SourceUtils.hasAnnotation(fileObject, "org.junit.Test") || SourceUtils.isInstanceOf(fileObject, TEST_CLASSES, false));
    }

    public static String getToplevelClassName(FileObject fileObject) {
        final String[] stringArray = new String[1];
        if (SourceUtils.isJavaFile(fileObject)) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                return null;
            }
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(final CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            return;
                        }
                        TreePathScanner<String, Void> treePathScanner = new TreePathScanner<String, Void>(){

                            @Override
                            public String visitClass(ClassTree classTree, Void void_) {
                                try {
                                    return ElementUtilities.getBinaryName((TypeElement)((TypeElement)compilationController.getTrees().getElement(this.getCurrentPath())));
                                }
                                catch (NullPointerException nullPointerException) {
                                    ProfilerLogger.log((Exception)nullPointerException);
                                    return "";
                                }
                            }
                        };
                        stringArray[0] = (String)treePathScanner.scan(compilationController.getCompilationUnit(), null);
                    }
                }, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return stringArray[0];
    }

    public static String getVMClassName(TypeElement typeElement) {
        if (typeElement.getSimpleName().length() == 0) {
            String string = typeElement.toString();
            String string2 = string.substring(0, string.length() - 1);
            int n = string2.lastIndexOf(" ");
            string2 = string2.substring(n + 1);
            return string2;
        }
        TypeElement typeElement2 = typeElement;
        StringBuffer stringBuffer = new StringBuffer();
        while (SourceUtils.isEnclosingElement(typeElement2.getEnclosingElement())) {
            stringBuffer.insert(0, "$" + typeElement2.getSimpleName().toString());
            typeElement2 = (TypeElement)typeElement2.getEnclosingElement();
        }
        stringBuffer.insert(0, typeElement2.getQualifiedName().toString());
        return stringBuffer.toString();
    }

    public static String getVMMethodName(ExecutableElement executableElement) {
        return executableElement.getSimpleName().toString();
    }

    public static String getVMMethodSignature(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return SourceUtils.getSignature(executableElement, compilationInfo);
    }

    public static String getVMMethodSignature(final ExecutableElement executableElement, ClasspathInfo classpathInfo) {
        final OutputParameter outputParameter = new OutputParameter((Object)"");
        FileObject fileObject = org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)executableElement), (ClasspathInfo)classpathInfo);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{fileObject});
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    outputParameter.setValue((Object)SourceUtils.getSignature(executableElement, (CompilationInfo)compilationController));
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return (String)outputParameter.getValue();
    }

    public static String getVMSignature(ExecutableElement executableElement) {
        String string = "(";
        List<? extends VariableElement> list = executableElement.getParameters();
        for (VariableElement variableElement : list) {
            string = string + VMUtils.typeToVMSignature((String)((Object)variableElement.asType()).toString());
        }
        string = executableElement.getKind().equals((Object)ElementKind.CONSTRUCTOR) ? string + ")V" : string + ")" + VMUtils.typeToVMSignature((String)((Object)executableElement.getReturnType()).toString());
        return string;
    }

    public static FileObject findFileObjectByClassName(final String string, Project project) {
        if (string == null) {
            return null;
        }
        final OutputParameter outputParameter = new OutputParameter(null);
        JavaSource javaSource = SourceUtils.getSources(project);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = SourceUtils.resolveClassByName(string, compilationController);
                    if (typeElement != null) {
                        outputParameter.setValue((Object)org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)compilationController.getClasspathInfo()));
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
        }
        return (FileObject)outputParameter.getValue();
    }

    public static Set<ElementHandle<TypeElement>> findImplementors(ClasspathInfo classpathInfo, final String string) {
        final HashSet<ClassIndex.SearchKind> hashSet = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
        final HashSet<ClassIndex.SearchScope> hashSet2 = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        final OutputParameter outputParameter = new OutputParameter(new HashSet());
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (!typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
                        outputParameter.setValue((Object)compilationController.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), hashSet, hashSet2));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return (Set)outputParameter.getValue();
    }

    public static Set<TypeElement> findImplementorsResolved(ClasspathInfo classpathInfo, final String string) {
        final HashSet<ClassIndex.SearchKind> hashSet = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
        final HashSet<ClassIndex.SearchScope> hashSet2 = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        final HashSet<TypeElement> hashSet3 = new HashSet<TypeElement>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                        return;
                    }
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    if (!typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
                        for (ElementHandle elementHandle : compilationController.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), hashSet, hashSet2)) {
                            hashSet3.add(elementHandle.resolve((CompilationInfo)compilationController));
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashSet3;
    }

    public static Collection<String> findMainClasses(FileObject[] fileObjectArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = org.netbeans.api.java.source.SourceUtils.getMainClasses((FileObject[])fileObjectArray);
        for (ElementHandle elementHandle : collection) {
            arrayList.add(elementHandle.getQualifiedName());
        }
        return arrayList;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        if (!SourceUtils.isJavaFile(fileObject)) {
            return false;
        }
        return !org.netbeans.api.java.source.SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
    }

    public static void openSource(Project project, final String string, final String string2, final String string3) {
        ProfilerLogger.debug((String)("Open Source: Project: " + (project == null ? "null" : ProjectUtilities.getProjectName(project))));
        ProfilerLogger.debug((String)("Open Source: Class name: " + string));
        ProfilerLogger.debug((String)("Open Source: Method name: " + string2));
        ProfilerLogger.debug((String)("Open Source: Method sig: " + string3));
        final JavaSource javaSource = SourceUtils.getSources(project);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Parameterizable parameterizable = null;
                    TypeElement typeElement = SourceUtils.resolveClassByName(string, compilationController);
                    if (string2 != null && string2.length() > 0 && typeElement != null) {
                        parameterizable = SourceUtils.resolveMethodByName(typeElement, string2, string3);
                    }
                    if (parameterizable == null) {
                        parameterizable = typeElement;
                    }
                    if (parameterizable != null) {
                        ProfilerLogger.debug((String)("Opening element: " + parameterizable));
                        final Parameterizable parameterizable2 = parameterizable;
                        String string4 = MessageFormat.format(NbBundle.getMessage(SourceUtils.class, (String)"MDRUtils_OpeningSourceMsg"), parameterizable2.toString());
                        final String string22 = string4 + " ...";
                        StatusDisplayer.getDefault().setStatusText(string22);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (!ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)parameterizable2)) {
                                    Profiler.getDefault().displayError(MessageFormat.format(NbBundle.getMessage(SourceUtils.class, (String)"MDRUtils_NoSourceFoundMessage"), string));
                                }
                                if (string22.equals(StatusDisplayer.getDefault().getStatusText())) {
                                    StatusDisplayer.getDefault().setStatusText("");
                                }
                            }
                        });
                    } else {
                        Profiler.getDefault().displayError(MessageFormat.format(NbBundle.getMessage(SourceUtils.class, (String)"MDRUtils_NoSourceFoundMessage"), string));
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
        }
    }

    public static ResolvedClass resolveClassAtPosition(FileObject fileObject, final int n, final boolean bl) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return null;
        }
        final OutputParameter outputParameter = new OutputParameter(null);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                    if (treePath == null) {
                        return;
                    }
                    Element element = compilationController.getTrees().getElement(treePath);
                    if (element == null) {
                        return;
                    }
                    if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.ENUM) {
                        TypeElement typeElement = (TypeElement)element;
                        String string = ElementUtilities.getBinaryName((TypeElement)typeElement);
                        outputParameter.setValue((Object)new ResolvedClass(typeElement, string));
                        return;
                    }
                    if (bl && (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.LOCAL_VARIABLE) && element.asType().getKind() == TypeKind.DECLARED) {
                        TypeElement typeElement = SourceUtils.getDeclaredType(element.asType());
                        String string = ElementUtilities.getBinaryName((TypeElement)typeElement);
                        outputParameter.setValue((Object)new ResolvedClass(typeElement, string));
                        return;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            iOException.printStackTrace();
            return null;
        }
        return (ResolvedClass)outputParameter.getValue();
    }

    public static TypeElement resolveClassByName(String string, CompilationController compilationController) {
        TypeElement typeElement;
        block9: {
            if (string == null || compilationController == null) {
                return null;
            }
            typeElement = compilationController.getElements().getTypeElement(string.replace('$', '.'));
            if (typeElement == null) {
                try {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    int n = string.indexOf(36);
                    if (n <= 0) break block9;
                    final String string2 = string;
                    string = string.substring(0, n);
                    typeElement = compilationController.getElements().getTypeElement(string);
                    if (typeElement == null) break block9;
                    FileObject fileObject = org.netbeans.api.java.source.SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)compilationController.getClasspathInfo());
                    final OutputParameter outputParameter = new OutputParameter((Object)typeElement);
                    try {
                        JavaSource.forFileObject((FileObject)fileObject).runUserActionTask((Task)new CancellableTask<CompilationController>(){
                            private volatile boolean isCancelled = false;

                            public void cancel() {
                                this.isCancelled = true;
                            }

                            public void run(final CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                                TreePathScanner<Void, String> treePathScanner = new TreePathScanner<Void, String>(){

                                    @Override
                                    public Void visitClass(ClassTree classTree, String string) {
                                        if (isCancelled) {
                                            return null;
                                        }
                                        Element element = compilationController.getTrees().getElement(this.getCurrentPath());
                                        if (element != null && element.getKind() == ElementKind.CLASS && ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)).equals(string)) {
                                            outputParameter.setValue((Object)((TypeElement)element));
                                            return null;
                                        }
                                        return (Void)super.visitClass(classTree, string);
                                    }
                                };
                                treePathScanner.scan(compilationController.getCompilationUnit(), string2);
                            }
                        }, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    typeElement = (TypeElement)outputParameter.getValue();
                }
                catch (IOException iOException) {
                    ProfilerLogger.log((Exception)iOException);
                }
            }
        }
        if (typeElement != null) {
            ProfilerLogger.debug((String)("Resolved: " + typeElement));
        } else {
            ProfilerLogger.debug((String)("Could not resolve: " + string));
        }
        if (typeElement == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SourceUtils.class, (String)"MDRUtils_ClassNotResolvedMessage", (Object)string));
        }
        return typeElement;
    }

    public static ResolvedMethod resolveMethodAtPosition(FileObject fileObject, final int n) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return null;
        }
        final OutputParameter outputParameter = new OutputParameter(null);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                    if (treePath == null) {
                        return;
                    }
                    Element element = compilationController.getTrees().getElement(treePath);
                    if (element != null && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.STATIC_INIT)) {
                        ExecutableElement executableElement = (ExecutableElement)element;
                        String string = ElementUtilities.getBinaryName((TypeElement)((TypeElement)executableElement.getEnclosingElement()));
                        String string2 = SourceUtils.getVMMethodName(executableElement);
                        String string3 = SourceUtils.getVMMethodSignature(executableElement, (CompilationInfo)compilationController);
                        outputParameter.setValue((Object)new ResolvedMethod(executableElement, string, string2, string3));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            iOException.printStackTrace();
            return null;
        }
        return (ResolvedMethod)outputParameter.getValue();
    }

    private static TypeElement getDeclaredType(TypeMirror typeMirror) {
        return typeMirror.accept(declaredTypeResolver, null);
    }

    private static boolean isEnclosingElement(Element element) {
        if (element == null) {
            return false;
        }
        ElementKind elementKind = element.getKind();
        return elementKind == ElementKind.CLASS || elementKind == ElementKind.ENUM || elementKind == ElementKind.INTERFACE;
    }

    private static boolean isMainMethod(ExecutableElement executableElement) {
        return org.netbeans.api.java.source.SourceUtils.isMainMethod((ExecutableElement)executableElement);
    }

    private static String getParamsSignature(List<? extends VariableElement> list, CompilationInfo compilationInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<? extends VariableElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            TypeMirror typeMirror = iterator.next().asType();
            String string = SourceUtils.getRealTypeName(typeMirror, compilationInfo);
            String string2 = VMUtils.typeToVMSignature((String)string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static Set<ElementHandle<TypeElement>> getProjectTypes(FileObject[] fileObjectArray, JavaSource javaSource) {
        HashSet<ClassIndex.SearchScope> hashSet = new HashSet<ClassIndex.SearchScope>();
        hashSet.add(ClassIndex.SearchScope.SOURCE);
        if (javaSource != null) {
            return javaSource.getClasspathInfo().getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, hashSet);
        }
        return null;
    }

    private static Set<ElementHandle<TypeElement>> getProjectTypes(Project project, JavaSource javaSource) {
        return SourceUtils.getProjectTypes(ProjectUtilities.getSourceRoots(project, true), javaSource);
    }

    private static String getRealTypeName(TypeMirror typeMirror, CompilationInfo compilationInfo) {
        TypeKind typeKind = typeMirror.getKind();
        if (typeKind.isPrimitive()) {
            return ((Object)typeMirror).toString();
        }
        switch (typeKind) {
            case VOID: {
                return ((Object)typeMirror).toString();
            }
            case DECLARED: {
                return ElementUtilities.getBinaryName((TypeElement)SourceUtils.getDeclaredType(typeMirror));
            }
            case ARRAY: {
                return SourceUtils.getRealTypeName(((ArrayType)typeMirror).getComponentType(), compilationInfo) + "[]";
            }
            case TYPEVAR: {
                List<? extends TypeMirror> list = compilationInfo.getTypes().directSupertypes(typeMirror);
                if (list.size() == 0) {
                    return "java.lang.Object";
                }
                if (list.size() > 1 && ((Object)list.get(0)).toString().equals("java.lang.Object") && SourceUtils.getDeclaredType(list.get(1)).getKind().isInterface()) {
                    return SourceUtils.getRealTypeName(list.get(1), compilationInfo);
                }
                return SourceUtils.getRealTypeName(list.get(0), compilationInfo);
            }
            case WILDCARD: {
                throw new IllegalArgumentException("Unexpected WILDCARD parameter: " + typeMirror);
            }
        }
        throw new IllegalArgumentException("Unexpected type parameter: " + typeMirror + " of kind " + (Object)((Object)typeKind));
    }

    private static String getSignature(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        try {
            switch (executableElement.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: 
                case STATIC_INIT: {
                    String string = SourceUtils.getParamsSignature(executableElement.getParameters(), compilationInfo);
                    String string2 = VMUtils.typeToVMSignature((String)SourceUtils.getRealTypeName(executableElement.getReturnType(), compilationInfo));
                    return "(" + string + ")" + string2;
                }
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warning(illegalArgumentException.getMessage());
            return null;
        }
    }

    public static JavaSource getSources(Project project) {
        if (project == null) {
            return SourceUtils.getSources((FileObject[])null);
        }
        return SourceUtils.getSources(ProjectUtilities.getSourceRoots(project, true));
    }

    private static JavaSource getSources(FileObject[] fileObjectArray) {
        ClassPath classPath;
        ClassPath classPath2;
        ClassPath classPath3;
        if (fileObjectArray == null) {
            classPath3 = ClassPathSupport.createProxyClassPath((ClassPath[])GlobalPathRegistry.getDefault().getPaths("classpath/source").toArray(new ClassPath[0]));
            classPath2 = JavaPlatform.getDefault().getBootstrapLibraries();
            classPath = ClassPathSupport.createProxyClassPath((ClassPath[])GlobalPathRegistry.getDefault().getPaths("classpath/compile").toArray(new ClassPath[0]));
        } else {
            classPath3 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
            classPath2 = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/boot");
            classPath = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/compile");
        }
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath2, (ClassPath)classPath, (ClassPath)classPath3);
        return JavaSource.create((ClasspathInfo)classpathInfo, Collections.emptyList());
    }

    private static boolean methodNameMatch(String string, ExecutableElement executableElement) {
        switch (executableElement.getKind()) {
            case METHOD: {
                return executableElement.getSimpleName().contentEquals(string);
            }
            case CONSTRUCTOR: {
                return string.equals(VM_CONSTRUCTUR_SIG);
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                return string.equals(VM_INITIALIZER_SIG);
            }
        }
        return false;
    }

    private static boolean methodSignatureMatch(String string, ExecutableElement executableElement) {
        String string2 = string.replaceAll("\\$", "/");
        return SourceUtils.getVMSignature(executableElement).equals(string2);
    }

    public static ExecutableElement resolveMethodByName(TypeElement typeElement, String string, String string2) {
        if (typeElement == null || string == null || string2 == null) {
            return null;
        }
        ExecutableElement executableElement = null;
        boolean bl = false;
        List<ExecutableElement> list = null;
        list = string.equals(VM_CONSTRUCTUR_SIG) ? ElementFilter.constructorsIn(typeElement.getEnclosedElements()) : ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement executableElement2 : list) {
            if (!SourceUtils.methodNameMatch(string, executableElement2)) continue;
            if (SourceUtils.methodSignatureMatch(string2, executableElement2)) {
                executableElement = executableElement2;
                bl = true;
                break;
            }
            executableElement = executableElement2;
        }
        if (!bl) {
            ProfilerLogger.debug((String)("Could not find exact signature match, opening at first method with same name: " + executableElement));
        }
        return executableElement;
    }

    private static int validateOffset(FileObject fileObject, final int n) {
        final OutputParameter outputParameter = new OutputParameter((Object)-1);
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        outputParameter.setValue((Object)-1);
                        Scope scope = compilationController.getTreeUtilities().scopeFor(n);
                        if (scope.getEnclosingClass() != null) {
                            outputParameter.setValue((Object)n);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return (Integer)outputParameter.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeclaredTypeResolver
    implements TypeVisitor<TypeElement, Void> {
        private DeclaredTypeResolver() {
        }

        @Override
        public TypeElement visit(TypeMirror typeMirror, Void void_) {
            return null;
        }

        @Override
        public TypeElement visit(TypeMirror typeMirror) {
            return null;
        }

        @Override
        public TypeElement visitArray(ArrayType arrayType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitDeclared(DeclaredType declaredType, Void void_) {
            return (TypeElement)declaredType.asElement();
        }

        @Override
        public TypeElement visitError(ErrorType errorType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitExecutable(ExecutableType executableType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitNoType(NoType noType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitNull(NullType nullType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitPrimitive(PrimitiveType primitiveType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitTypeVariable(TypeVariable typeVariable, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitUnknown(TypeMirror typeMirror, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitWildcard(WildcardType wildcardType, Void void_) {
            return null;
        }
    }

    public static class ResolvedMethod {
        private ExecutableElement method;
        private String vmClassName;
        private String vmMethodName;
        private String vmMethodSignature;

        ResolvedMethod(ExecutableElement executableElement, String string, String string2, String string3) {
            this.method = executableElement;
            this.vmClassName = string;
            this.vmMethodName = string2;
            this.vmMethodSignature = string3;
        }

        public ExecutableElement getMethod() {
            return this.method;
        }

        public String getVMClassName() {
            return this.vmClassName;
        }

        public String getVMMethodName() {
            return this.vmMethodName;
        }

        public String getVMMethodSignature() {
            return this.vmMethodSignature;
        }
    }

    public static class ResolvedClass {
        private String vmClassName;
        private TypeElement jclass;

        ResolvedClass(TypeElement typeElement, String string) {
            this.jclass = typeElement;
            this.vmClassName = string;
        }

        public TypeElement getJClass() {
            return this.jclass;
        }

        public String getVMClassName() {
            return this.vmClassName;
        }
    }
}

