/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.ClassViewModel;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.HostKeyArray;
import org.netbeans.modules.cnd.classview.NamespaceKeyArray;
import org.netbeans.modules.cnd.classview.SortedName;
import org.netbeans.modules.cnd.classview.model.ProjectNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsKeyArray
extends Children.Keys<CsmProject> {
    private Map<CsmProject, SortedName> myProjects;
    private ChildrenUpdater childrenUpdater;
    private static Comparator<Map.Entry<CsmProject, SortedName>> COMARATOR = new ProjectComparator();
    private Object lock = new String("ProjectsKeyArray lock");

    public ProjectsKeyArray(ChildrenUpdater childrenUpdater) {
        this.childrenUpdater = childrenUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKeys() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                ArrayList<Map.Entry<CsmProject, SortedName>> arrayList = new ArrayList<Map.Entry<CsmProject, SortedName>>(this.myProjects.entrySet());
                Collections.sort(arrayList, COMARATOR);
                ArrayList<CsmProject> arrayList2 = new ArrayList<CsmProject>();
                for (Map.Entry entry : arrayList) {
                    CsmProject csmProject = (CsmProject)entry.getKey();
                    arrayList2.add(csmProject);
                }
                this.setKeys(arrayList2);
            } else {
                this.setKeys(Collections.emptyList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                this.myProjects.clear();
            }
        }
        this.childrenUpdater = null;
        this.setKeys(new CsmProject[0]);
    }

    private Set<CsmProject> getProjects() {
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
            if (ClassViewModel.isShowLibs()) {
                for (CsmProject csmProject2 : csmProject.getLibraries()) {
                    hashSet.add(csmProject2);
                }
            }
            hashSet.add(csmProject);
        }
        return hashSet;
    }

    private SortedName getSortedName(CsmProject csmProject, boolean bl) {
        if (bl) {
            return new SortedName(1, csmProject.getName(), 0);
        }
        return new SortedName(0, csmProject.getName(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                return this.myProjects.size() == 0;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(CsmProject csmProject) {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects == null) {
                return;
            }
            if (this.myProjects.containsKey(csmProject)) {
                return;
            }
            this.myProjects.put(csmProject, this.getSortedName(csmProject, false));
        }
        this.resetKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProject(CsmProject csmProject) {
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects == null || this.myProjects.size() == 0) {
                return;
            }
            if (!this.myProjects.containsKey(csmProject)) {
                return;
            }
            this.myProjects.remove(csmProject);
            this.childrenUpdater.unregister(csmProject);
            boolean bl = true;
            for (CsmProject csmProject2 : this.myProjects.keySet()) {
                SortedName sortedName = this.myProjects.get(csmProject2);
                if (sortedName == null || sortedName.getPrefix() != 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (CsmProject csmProject2 : this.myProjects.keySet()) {
                    this.childrenUpdater.unregister(csmProject2);
                }
                this.myProjects.clear();
            }
        }
        this.resetKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjects() {
        Set<CsmProject> set = this.getProjects();
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                for (CsmProject csmProject : this.myProjects.keySet()) {
                    if (set.contains(csmProject)) continue;
                    this.childrenUpdater.unregister(csmProject);
                }
            }
            this.myProjects = this.createProjectsMap();
            for (CsmProject csmProject : set) {
                this.myProjects.put(csmProject, this.getSortedName(csmProject, false));
            }
        }
        this.resetKeys();
    }

    private Map<CsmProject, SortedName> createProjectsMap() {
        return new ConcurrentHashMap<CsmProject, SortedName>();
    }

    protected Node[] createNodes(CsmProject csmProject) {
        ProjectNode projectNode = null;
        try {
            projectNode = new ProjectNode(csmProject, (Children.Array)new NamespaceKeyArray(this.childrenUpdater, csmProject));
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (projectNode != null) {
            return new Node[]{projectNode};
        }
        return new Node[0];
    }

    protected void destroyNodes(Node[] nodeArray) {
        for (Node node : nodeArray) {
            Children children = node.getChildren();
            if (!(children instanceof HostKeyArray)) continue;
            ((HostKeyArray)children).dispose();
        }
        super.destroyNodes(nodeArray);
    }

    void ensureAddNotify() {
        if (this.myProjects == null) {
            this.addNotify();
        }
    }

    protected void addNotify() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesP: addNotify()");
        }
        this.resetProjects();
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        super.removeNotify();
        Object object = this.lock;
        synchronized (object) {
            if (this.myProjects != null) {
                this.myProjects.clear();
                this.resetKeys();
            }
            this.myProjects = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProjectComparator
    implements Comparator<Map.Entry<CsmProject, SortedName>> {
        private ProjectComparator() {
        }

        @Override
        public int compare(Map.Entry<CsmProject, SortedName> entry, Map.Entry<CsmProject, SortedName> entry2) {
            if (entry.getKey().isArtificial() != entry2.getKey().isArtificial()) {
                return entry.getKey().isArtificial() ? 1 : -1;
            }
            return entry.getValue().compareTo(entry2.getValue());
        }
    }
}

