/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemFilesParser;
import org.netbeans.modules.ruby.platform.gems.GemPanel;
import org.netbeans.modules.ruby.platform.gems.GemRunner;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GemManager {
    private static final Logger LOGGER = Logger.getLogger(GemManager.class.getName());
    private static final String[] TOP_LEVEL_REPO_DIRS = new String[]{"cache", "specifications", "gems", "doc"};
    private static final String SPECIFICATIONS = "specifications";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-\\S+)?");
    private static final boolean SKIP_INDEX_LIBS = System.getProperty("ruby.index.nolibs") != null;
    private static final boolean SKIP_INDEX_GEMS = System.getProperty("ruby.index.nogems") != null;
    private static final String DOT_GEM_SPEC = ".gemspec";
    private Map<String, Map<String, File>> gemFiles;
    private Map<String, String> gemVersions;
    private Map<String, URL> gemUrls;
    private Set<URL> nonGemUrls;
    public static String TEST_GEM_HOME;
    private List<Gem> installed;
    private List<Gem> remote;
    private String gemTool;
    private String gemHomeUrl;
    private String rake;
    private String rails;
    private final RubyPlatform platform;

    public GemManager(RubyPlatform rubyPlatform) {
        assert (rubyPlatform.hasRubyGemsInstalled()) : "called when RubyGems installed";
        this.platform = rubyPlatform;
    }

    private String getGemMissingMessage() {
        String string;
        if (Utilities.isMac() && "/usr/bin/ruby".equals(this.platform.getInterpreter()) && ((string = System.getProperty("os.version")) == null || string.startsWith("10.4"))) {
            return NbBundle.getMessage(GemManager.class, (String)"GemMissingMac");
        }
        return NbBundle.getMessage(GemManager.class, (String)"GemMissing");
    }

    public String getGemProblem() {
        String string = this.getGemTool();
        if (string == null) {
            return this.getGemMissingMessage();
        }
        String string2 = this.getGemHome();
        if (string2 == null) {
            return NbBundle.getMessage(GemManager.class, (String)"CannotFindGemRepository");
        }
        File file = new File(string2);
        if (!file.exists()) {
            return null;
        }
        return null;
    }

    private boolean checkGemHomePermissions() {
        if (!this.getGemHomeF().canWrite()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GemManager.class, (String)"GemNotWritable", (Object)this.getGemHome()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            return false;
        }
        return true;
    }

    public static void initializeRepository(File file) throws IOException {
        if (!file.exists()) {
            file.mkdirs();
        }
        GemManager.initializeRepository(FileUtil.toFileObject((File)file));
    }

    public static void initializeRepository(FileObject fileObject) throws IOException {
        for (String string : TOP_LEVEL_REPO_DIRS) {
            fileObject.createFolder(string);
        }
    }

    public String getGemHome() {
        return this.platform.getInfo().getGemHome();
    }

    public File getGemHomeF() {
        return FileUtil.normalizeFile((File)new File(this.platform.getInfo().getGemHome()));
    }

    public FileObject getGemHomeFO() {
        return FileUtil.toFileObject((File)this.getGemHomeF());
    }

    public String getGemHomeUrl() {
        String string;
        if (this.gemHomeUrl == null && (string = this.getGemHome()) != null) {
            try {
                File file = new File(string);
                if (file != null) {
                    this.gemHomeUrl = file.toURI().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return this.gemHomeUrl;
    }

    public Set<? extends File> getRepositories() {
        Set<File> set = this.getGemPath();
        set.add(this.getGemHomeF());
        return set;
    }

    public Set<File> getGemPath() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.platform.getInfo().getGemPath(), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(new File(stringTokenizer.nextToken()));
        }
        return linkedHashSet;
    }

    public boolean addGemPath(File file) {
        boolean bl;
        Set<File> set = this.getGemPath();
        try {
            bl = set.add(file.getCanonicalFile());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
            bl = false;
        }
        if (bl) {
            this.storeGemPath(set);
        }
        return bl;
    }

    public void removeGemPath(File file) {
        Set<File> set = this.getGemPath();
        set.remove(file);
        this.storeGemPath(set);
    }

    private void storeGemPath(Set<File> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : set) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(file.getAbsolutePath());
        }
        this.platform.getInfo().setGemPath(stringBuilder.toString());
        try {
            RubyPlatformManager.storePlatform(this.platform);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
        this.resetLocal();
    }

    public static int compareGemVersions(String string, String string2) {
        if (string.equals(string2)) {
            return 0;
        }
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            int n3 = Integer.parseInt(matcher.group(3));
            Matcher matcher2 = VERSION_PATTERN.matcher(string2);
            if (matcher2.matches()) {
                int n4 = Integer.parseInt(matcher2.group(1));
                int n5 = Integer.parseInt(matcher2.group(2));
                int n6 = Integer.parseInt(matcher2.group(3));
                if (n != n4) {
                    return n - n4;
                }
                if (n2 != n5) {
                    return n2 - n5;
                }
                if (n3 != n6) {
                    return n3 - n6;
                }
            }
        }
        return string.compareTo(string2);
    }

    public boolean isGemInstalled(String string) {
        return this.getVersion(string) != null;
    }

    public boolean isGemInstalled(String string, String string2) {
        String string3 = this.getVersion(string);
        return this.isRightVersion(string3, string2, false);
    }

    public boolean isGemInstalledForPlatform(String string, String string2, boolean bl) {
        String string3 = this.getVersionForPlatform(string);
        return this.isRightVersion(string3, string2, bl);
    }

    private boolean isRightVersion(String string, String string2, boolean bl) {
        boolean bl2 = false;
        if (string != null) {
            int n = GemManager.compareGemVersions(string2, string);
            bl2 = bl ? n == 0 : n <= 0;
        }
        return bl2;
    }

    public boolean isGemInstalledForPlatform(String string, String string2) {
        return this.isGemInstalledForPlatform(string, string2, false);
    }

    public String getVersion(String string) {
        this.initGemList();
        if (this.gemFiles == null) {
            return null;
        }
        Map<String, File> map = this.gemFiles.get(string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.keySet().iterator().next();
    }

    public String getVersionForPlatform(String string) {
        this.initGemList();
        if (this.gemFiles == null) {
            return null;
        }
        Map<String, File> map = this.gemFiles.get(string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, File> entry : map.entrySet()) {
            String string2 = entry.getValue().getName();
            if (!this.platform.isJRuby() && string2.endsWith("-java.gemspec")) continue;
            if (string2.startsWith("ruby-debug-base-")) {
                boolean bl = string2.endsWith("-java.gemspec");
                if (this.platform.isJRuby() && !bl || !this.platform.isJRuby() && bl) continue;
            }
            return entry.getKey();
        }
        return null;
    }

    private void logGems(Level level) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        if (this.gemFiles == null) {
            LOGGER.log(level, "No gems found, gemFiles is null");
            return;
        }
        LOGGER.log(level, "Found " + this.gemFiles.size() + " gems.");
        for (String string : this.gemFiles.keySet()) {
            Map<String, File> map = this.gemFiles.get(string);
            LOGGER.log(level, string + " has " + (map == null ? "null" : "" + map.size()) + " version(s):");
            for (String string2 : map.keySet()) {
                LOGGER.log(level, string2 + " at " + map.get(string2));
            }
        }
    }

    private void initGemList() {
        if (this.gemFiles == null) {
            assert (this.platform.hasRubyGemsInstalled()) : "asking for gems only when RubyGems are installed";
            this.gemFiles = new HashMap<String, Map<String, File>>();
            for (File file : this.getRepositories()) {
                File file2 = new File(file, SPECIFICATIONS);
                if (file2.exists()) {
                    LOGGER.finest("Initializing \"" + file + "\" repository");
                    File[] fileArray = file2.listFiles();
                    if (fileArray != null) {
                        GemManager.chooseGems(fileArray, this.gemFiles);
                    }
                } else {
                    LOGGER.finest("Cannot find Gems repository. \"" + file + "\" does not exist or is not a directory.");
                }
                this.logGems(Level.FINEST);
            }
        }
    }

    private static File[] chooseGems(File[] fileArray, Map<String, Map<String, File>> map) {
        GemFilesParser gemFilesParser = new GemFilesParser(fileArray);
        gemFilesParser.chooseGems();
        map.putAll(gemFilesParser.getGemMap());
        return gemFilesParser.getFiles();
    }

    public Set<String> getInstalledGemsFiles() {
        this.initGemList();
        if (this.gemFiles == null) {
            return Collections.emptySet();
        }
        return this.gemFiles.keySet();
    }

    public void reset() {
        this.resetRemote();
        this.resetLocal();
        this.gemHomeUrl = null;
    }

    public void resetRemote() {
        this.remote = null;
    }

    public void resetLocal() {
        this.installed = null;
        this.gemFiles = null;
        this.platform.fireGemsChanged();
    }

    public void getAllGems(List<String> list) {
        this.reloadIfNeeded(list);
    }

    public List<Gem> getInstalledGems(List<String> list) {
        this.reloadIfNeeded(list);
        return this.installed != null ? this.installed : Collections.emptyList();
    }

    public List<Gem> getRemoteGems(List<String> list) {
        this.reloadIfNeeded(list);
        return this.remote != null ? this.remote : Collections.emptyList();
    }

    public boolean haveGemTool() {
        return this.getGemTool() != null;
    }

    private boolean checkGemProblem() {
        String string = this.getGemProblem();
        if (string != null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            return false;
        }
        return true;
    }

    public void reloadIfNeeded(List<String> list) {
        boolean bl;
        if (!this.checkGemProblem()) {
            return;
        }
        GemRunner gemRunner = new GemRunner(this.platform);
        if (this.installed == null && this.remote == null) {
            bl = gemRunner.fetchBoth();
            this.installed = new ArrayList<Gem>();
            this.remote = new ArrayList<Gem>();
        } else if (this.installed == null) {
            bl = gemRunner.fetchLocal();
            this.installed = new ArrayList<Gem>();
        } else if (this.remote == null) {
            bl = gemRunner.fetchRemote();
            this.remote = new ArrayList<Gem>();
        } else {
            return;
        }
        if (bl) {
            GemManager.parseGemList(gemRunner.getOutput(), this.installed, this.remote);
            if (this.installed != null) {
                Collections.sort(this.installed);
            }
            if (this.remote != null) {
                Collections.sort(this.remote);
            }
        } else {
            boolean bl2 = false;
            for (String string : gemRunner.getOutput()) {
                if (bl2) {
                    list.add(string);
                    continue;
                }
                if (string.startsWith("***") || string.startsWith(" ") || string.trim().length() == 0 || string.matches("[a-zA-Z\\-]+ \\(([0-9., ])+\\)\\s?")) continue;
                list.add(string);
                bl2 = true;
            }
        }
    }

    private static void parseGemList(List<String> list, List<Gem> list2, List<Gem> list3) {
        Gem gem = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string : list) {
            if (string.length() == 0) {
                gem = null;
                continue;
            }
            if (string.startsWith("*** REMOTE GEMS")) {
                bl3 = true;
                bl2 = false;
                bl = true;
                gem = null;
                continue;
            }
            if (string.startsWith("*** LOCAL GEMS")) {
                bl3 = false;
                bl2 = true;
                bl = true;
                gem = null;
                continue;
            }
            if (!bl) continue;
            if (Character.isWhitespace(string.charAt(0))) {
                if (gem == null) continue;
                String string2 = string.trim();
                if (gem.getDescription() == null) {
                    gem.setDescription(string2);
                    continue;
                }
                gem.setDescription(gem.getDescription() + " " + string2);
                continue;
            }
            if (string.charAt(0) == '.') continue;
            int n = string.indexOf(40);
            if (n != -1) {
                String string3 = string.substring(0, n).trim();
                int n2 = string.indexOf(41);
                String string4 = n2 != -1 ? string.substring(n + 1, n2) : string.substring(n);
                gem = new Gem(string3, bl2 ? string4 : null, bl2 ? null : string4);
                if (bl2) {
                    list2.add(gem);
                    continue;
                }
                assert (bl3);
                list3.add(gem);
                continue;
            }
            gem = null;
        }
    }

    public void installGem(String string, boolean bl, boolean bl2, String string2) {
        if (!this.checkGemHomePermissions()) {
            return;
        }
        Gem[] gemArray = new Gem[]{new Gem(string, null, null)};
        Runnable runnable = new Runnable(){

            public void run() {
                GemManager.this.platform.recomputeRoots();
            }
        };
        this.install(gemArray, null, bl, bl2, string2, true, true, runnable);
    }

    public void installGem(String string, boolean bl, boolean bl2) {
        this.installGem(string, bl, bl2, null);
    }

    public boolean install(Gem[] gemArray, Component component, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> list = this.mapToGemNames(gemArray);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl4) {
            gemRunner.installAsynchronously(list, bl, bl2, bl3, string, this.resetCompletionTask(runnable), component);
            return false;
        }
        boolean bl5 = gemRunner.install(list, bl, bl2, bl3, string);
        this.resetLocal();
        return bl5;
    }

    boolean installLocal(File file, GemPanel gemPanel, boolean bl, boolean bl2, boolean bl3, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl3) {
            gemRunner.installLocalAsynchronously(file, bl, bl2, this.resetCompletionTask(runnable), gemPanel);
            return false;
        }
        boolean bl4 = gemRunner.installLocal(file, bl, bl2);
        this.resetLocal();
        return bl4;
    }

    public boolean uninstall(Gem[] gemArray, Component component, boolean bl, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> list = this.mapToGemNames(gemArray);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl) {
            gemRunner.uninstallAsynchronously(list, this.resetCompletionTask(runnable), component);
            return false;
        }
        boolean bl2 = gemRunner.uninstall(list);
        this.resetLocal();
        return bl2;
    }

    public boolean update(Gem[] gemArray, Component component, boolean bl, boolean bl2, boolean bl3, Runnable runnable) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> list = gemArray == null ? null : this.mapToGemNames(gemArray);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (bl3) {
            gemRunner.updateAsynchronously(list, bl, bl2, this.resetCompletionTask(runnable), component);
            return false;
        }
        boolean bl4 = gemRunner.update(list, bl, bl2);
        this.resetLocal();
        return bl4;
    }

    public String getGemTool() {
        String string;
        if (!this.platform.hasRubyGemsInstalled()) {
            return null;
        }
        if (this.gemTool == null && (string = this.platform.getBinDir()) != null) {
            this.gemTool = string + File.separator + "gem";
            if (!new File(this.gemTool).isFile()) {
                this.gemTool = null;
            }
        }
        if (this.gemTool == null) {
            this.gemTool = Util.findOnPath("gem");
        }
        return this.gemTool;
    }

    public String getRake() {
        if (this.rake == null) {
            this.rake = this.platform.findExecutable("rake");
            if (this.rake != null && !new File(this.rake).exists() && this.getVersion("rake") != null) {
                InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                File file = installedFileLocator.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
                if (file == null) {
                    throw new RuntimeException("Can't find cluster");
                }
                file = new File(file.getParentFile().getParentFile().getAbsolutePath() + File.separator + "rake");
                try {
                    this.rake = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return this.rake;
    }

    public boolean isValidRake(boolean bl) {
        String string = this.getRake();
        boolean bl2 = string != null && new File(string).exists();
        this.possiblyNotifyUser(bl, bl2, "rake");
        return bl2;
    }

    public String getRails() {
        if (this.rails == null) {
            this.rails = this.platform.findExecutable("rails");
        }
        return this.rails;
    }

    public boolean isValidRails(boolean bl) {
        String string = this.getRails();
        boolean bl2 = string != null && new File(string).exists();
        this.possiblyNotifyUser(bl, bl2, "rails");
        return bl2;
    }

    public String getAutoTest() {
        return this.platform.findExecutable("autotest");
    }

    public boolean isValidAutoTest(boolean bl) {
        String string = this.getAutoTest();
        boolean bl2 = string != null && new File(string).exists();
        this.possiblyNotifyUser(bl, bl2, "autotest");
        return bl2;
    }

    private void possiblyNotifyUser(boolean bl, boolean bl2, String string) {
        if (bl && !bl2) {
            String string2 = NbBundle.getMessage(GemManager.class, (String)"GemManager.NotInstalledCmd", (Object)string, (Object)this.platform.getLabel());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public Set<URL> getNonGemLoadPath() {
        if (this.nonGemUrls == null) {
            this.initializeUrlMaps();
        }
        return this.nonGemUrls;
    }

    public Map<String, String> getGemVersions() {
        if (this.gemVersions == null) {
            this.initializeUrlMaps();
        }
        return this.gemVersions;
    }

    public Map<String, URL> getGemUrls() {
        if (this.gemUrls == null) {
            this.initializeUrlMaps();
        }
        return this.gemUrls;
    }

    private void initializeUrlMaps() {
        File file = this.platform.getHome();
        if (file == null || !file.exists()) {
            this.gemVersions = Collections.emptyMap();
            this.gemUrls = Collections.emptyMap();
            this.nonGemUrls = Collections.emptySet();
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            this.gemUrls = new HashMap<String, URL>(60);
            this.gemVersions = new HashMap<String, String>(60);
            this.nonGemUrls = new HashSet<URL>(12);
            FileObject fileObject = this.platform.getRubyStubs();
            if (fileObject != null) {
                try {
                    this.nonGemUrls.add(fileObject.getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            if (!SKIP_INDEX_LIBS && (object3 = this.platform.getLibDir()) != null) {
                object2 = new File((String)object3);
                assert (((File)object2).exists() && ((File)object2).isDirectory());
                this.nonGemUrls.add(((File)object2).toURI().toURL());
            }
            if (!SKIP_INDEX_GEMS) {
                this.initGemList();
                if (RubyPlatformManager.PREINDEXING) {
                    object3 = this.getGemHome();
                    object2 = new File((String)object3, "gems");
                    if (((File)object2).exists()) {
                        object = ((File)object2).listFiles();
                        for (File file2 : object) {
                            File file3;
                            if (file2.getName().indexOf(45) == -1 || !(file3 = new File(file2, "lib")).exists() || !file3.isDirectory()) continue;
                            URL uRL = file3.toURI().toURL();
                            this.nonGemUrls.add(uRL);
                        }
                    }
                } else if (this.gemFiles != null) {
                    object3 = this.gemFiles.keySet();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        Map<String, File> map = this.gemFiles.get(object);
                        assert (map.keySet().size() == 1);
                        File file4 = map.values().iterator().next();
                        assert (file4.getName().endsWith(DOT_GEM_SPEC));
                        String string = file4.getName().substring(0, file4.getName().length() - DOT_GEM_SPEC.length());
                        File file5 = new File(file4.getParentFile().getParentFile(), "gems" + File.separator + string + File.separator + "lib");
                        if (!file5.exists() || !file5.isDirectory()) continue;
                        URL uRL = file5.toURI().toURL();
                        this.gemUrls.put((String)object, uRL);
                        String string2 = map.keySet().iterator().next();
                        this.gemVersions.put((String)object, string2);
                    }
                }
            }
            if (!SKIP_INDEX_LIBS && (object3 = this.platform.getRubyLibSiteDir()) != null && ((File)(object2 = new File((String)object3))).exists() && ((File)object2).isDirectory()) {
                this.nonGemUrls.add(((File)object2).toURI().toURL());
            }
            this.gemUrls = Collections.unmodifiableMap(this.gemUrls);
            this.gemVersions = Collections.unmodifiableMap(this.gemVersions);
            this.nonGemUrls = Collections.unmodifiableSet(this.nonGemUrls);
            object3 = LanguageRegistry.getInstance().getLanguageByMimeType("text/x-ruby");
            object2 = ClassIndexManager.get((Language)object3);
            object = new ArrayList(this.gemUrls.size() + this.nonGemUrls.size());
            object.addAll(this.gemUrls.values());
            object.addAll(this.nonGemUrls);
            object2.setBootRoots((List)object);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    private List<String> mapToGemNames(Gem[] gemArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Gem gem : gemArray) {
            arrayList.add(gem.getName());
        }
        return arrayList;
    }

    private Runnable resetCompletionTask(final Runnable runnable) {
        return new Runnable(){

            public void run() {
                GemManager.this.resetLocal();
                runnable.run();
            }
        };
    }

    public static String getNotInstalledMessage() {
        return NbBundle.getMessage(GemManager.class, (String)"GemManager.rubyGemsNotInstalled");
    }

    static boolean isValidGemHome(File file) {
        Parameters.notNull((CharSequence)"gemHomeF", (Object)file);
        boolean bl = file.isDirectory();
        for (int i = 0; bl && i < TOP_LEVEL_REPO_DIRS.length; ++i) {
            String string = TOP_LEVEL_REPO_DIRS[i];
            File file2 = new File(file, string);
            LOGGER.finest("Checking: " + file2);
            LOGGER.finest("valid: " + (bl &= file2.isDirectory()));
        }
        return bl;
    }

    public static void adjustEnvironment(RubyPlatform rubyPlatform, Map<String, String> map) {
        if (rubyPlatform.hasRubyGemsInstalled()) {
            String string = GemManager.adjustGemPath(rubyPlatform.getGemManager().getGemHome());
            String string2 = GemManager.adjustGemPath(rubyPlatform.getInfo().getGemPath());
            map.put("GEM_HOME", string);
            map.put("GEM_PATH", string2);
        }
    }

    private static String adjustGemPath(String string) {
        return Utilities.isWindows() ? string.replace('\\', '/') : string;
    }
}

