/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GemFilesParser {
    private static final String DOT_GEM_SPEC = ".gemspec";
    private static final Pattern PATTERN = Pattern.compile("([\\w-]+)\\-([\\d.]+)");
    private static final Logger LOGGER = Logger.getLogger(GemFilesParser.class.getName());
    private final File[] specFiles;
    private Map<String, Map<String, File>> resultMap;

    public GemFilesParser(File ... fileArray) {
        Parameters.notNull((CharSequence)"files", (Object)fileArray);
        this.specFiles = fileArray;
    }

    public void chooseGems() {
        this.resultMap = new HashMap<String, Map<String, File>>();
        for (File file : this.specFiles) {
            String string = file.getName();
            if (!string.endsWith(DOT_GEM_SPEC)) continue;
            GemInfo gemInfo = GemFilesParser.parseInfo(string = string.substring(0, string.length() - DOT_GEM_SPEC.length()));
            if (gemInfo == null) {
                LOGGER.fine("Could not resolve the name and version for " + string);
                continue;
            }
            Map<String, File> map = this.resultMap.get(gemInfo.getName());
            if (map == null) {
                map = new HashMap<String, File>();
                this.resultMap.put(gemInfo.getName(), map);
                map.put(gemInfo.getVersion(), file);
                continue;
            }
            String string2 = map.keySet().iterator().next();
            if (GemManager.compareGemVersions(gemInfo.getVersion(), string2) <= 0) continue;
            map.clear();
            map.put(gemInfo.getVersion(), file);
        }
    }

    private void checkInitialiazed() {
        if (this.resultMap == null) {
            throw new IllegalStateException("Not initialized, you must run the chooseGems method first");
        }
    }

    public Map<String, Map<String, File>> getGemMap() {
        this.checkInitialiazed();
        return this.resultMap;
    }

    public File[] getFiles() {
        this.checkInitialiazed();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Map<String, File> map : this.resultMap.values()) {
            for (File file : map.values()) {
                arrayList.add(file);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    static GemInfo parseInfo(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.find() || matcher.groupCount() < 2) {
            return null;
        }
        return new GemInfo(matcher.group(1), matcher.group(2));
    }

    static final class GemInfo {
        private final String name;
        private final String version;

        public GemInfo(String string, String string2) {
            this.name = string;
            this.version = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

