/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.Util;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class PlatformComponentFactory {
    private static final String DETECTING_VALUE = NbBundle.getMessage(PlatformComponentFactory.class, (String)"PlatformComponentFactory.detetctingPlatforms");
    private static final Logger LOGGER = Logger.getLogger(PlatformComponentFactory.class.getName());
    public static final Color INVALID_PLAF_COLOR = UIManager.getColor("nb.errorForeground");

    private PlatformComponentFactory() {
    }

    public static JComboBox getRubyPlatformsComboxBox() {
        final JComboBox jComboBox = new JComboBox();
        jComboBox.setRenderer(new RubyPlatformListRenderer());
        if (Util.isFirstPlatformTouch()) {
            jComboBox.setModel(PlatformComponentFactory.createComboWaitModel());
            jComboBox.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    RubyPlatformManager.performPlatformDetection();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            jComboBox.setModel(new RubyPlatformListModel());
                            jComboBox.setEnabled(true);
                        }
                    });
                }
            });
        } else {
            jComboBox.setModel(new RubyPlatformListModel());
        }
        return jComboBox;
    }

    public static RubyPlatform getPlatform(JComboBox jComboBox) {
        Object object = jComboBox.getModel().getSelectedItem();
        return object == DETECTING_VALUE ? null : (RubyPlatform)object;
    }

    public static boolean isLoadingPlatforms(JComboBox jComboBox) {
        Object object = jComboBox.getModel().getSelectedItem();
        return object == DETECTING_VALUE;
    }

    public static JList getRubyPlatformsList() {
        JList jList = new JList(new RubyPlatformListModel());
        jList.setSelectionMode(0);
        jList.setCellRenderer(new RubyPlatformListRenderer());
        return jList;
    }

    public static ComboBoxModel createComboWaitModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{DETECTING_VALUE});
    }

    public static void addPlatformChangeListener(JComboBox jComboBox, PlatformChangeListener platformChangeListener) {
        jComboBox.addItemListener(platformChangeListener);
        jComboBox.addPropertyChangeListener(platformChangeListener);
    }

    public static void removePlatformChangeListener(JComboBox jComboBox, PlatformChangeListener platformChangeListener) {
        jComboBox.removeItemListener(platformChangeListener);
        jComboBox.removePropertyChangeListener(platformChangeListener);
    }

    private static class RubyPlatformListRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public RubyPlatformListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            this.setName("ComboBox.listRenderer");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object instanceof String) {
                string = (String)object;
            } else {
                RubyPlatform rubyPlatform = (RubyPlatform)object;
                string = rubyPlatform.getLabel();
                if (rubyPlatform != null && !rubyPlatform.isValid()) {
                    this.setForeground(INVALID_PLAF_COLOR);
                }
            }
            this.setText(string);
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    public static class RubyPlatformListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private RubyPlatform[] nbPlafs;
        private Object selectedPlaf;

        private static RubyPlatform[] getSortedPlatforms(RubyPlatform rubyPlatform) {
            Set<RubyPlatform> set = RubyPlatformManager.getPlatforms();
            if (rubyPlatform != null) {
                set.add(rubyPlatform);
            }
            RubyPlatform[] rubyPlatformArray = set.toArray(new RubyPlatform[set.size()]);
            Arrays.sort(rubyPlatformArray, new Comparator<RubyPlatform>(){

                @Override
                public int compare(RubyPlatform rubyPlatform, RubyPlatform rubyPlatform2) {
                    int n = Collator.getInstance().compare(rubyPlatform.getInfo().getLongDescription(), rubyPlatform2.getInfo().getLongDescription());
                    if (n != 0) {
                        return n;
                    }
                    return System.identityHashCode(rubyPlatform) - System.identityHashCode(rubyPlatform2);
                }
            });
            return rubyPlatformArray;
        }

        public RubyPlatformListModel() {
            this(null);
        }

        public RubyPlatformListModel(RubyPlatform rubyPlatform) {
            this.nbPlafs = RubyPlatformListModel.getSortedPlatforms(rubyPlatform);
            if (rubyPlatform == null) {
                if (this.nbPlafs.length > 0) {
                    this.selectedPlaf = this.nbPlafs[0];
                }
            } else {
                this.selectedPlaf = rubyPlatform;
            }
        }

        public int getSize() {
            return this.nbPlafs.length;
        }

        public Object getElementAt(int n) {
            return n < this.nbPlafs.length ? this.nbPlafs[n] : null;
        }

        public void setSelectedItem(Object object) {
            assert (object == null || object instanceof RubyPlatform);
            if (this.selectedPlaf != object) {
                this.selectedPlaf = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedPlaf;
        }

        void removePlatform(RubyPlatform rubyPlatform) {
            try {
                RubyPlatformManager.removePlatform(rubyPlatform);
                this.nbPlafs = RubyPlatformListModel.getSortedPlatforms(null);
                this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            }
        }

        RubyPlatform addPlatform(File file) {
            try {
                RubyPlatform rubyPlatform = RubyPlatformManager.addPlatform(file);
                if (rubyPlatform != null) {
                    this.nbPlafs = RubyPlatformListModel.getSortedPlatforms(null);
                    this.fireContentsChanged(this, 0, this.nbPlafs.length - 1);
                }
                return rubyPlatform;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
                return null;
            }
        }
    }

    public static abstract class PlatformChangeListener
    implements ItemListener,
    PropertyChangeListener {
        public abstract void platformChanged();

        public void itemStateChanged(ItemEvent itemEvent) {
            this.platformChanged();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                this.platformChanged();
            }
        }
    }
}

