/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.drawingarea.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.drawingarea.navigator.ElementNameComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTreeModel
implements TreeModel {
    private Object root = new Object();
    private TreeMap<String, ArrayList<IElement>> categories = new TreeMap();
    private ArrayList<String> categoryNames = new ArrayList();

    public CategoryTreeModel(ETList<IElement> eTList) {
        this.buildCategories(eTList);
    }

    @Override
    public boolean isLeaf(Object object) {
        boolean bl = true;
        bl = this.getChildCount(object) <= 0;
        return bl;
    }

    @Override
    public int getChildCount(Object object) {
        int n = 0;
        if (object == this.root) {
            n = this.categories.size();
        } else if (object instanceof String) {
            String string = (String)object;
            if (this.categories.containsKey(string)) {
                n = this.categories.get(string).size();
            }
        } else if (object instanceof IElement) {
            n = 0;
        }
        return n;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public Object getChild(Object object, int n) {
        Object object2 = null;
        if (object == this.root) {
            object2 = this.categoryNames.get(n);
        } else if (object instanceof String) {
            String string = (String)object;
            if (this.categories.containsKey(string)) {
                object2 = this.categories.get(string).get(n);
            }
        } else if (object instanceof IElement) {
            object2 = 0;
        }
        return object2;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n = 0;
        if (object == this.root) {
            n = this.categoryNames.indexOf(object2);
        } else if (object instanceof String) {
            String string = (String)object;
            if (this.categories.containsKey(string)) {
                n = this.categories.get(string).indexOf(object2);
            }
        } else if (object instanceof IElement) {
            n = 0;
        }
        return n;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    private void buildCategories(ETList<IElement> eTList) {
        Object object2;
        for (Object object2 : eTList) {
            String string = object2.getElementType();
            ArrayList arrayList = this.getCategory(string);
            arrayList.add(object2);
        }
        Set<String> set = this.categories.keySet();
        this.categoryNames.addAll((Collection<String>)set);
        object2 = new ElementNameComparator();
        for (ArrayList arrayList : this.categories.values()) {
            Collections.sort(arrayList, object2);
        }
    }

    private ArrayList getCategory(String string) {
        ArrayList<Object> arrayList = this.categories.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.categories.put(string, arrayList);
        }
        return arrayList;
    }
}

