/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.drawingarea;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.drawingarea.DiagramTopComponent;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogDiagramDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewUMLFileTemplates;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogDiagramDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewUMLDiagWizardIterator;
import org.netbeans.modules.uml.ui.support.applicationmanager.IDiagramCallback;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.diagramsupport.ProxyDiagramManager;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLDiagramManager
implements IProductDiagramManager,
INewUMLFileTemplates {
    private HashMap<String, DiagramTopComponent> m_OpenDiagrams = new HashMap();
    private IDiagram m_CurrentDiagram = null;

    public IDiagram openDiagram(String string, boolean bl, IDiagramCallback iDiagramCallback) {
        IDiagram iDiagram;
        this.showDiagram(string, bl);
        this.m_CurrentDiagram = iDiagram = this.retrieveDiagram(string);
        if (iDiagramCallback != null) {
            iDiagramCallback.returnedDiagram(iDiagram);
        }
        this.raiseWindow(iDiagram);
        this.garbageCollect();
        return iDiagram;
    }

    public IDiagram openDiagram2(IProxyDiagram iProxyDiagram, boolean bl, IDiagramCallback iDiagramCallback) {
        return this.openDiagram(iProxyDiagram.getFilename(), bl, null);
    }

    public long closeDiagram(String string) {
        IDiagram iDiagram = this.retrieveDiagram(string);
        if (iDiagram != null) {
            iDiagram.preClose();
        }
        this.hideDiagram(iDiagram);
        return 0L;
    }

    public long closeDiagram2(IDiagram iDiagram) {
        this.closeDiagram(iDiagram.getFilename());
        return 0L;
    }

    public long closeDiagram3(IProxyDiagram iProxyDiagram) {
        this.closeDiagram(iProxyDiagram.getFilename());
        return 0L;
    }

    public IDiagram newDiagramDialog(INamespace iNamespace, int n, int n2, IDiagramCallback iDiagramCallback) {
        if (iNamespace == null) {
            return null;
        }
        IDiagram iDiagram = this.doNewDiagramDialog(iNamespace, n, n2);
        if (iDiagram != null && iDiagramCallback != null) {
            iDiagramCallback.returnedDiagram(iDiagram);
        }
        return iDiagram;
    }

    public long raiseWindow(IDiagram iDiagram) {
        DiagramTopComponent diagramTopComponent = this.findTopComponent(iDiagram);
        if (diagramTopComponent != null) {
            Runnable runnable = new Runnable((TopComponent)diagramTopComponent){
                final /* synthetic */ TopComponent val$tc;
                {
                    this.val$tc = topComponent;
                }

                public void run() {
                    this.val$tc.requestActive();
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.showDiagram(iDiagram.getFilename(), true);
        }
        return 0L;
    }

    public IDiagram getCurrentDiagram() {
        return this.m_CurrentDiagram;
    }

    public IDiagram getOpenDiagram(String string) {
        return this.retrieveDiagram(string);
    }

    public IDiagram createDiagram(int n, INamespace iNamespace, String string, IDiagramCallback iDiagramCallback) {
        IDiagram iDiagram = this.doCreateDiagram(n, iNamespace, string);
        if (iDiagram != null && iDiagramCallback != null) {
            iDiagramCallback.returnedDiagram(iDiagram);
        }
        this.m_CurrentDiagram = iDiagram;
        this.garbageCollect();
        return iDiagram;
    }

    public ETList<IProxyDiagram> getOpenDiagrams() {
        ETArrayList eTArrayList = new ETArrayList();
        Collection<DiagramTopComponent> collection = this.m_OpenDiagrams.values();
        for (DiagramTopComponent diagramTopComponent : collection) {
            IDrawingAreaControl iDrawingAreaControl = diagramTopComponent.getDrawingAreaControl();
            IDiagram iDiagram = iDrawingAreaControl.getDiagram();
            ProxyDiagramManager proxyDiagramManager = ProxyDiagramManager.instance();
            IProxyDiagram iProxyDiagram = proxyDiagramManager.getDiagram(iDiagram);
            if (iProxyDiagram == null) continue;
            eTArrayList.add((Object)iProxyDiagram);
        }
        return eTArrayList;
    }

    public long minimizeDiagram(String string, boolean bl) {
        return 0L;
    }

    public long minimizeDiagram2(IDiagram iDiagram, boolean bl) {
        return 0L;
    }

    public long minimizeDiagram3(IProxyDiagram iProxyDiagram, boolean bl) {
        return 0L;
    }

    protected IDiagram retrieveDiagram(String string) {
        IDiagram iDiagram = null;
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct instanceof IProduct) {
            iDiagram = ((IProduct)iCoreProduct).getDiagram(string);
        }
        return iDiagram;
    }

    protected void hideDiagram(String string) {
        DiagramTopComponent diagramTopComponent;
        if (string != null && (diagramTopComponent = this.findTopComponent(string)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = diagramTopComponent.preferredID();
                    diagramTopComponent.close();
                    UMLDiagramManager.this.m_OpenDiagrams.remove(string);
                }
            });
        }
    }

    protected void hideDiagram(IDiagram iDiagram) {
        DiagramTopComponent diagramTopComponent;
        if (iDiagram != null && (diagramTopComponent = this.findTopComponent(iDiagram)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = diagramTopComponent.preferredID();
                    diagramTopComponent.close();
                    UMLDiagramManager.this.m_OpenDiagrams.remove(string);
                }
            });
        }
    }

    protected void hideDiagram(DiagramTopComponent diagramTopComponent) {
        if (diagramTopComponent != null) {
            final DiagramTopComponent diagramTopComponent2 = diagramTopComponent;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    diagramTopComponent2.close();
                    String string = diagramTopComponent2.preferredID();
                    UMLDiagramManager.this.m_OpenDiagrams.remove(string);
                }
            });
        }
    }

    protected void showDiagram(String string, boolean bl) {
        if (string != null) {
            DiagramTopComponent diagramTopComponent = this.findTopComponent(string);
            if (diagramTopComponent != null) {
                diagramTopComponent.open();
                diagramTopComponent.requestActive();
            } else {
                DiagramTopComponent diagramTopComponent2 = new DiagramTopComponent(string, bl);
                this.showDiagram(diagramTopComponent2);
            }
        }
    }

    protected void showDiagram(DiagramTopComponent diagramTopComponent) {
        if (diagramTopComponent != null) {
            diagramTopComponent.addPropertyChangeListener(new DiagramPropertyListener());
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new DiagramPropertyListener());
            ShowTopComponentGroup showTopComponentGroup = new ShowTopComponentGroup("modeling-diagrams", diagramTopComponent);
            if (SwingUtilities.isEventDispatchThread()) {
                showTopComponentGroup.show();
            } else {
                try {
                    SwingUtilities.invokeAndWait(showTopComponentGroup);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            String string = diagramTopComponent.preferredID();
            this.m_OpenDiagrams.put(string, diagramTopComponent);
        }
    }

    public void refresh(IProxyDiagram iProxyDiagram) {
    }

    protected void garbageCollect() {
    }

    public IDiagram doNewDiagramDialog(INamespace iNamespace, int n, int n2) {
        Object object;
        boolean bl;
        IDiagram iDiagram = null;
        NewDialogDiagramDetails newDialogDiagramDetails = new NewDialogDiagramDetails();
        newDialogDiagramDetails.setNamespace(iNamespace);
        newDialogDiagramDetails.setDiagramKind(n);
        newDialogDiagramDetails.setAvailableDiagramKinds(n2);
        NewUMLDiagWizardIterator newUMLDiagWizardIterator = new NewUMLDiagWizardIterator();
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)newUMLDiagWizardIterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(UMLDiagramManager.class, (String)"IDS_NEW_DIAGRAM_WIZARD_TITLE"));
        wizardDescriptor.putProperty("DIAGRAM_DETAILS", (Object)newDialogDiagramDetails);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UMLDiagramManager.class, (String)"IDS_NEW_DIAGRAM_WIZARD_TITLE_DESCRIPTION"));
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl && (object = wizardDescriptor.getProperty("DIAGRAM_DETAILS")) != null && object instanceof INewDialogDiagramDetails) {
            INewDialogDiagramDetails iNewDialogDiagramDetails = (INewDialogDiagramDetails)object;
            try {
                String string = iNewDialogDiagramDetails.getName();
                INamespace iNamespace2 = iNewDialogDiagramDetails.getNamespace();
                int n3 = iNewDialogDiagramDetails.getDiagramKind();
                boolean bl3 = false;
                if (!bl3) {
                    iDiagram = this.createDiagram(n3, iNamespace2, string, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iDiagram;
    }

    public IDiagram doCreateDiagram(int n, INamespace iNamespace, String string) {
        DiagramTopComponent diagramTopComponent = new DiagramTopComponent(iNamespace, string, n);
        this.showDiagram(diagramTopComponent);
        return diagramTopComponent.getAssociatedDiagram();
    }

    protected DiagramTopComponent findTopComponent(String string) {
        IDiagram iDiagram = this.retrieveDiagram(string);
        return this.findTopComponent(iDiagram);
    }

    protected DiagramTopComponent findTopComponent(IDiagram iDiagram) {
        DiagramTopComponent diagramTopComponent = null;
        if (iDiagram != null) {
            String string = DiagramTopComponent.preferredIDForDiagram(iDiagram);
            diagramTopComponent = this.m_OpenDiagrams.get(string);
        }
        return diagramTopComponent;
    }

    public void closeAllDiagrams() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Collection collection = UMLDiagramManager.this.m_OpenDiagrams.values();
                for (DiagramTopComponent diagramTopComponent : collection) {
                    diagramTopComponent.close();
                }
            }
        });
    }

    public class ShowTopComponentGroup
    implements Runnable {
        private String mGroupName = "";
        private DiagramTopComponent mTopComponent = null;

        public ShowTopComponentGroup(String string, DiagramTopComponent diagramTopComponent) {
            this.mGroupName = string;
            this.mTopComponent = diagramTopComponent;
        }

        public void run() {
            this.show();
        }

        public void show() {
            this.mTopComponent.open();
            this.mTopComponent.requestActive();
        }
    }

    public class DiagramPropertyListener
    implements PropertyChangeListener {
        Boolean groupVisible = null;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Debug.out.println("Property Change: " + propertyChangeEvent.getPropertyName());
            if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                Debug.out.println("Inside of the property change listener");
                WindowManager windowManager = WindowManager.getDefault();
                TopComponentGroup topComponentGroup = windowManager.findTopComponentGroup("uml-diagram");
                Debug.out.println("Found a group: " + topComponentGroup);
                if (topComponentGroup != null) {
                    boolean bl = false;
                    for (Mode mode : windowManager.getModes()) {
                        TopComponent topComponent = mode.getSelectedTopComponent();
                        if (!(topComponent instanceof DiagramTopComponent)) continue;
                        bl = true;
                        break;
                    }
                    Debug.out.println("diagramSelected = " + bl);
                    if (bl && !Boolean.TRUE.equals(this.groupVisible)) {
                        Debug.out.println("About to open the group");
                        topComponentGroup.open();
                    } else if (!bl && !Boolean.FALSE.equals(this.groupVisible)) {
                        Debug.out.println("About to close the group");
                        topComponentGroup.close();
                    }
                    this.groupVisible = bl ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
    }
}

