/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.websvc.wsitconf.api.DevDefaultsProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSampleProjectGenerator {
    public static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/web-project/3";
    public static final String JSPC_CLASSPATH = "jspc.classpath";

    private WebSampleProjectGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FileObject> createProjectFromTemplate(FileObject fileObject, File file, String string) throws IOException {
        assert (fileObject != null && file != null && string != null);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (fileObject.getExt().endsWith("zip")) {
            FileObject fileObject2 = WebSampleProjectGenerator.createProjectFolder(file);
            InputStream inputStream = fileObject.getInputStream();
            try {
                WebSampleProjectGenerator.unzip(inputStream, fileObject2);
                arrayList.add(fileObject2);
                File file2 = FileUtil.toFile((FileObject)fileObject2.getFileObject("nbproject/project.xml"));
                Document document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, null, null);
                NodeList nodeList = document.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1) continue;
                        Element element = (Element)node;
                        WebSampleProjectGenerator.replaceText(element, string);
                    }
                    WebSampleProjectGenerator.saveXml(document, fileObject2, "nbproject/project.xml");
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            fileObject2.refresh(false);
        } else {
            String string2 = (String)fileObject.getAttribute("files");
            if (string2 != null && string2.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3 == null || string3.trim().equals("")) continue;
                    InputStream inputStream = WebSampleProjectGenerator.class.getResourceAsStream(string3);
                    try {
                        FileObject fileObject3 = WebSampleProjectGenerator.createProjectFolder(new File(file, string3.substring(string3.lastIndexOf("/") + 1, string3.indexOf(46))));
                        WebSampleProjectGenerator.unzip(inputStream, fileObject3);
                        arrayList.add(fileObject3);
                        Boolean bl = (Boolean)fileObject.getAttribute("needsdefaults");
                        if (!bl.booleanValue()) continue;
                        DevDefaultsProvider.getDefault().fillDefaultsToDefaultServer();
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    private static FileObject createProjectFolder(File file) throws IOException {
        FileObject fileObject;
        Stack<String> stack = new Stack<String>();
        while ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            stack.push(file.getName());
            file = file.getParentFile();
        }
        while (!stack.empty()) {
            fileObject = fileObject.createFolder((String)stack.pop());
            assert (fileObject != null);
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream inputStream, FileObject fileObject) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    private static void replaceText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            text.setNodeValue(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

