/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Node;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableVisitor
implements ParseTreeVisitor {
    private AstPath path = new AstPath();
    private ScopeChain scopes = new ScopeChain();
    private boolean inWith;

    private Node getParent() {
        return this.path.leafParent();
    }

    @Override
    public boolean visit(Node node) {
        this.path.descend(node);
        switch (node.getType()) {
            case 105: 
            case 132: {
                this.scopes.push(node);
                break;
            }
            case 155: {
                Scope scope = this.scopes.getCurrent();
                scope.locals.add(node.getString());
                break;
            }
            case 48: {
                if (this.inWith) break;
                Scope scope = this.scopes.getCurrent();
                String string = node.getString();
                scope.writtenVars.add(string);
                break;
            }
            case 119: {
                this.inWith = true;
                break;
            }
            case 38: {
                Node node2 = this.getParent();
                int n = -1;
                if (node2 != null && (n = node2.getType()) == 37 && node2.getFirstChild() != node) {
                    n = -1;
                }
                if (n == 118) {
                    Scope scope = this.scopes.getCurrent();
                    if (scope.node.getType() == 132) {
                        scope.writtenVars.add(node.getString());
                        break;
                    }
                    scope.locals.add(node.getString());
                    break;
                }
                if (n == 56) {
                    Scope scope = this.scopes.getCurrent();
                    scope.locals.add(node.getString());
                    break;
                }
                if (n == 37) {
                    Scope scope = this.scopes.getCurrent();
                    scope.readCalls.add(node.getString());
                    break;
                }
                if (this.inWith) break;
                Scope scope = this.scopes.getCurrent();
                String string = node.getString();
                if (string.equals("undefined")) break;
                scope.readVars.add(string);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean unvisit(Node node) {
        switch (node.getType()) {
            case 105: 
            case 132: {
                this.scopes.pop();
                break;
            }
            case 119: {
                this.inWith = false;
            }
        }
        this.path.ascend();
        return false;
    }

    Collection<Node> getUnusedVars() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Scope scope : this.scopes.roots) {
            this.addUnused(scope, arrayList);
        }
        return arrayList;
    }

    public Map<String, List<Node>> getLocalVars(Node node) {
        Scope scope = this.scopes.findScope(node);
        HashMap<String, List<Node>> hashMap = new HashMap<String, List<Node>>();
        Scope scope2 = scope;
        while (scope2 != null) {
            for (String string : scope2.locals) {
                List list = scope2.findVarNodes(string);
                assert (list != null);
                List list2 = (List)hashMap.get(string);
                if (list2 != null) {
                    list2.addAll(list);
                    continue;
                }
                hashMap.put(string, list);
            }
            scope2 = scope2.parent;
        }
        return hashMap;
    }

    private void addUnused(Scope scope, List<Node> list) {
        HashSet<String> hashSet = new HashSet<String>(scope.locals);
        this.removeRead(scope, hashSet);
        if (hashSet.size() > 0) {
            List list2 = scope.findVarNodes(hashSet);
            list.addAll(list2);
        }
        for (Scope scope2 : scope) {
            this.addUnused(scope2, list);
        }
    }

    private void removeRead(Scope scope, Set<String> set) {
        set.removeAll(scope.readVars);
        set.removeAll(scope.readCalls);
        for (Scope scope2 : scope) {
            this.removeRead(scope2, set);
        }
    }

    private void removeLocals(Scope scope, Set<String> set) {
        set.removeAll(scope.locals);
        for (Scope scope2 : scope) {
            this.removeLocals(scope2, set);
        }
    }

    public List<Node> getGlobalVars(boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Scope scope : this.scopes.roots) {
            this.addGlobals(scope, arrayList, bl);
        }
        return arrayList;
    }

    private void addGlobals(Scope scope, List<Node> list, boolean bl) {
        HashSet<String> hashSet;
        if (bl) {
            hashSet = new HashSet<String>(scope.writtenVars);
        } else {
            hashSet = new HashSet(scope.readVars);
            hashSet.addAll(scope.writtenVars);
        }
        this.removeLocals(scope, hashSet);
        Object object = scope.parent;
        while (object != null) {
            hashSet.removeAll(((Scope)object).locals);
            object = ((Scope)object).parent;
        }
        if (hashSet.size() > 0) {
            object = scope.findVarNodes(hashSet);
            list.addAll((Collection<Node>)object);
        }
        for (Scope scope2 : scope) {
            this.addGlobals(scope2, list, bl);
        }
    }

    public Node getDefiningScope(Node node) {
        Scope scope;
        int n = node.getType();
        if ((n == 38 || n == 48 || n == 155) && (scope = this.scopes.findScope(node)) != null) {
            return scope.node;
        }
        return null;
    }

    private static class ScopeChain {
        private List<Scope> scopes = new ArrayList<Scope>();
        private List<Scope> roots = new ArrayList<Scope>();
        private Scope current;

        private ScopeChain() {
        }

        Scope getCurrent() {
            return this.current;
        }

        Scope push(Node node) {
            Scope scope = new Scope(node);
            if (this.roots.isEmpty()) {
                this.roots.add(scope);
            } else {
                this.current.addScope(scope);
            }
            this.scopes.add(scope);
            this.current = scope;
            return scope;
        }

        Scope pop() {
            this.current = this.current.parent;
            return this.current;
        }

        private Scope findScope(Node node) {
            while (node != null) {
                int n = node.getType();
                if (n == 105 || n == 132) {
                    for (Scope scope : this.roots) {
                        Scope scope2 = this.findScope(scope, node);
                        if (scope2 == null) continue;
                        return scope2;
                    }
                }
                node = node.getParentNode();
            }
            return null;
        }

        private Scope findScope(Scope scope, Node node) {
            if (scope.node == node) {
                return scope;
            }
            if (scope.nested != null) {
                for (Scope scope2 : scope.nested) {
                    Scope scope3 = this.findScope(scope2, node);
                    if (scope3 == null) continue;
                    return scope3;
                }
            }
            return null;
        }

        public String toString() {
            return "ScopeChain:" + this.roots;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Scope
    implements Iterable<Scope> {
        private final Node node;
        private List<Scope> nested;
        private Scope parent;
        private Set<String> locals = new HashSet<String>();
        private Set<String> readVars = new HashSet<String>();
        private Set<String> readCalls = new HashSet<String>();
        private Set<String> writtenVars = new HashSet<String>();

        Scope(Node node) {
            this.node = node;
        }

        void addScope(Scope scope) {
            if (this.nested == null) {
                this.nested = new ArrayList<Scope>();
            }
            this.nested.add(scope);
            scope.parent = this;
        }

        @Override
        public Iterator<Scope> iterator() {
            if (this.nested != null) {
                return this.nested.iterator();
            }
            return Collections.emptySet().iterator();
        }

        private List<Node> findVarNodes(String string) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.addNodes(this.node, string, arrayList);
            return arrayList;
        }

        private void addNodes(Node node, String string, List<Node> list) {
            String string2;
            switch (node.getType()) {
                case 38: 
                case 48: 
                case 155: {
                    string2 = node.getString();
                    if (!string2.equals(string)) break;
                    list.add(node);
                    break;
                }
            }
            if (node.hasChildren()) {
                for (string2 = node.getFirstChild(); string2 != null; string2 = string2.getNext()) {
                    int n = string2.getType();
                    if (n == 105 || n == 132) continue;
                    this.addNodes((Node)string2, string, list);
                }
            }
        }

        private List<Node> findVarNodes(Set<String> set) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            this.addNodes(this.node, set, arrayList);
            return arrayList;
        }

        private void addNodes(Node node, Set<String> set, List<Node> list) {
            String string;
            switch (node.getType()) {
                case 38: 
                case 48: 
                case 155: {
                    string = node.getString();
                    if (!set.contains(string)) break;
                    list.add(node);
                    break;
                }
            }
            if (node.hasChildren()) {
                for (string = node.getFirstChild(); string != null; string = string.getNext()) {
                    int n = string.getType();
                    if (n == 105 || n == 132) continue;
                    this.addNodes((Node)string, set, list);
                }
            }
        }

        public String toString() {
            return "Scope(node=" + this.node + ",locals=" + this.locals + ",read=" + this.readVars + ",calls=" + this.readCalls + ", written=" + this.writtenVars + ")";
        }
    }
}

