/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Node;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsSemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> semanticHighlights;

    public Map<OffsetRange, ColoringAttributes> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        Object object2;
        Object object3;
        Node node32;
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        if (jsParseResult == null) {
            return;
        }
        Node node2 = jsParseResult.getRootNode();
        if (node2 == null) {
            return;
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        Object object4 = new HashMap<OffsetRange, ColoringAttributes>(100);
        Collection<Node> collection = variableVisitor.getUnusedVars();
        for (Node node32 : collection) {
            OffsetRange offsetRange = AstUtilities.getNameRange(node32);
            object4.put(offsetRange, ColoringAttributes.UNUSED);
        }
        List<Node> list = variableVisitor.getGlobalVars(false);
        node32 = jsParseResult.getSanitizedRange();
        boolean bl = node32 != OffsetRange.NONE && node32.getLength() == 1;
        Object object5 = list.iterator();
        while (object5.hasNext()) {
            object3 = (Node)object5.next();
            object2 = object3.getString();
            OffsetRange object6 = AstUtilities.getNameRange((Node)object3);
            if (bl && object6.getEnd() == node32.getStart()) continue;
            if (Character.isUpperCase(((String)object2).charAt(0))) {
                object4.put(object6, ColoringAttributes.CLASS);
                continue;
            }
            object4.put(object6, ColoringAttributes.GLOBAL);
        }
        object5 = new ArrayList();
        AstUtilities.addNodesByType(node2, new int[]{47, 156, 157}, (List<Node>)object5);
        object3 = object5.iterator();
        while (object3.hasNext()) {
            object2 = (Node)object3.next();
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)object2);
            int n = object2.getType();
            if (n == 47) {
                object4.put((OffsetRange)offsetRange, (ColoringAttributes)ColoringAttributes.REGEXP);
                continue;
            }
            if (n == 157) {
                if (!AstUtilities.isLabelledFunction((Node)object2)) continue;
                object4.put((OffsetRange)offsetRange, (ColoringAttributes)ColoringAttributes.METHOD);
                continue;
            }
            assert (n == 156);
            object4.put((OffsetRange)offsetRange, (ColoringAttributes)ColoringAttributes.METHOD);
        }
        if (this.isCancelled()) {
            return;
        }
        if (object4.size() > 0) {
            if (jsParseResult.getTranslatedSource() != null) {
                object3 = new HashMap(2 * object4.size());
                for (Map.Entry entry : object4.entrySet()) {
                    OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)entry.getKey());
                    if (offsetRange == OffsetRange.NONE) continue;
                    object3.put(offsetRange, entry.getValue());
                }
                object4 = object3;
            }
            this.semanticHighlights = object4;
        } else {
            this.semanticHighlights = null;
        }
    }
}

