/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.documentation.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.netbeans.modules.uml.documentation.ui.DocumentationEditorKit;
import org.netbeans.modules.uml.resources.images.ImageUtil;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class DocumentationPane
extends JPanel
implements KeyListener,
FocusListener,
DocumentListener {
    private DocUndoableEditListener undoableEditListner = new DocUndoableEditListener();
    private boolean displaySave = true;
    private JTextPane m_TextPane = null;
    private HTMLEditorKit htmlKit = null;
    private HTMLDocument htmlDoc = null;
    private JToolBar toolbar;
    private StyledEditorKit.BoldAction boldAction;
    private StyledEditorKit.ItalicAction italicAction;
    private StyledEditorKit.UnderlineAction underlineAction;
    private ColorAction colorAction;
    private StyledEditorKit.AlignmentAction leftAction;
    private StyledEditorKit.AlignmentAction centerAction;
    private StyledEditorKit.AlignmentAction rightAction;
    private UndoManager undoMgr;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private SaveAction saveAction;
    public static final String PROP_DIRTY = "dirty_state";

    public DocumentationPane() {
        this(true);
    }

    public DocumentationPane(boolean bl) {
        this.displaySave = bl;
        this.init();
    }

    private void init() {
        this.m_TextPane = new JTextPane();
        this.htmlKit = new DocumentationEditorKit();
        this.htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
        Cursor cursor = Cursor.getPredefinedCursor(2);
        this.htmlKit.setDefaultCursor(cursor);
        this.m_TextPane.setCursor(cursor);
        this.m_TextPane.setEditorKit(this.htmlKit);
        this.m_TextPane.setDocument(this.htmlDoc);
        this.m_TextPane.setMargin(new Insets(5, 5, 5, 5));
        this.m_TextPane.addKeyListener(this);
        this.m_TextPane.addFocusListener(this);
        this.m_TextPane.getStyledDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_TextPane);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.createToolBar(), "North");
        this.m_TextPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentationPane.class, (String)"ACDS_EDITOR"));
        this.m_TextPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_EDITOR"));
        this.undoMgr = new UndoManager();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.m_TextPane.getStyledDocument().addDocumentListener(this);
        this.m_TextPane.getDocument().addUndoableEditListener(this.undoableEditListner);
        this.m_TextPane.setCaretPosition(0);
        this.registerAccelerator();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentationPane.class, (String)"ACDS_DOCUMENTATION"));
        this.setEnabled(false);
    }

    protected JTextPane getTextPane() {
        return this.m_TextPane;
    }

    public HTMLEditorKit getEditorKit() {
        return this.htmlKit;
    }

    public void purgeUndos() {
        if (this.undoMgr != null) {
            this.undoMgr.discardAllEdits();
            this.undoAction.updateState();
            this.redoAction.updateState();
        }
    }

    private JToolBar createToolBar() {
        JButton jButton;
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.toolbar.setAlignmentX(0.0f);
        this.boldAction = new StyledEditorKit.BoldAction();
        this.italicAction = new StyledEditorKit.ItalicAction();
        this.underlineAction = new StyledEditorKit.UnderlineAction();
        this.leftAction = new StyledEditorKit.AlignmentAction(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_ALIGNLEFT"), 0);
        this.centerAction = new StyledEditorKit.AlignmentAction(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_CENTER"), 1);
        this.rightAction = new StyledEditorKit.AlignmentAction(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_ALIGNRIGHT"), 2);
        this.colorAction = new ColorAction();
        this.saveAction = new SaveAction();
        if (this.displaySave) {
            jButton = new JButton(this.saveAction);
            jButton.setRequestFocusEnabled(false);
            jButton.setIcon(ImageUtil.instance().getIcon("save.png"));
            jButton.setText(null);
            jButton.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_SAVE"));
            jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_SAVE"));
            this.toolbar.add(jButton);
            this.toolbar.addSeparator();
        }
        jButton = new JButton(this.boldAction);
        jButton.setRequestFocusEnabled(false);
        jButton.setIcon(ImageUtil.instance().getIcon("bold.png"));
        jButton.setText(null);
        jButton.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_BOLD"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_BOLD"));
        this.toolbar.add(jButton);
        JButton jButton2 = new JButton(this.italicAction);
        jButton2.setRequestFocusEnabled(false);
        jButton2.setIcon(ImageUtil.instance().getIcon("italics.png"));
        jButton2.setText(null);
        jButton2.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_ITALIC"));
        jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_ITALIC"));
        this.toolbar.add(jButton2);
        JButton jButton3 = new JButton(this.underlineAction);
        jButton3.setRequestFocusEnabled(false);
        jButton3.setIcon(ImageUtil.instance().getIcon("underline.png"));
        jButton3.setText(null);
        jButton3.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_UNDER"));
        jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_UNDER"));
        this.toolbar.add(jButton3);
        JButton jButton4 = this.toolbar.add(this.colorAction);
        jButton4.setRequestFocusEnabled(false);
        jButton4.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_FONTCOLOR"));
        jButton4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_FONTCOLOR"));
        this.toolbar.addSeparator();
        JButton jButton5 = new JButton(this.leftAction);
        jButton5.setRequestFocusEnabled(false);
        jButton5.setIcon(ImageUtil.instance().getIcon("align-left-text.png"));
        jButton5.setText(null);
        jButton5.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_ALIGNLEFT"));
        jButton5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_ALIGNLEFT"));
        this.toolbar.add(jButton5);
        JButton jButton6 = new JButton(this.centerAction);
        jButton6.setRequestFocusEnabled(false);
        jButton6.setIcon(ImageUtil.instance().getIcon("align-center-text.png"));
        jButton6.setText(null);
        jButton6.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_CENTER"));
        jButton6.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_CENTER"));
        this.toolbar.add(jButton6);
        JButton jButton7 = new JButton(this.rightAction);
        jButton7.setRequestFocusEnabled(false);
        jButton7.setIcon(ImageUtil.instance().getIcon("align-right-text.png"));
        jButton7.setText(null);
        jButton7.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_ALIGNRIGHT"));
        jButton7.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DocumentationPane.class, (String)"ACNS_ALIGNRIGHT"));
        this.toolbar.add(jButton7);
        return this.toolbar;
    }

    private void registerAccelerator() {
        this.registerKeyboardAction(this.boldAction, KeyStroke.getKeyStroke(66, 2, false), 1);
        this.registerKeyboardAction(this.italicAction, KeyStroke.getKeyStroke(73, 2, false), 1);
        this.registerKeyboardAction(this.underlineAction, KeyStroke.getKeyStroke(85, 2, false), 1);
        this.registerKeyboardAction(this.colorAction, KeyStroke.getKeyStroke(65, 10, false), 1);
        this.registerKeyboardAction(this.leftAction, KeyStroke.getKeyStroke(76, 3, false), 1);
        this.registerKeyboardAction(this.centerAction, KeyStroke.getKeyStroke(67, 3, false), 1);
        this.registerKeyboardAction(this.rightAction, KeyStroke.getKeyStroke(82, 3, false), 1);
        this.registerKeyboardAction(this.undoAction, KeyStroke.getKeyStroke(90, 2, false), 1);
        this.registerKeyboardAction(this.redoAction, KeyStroke.getKeyStroke(89, 2, false), 1);
        this.registerKeyboardAction(this.saveAction, KeyStroke.getKeyStroke(83, 2, false), 1);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            AttributeSet attributeSet = this.getTextPane().getParagraphAttributes();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                if (!object.equals("pre") && object != HTML.Tag.PRE) continue;
                return;
            }
            try {
                this.insertBreak();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.m_TextPane.selectAll();
        int n = this.m_TextPane.getSelectionEnd();
        String string = this.m_TextPane.getSelectedText();
        if (string != null && string.trim().length() > 0) {
            this.m_TextPane.setCaretPosition(n);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentChange(documentEvent);
    }

    public void handleDocumentChange(DocumentEvent documentEvent) {
    }

    public boolean isDirty() {
        return this.undoMgr.canUndo();
    }

    public String getDocumentText() {
        return this.getTextPane().getText();
    }

    public synchronized void setDocumentText(String string) {
        this.getTextPane().getDocument().removeDocumentListener(this);
        this.getTextPane().getDocument().removeUndoableEditListener(this.undoableEditListner);
        this.getTextPane().removeAll();
        this.getTextPane().setText(string);
        this.getTextPane().getDocument().addDocumentListener(this);
        this.getTextPane().getDocument().addUndoableEditListener(this.undoableEditListner);
        this.getTextPane().setCaretPosition(0);
        Cursor cursor = Cursor.getPredefinedCursor(2);
        this.getEditorKit().setDefaultCursor(cursor);
        this.purgeUndos();
        this.setEnabled(true);
    }

    public void setEnabled(boolean bl) {
        if (!bl && this.getTextPane().isEditable()) {
            this.getTextPane().getDocument().removeDocumentListener(this);
            this.getTextPane().getDocument().removeUndoableEditListener(this.undoableEditListner);
        }
        this.getTextPane().setEditable(bl);
        this.saveAction.setEnabled(bl && this.undoMgr.canUndo());
        this.boldAction.setEnabled(bl);
        this.italicAction.setEnabled(bl);
        this.underlineAction.setEnabled(bl);
        this.colorAction.setEnabled(bl);
        this.leftAction.setEnabled(bl);
        this.centerAction.setEnabled(bl);
        this.rightAction.setEnabled(bl);
        super.setEnabled(bl);
    }

    private void insertBreak() throws IOException, BadLocationException, RuntimeException {
        int n = this.getTextPane().getCaretPosition();
        this.htmlKit.insertHTML(this.htmlDoc, n, "<BR>", 0, 0, HTML.Tag.BR);
        this.getTextPane().setCaretPosition(n + 1);
    }

    private String getSubText(String string) {
        String string2 = this.getTextPane().getText().toLowerCase();
        int n = string2.indexOf("<" + string.toLowerCase());
        int n2 = string2.indexOf(">", n) + 1;
        String string3 = "</" + string.toLowerCase() + ">";
        int n3 = string2.indexOf(string3);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0 || n3 > string2.length()) {
            n3 = string2.length();
        }
        return this.getTextPane().getText().substring(n2, n3);
    }

    public String getDocumentBody() {
        return this.getSubText("body");
    }

    public String getTrimmedDocumentation() {
        String string = this.getDocumentBody().trim();
        return this.removeHTMLComments(string);
    }

    private String removeHTMLComments(String string) {
        String string2 = string;
        int n = string2.indexOf("<!--");
        int n2 = string2.indexOf("-->", n);
        while (n >= 0 && n2 > n + 4) {
            string2 = string2.substring(0, n) + string2.substring(n2 + 3);
            n = string2.indexOf("<!--");
            n2 = string2.indexOf("-->", n);
        }
        return string2;
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = DocumentationPane.this.getTextPane().getCaretPosition();
            DocumentationPane.this.firePropertyChange(DocumentationPane.PROP_DIRTY, true, false);
            DocumentationPane.this.saveAction.setEnabled(false);
            DocumentationPane.this.purgeUndos();
            int n2 = DocumentationPane.this.getTextPane().getDocument().getLength();
            if (n > n2) {
                DocumentationPane.this.getTextPane().setCaretPosition(n2);
            } else {
                DocumentationPane.this.getTextPane().setCaretPosition(n);
            }
        }

        protected void updateState() {
            this.setEnabled(DocumentationPane.this.undoMgr.canUndo());
        }
    }

    class ColorAction
    extends StyledEditorKit.ForegroundAction {
        public ColorAction() {
            super("", Color.BLACK);
            this.putValue("SmallIcon", ImageUtil.instance().getIcon("color-chooser.png"));
            DocumentationPane.this.setToolTipText(NbBundle.getMessage(DocumentationPane.class, (String)"IDS_FONTCOLOR"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DocumentationPane.this.getTextPane().requestFocus();
            Color color = JColorChooser.showDialog(DocumentationPane.this, NbBundle.getMessage(DocumentationPane.class, (String)"IDS_TITLE"), DocumentationPane.this.m_TextPane.getForeground());
            if (color != null) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(simpleAttributeSet, color);
                this.setCharacterAttributes(DocumentationPane.this.getTextPane(), simpleAttributeSet, false);
            }
        }
    }

    class DocUndoableEditListener
    implements UndoableEditListener {
        DocUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            DocumentationPane.this.undoMgr.addEdit(undoableEditEvent.getEdit());
            DocumentationPane.this.undoAction.updateState();
            DocumentationPane.this.redoAction.updateState();
            DocumentationPane.this.saveAction.setEnabled(DocumentationPane.this.undoMgr.canUndo());
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(NbBundle.getMessage(DocumentationPane.class, (String)"Redo"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DocumentationPane.this.undoMgr.redo();
            }
            catch (CannotUndoException cannotUndoException) {
                cannotUndoException.printStackTrace();
            }
            this.updateState();
            DocumentationPane.this.undoAction.updateState();
            DocumentationPane.this.saveAction.updateState();
        }

        protected void updateState() {
            this.setEnabled(DocumentationPane.this.undoMgr.canRedo());
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(NbBundle.getMessage(DocumentationPane.class, (String)"Undo"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DocumentationPane.this.undoMgr.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                cannotUndoException.printStackTrace();
            }
            this.updateState();
            DocumentationPane.this.redoAction.updateState();
            DocumentationPane.this.saveAction.updateState();
        }

        protected void updateState() {
            this.setEnabled(DocumentationPane.this.undoMgr.canUndo());
        }
    }
}

