/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model;

import com.sun.istack.NotNull;
import com.sun.xml.bind.api.CompositeStructure;
import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.model.ExceptionType;
import com.sun.xml.ws.api.model.MEP;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.CheckedExceptionImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.RuntimeModelerException;
import com.sun.xml.ws.model.SOAPSEIModel;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.soap.SOAPBindingImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLInputImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.resources.ModelerMessages;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.util.localization.Localizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.ws.Action;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.FaultAction;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.Response;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeModeler {
    private BindingID bindingId;
    private Class portClass;
    private AbstractSEIModelImpl model;
    private SOAPBindingImpl defaultBinding;
    private String packageName;
    private String targetNamespace;
    private boolean isWrapped = true;
    private boolean usesWebMethod = false;
    private ClassLoader classLoader = null;
    private final WSDLPortImpl binding;
    private QName serviceName;
    private QName portName;
    private Map<Class, Boolean> classUsesWebMethod = new HashMap<Class, Boolean>();
    public static final String PD_JAXWS_PACKAGE_PD = ".jaxws.";
    public static final String JAXWS_PACKAGE_PD = "jaxws.";
    public static final String RESPONSE = "Response";
    public static final String RETURN = "return";
    public static final String BEAN = "Bean";
    public static final String SERVICE = "Service";
    public static final String PORT = "Port";
    public static final Class HOLDER_CLASS = Holder.class;
    public static final Class<RemoteException> REMOTE_EXCEPTION_CLASS = RemoteException.class;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server");

    public RuntimeModeler(@NotNull Class portClass, @NotNull QName serviceName, @NotNull BindingID bindingId) {
        this.portClass = portClass;
        this.serviceName = serviceName;
        this.binding = null;
        this.bindingId = bindingId;
    }

    public RuntimeModeler(@NotNull Class sei, @NotNull QName serviceName, @NotNull WSDLPortImpl wsdlPort) {
        this.portClass = sei;
        this.serviceName = serviceName;
        this.bindingId = wsdlPort.getBinding().getBindingId();
        if (this.bindingId == null) {
            this.bindingId = BindingID.SOAP11_HTTP;
        }
        this.binding = wsdlPort;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPortName(QName portName) {
        this.portName = portName;
    }

    private static <T extends Annotation> T getPrivClassAnnotation(final Class<?> clazz, final Class<T> T) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return clazz.getAnnotation(T);
            }
        }));
    }

    private static <T extends Annotation> T getPrivMethodAnnotation(final Method method, final Class<T> T) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return method.getAnnotation(T);
            }
        }));
    }

    private static Annotation[][] getPrivParameterAnnotations(final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Annotation[][]>(){

            @Override
            public Annotation[][] run() {
                return method.getParameterAnnotations();
            }
        });
    }

    public AbstractSEIModelImpl buildRuntimeModel() {
        this.model = new SOAPSEIModel();
        Class clazz = this.portClass;
        WebService webService = RuntimeModeler.getPrivClassAnnotation(this.portClass, WebService.class);
        if (webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", this.portClass.getCanonicalName());
        }
        if (webService.endpointInterface().length() > 0) {
            clazz = this.getClass(webService.endpointInterface(), ModelerMessages.localizableRUNTIME_MODELER_CLASS_NOT_FOUND(webService.endpointInterface()));
            WebService seiService = RuntimeModeler.getPrivClassAnnotation(clazz, WebService.class);
            if (seiService == null) {
                throw new RuntimeModelerException("runtime.modeler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
            SOAPBinding sbPortClass = RuntimeModeler.getPrivClassAnnotation(this.portClass, SOAPBinding.class);
            SOAPBinding sbSei = RuntimeModeler.getPrivClassAnnotation(clazz, SOAPBinding.class);
            if (sbPortClass != null && (sbSei == null || sbSei.style() != sbPortClass.style() || sbSei.use() != sbPortClass.use())) {
                logger.warning(ServerMessages.RUNTIMEMODELER_INVALIDANNOTATION_ON_IMPL("@SOAPBinding", this.portClass.getName(), clazz.getName()));
            }
        }
        if (this.serviceName == null) {
            this.serviceName = RuntimeModeler.getServiceName(this.portClass);
        }
        this.model.setServiceQName(this.serviceName);
        String portLocalName = this.portClass.getSimpleName() + PORT;
        if (webService.portName().length() > 0) {
            portLocalName = webService.portName();
        } else if (webService.name().length() > 0) {
            portLocalName = webService.name() + PORT;
        }
        if (this.portName == null) {
            this.portName = new QName(this.serviceName.getNamespaceURI(), portLocalName);
        }
        if (!this.portName.getNamespaceURI().equals(this.serviceName.getNamespaceURI())) {
            throw new RuntimeModelerException("runtime.modeler.portname.servicename.namespace.mismatch", this.serviceName, this.portName);
        }
        this.model.setPortName(this.portName);
        this.processClass(clazz);
        if (this.model.getJavaMethods().size() == 0) {
            throw new RuntimeModelerException("runtime.modeler.no.operations", this.portClass.getName());
        }
        this.model.postProcess();
        if (this.binding != null) {
            this.model.freeze(this.binding);
        }
        return this.model;
    }

    private Class getClass(String className, Localizable errorMessage) {
        try {
            if (this.classLoader == null) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeModelerException(errorMessage);
        }
    }

    protected void setUsesWebMethod(Class clazz, Boolean usesWebMethod) {
        this.classUsesWebMethod.put(clazz, usesWebMethod);
    }

    protected void determineWebMethodUse(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            this.setUsesWebMethod(clazz, false);
        } else {
            boolean hasWebMethod = false;
            for (Method method : clazz.getMethods()) {
                WebMethod webMethod;
                if (method.getDeclaringClass() != clazz || (webMethod = RuntimeModeler.getPrivMethodAnnotation(method, WebMethod.class)) == null || webMethod.exclude()) continue;
                hasWebMethod = true;
                break;
            }
            this.setUsesWebMethod(clazz, hasWebMethod);
        }
        this.determineWebMethodUse(clazz.getSuperclass());
    }

    void processClass(Class clazz) {
        this.determineWebMethodUse(clazz);
        WebService webService = RuntimeModeler.getPrivClassAnnotation(clazz, WebService.class);
        String portTypeLocalName = clazz.getSimpleName();
        if (webService.name().length() > 0) {
            portTypeLocalName = webService.name();
        }
        this.targetNamespace = webService.targetNamespace();
        this.packageName = "";
        if (clazz.getPackage() != null) {
            this.packageName = clazz.getPackage().getName();
        }
        if (this.targetNamespace.length() == 0) {
            this.targetNamespace = RuntimeModeler.getNamespace(this.packageName);
        }
        this.model.setTargetNamespace(this.targetNamespace);
        QName portTypeName = new QName(this.targetNamespace, portTypeLocalName);
        this.model.setPortTypeName(portTypeName);
        this.model.setWSDLLocation(webService.wsdlLocation());
        SOAPBinding soapBinding = RuntimeModeler.getPrivClassAnnotation(clazz, SOAPBinding.class);
        if (soapBinding != null) {
            this.isWrapped = soapBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
        }
        this.defaultBinding = this.createBinding(soapBinding);
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !this.isWebMethod(method, clazz)) continue;
            this.processMethod(method, webService);
        }
        XmlSeeAlso xmlSeeAlso = RuntimeModeler.getPrivClassAnnotation(clazz, XmlSeeAlso.class);
        if (xmlSeeAlso != null) {
            this.model.setAdditionalClasses(xmlSeeAlso.value());
        }
    }

    protected boolean isWebMethod(Method method, Class clazz) {
        if (clazz.isInterface()) {
            return true;
        }
        Class<?> declClass = method.getDeclaringClass();
        boolean declHasWebService = RuntimeModeler.getPrivClassAnnotation(declClass, WebService.class) != null;
        WebMethod webMethod = RuntimeModeler.getPrivMethodAnnotation(method, WebMethod.class);
        if (webMethod != null && !webMethod.exclude() && declHasWebService) {
            return true;
        }
        return declHasWebService && this.classUsesWebMethod.get(declClass) == false;
    }

    protected SOAPBindingImpl createBinding(SOAPBinding soapBinding) {
        SOAPBindingImpl rtSOAPBinding = new SOAPBindingImpl();
        SOAPBinding.Style style = soapBinding != null ? soapBinding.style() : SOAPBinding.Style.DOCUMENT;
        rtSOAPBinding.setStyle(style);
        assert (this.bindingId != null);
        SOAPVersion soapVersion = this.bindingId.getSOAPVersion();
        rtSOAPBinding.setSOAPVersion(soapVersion);
        return rtSOAPBinding;
    }

    public static String getNamespace(@NotNull String packageName) {
        String[] tokens;
        if (packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuilder namespace = new StringBuilder("http://");
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                namespace.append('.');
            }
            namespace.append(tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    protected void processMethod(Method method, WebService webService) {
        WSDLBoundOperationImpl bo;
        JavaMethodImpl javaMethod;
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods) || Modifier.isStatic(mods)) {
            if (method.getAnnotation(WebMethod.class) != null) {
                if (Modifier.isStatic(mods)) {
                    throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_WEBMETHOD_MUST_BE_NONSTATIC(method));
                }
                throw new RuntimeModelerException(ModelerMessages.localizableRUNTIME_MODELER_WEBMETHOD_MUST_BE_PUBLIC(method));
            }
            return;
        }
        WebMethod webMethod = RuntimeModeler.getPrivMethodAnnotation(method, WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return;
        }
        if (this.usesWebMethod && webMethod == null) {
            return;
        }
        if (method.getDeclaringClass() == this.portClass) {
            javaMethod = new JavaMethodImpl(this.model, method, method);
        } else {
            try {
                Method tmpMethod = this.portClass.getMethod(method.getName(), method.getParameterTypes());
                javaMethod = new JavaMethodImpl(this.model, tmpMethod, method);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeModelerException("runtime.modeler.method.not.found", method.getName(), this.portClass.getName());
            }
        }
        String methodName = method.getName();
        MEP mep = this.getMEP(method);
        javaMethod.setMEP(mep);
        String action = null;
        String operationName = method.getName();
        if (webMethod != null) {
            action = webMethod.action();
            String string = operationName = webMethod.operationName().length() > 0 ? webMethod.operationName() : operationName;
        }
        if (this.binding != null && (bo = this.binding.getBinding().get(new QName(this.targetNamespace, operationName))) != null) {
            WSDLInputImpl wsdlInput = bo.getOperation().getInput();
            String wsaAction = wsdlInput.getAction();
            action = wsaAction != null && !wsdlInput.isDefaultAction() ? wsaAction : bo.getSOAPAction();
        }
        javaMethod.setOperationName(operationName);
        SOAPBinding methodBinding = method.getAnnotation(SOAPBinding.class);
        if (methodBinding == null && !method.getDeclaringClass().equals(this.portClass) && !method.getDeclaringClass().isInterface()) {
            methodBinding = method.getDeclaringClass().getAnnotation(SOAPBinding.class);
        }
        boolean methodIsWrapped = this.isWrapped;
        SOAPBinding.Style style = this.defaultBinding.getStyle();
        if (methodBinding != null) {
            SOAPBindingImpl mySOAPBinding = this.createBinding(methodBinding);
            style = mySOAPBinding.getStyle();
            if (action != null) {
                mySOAPBinding.setSOAPAction(action);
            }
            methodIsWrapped = methodBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
            javaMethod.setBinding(mySOAPBinding);
        } else {
            SOAPBindingImpl sb = new SOAPBindingImpl(this.defaultBinding);
            if (action != null) {
                sb.setSOAPAction(action);
            } else {
                sb.setSOAPAction("");
            }
            javaMethod.setBinding(sb);
        }
        if (!methodIsWrapped) {
            this.processDocBareMethod(javaMethod, methodName, webMethod, operationName, method, webService);
        } else if (style.equals((Object)SOAPBinding.Style.DOCUMENT)) {
            this.processDocWrappedMethod(javaMethod, methodName, webMethod, operationName, method, webService);
        } else {
            this.processRpcMethod(javaMethod, methodName, webMethod, operationName, method, webService);
        }
        this.model.addJavaMethod(javaMethod);
    }

    private MEP getMEP(Method m) {
        if (m.isAnnotationPresent(Oneway.class)) {
            return MEP.ONE_WAY;
        }
        if (Response.class.isAssignableFrom(m.getReturnType())) {
            return MEP.ASYNC_POLL;
        }
        if (Future.class.isAssignableFrom(m.getReturnType())) {
            return MEP.ASYNC_CALLBACK;
        }
        return MEP.REQUEST_RESPONSE;
    }

    /*
     * WARNING - void declaration
     */
    protected void processDocWrappedMethod(JavaMethodImpl javaMethod, String methodName, WebMethod webMethod, String operationName, Method method, WebService webService) {
        boolean isOneway = method.isAnnotationPresent(Oneway.class);
        RequestWrapper reqWrapper = method.getAnnotation(RequestWrapper.class);
        ResponseWrapper resWrapper = method.getAnnotation(ResponseWrapper.class);
        String beanPackage = this.packageName + PD_JAXWS_PACKAGE_PD;
        if (this.packageName == null || this.packageName != null && this.packageName.length() == 0) {
            beanPackage = JAXWS_PACKAGE_PD;
        }
        String requestClassName = reqWrapper != null && reqWrapper.className().length() > 0 ? reqWrapper.className() : beanPackage + RuntimeModeler.capitalize(method.getName());
        String responseClassName = resWrapper != null && resWrapper.className().length() > 0 ? resWrapper.className() : beanPackage + RuntimeModeler.capitalize(method.getName()) + RESPONSE;
        Class requestClass = this.getClass(requestClassName, ModelerMessages.localizableRUNTIME_MODELER_WRAPPER_NOT_FOUND(requestClassName));
        String reqName = operationName;
        String reqNamespace = this.targetNamespace;
        if (reqWrapper != null) {
            if (reqWrapper.targetNamespace().length() > 0) {
                reqNamespace = reqWrapper.targetNamespace();
            }
            if (reqWrapper.localName().length() > 0) {
                reqName = reqWrapper.localName();
            }
        }
        QName reqElementName = new QName(reqNamespace, reqName);
        Class responseClass = null;
        String resName = operationName + RESPONSE;
        String resNamespace = this.targetNamespace;
        if (!isOneway) {
            responseClass = this.getClass(responseClassName, ModelerMessages.localizableRUNTIME_MODELER_WRAPPER_NOT_FOUND(responseClassName));
            if (resWrapper != null) {
                if (resWrapper.targetNamespace().length() > 0) {
                    resNamespace = resWrapper.targetNamespace();
                }
                if (resWrapper.localName().length() > 0) {
                    resName = resWrapper.localName();
                }
            }
        }
        QName resElementName = new QName(resNamespace, resName);
        TypeReference typeRef = new TypeReference(reqElementName, (Type)requestClass, new Annotation[0]);
        WrapperParameter requestWrapper = new WrapperParameter(javaMethod, typeRef, WebParam.Mode.IN, 0);
        requestWrapper.setBinding(ParameterBinding.BODY);
        javaMethod.addParameter(requestWrapper);
        WrapperParameter responseWrapper = null;
        if (!isOneway) {
            typeRef = new TypeReference(resElementName, (Type)responseClass, new Annotation[0]);
            responseWrapper = new WrapperParameter(javaMethod, typeRef, WebParam.Mode.OUT, -1);
            javaMethod.addParameter(responseWrapper);
            responseWrapper.setBinding(ParameterBinding.BODY);
        }
        String resultName = RETURN;
        String resultTNS = "";
        QName resultQName = null;
        WebResult webResult = method.getAnnotation(WebResult.class);
        Class returnType = method.getReturnType();
        boolean isResultHeader = false;
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                resultName = webResult.name();
            }
            resultTNS = webResult.targetNamespace();
            isResultHeader = webResult.header();
            if (resultTNS.length() == 0 && webResult.header()) {
                resultTNS = this.targetNamespace;
            }
            resultQName = new QName(resultTNS, resultName);
        } else if (!(isOneway || returnType.getName().equals("void") || javaMethod.isAsync() || resultQName != null)) {
            resultQName = new QName(resultTNS, RETURN);
        }
        if (javaMethod.isAsync()) {
            returnType = this.getAsyncReturnType(method, returnType);
            resultQName = new QName(RETURN);
        }
        if (!isOneway && returnType != null && !returnType.getName().equals("void")) {
            Annotation[] rann = method.getAnnotations();
            if (resultQName.getLocalPart() != null) {
                TypeReference rTypeReference = new TypeReference(resultQName, (Type)returnType, rann);
                ParameterImpl returnParameter = new ParameterImpl(javaMethod, rTypeReference, WebParam.Mode.OUT, -1);
                if (isResultHeader) {
                    returnParameter.setBinding(ParameterBinding.HEADER);
                    javaMethod.addParameter(returnParameter);
                } else {
                    returnParameter.setBinding(ParameterBinding.BODY);
                    responseWrapper.addWrapperChild(returnParameter);
                }
            }
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] pannotations = RuntimeModeler.getPrivParameterAnnotations(method);
        int pos = 0;
        for (Class<?> clazz : parameterTypes) {
            void var37_37;
            String partName = null;
            String paramName = "arg" + pos;
            String paramNamespace = "";
            boolean isHeader = false;
            if (javaMethod.isAsync() && AsyncHandler.class.isAssignableFrom(clazz)) continue;
            boolean isHolder = HOLDER_CLASS.isAssignableFrom(clazz);
            if (isHolder && clazz == Holder.class) {
                Class clazz2 = Navigator.REFLECTION.erasure(((ParameterizedType)genericParameterTypes[pos]).getActualTypeArguments()[0]);
            }
            WebParam.Mode paramMode = isHolder ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Annotation annotation : pannotations[pos]) {
                if (annotation.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)annotation;
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                isHeader = webParam.header();
                partName = webParam.partName().length() > 0 ? webParam.partName() : paramName;
                if (isHeader) {
                    paramNamespace = this.targetNamespace;
                }
                if (!webParam.targetNamespace().equals("")) {
                    paramNamespace = webParam.targetNamespace();
                }
                paramMode = webParam.mode();
                if (!isHolder || paramMode != WebParam.Mode.IN) break;
                paramMode = WebParam.Mode.INOUT;
                break;
            }
            QName paramQName = new QName(paramNamespace, paramName);
            typeRef = new TypeReference(paramQName, (Type)var37_37, pannotations[pos]);
            ParameterImpl param = new ParameterImpl(javaMethod, typeRef, paramMode, pos++);
            if (isHeader) {
                param.setBinding(ParameterBinding.HEADER);
                javaMethod.addParameter(param);
                param.setPartName(partName);
                continue;
            }
            param.setBinding(ParameterBinding.BODY);
            if (paramMode != WebParam.Mode.OUT) {
                requestWrapper.addWrapperChild(param);
            }
            if (paramMode == WebParam.Mode.IN) continue;
            if (isOneway) {
                throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.out.parameters", this.portClass.getCanonicalName(), methodName);
            }
            responseWrapper.addWrapperChild(param);
        }
        this.processExceptions(javaMethod, method);
    }

    /*
     * WARNING - void declaration
     */
    protected void processRpcMethod(JavaMethodImpl javaMethod, String methodName, WebMethod webMethod, String operationName, Method method, WebService webService) {
        boolean isOneway = method.isAnnotationPresent(Oneway.class);
        TreeMap<Integer, ParameterImpl> resRpcParams = new TreeMap<Integer, ParameterImpl>();
        TreeMap<Integer, ParameterImpl> reqRpcParams = new TreeMap<Integer, ParameterImpl>();
        String reqNamespace = this.targetNamespace;
        String respNamespace = this.targetNamespace;
        if (this.binding != null && this.binding.getBinding().isRpcLit()) {
            QName opQName = new QName(this.binding.getBinding().getPortTypeName().getNamespaceURI(), operationName);
            WSDLBoundOperationImpl op = this.binding.getBinding().get(opQName);
            if (op != null) {
                if (op.getRequestNamespace() != null) {
                    reqNamespace = op.getRequestNamespace();
                }
                if (op.getResponseNamespace() != null) {
                    respNamespace = op.getResponseNamespace();
                }
            }
        }
        QName reqElementName = new QName(reqNamespace, operationName);
        QName resElementName = null;
        if (!isOneway) {
            resElementName = new QName(respNamespace, operationName + RESPONSE);
        }
        Class<CompositeStructure> wrapperType = CompositeStructure.class;
        TypeReference typeRef = new TypeReference(reqElementName, wrapperType, new Annotation[0]);
        WrapperParameter requestWrapper = new WrapperParameter(javaMethod, typeRef, WebParam.Mode.IN, 0);
        requestWrapper.setInBinding(ParameterBinding.BODY);
        javaMethod.addParameter(requestWrapper);
        WrapperParameter responseWrapper = null;
        if (!isOneway) {
            typeRef = new TypeReference(resElementName, wrapperType, new Annotation[0]);
            responseWrapper = new WrapperParameter(javaMethod, typeRef, WebParam.Mode.OUT, -1);
            responseWrapper.setOutBinding(ParameterBinding.BODY);
            javaMethod.addParameter(responseWrapper);
        }
        Class returnType = method.getReturnType();
        String resultName = RETURN;
        String resultTNS = this.targetNamespace;
        String resultPartName = resultName;
        boolean isResultHeader = false;
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            isResultHeader = webResult.header();
            if (webResult.name().length() > 0) {
                resultName = webResult.name();
            }
            if (webResult.partName().length() > 0) {
                resultPartName = webResult.partName();
                if (!isResultHeader) {
                    resultName = resultPartName;
                }
            } else {
                resultPartName = resultName;
            }
            if (webResult.targetNamespace().length() > 0) {
                resultTNS = webResult.targetNamespace();
            }
            isResultHeader = webResult.header();
        }
        QName resultQName = isResultHeader ? new QName(resultTNS, resultName) : new QName(resultName);
        if (javaMethod.isAsync()) {
            returnType = this.getAsyncReturnType(method, returnType);
        }
        if (!isOneway && returnType != null && returnType != Void.TYPE) {
            Annotation[] rann = method.getAnnotations();
            TypeReference rTypeReference = new TypeReference(resultQName, (Type)returnType, rann);
            ParameterImpl returnParameter = new ParameterImpl(javaMethod, rTypeReference, WebParam.Mode.OUT, -1);
            returnParameter.setPartName(resultPartName);
            if (isResultHeader) {
                returnParameter.setBinding(ParameterBinding.HEADER);
                javaMethod.addParameter(returnParameter);
            } else {
                ParameterBinding rb = this.getBinding(operationName, resultPartName, false, WebParam.Mode.OUT);
                returnParameter.setBinding(rb);
                if (rb.isBody()) {
                    WSDLPart p = this.getPart(new QName(this.targetNamespace, operationName), resultPartName, WebParam.Mode.OUT);
                    if (p == null) {
                        resRpcParams.put(resRpcParams.size() + 10000, returnParameter);
                    } else {
                        resRpcParams.put(p.getIndex(), returnParameter);
                    }
                } else {
                    javaMethod.addParameter(returnParameter);
                }
            }
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] pannotations = RuntimeModeler.getPrivParameterAnnotations(method);
        int pos = 0;
        for (Class<?> clazz : parameterTypes) {
            void var32_35;
            QName paramQName;
            String paramName = "";
            String paramNamespace = "";
            String partName = "";
            boolean isHeader = false;
            if (javaMethod.isAsync() && AsyncHandler.class.isAssignableFrom(clazz)) continue;
            boolean isHolder = HOLDER_CLASS.isAssignableFrom(clazz);
            if (isHolder && clazz == Holder.class) {
                Class clazz2 = Navigator.REFLECTION.erasure(((ParameterizedType)genericParameterTypes[pos]).getActualTypeArguments()[0]);
            }
            WebParam.Mode paramMode = isHolder ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Annotation annotation : pannotations[pos]) {
                if (annotation.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)annotation;
                paramName = webParam.name();
                partName = webParam.partName();
                isHeader = webParam.header();
                WebParam.Mode mode = webParam.mode();
                paramNamespace = webParam.targetNamespace();
                if (isHolder && mode == WebParam.Mode.IN) {
                    mode = WebParam.Mode.INOUT;
                }
                paramMode = mode;
                break;
            }
            if (paramName.length() == 0) {
                paramName = "arg" + pos;
            }
            if (partName.length() == 0) {
                partName = paramName;
            } else if (!isHeader) {
                paramName = partName;
            }
            if (partName.length() == 0) {
                partName = paramName;
            }
            if (!isHeader) {
                paramQName = new QName("", paramName);
            } else {
                if (paramNamespace.length() == 0) {
                    paramNamespace = this.targetNamespace;
                }
                paramQName = new QName(paramNamespace, paramName);
            }
            typeRef = new TypeReference(paramQName, (Type)var32_35, pannotations[pos]);
            ParameterImpl param = new ParameterImpl(javaMethod, typeRef, paramMode, pos++);
            param.setPartName(partName);
            if (paramMode == WebParam.Mode.INOUT) {
                ParameterBinding pb = this.getBinding(operationName, partName, isHeader, WebParam.Mode.IN);
                param.setInBinding(pb);
                pb = this.getBinding(operationName, partName, isHeader, WebParam.Mode.OUT);
                param.setOutBinding(pb);
            } else if (isHeader) {
                param.setBinding(ParameterBinding.HEADER);
            } else {
                ParameterBinding pb = this.getBinding(operationName, partName, false, paramMode);
                param.setBinding(pb);
            }
            if (param.getInBinding().isBody()) {
                if (!param.isOUT()) {
                    WSDLPart p = this.getPart(new QName(this.targetNamespace, operationName), partName, WebParam.Mode.IN);
                    if (p == null) {
                        reqRpcParams.put(reqRpcParams.size() + 10000, param);
                    } else {
                        reqRpcParams.put(p.getIndex(), param);
                    }
                }
                if (param.isIN()) continue;
                if (isOneway) {
                    throw new RuntimeModelerException("runtime.modeler.oneway.operation.no.out.parameters", this.portClass.getCanonicalName(), methodName);
                }
                WSDLPart p = this.getPart(new QName(this.targetNamespace, operationName), partName, WebParam.Mode.OUT);
                if (p == null) {
                    resRpcParams.put(resRpcParams.size() + 10000, param);
                    continue;
                }
                resRpcParams.put(p.getIndex(), param);
                continue;
            }
            javaMethod.addParameter(param);
        }
        for (ParameterImpl p : reqRpcParams.values()) {
            requestWrapper.addWrapperChild(p);
        }
        for (ParameterImpl p : resRpcParams.values()) {
            responseWrapper.addWrapperChild(p);
        }
        this.processExceptions(javaMethod, method);
    }

    protected void processExceptions(JavaMethodImpl javaMethod, Method method) {
        Action actionAnn = method.getAnnotation(Action.class);
        FaultAction[] faultActions = new FaultAction[]{};
        if (actionAnn != null) {
            faultActions = actionAnn.fault();
        }
        for (Class<?> exception : method.getExceptionTypes()) {
            Annotation[] anns;
            Class exceptionBean;
            if (REMOTE_EXCEPTION_CLASS.isAssignableFrom(exception)) continue;
            WebFault webFault = RuntimeModeler.getPrivClassAnnotation(exception, WebFault.class);
            Method faultInfoMethod = this.getWSDLExceptionFaultInfo(exception);
            ExceptionType exceptionType = ExceptionType.WSDLException;
            String namespace = this.targetNamespace;
            String name = exception.getSimpleName();
            String beanPackage = this.packageName + PD_JAXWS_PACKAGE_PD;
            if (this.packageName.length() == 0) {
                beanPackage = JAXWS_PACKAGE_PD;
            }
            String className = beanPackage + name + BEAN;
            if (webFault != null) {
                if (webFault.faultBean().length() > 0) {
                    className = webFault.faultBean();
                }
                if (webFault.name().length() > 0) {
                    name = webFault.name();
                }
                if (webFault.targetNamespace().length() > 0) {
                    namespace = webFault.targetNamespace();
                }
            }
            if (faultInfoMethod == null) {
                exceptionBean = this.getClass(className, ModelerMessages.localizableRUNTIME_MODELER_WRAPPER_NOT_FOUND(className));
                exceptionType = ExceptionType.UserDefined;
                anns = exceptionBean.getAnnotations();
            } else {
                exceptionBean = faultInfoMethod.getReturnType();
                anns = faultInfoMethod.getAnnotations();
            }
            QName faultName = new QName(namespace, name);
            TypeReference typeRef = new TypeReference(faultName, (Type)exceptionBean, anns);
            CheckedExceptionImpl checkedException = new CheckedExceptionImpl(javaMethod, exception, typeRef, exceptionType);
            checkedException.setMessageName(exception.getSimpleName());
            for (FaultAction fa : faultActions) {
                if (!fa.className().equals(exception) || fa.value().equals("")) continue;
                checkedException.setFaultAction(fa.value());
                break;
            }
            javaMethod.addException(checkedException);
        }
    }

    protected Method getWSDLExceptionFaultInfo(Class exception) {
        if (!exception.isAnnotationPresent(WebFault.class)) {
            return null;
        }
        try {
            return exception.getMethod("getFaultInfo", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processDocBareMethod(JavaMethodImpl javaMethod, String methodName, WebMethod webMethod, String operationName, Method method, WebService webService) {
        String resultName = operationName + RESPONSE;
        String resultTNS = this.targetNamespace;
        String resultPartName = null;
        boolean isResultHeader = false;
        WebResult webResult = method.getAnnotation(WebResult.class);
        if (webResult != null) {
            if (webResult.name().length() > 0) {
                resultName = webResult.name();
            }
            if (webResult.targetNamespace().length() > 0) {
                resultTNS = webResult.targetNamespace();
            }
            resultPartName = webResult.partName();
            isResultHeader = webResult.header();
        }
        Class returnType = method.getReturnType();
        if (javaMethod.isAsync()) {
            returnType = this.getAsyncReturnType(method, returnType);
        }
        if (returnType != null && !returnType.getName().equals("void")) {
            Annotation[] rann = method.getAnnotations();
            if (resultName != null) {
                QName responseQName = new QName(resultTNS, resultName);
                TypeReference rTypeReference = new TypeReference(responseQName, (Type)returnType, rann);
                ParameterImpl returnParameter = new ParameterImpl(javaMethod, rTypeReference, WebParam.Mode.OUT, -1);
                if (resultPartName == null || resultPartName.length() == 0) {
                    resultPartName = resultName;
                }
                returnParameter.setPartName(resultPartName);
                if (isResultHeader) {
                    returnParameter.setBinding(ParameterBinding.HEADER);
                } else {
                    ParameterBinding rb = this.getBinding(operationName, resultPartName, false, WebParam.Mode.OUT);
                    returnParameter.setBinding(rb);
                }
                javaMethod.addParameter(returnParameter);
            }
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] pannotations = RuntimeModeler.getPrivParameterAnnotations(method);
        int pos = 0;
        for (Class<?> clazz : parameterTypes) {
            ParameterBinding pb;
            void var20_21;
            String paramName = operationName;
            String partName = null;
            String requestNamespace = this.targetNamespace;
            boolean isHeader = false;
            if (javaMethod.isAsync() && AsyncHandler.class.isAssignableFrom(clazz)) continue;
            boolean isHolder = HOLDER_CLASS.isAssignableFrom(clazz);
            if (isHolder && clazz == Holder.class) {
                Class clazz2 = Navigator.REFLECTION.erasure(((ParameterizedType)genericParameterTypes[pos]).getActualTypeArguments()[0]);
            }
            WebParam.Mode paramMode = isHolder ? WebParam.Mode.INOUT : WebParam.Mode.IN;
            for (Annotation annotation : pannotations[pos]) {
                if (annotation.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)annotation;
                if (webParam.name().length() > 0) {
                    paramName = webParam.name();
                }
                partName = webParam.partName();
                if (!webParam.targetNamespace().equals("")) {
                    requestNamespace = webParam.targetNamespace();
                }
                isHeader = webParam.header();
                paramMode = webParam.mode();
                if (!isHolder || paramMode != WebParam.Mode.IN) break;
                paramMode = WebParam.Mode.INOUT;
                break;
            }
            QName requestQName = new QName(requestNamespace, paramName);
            TypeReference typeRef = new TypeReference(requestQName, (Type)var20_21, pannotations[pos]);
            ParameterImpl param = new ParameterImpl(javaMethod, typeRef, paramMode, pos++);
            if (partName == null || partName.length() == 0) {
                partName = paramName;
            }
            param.setPartName(partName);
            if (paramMode == WebParam.Mode.INOUT) {
                pb = this.getBinding(operationName, partName, isHeader, WebParam.Mode.IN);
                param.setInBinding(pb);
                pb = this.getBinding(operationName, partName, isHeader, WebParam.Mode.OUT);
                param.setOutBinding(pb);
            } else if (isHeader) {
                param.setBinding(ParameterBinding.HEADER);
            } else {
                pb = this.getBinding(operationName, partName, false, paramMode);
                param.setBinding(pb);
            }
            javaMethod.addParameter(param);
        }
        this.validateDocBare(javaMethod);
        this.processExceptions(javaMethod, method);
    }

    private void validateDocBare(JavaMethodImpl javaMethod) {
        int numInBodyBindings = 0;
        for (ParameterImpl param : javaMethod.getRequestParameters()) {
            if (param.getBinding().equals(ParameterBinding.BODY) && param.isIN()) {
                ++numInBodyBindings;
            }
            if (numInBodyBindings <= true) continue;
            throw new RuntimeModelerException(ModelerMessages.localizableNOT_A_VALID_BARE_METHOD(this.portClass.getName(), javaMethod.getMethod().getName()));
        }
    }

    private Class getAsyncReturnType(Method method, Class returnType) {
        if (Response.class.isAssignableFrom(returnType)) {
            Type ret = method.getGenericReturnType();
            return Navigator.REFLECTION.erasure(((ParameterizedType)ret).getActualTypeArguments()[0]);
        }
        Type[] types = method.getGenericParameterTypes();
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        for (Class<?> cls : params) {
            if (AsyncHandler.class.isAssignableFrom(cls)) {
                return Navigator.REFLECTION.erasure(((ParameterizedType)types[i]).getActualTypeArguments()[0]);
            }
            ++i;
        }
        return returnType;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static QName getServiceName(Class<?> implClass) {
        WebService webService;
        if (implClass.isInterface()) {
            throw new RuntimeModelerException("runtime.modeler.cannot.get.serviceName.from.interface", implClass.getCanonicalName());
        }
        String name = implClass.getSimpleName() + SERVICE;
        String packageName = "";
        if (implClass.getPackage() != null) {
            packageName = implClass.getPackage().getName();
        }
        if ((webService = implClass.getAnnotation(WebService.class)) == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", implClass.getCanonicalName());
        }
        if (webService.serviceName().length() > 0) {
            name = webService.serviceName();
        }
        String targetNamespace = RuntimeModeler.getNamespace(packageName);
        if (webService.targetNamespace().length() > 0) {
            targetNamespace = webService.targetNamespace();
        } else if (targetNamespace == null) {
            throw new RuntimeModelerException("runtime.modeler.no.package", implClass.getName());
        }
        return new QName(targetNamespace, name);
    }

    public static QName getPortName(Class<?> implClass, String targetNamespace) {
        WebService webService = implClass.getAnnotation(WebService.class);
        if (webService == null) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", implClass.getCanonicalName());
        }
        String name = webService.portName().length() > 0 ? webService.portName() : (webService.name().length() > 0 ? webService.name() + PORT : implClass.getSimpleName() + PORT);
        if (targetNamespace == null) {
            if (webService.targetNamespace().length() > 0) {
                targetNamespace = webService.targetNamespace();
            } else {
                String packageName = null;
                if (implClass.getPackage() != null) {
                    packageName = implClass.getPackage().getName();
                }
                if ((targetNamespace = RuntimeModeler.getNamespace(packageName)) == null) {
                    throw new RuntimeModelerException("runtime.modeler.no.package", implClass.getName());
                }
            }
        }
        return new QName(targetNamespace, name);
    }

    public static QName getPortTypeName(Class<?> implOrSeiClass) {
        String tns;
        String name;
        WebService webService;
        String epi;
        assert (implOrSeiClass != null);
        Class<?> clazz = implOrSeiClass;
        if (!implOrSeiClass.isAnnotationPresent(WebService.class)) {
            throw new RuntimeModelerException("runtime.modeler.no.webservice.annotation", implOrSeiClass.getCanonicalName());
        }
        if (!implOrSeiClass.isInterface() && (epi = (webService = implOrSeiClass.getAnnotation(WebService.class)).endpointInterface()).length() > 0) {
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(epi);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeModelerException("runtime.modeler.class.not.found", epi);
            }
            if (!clazz.isAnnotationPresent(WebService.class)) {
                throw new RuntimeModelerException("runtime.modeler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
        }
        if ((name = (webService = clazz.getAnnotation(WebService.class)).name()).length() == 0) {
            name = clazz.getSimpleName();
        }
        if ((tns = webService.targetNamespace()).length() == 0) {
            tns = RuntimeModeler.getNamespace(clazz.getPackage().getName());
        }
        if (tns == null) {
            throw new RuntimeModelerException("runtime.modeler.no.package", clazz.getName());
        }
        return new QName(tns, name);
    }

    private ParameterBinding getBinding(String operation, String part, boolean isHeader, WebParam.Mode mode) {
        if (this.binding == null) {
            if (isHeader) {
                return ParameterBinding.HEADER;
            }
            return ParameterBinding.BODY;
        }
        QName opName = new QName(this.binding.getBinding().getPortType().getName().getNamespaceURI(), operation);
        return this.binding.getBinding().getBinding(opName, part, mode);
    }

    private WSDLPart getPart(QName opName, String partName, WebParam.Mode mode) {
        WSDLBoundOperationImpl bo;
        if (this.binding != null && (bo = this.binding.getBinding().get(opName)) != null) {
            return bo.getPart(partName, mode);
        }
        return null;
    }
}

