/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportProvider;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.model.spi.RestServicesMetadataModelFactory;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public abstract class RestSupport {
    public static final String SWDP_LIBRARY = "restlib";
    public static final String RESTAPI_LIBRARY = "restapi";
    public static final String PROP_SWDP_CLASSPATH = "libs.swdp.classpath";
    public static final String PROP_RESTBEANS_TEST_DIR = "restbeans.test.dir";
    public static final String PROP_RESTBEANS_TEST_FILE = "restbeans.test.file";
    public static final String PROP_RESTBEANS_TEST_URL = "restbeans.test.url";
    public static final String PROP_BASE_URL_TOKEN = "base.url.token";
    public static final String BASE_URL_TOKEN = "___BASE_URL___";
    public static final String RESTBEANS_TEST_DIR = "build/generated/rest-test";
    public static final String COMMAND_TEST_RESTBEANS = "test-restbeans";
    public static final String REST_SUPPORT_ON = "rest.support.on";
    public static final String TEST_RESBEANS = "test-resbeans";
    public static final String TEST_RESBEANS_HTML = "test-resbeans.html";
    public static final String TEST_RESBEANS_JS = "test-resbeans.js";
    public static final String TEST_RESBEANS_CSS = "test-resbeans.css";
    public static final String TEST_RESBEANS_CSS2 = "css_master-all.css";
    public static final String REST_SERVLET_ADAPTOR = "ServletAdaptor";
    public static final String REST_SERVLET_ADAPTOR_CLASS = "com.sun.ws.rest.impl.container.servlet.ServletAdaptor";
    public static final String REST_SERVLET_ADAPTOR_MAPPING = "/resources/*";
    public static final String PARAM_WEB_RESOURCE_CLASS = "webresourceclass";
    public static final String WEB_RESOURCE_CLASS = "webresources.WebResources";
    public static final String REST_API_JAR = "jsr311-api.jar";
    public static final String REST_RI_JAR = "jersey.jar";
    public static final String IGNORE_PLATFORM_RESTLIB = "restlib.ignore.platform";
    public static final String JSR311_API_LOCATION = "modules/ext/rest/jsr311-api.jar";
    private AntProjectHelper helper;
    protected RestServicesModel restServicesModel;
    private List<PropertyChangeListener> modelListeners = new ArrayList<PropertyChangeListener>();
    protected final Project project;
    private boolean buildExtensionInited = false;

    public RestSupport(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null project");
        }
        this.project = project;
    }

    public abstract void ensureRestDevelopmentReady() throws IOException;

    public abstract void removeRestDevelopmentReadiness() throws IOException;

    public abstract boolean isReady();

    public abstract FileObject getPersistenceXml();

    public FileObject findSourceRoot() {
        return RestSupport.findSourceRoot(this.getProject());
    }

    public static FileObject findSourceRoot(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            return sourceGroupArray[0].getRootFolder();
        }
        return null;
    }

    public void addModelListener(PropertyChangeListener propertyChangeListener) {
        this.modelListeners.add(propertyChangeListener);
        if (this.restServicesModel != null) {
            this.restServicesModel.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeModelListener(PropertyChangeListener propertyChangeListener) {
        this.modelListeners.remove(propertyChangeListener);
        if (this.restServicesModel != null) {
            this.restServicesModel.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public RestServicesModel getRestServicesModel() {
        FileObject fileObject = this.findSourceRoot();
        if (this.restServicesModel == null && fileObject != null) {
            ClassPathProvider classPathProvider = (ClassPathProvider)this.getProject().getLookup().lookup(ClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)classPathProvider.findClassPath(fileObject, "classpath/boot"), (ClassPath)RestSupport.extendWithJsr311Api(classPathProvider.findClassPath(fileObject, "classpath/compile")), (ClassPath)classPathProvider.findClassPath(fileObject, "classpath/source"), null);
            this.restServicesModel = RestServicesMetadataModelFactory.createMetadataModel(metadataUnit, this.project);
            for (PropertyChangeListener propertyChangeListener : this.modelListeners) {
                this.restServicesModel.addPropertyChangeListener(propertyChangeListener);
            }
        }
        return this.restServicesModel;
    }

    protected void refreshRestServicesMetadataModel() {
        if (this.restServicesModel != null) {
            for (PropertyChangeListener propertyChangeListener : this.modelListeners) {
                this.restServicesModel.removePropertyChangeListener(propertyChangeListener);
            }
            this.restServicesModel = null;
        }
        try {
            this.getRestServicesModel().runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                    restServicesMetadata.getRoot().sizeRestServiceDescription();
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    public static ClassPath extendWithJsr311Api(ClassPath classPath) {
        File file = InstalledFileLocator.getDefault().locate(JSR311_API_LOCATION, null, false);
        return RestSupport.extendClassPath(classPath, file);
    }

    public static ClassPath extendClassPath(ClassPath classPath, File file) {
        if (file == null) {
            return classPath;
        }
        try {
            PathResourceImplementation pathResourceImplementation = RestSupport.getPathResource(file);
            ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
            arrayList.add(pathResourceImplementation);
            for (FileObject fileObject : classPath.getRoots()) {
                arrayList.add(ClassPathSupport.createResource((URL)fileObject.getURL()));
            }
            return ClassPathSupport.createClassPath(arrayList);
        }
        catch (Exception exception) {
            return classPath;
        }
    }

    private static PathResourceImplementation getPathResource(File file) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else {
            uRL = file.toURI().toURL();
            String string = uRL.toExternalForm();
            if (!string.endsWith("/")) {
                uRL = new URL(string + "/");
            }
        }
        return ClassPathSupport.createResource((URL)uRL);
    }

    public abstract void extendBuildScripts() throws IOException;

    public void initBuildScripts() throws IOException {
        if (!this.buildExtensionInited) {
            this.extendBuildScripts();
            this.buildExtensionInited = true;
        }
    }

    public FileObject generateTestClient(File file) throws IOException {
        this.initBuildScripts();
        if (!file.isDirectory()) {
            FileUtil.createFolder((File)file);
        }
        String[] stringArray = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_Trail", "MSG_TEST_RESBEANS_TestInput", "MSG_TEST_RESBEANS_TestOutput"};
        String[] stringArray2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_Param", "MSG_TEST_RESBEANS_ResourceInputs", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_ServerError", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_ErrorHint", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_NoHeaders", "MSG_TEST_RESBEANS_NewParamName", "MSG_TEST_RESBEANS_NewParamValue", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources"};
        FileObject fileObject = this.copyFile(file, TEST_RESBEANS_HTML, stringArray, true);
        this.copyFile(file, TEST_RESBEANS_JS, stringArray2, false);
        this.copyFile(file, TEST_RESBEANS_CSS);
        this.copyFile(file, TEST_RESBEANS_CSS2);
        this.copyFile(file, "expand.gif");
        this.copyFile(file, "collapse.gif");
        this.copyFile(file, "item.gif");
        this.copyFile(file, "cc.gif");
        this.copyFile(file, "og.gif");
        this.copyFile(file, "cg.gif");
        this.copyFile(file, "app.gif");
        File file2 = new File(file, "images");
        file2.mkdir();
        this.copyFile(file, "images/background_border_bottom.gif");
        this.copyFile(file, "images/pbsel.png");
        this.copyFile(file, "images/bg_gradient.gif");
        this.copyFile(file, "images/pname.png");
        this.copyFile(file, "images/level1_selected-1lvl.jpg");
        this.copyFile(file, "images/primary-enabled.gif");
        this.copyFile(file, "images/masthead.png");
        this.copyFile(file, "images/primary-roll.gif");
        this.copyFile(file, "images/pbdis.png");
        this.copyFile(file, "images/secondary-enabled.gif");
        this.copyFile(file, "images/pbena.png");
        this.copyFile(file, "images/tbsel.png");
        this.copyFile(file, "images/pbmou.png");
        this.copyFile(file, "images/tbuns.png");
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyFile(File file, String string, String[] stringArray, boolean bl) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(string);
        } else if (!bl) {
            return fileObject2;
        }
        FileLock fileLock = null;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            int n;
            fileLock = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            InputStream inputStream = RestSupport.class.getResourceAsStream("resources/" + string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string3 = "\n";
            if (File.separatorChar == '\\') {
                string3 = "\r\n";
            }
            String[] stringArray2 = null;
            if (stringArray != null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = NbBundle.getMessage(RestSupport.class, (String)stringArray[n]);
                }
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    string2 = string2.replaceAll(stringArray[n], stringArray2[n]);
                }
                bufferedWriter.write(string2);
                bufferedWriter.write(string3);
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file, String string) throws IOException {
        String string2 = "resources/" + string;
        File file2 = new File(file, string);
        if (!file2.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = RestSupport.class.getResourceAsStream(string2);
                outputStream = new FileOutputStream(file2);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    public void addSwdpLibrary(String[] stringArray) throws IOException {
        Library library = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
        if (library == null) {
            return;
        }
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            throw new IOException("Project has no Java sources");
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        for (String string : stringArray) {
            try {
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)fileObject, (String)string);
                Library library2 = LibraryManager.getDefault().getLibrary(RESTAPI_LIBRARY);
                if (library2 == null) continue;
                ProjectClassPathModifier.removeLibraries((Library[])new Library[]{library2}, (FileObject)fileObject, (String)"classpath/compile");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.getLogger(this.getClass().getName()).info(string + " not supported.");
            }
        }
    }

    public void removeSwdpLibrary(String[] stringArray) throws IOException {
        Library library = LibraryManager.getDefault().getLibrary(SWDP_LIBRARY);
        if (library == null) {
            return;
        }
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        for (String string : stringArray) {
            try {
                ProjectClassPathModifier.removeLibraries((Library[])new Library[]{library}, (FileObject)fileObject, (String)string);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Logger.getLogger(this.getClass().getName()).info(string + " not supported.");
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    public boolean hasSwdpLibrary() {
        return !RestSupport.needsSwdpLibrary(this.getProject());
    }

    private static boolean needsSwdpLibrary(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray.length < 1) {
            return false;
        }
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        FileObject fileObject2 = classPath.findResource("com/sun/ws/rest/api/UriTemplate.class");
        return fileObject2 == null;
    }

    public boolean isRestSupportOn() {
        if (this.getAntProjectHelper() == null) {
            return false;
        }
        String string = this.getProjectProperty(REST_SUPPORT_ON);
        return "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    public void setRestSupport(Boolean bl) {
        this.setProjectProperty(REST_SUPPORT_ON, bl.toString());
    }

    public void setProjectProperty(String string, String string2) {
        if (this.getAntProjectHelper() == null) {
            return;
        }
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        editableProperties.setProperty(string, string2);
        this.helper.putProperties("nbproject/project.properties", editableProperties);
        try {
            ProjectManager.getDefault().saveProject(this.getProject());
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
        }
    }

    public String getProjectProperty(String string) {
        if (this.getAntProjectHelper() == null) {
            return null;
        }
        return this.helper.getStandardPropertyEvaluator().getProperty(string);
    }

    protected boolean ignorePlatformRestLibrary() {
        String string = this.getProjectProperty(IGNORE_PLATFORM_RESTLIB);
        Boolean bl = string != null ? Boolean.valueOf(string) : true;
        return bl != Boolean.FALSE;
    }

    public AntProjectHelper getAntProjectHelper() {
        JAXWSSupport jAXWSSupport;
        JAXWSSupportProvider jAXWSSupportProvider;
        if (this.helper == null && (jAXWSSupportProvider = (JAXWSSupportProvider)this.project.getLookup().lookup(JAXWSSupportProvider.class)) != null && (jAXWSSupport = jAXWSSupportProvider.findJAXWSSupport(this.project.getProjectDirectory())) != null) {
            this.helper = jAXWSSupport.getAntProjectHelper();
        }
        return this.helper;
    }
}

