/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.components.ComponentMorpher;
import org.netbeans.lib.profiler.ui.components.VerticalLayout;
import org.netbeans.lib.profiler.ui.components.XPStyleBorder;
import org.netbeans.modules.profiler.ui.stp.MonitorSettingsBasicPanel;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TaskChooser
extends JPanel {
    private static final String MORPHER_ACCESS_NAME = NbBundle.getMessage(MonitorSettingsBasicPanel.class, (String)"TaskChooser_MorpherAccessName");
    private static final String MORPHER_ACCESS_DESCR = NbBundle.getMessage(MonitorSettingsBasicPanel.class, (String)"TaskChooser_MorpherAccessDescr");
    private ArrayList items = new ArrayList();
    private Color parentColor;
    private ComponentMorpher expandedMorpher = null;
    private Item expandedItem = null;
    private Vector listeners = new Vector();
    private boolean isSwitching = false;

    public TaskChooser() {
        this(UIManager.getColor("Panel.background"));
    }

    public TaskChooser(Color color) {
        this.parentColor = color;
        this.initComponents();
    }

    public void add(Item item) {
        this.items.add(item);
        super.add((Component)this.createItemMorpher(item));
    }

    public Component add(Component component) {
        throw new RuntimeException("Not implemented for this component");
    }

    public Component add(Component component, int n) {
        throw new RuntimeException("Not implemented for this component");
    }

    public void add(Component component, Object object) {
        throw new RuntimeException("Not implemented for this component");
    }

    public void add(Component component, Object object, int n) {
        throw new RuntimeException("Not implemented for this component");
    }

    public Component add(String string, Component component) {
        throw new RuntimeException("Not implemented for this component");
    }

    public void addItemListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void expand(Item item) {
        this.expandItem(item);
    }

    public void expandImmediately(Item item) {
        this.reset();
        if (item != null) {
            ComponentMorpher componentMorpher = (ComponentMorpher)this.getComponent(this.items.indexOf(item));
            componentMorpher.expand();
            componentMorpher.setFocusable(false);
            ((XPStyleBorder)componentMorpher.getBorder()).setSelected();
            this.refreshLayout();
            this.expandedMorpher = componentMorpher;
            this.expandedItem = item;
        }
    }

    public void refreshLayout() {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            if (!(component instanceof ComponentMorpher)) continue;
            ((ComponentMorpher)component).refreshLayout();
        }
    }

    public void removeItemListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        if (this.expandedMorpher != null) {
            this.expandedMorpher.reset();
            ((XPStyleBorder)this.expandedMorpher.getBorder()).setDefault();
            this.refreshLayout();
            this.expandedMorpher = null;
            this.expandedItem = null;
        }
    }

    private ComponentMorpher createItemMorpher(final Item item) {
        JComponent jComponent = this.setupItemSmallComponent(item);
        JComponent jComponent2 = this.setupItemLargeComponent(item);
        final ComponentMorpher componentMorpher = new ComponentMorpher(jComponent, jComponent2, 6, 10);
        componentMorpher.getAccessibleContext().setAccessibleName(MORPHER_ACCESS_NAME);
        componentMorpher.getAccessibleContext().setAccessibleDescription(MORPHER_ACCESS_DESCR);
        final XPStyleBorder xPStyleBorder = XPStyleBorder.getDefaultInstance((Color)SelectProfilingTask.BACKGROUND_COLOR_INACTIVE, (Color)this.parentColor);
        componentMorpher.setBorder((Border)xPStyleBorder);
        componentMorpher.setFocusable(true);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (xPStyleBorder.isSelected()) {
                    return;
                }
                xPStyleBorder.setFocused();
                componentMorpher.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (xPStyleBorder.isSelected()) {
                    return;
                }
                xPStyleBorder.setDefault();
                componentMorpher.repaint();
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TaskChooser.this.isEnabled()) {
                    return;
                }
                if (mouseEvent.getButton() == 1 && !TaskChooser.this.isSwitching && componentMorpher != TaskChooser.this.expandedMorpher) {
                    TaskChooser.this.expandItem(item);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!TaskChooser.this.isEnabled()) {
                    return;
                }
                if (xPStyleBorder.isSelected() || componentMorpher.isFocusOwner()) {
                    return;
                }
                xPStyleBorder.setFocused();
                if (componentMorpher != TaskChooser.this.expandedMorpher) {
                    componentMorpher.repaint();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (!TaskChooser.this.isEnabled()) {
                    return;
                }
                if (xPStyleBorder.isSelected() || componentMorpher.isFocusOwner()) {
                    return;
                }
                xPStyleBorder.setDefault();
                if (componentMorpher != TaskChooser.this.expandedMorpher) {
                    componentMorpher.repaint();
                }
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32 && !TaskChooser.this.isSwitching && componentMorpher != TaskChooser.this.expandedMorpher) {
                    TaskChooser.this.expandItem(item);
                }
            }
        };
        componentMorpher.addFocusListener(focusListener);
        componentMorpher.addMouseListener((MouseListener)mouseAdapter);
        componentMorpher.addKeyListener((KeyListener)keyAdapter);
        jComponent.getComponent(0).addMouseListener(mouseAdapter);
        return componentMorpher;
    }

    private void expandItem(final Item item) {
        final ComponentMorpher componentMorpher = (ComponentMorpher)this.getComponent(this.items.indexOf(item));
        final ComponentMorpher componentMorpher2 = this.expandedMorpher;
        ((XPStyleBorder)componentMorpher.getBorder()).setSelected();
        if (componentMorpher2 != null) {
            ((XPStyleBorder)componentMorpher2.getBorder()).setDefault();
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskChooser.this.isSwitching = true;
                componentMorpher.setupMorphing();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            TaskChooser.this.fireItemWillExpand(item);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (componentMorpher2 != null) {
                    componentMorpher2.setupMorphing();
                }
                if (TaskChooser.this.expandedItem != null) {
                    TaskChooser.this.fireItemWillCollapse(TaskChooser.this.expandedItem);
                }
                while (componentMorpher.isMorphing() || componentMorpher2 != null && componentMorpher2.isMorphing()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                componentMorpher.morphingStep();
                                if (componentMorpher2 != null) {
                                    componentMorpher2.morphingStep();
                                }
                            }
                        });
                        Thread.sleep(componentMorpher.getMorphingDelay());
                    }
                    catch (Exception exception) {}
                }
                final Item item2 = TaskChooser.this.expandedItem;
                TaskChooser.this.expandedItem = item;
                TaskChooser.this.expandedMorpher = componentMorpher;
                TaskChooser.this.isSwitching = false;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (componentMorpher2 != null) {
                                componentMorpher2.setFocusable(true);
                            }
                            TaskChooser.this.fireItemExpanded(item);
                            TaskChooser.this.fireItemCollapsed(item2);
                            componentMorpher.setFocusable(false);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }, 0, 9);
    }

    private void fireItemCollapsed(Item item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemCollapsed(item);
        }
    }

    private void fireItemExpanded(Item item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemExpanded(item);
        }
    }

    private void fireItemWillCollapse(Item item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemWillCollapse(item);
        }
    }

    private void fireItemWillExpand(Item item) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).itemWillExpand(item);
        }
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout((LayoutManager)new VerticalLayout());
        this.setFocusable(false);
    }

    private JComponent setupItemLargeComponent(Item item) {
        return item.getLargeComponent();
    }

    private JComponent setupItemSmallComponent(Item item) {
        JComponent jComponent = item.getSmallComponent();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new OverlayLayout(jPanel));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        jPanel.setOpaque(true);
        jPanel.setBackground(jComponent.getBackground());
        return jPanel;
    }

    public static interface Listener {
        public void itemCollapsed(Item var1);

        public void itemExpanded(Item var1);

        public void itemWillCollapse(Item var1);

        public void itemWillExpand(Item var1);
    }

    public static interface Item {
        public JComponent getLargeComponent();

        public JComponent getSmallComponent();
    }
}

