/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MemorySettingsAdvancedPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String DO_NOT_OVERRIDE_STRING = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_DoNotOverrideString");
    private static final String CHOOSE_WORKDIR_DIALOG_CAPTION = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_ChooseWorkDirDialogCaption");
    private static final String SETTINGS_CAPTION = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_SettingsCaption");
    private static final String RECORD_TRACES_LABEL_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_RecordTracesLabelText");
    private static final String FULL_STACK_RADIO_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_FullStackRadioText");
    private static final String LIMIT_STACK_RADIO_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_LimitStackRadioText");
    private static final String FRAMES_LABEL_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_FramesLabelText");
    private static final String RUN_GC_CHECKBOX_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_RunGcCheckboxText");
    private static final String THREADS_CAPTION = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_ThreadsCaption");
    private static final String ENABLE_THREADS_CHECKBOX_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_EnableThreadsCheckboxText");
    private static final String GLOBAL_SETTINGS_CAPTION = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_GlobalSettingsCaption");
    private static final String OVERRIDE_SETTINGS_CHECKBOX_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_OverrideSettingsCheckboxText");
    private static final String WORKDIR_LABEL_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_WorkDirLabelText");
    private static final String CHOOSE_WORKDIR_LINK_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_ChooseWorkDirLinkText");
    private static final String JAVA_PLATFORM_LABEL_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_JavaPlatformLabelText");
    private static final String JVM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"MemorySettingsAdvancedPanel_JvmArgumentsLabelText");
    private static final String STP_MONITOR_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpMonitorTooltip");
    private static final String STP_OVERRIDE_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpOverrideTooltip");
    private static final String STP_WORKDIR_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpWorkDirTooltip");
    private static final String STP_JPLATFORM_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpJPlatformTooltip");
    private static final String STP_VMARGS_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpVmArgsTooltip");
    private static final String STP_FULLDEPTH_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpFullDepthTooltip");
    private static final String STP_LIMITDEPTH_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpLimitDepthTooltip");
    private static final String STP_RUNGC_TOOLTIP = NbBundle.getMessage(MemorySettingsAdvancedPanel.class, (String)"StpRunGcTooltip");
    private static final String HELP_CTX_KEY = "MemorySettings.Advanced.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MemorySettings.Advanced.HelpCtx");
    private HyperlinkLabel workingDirectorySelectLink;
    private JCheckBox overrideSettingsCheckbox;
    private JCheckBox runGCCheckbox;
    private JCheckBox threadsMonitoringCheckbox;
    private JComboBox javaPlatformCombo;
    private JLabel defineDepthLabel;
    private JLabel javaPlatformLabel;
    private JLabel recordStackTracesLabel;
    private JLabel vmArgumentsLabel;
    private JLabel workingDirectoryLabel;
    private JPanel globalSettingsPanel;
    private JPanel settingsPanel;
    private JPanel threadsSettingsPanel;
    private JRadioButton definedDepthRadio;
    private JRadioButton fullDepthRadio;
    private JSpinner defineDepthSpinner;
    private JTextField vmArgumentsTextField;
    private JTextField workingDirectoryTextField;
    private WeakReference<JFileChooser> workingDirectoryChooserReference;

    public MemorySettingsAdvancedPanel() {
        this.initComponents();
    }

    public void setAllocStackTraceLimit(int n) {
        if (n <= 0) {
            this.defineDepthSpinner.setValue(n < 0 ? new Integer(-n) : new Integer(10));
            this.fullDepthRadio.setSelected(true);
        } else {
            this.defineDepthSpinner.setValue(new Integer(n));
            this.definedDepthRadio.setSelected(true);
        }
    }

    public int getAllocStackTraceLimit() {
        if (this.fullDepthRadio.isSelected()) {
            int n = -10;
            try {
                n = -((Number)this.defineDepthSpinner.getValue()).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n;
        }
        int n = 10;
        try {
            n = ((Number)this.defineDepthSpinner.getValue()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setJavaPlatformName(String string) {
        this.updateJavaPlatformCombo(string);
    }

    public String getJavaPlatformName() {
        int n = this.javaPlatformCombo.getSelectedIndex();
        if (n == 0) {
            return null;
        }
        return this.javaPlatformCombo.getSelectedItem().toString();
    }

    public void setOverrideAvailable(boolean bl) {
        this.overrideSettingsCheckbox.setEnabled(bl);
        this.workingDirectoryLabel.setEnabled(bl);
        this.workingDirectoryTextField.setEnabled(bl);
        this.workingDirectorySelectLink.setEnabled(bl);
        this.javaPlatformLabel.setEnabled(bl);
        this.javaPlatformCombo.setEnabled(bl);
        this.vmArgumentsLabel.setEnabled(bl);
        this.vmArgumentsTextField.setEnabled(bl);
    }

    public void setOverrideSettings(boolean bl) {
        this.overrideSettingsCheckbox.setSelected(bl);
        this.updateEnabling();
    }

    public boolean getOverrideSettings() {
        return this.overrideSettingsCheckbox.isSelected();
    }

    public void setRecordStackTrace(boolean bl) {
        this.recordStackTracesLabel.setEnabled(bl && this.runGCCheckbox.isEnabled());
        this.fullDepthRadio.setEnabled(bl && this.runGCCheckbox.isEnabled());
        this.definedDepthRadio.setEnabled(bl && this.runGCCheckbox.isEnabled());
        this.defineDepthSpinner.setEnabled(bl && this.runGCCheckbox.isEnabled());
        this.updateEnabling();
    }

    public void setRunGC(boolean bl) {
        this.runGCCheckbox.setSelected(bl);
    }

    public boolean getRunGC() {
        return this.runGCCheckbox.isSelected();
    }

    public void setThreadsMonitoring(boolean bl) {
        this.threadsMonitoringCheckbox.setSelected(bl);
    }

    public boolean getThreadsMonitoring() {
        return this.threadsMonitoringCheckbox.isSelected();
    }

    public void setVMArguments(String string) {
        this.vmArgumentsTextField.setText(string);
    }

    public String getVMArguments() {
        return this.vmArgumentsTextField.getText().trim();
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectoryTextField.setText(string);
    }

    public String getWorkingDirectory() {
        return this.workingDirectoryTextField.getText().trim();
    }

    public void disableAll() {
        this.recordStackTracesLabel.setEnabled(false);
        this.fullDepthRadio.setEnabled(false);
        this.definedDepthRadio.setEnabled(false);
        this.defineDepthSpinner.setEnabled(false);
        this.defineDepthLabel.setEnabled(false);
        this.runGCCheckbox.setEnabled(false);
        this.threadsSettingsPanel.setEnabled(false);
        this.threadsMonitoringCheckbox.setEnabled(false);
        this.globalSettingsPanel.setEnabled(false);
        this.overrideSettingsCheckbox.setEnabled(false);
        this.workingDirectoryLabel.setEnabled(false);
        this.workingDirectoryTextField.setEnabled(false);
        this.workingDirectorySelectLink.setEnabled(false);
        this.javaPlatformLabel.setEnabled(false);
        this.javaPlatformCombo.setEnabled(false);
        this.vmArgumentsLabel.setEnabled(false);
        this.vmArgumentsTextField.setEnabled(false);
    }

    public void enableAll() {
        this.recordStackTracesLabel.setEnabled(true);
        this.fullDepthRadio.setEnabled(true);
        this.definedDepthRadio.setEnabled(true);
        this.defineDepthSpinner.setEnabled(true);
        this.defineDepthLabel.setEnabled(true);
        this.runGCCheckbox.setEnabled(true);
        this.threadsSettingsPanel.setEnabled(true);
        this.threadsMonitoringCheckbox.setEnabled(true);
        this.globalSettingsPanel.setEnabled(true);
        this.overrideSettingsCheckbox.setEnabled(true);
        this.workingDirectoryLabel.setEnabled(true);
        this.workingDirectoryTextField.setEnabled(true);
        this.workingDirectorySelectLink.setEnabled(true);
        this.javaPlatformLabel.setEnabled(true);
        this.javaPlatformCombo.setEnabled(true);
        this.vmArgumentsLabel.setEnabled(true);
        this.vmArgumentsTextField.setEnabled(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Tester Frame");
        MemorySettingsAdvancedPanel memorySettingsAdvancedPanel = new MemorySettingsAdvancedPanel();
        memorySettingsAdvancedPanel.setPreferredSize(new Dimension(375, 255));
        jFrame.getContentPane().add(memorySettingsAdvancedPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private JFileChooser getFileChooser() {
        JFileChooser jFileChooser;
        if (this.workingDirectoryChooserReference == null || this.workingDirectoryChooserReference.get() == null) {
            jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(CHOOSE_WORKDIR_DIALOG_CAPTION);
            this.workingDirectoryChooserReference = new WeakReference<JFileChooser>(jFileChooser);
        } else {
            jFileChooser = (JFileChooser)this.workingDirectoryChooserReference.get();
        }
        return jFileChooser;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.settingsPanel = new JPanel(new GridBagLayout());
        this.settingsPanel.setOpaque(false);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(SETTINGS_CAPTION));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.settingsPanel, gridBagConstraints);
        this.recordStackTracesLabel = new JLabel(RECORD_TRACES_LABEL_TEXT);
        this.recordStackTracesLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.settingsPanel.add((Component)this.recordStackTracesLabel, gridBagConstraints);
        this.fullDepthRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.fullDepthRadio, (String)FULL_STACK_RADIO_TEXT);
        this.fullDepthRadio.setToolTipText(STP_FULLDEPTH_TOOLTIP);
        buttonGroup.add(this.fullDepthRadio);
        this.fullDepthRadio.addActionListener(this.getSettingsChangeListener());
        this.fullDepthRadio.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.settingsPanel.add((Component)this.fullDepthRadio, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.definedDepthRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.definedDepthRadio, (String)LIMIT_STACK_RADIO_TEXT);
        this.definedDepthRadio.setToolTipText(STP_LIMITDEPTH_TOOLTIP);
        buttonGroup.add(this.definedDepthRadio);
        this.definedDepthRadio.setOpaque(false);
        this.definedDepthRadio.setSelected(true);
        this.definedDepthRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MemorySettingsAdvancedPanel.this.updateEnabling();
            }
        });
        this.definedDepthRadio.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.definedDepthRadio, gridBagConstraints);
        this.defineDepthSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(55, Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.defineDepthSpinner.addChangeListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.defineDepthSpinner, gridBagConstraints);
        this.defineDepthLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.defineDepthLabel, (String)FRAMES_LABEL_TEXT);
        this.defineDepthLabel.setLabelFor(this.defineDepthSpinner);
        this.defineDepthSpinner.setToolTipText(STP_LIMITDEPTH_TOOLTIP);
        this.defineDepthLabel.setToolTipText(STP_LIMITDEPTH_TOOLTIP);
        this.defineDepthLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.defineDepthLabel, gridBagConstraints);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 19, 5, 0);
        this.settingsPanel.add((Component)jPanel, gridBagConstraints);
        this.runGCCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.runGCCheckbox, (String)RUN_GC_CHECKBOX_TEXT);
        this.runGCCheckbox.setToolTipText(STP_RUNGC_TOOLTIP);
        this.runGCCheckbox.setOpaque(false);
        this.runGCCheckbox.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 3, 0);
        this.settingsPanel.add((Component)this.runGCCheckbox, gridBagConstraints);
        this.threadsSettingsPanel = new JPanel(new GridBagLayout());
        this.threadsSettingsPanel.setOpaque(false);
        this.threadsSettingsPanel.setBorder(BorderFactory.createTitledBorder(THREADS_CAPTION));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.threadsSettingsPanel, gridBagConstraints);
        this.threadsMonitoringCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.threadsMonitoringCheckbox, (String)ENABLE_THREADS_CHECKBOX_TEXT);
        this.threadsMonitoringCheckbox.setToolTipText(STP_MONITOR_TOOLTIP);
        this.threadsMonitoringCheckbox.setOpaque(false);
        this.threadsMonitoringCheckbox.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 3, 0);
        this.threadsSettingsPanel.add((Component)this.threadsMonitoringCheckbox, gridBagConstraints);
        this.globalSettingsPanel = new JPanel(new GridBagLayout());
        this.globalSettingsPanel.setOpaque(false);
        this.globalSettingsPanel.setBorder(BorderFactory.createTitledBorder(GLOBAL_SETTINGS_CAPTION));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.globalSettingsPanel, gridBagConstraints);
        this.overrideSettingsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.overrideSettingsCheckbox, (String)OVERRIDE_SETTINGS_CHECKBOX_TEXT);
        this.overrideSettingsCheckbox.setToolTipText(STP_OVERRIDE_TOOLTIP);
        this.overrideSettingsCheckbox.setOpaque(false);
        this.overrideSettingsCheckbox.setSelected(true);
        this.overrideSettingsCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MemorySettingsAdvancedPanel.this.updateEnabling();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.globalSettingsPanel.add((Component)this.overrideSettingsCheckbox, gridBagConstraints);
        this.workingDirectoryLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.workingDirectoryLabel, (String)WORKDIR_LABEL_TEXT);
        this.workingDirectoryLabel.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryLabel, gridBagConstraints);
        this.workingDirectoryTextField = new JTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.workingDirectoryLabel.setLabelFor(this.workingDirectoryTextField);
        this.workingDirectoryTextField.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MemorySettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MemorySettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MemorySettingsAdvancedPanel.this.checkWorkingDirectory();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryTextField, gridBagConstraints);
        Color color = Color.RED;
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        this.workingDirectorySelectLink = new HyperlinkLabel("<a href='#'>" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", "<a href='#' color=\"" + string + "\">" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", new Runnable(){

            public void run() {
                JFileChooser jFileChooser = MemorySettingsAdvancedPanel.this.getFileChooser();
                jFileChooser.setCurrentDirectory(new File(MemorySettingsAdvancedPanel.this.workingDirectoryTextField.getText().trim()));
                if (jFileChooser.showOpenDialog(null) == 0) {
                    MemorySettingsAdvancedPanel.this.workingDirectoryTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.workingDirectorySelectLink.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 3);
        this.globalSettingsPanel.add((Component)((Object)this.workingDirectorySelectLink), gridBagConstraints);
        this.javaPlatformLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)JAVA_PLATFORM_LABEL_TEXT);
        this.javaPlatformLabel.setToolTipText(STP_JPLATFORM_TOOLTIP);
        this.javaPlatformLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        this.javaPlatformCombo = new JComboBox(new Object[]{DO_NOT_OVERRIDE_STRING}){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        this.javaPlatformCombo.setToolTipText(STP_JPLATFORM_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        this.vmArgumentsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.vmArgumentsLabel, (String)JVM_ARGUMENTS_LABEL_TEXT);
        this.vmArgumentsLabel.setToolTipText(STP_VMARGS_TOOLTIP);
        this.vmArgumentsLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsLabel, gridBagConstraints);
        this.vmArgumentsTextField = new JTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.vmArgumentsLabel.setLabelFor(this.vmArgumentsTextField);
        this.vmArgumentsTextField.setToolTipText(STP_VMARGS_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
    }

    private void updateEnabling() {
        this.defineDepthSpinner.setEnabled(this.definedDepthRadio.isSelected() && this.recordStackTracesLabel.isEnabled());
        this.defineDepthLabel.setEnabled(this.definedDepthRadio.isSelected() && this.recordStackTracesLabel.isEnabled());
        boolean bl = this.overrideSettingsCheckbox.isSelected() && this.overrideSettingsCheckbox.isEnabled();
        this.workingDirectoryLabel.setEnabled(bl);
        this.workingDirectoryTextField.setEnabled(bl);
        this.workingDirectorySelectLink.setEnabled(bl);
        this.javaPlatformLabel.setEnabled(bl);
        this.javaPlatformCombo.setEnabled(bl);
        this.vmArgumentsLabel.setEnabled(bl);
        this.vmArgumentsTextField.setEnabled(bl);
    }

    private void checkWorkingDirectory() {
        String string = this.workingDirectoryTextField.getText().trim();
        if (string.length() == 0 || new File(string).exists()) {
            this.workingDirectoryTextField.setForeground(UIManager.getColor("TextField.foreground"));
        } else {
            this.workingDirectoryTextField.setForeground(Color.RED);
        }
    }

    private void updateJavaPlatformCombo(String string) {
        List list = JavaPlatformSelector.getSupportedPlatforms();
        String[] stringArray = new String[list.size() + 1];
        stringArray[0] = DO_NOT_OVERRIDE_STRING;
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = ((JavaPlatform)list.get(i - 1)).getDisplayName();
        }
        this.javaPlatformCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (string != null) {
            this.javaPlatformCombo.setSelectedItem(string);
        } else {
            this.javaPlatformCombo.setSelectedIndex(0);
        }
    }
}

