/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.ContextAware;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.CompositeCPUCCTWalker;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.CategoryCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.openide.util.NbBundle;

public class MergedCategoryTrackerPanel
extends StatisticalModule
implements ContextAware {
    private static final String NO_METHOD_LABEL_TEXT = NbBundle.getMessage(MergedCategoryTrackerPanel.class, (String)"MergedCategoryTrackerPanel_NoMethodLabelText");
    private static final String NO_DATA_LABEL_TEXT = NbBundle.getMessage(MergedCategoryTrackerPanel.class, (String)"MergedCategoryTrackerPanel_NoDataLabelText");
    private static final String METHOD_CATEGORIES_STRING = NbBundle.getMessage(MergedCategoryTrackerPanel.class, (String)"MergedCategoryTrackerPanel_MethodCategoriesString");
    private static final String DESCR_STRING = NbBundle.getMessage(MergedCategoryTrackerPanel.class, (String)"MergedCategoryTrackerPanel_DescrString");
    private CompositeCPUCCTWalker treeWalker;
    private JLabel noData = new JLabel(NO_DATA_LABEL_TEXT);
    private JLabel noMethods = new JLabel(NO_METHOD_LABEL_TEXT);
    private Map<Integer, List<CategoryCPUCCTNode>> pathMap = new HashMap<Integer, List<CategoryCPUCCTNode>>();
    private MergedCategoryTrackerModel model;
    private RuntimeCPUCCTNode lastAppNode = null;

    public MergedCategoryTrackerPanel() {
        this.initComponents();
    }

    public void setContext(ProfilerClient profilerClient) {
        this.model = new MergedCategoryTrackerModel();
        this.treeWalker = new CompositeCPUCCTWalker();
        this.treeWalker.add(0, (CPUCCTVisitor)this.model);
    }

    public void setSelectedMethodId(int n) {
        int n2 = this.getSelectedMethodId();
        super.setSelectedMethodId(n);
        if (n2 != n) {
            n2 = n;
            this.refresh(this.lastAppNode);
        }
    }

    public void refresh(RuntimeCPUCCTNode runtimeCPUCCTNode) {
        if (runtimeCPUCCTNode == null) {
            return;
        }
        if (this.model != null) {
            runtimeCPUCCTNode.accept((RuntimeCPUCCTNodeVisitor)this.treeWalker);
            this.lastAppNode = runtimeCPUCCTNode;
        }
    }

    private void initComponents() {
        BoxLayout boxLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(boxLayout);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setName(METHOD_CATEGORIES_STRING);
        this.setToolTipText(DESCR_STRING);
        this.noMethods.setOpaque(false);
        this.noMethods.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noMethods.getBorder()));
        this.noData.setOpaque(false);
        this.noData.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noData.getBorder()));
        this.add(this.noMethods);
    }

    private void refreshData() {
        Set<String> set;
        if (this.model == null) {
            return;
        }
        Runnable runnable = null;
        runnable = this.getSelectedMethodId() == -1 ? new Runnable(){

            public void run() {
                MergedCategoryTrackerPanel.this.removeAll();
                MergedCategoryTrackerPanel.this.add(MergedCategoryTrackerPanel.this.noMethods);
                MergedCategoryTrackerPanel.this.revalidate();
                MergedCategoryTrackerPanel.this.repaint();
            }
        } : ((set = this.model.getPaths(this.getSelectedMethodId())) == null || set.isEmpty() ? new Runnable(){

            public void run() {
                MergedCategoryTrackerPanel.this.removeAll();
                MergedCategoryTrackerPanel.this.add(MergedCategoryTrackerPanel.this.noData);
                MergedCategoryTrackerPanel.this.revalidate();
                MergedCategoryTrackerPanel.this.repaint();
            }
        } : new Runnable(){

            public void run() {
                MergedCategoryTrackerPanel.this.removeAll();
                for (String string : set) {
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.setOpaque(false);
                    JLabel jLabel = new JLabel(string);
                    jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), jLabel.getBorder()));
                    jLabel.setOpaque(false);
                    jPanel.add((Component)jLabel, "West");
                    MergedCategoryTrackerPanel.this.add(jPanel);
                }
                MergedCategoryTrackerPanel.this.revalidate();
                MergedCategoryTrackerPanel.this.repaint();
            }
        });
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MergedCategoryTrackerModel
    extends CPUCCTVisitorAdapter {
        private final Set<String> EMPTY_SET = new HashSet<String>();
        private Collection<String> categories = new ArrayList<String>();
        private ReadWriteLock lock = new ReentrantReadWriteLock();
        private boolean inCalculation = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getPaths(int n) {
            this.lock.readLock().lock();
            try {
                HashSet<String> hashSet = new HashSet<String>(this.categories);
                return hashSet;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void afterWalk() {
            this.lock.writeLock().unlock();
            MergedCategoryTrackerPanel.this.refreshData();
        }

        public void beforeWalk() {
            this.lock.writeLock().lock();
            this.categories.clear();
        }

        public void visit(MethodCPUCCTNode methodCPUCCTNode) {
            if (methodCPUCCTNode.getMethodId() == MergedCategoryTrackerPanel.this.getSelectedMethodId()) {
                this.inCalculation = true;
            }
        }

        public void visitPost(CategoryCPUCCTNode categoryCPUCCTNode) {
            if (this.inCalculation) {
                this.categories.add(categoryCPUCCTNode.getMark().getDescription());
            }
        }

        public void visitPost(MethodCPUCCTNode methodCPUCCTNode) {
            if (methodCPUCCTNode.getMethodId() == MergedCategoryTrackerPanel.this.getSelectedMethodId()) {
                this.inCalculation = false;
            }
        }
    }
}

