/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.TimedGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TimeCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener {
    private static final String UNITS_MINUTES = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_UnitsMinutes");
    private static final String UNITS_HOURS = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_UnitsHours");
    private static final String TAKE_AT_LABEL_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TakeAtLabelText");
    private static final String NOW_BUTTON_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_NowButtonText");
    private static final String TODAY_BUTTON_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TodayButtonText");
    private static final String TAKE_ONCE_RADIO_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TakeOnceRadioText");
    private static final String TAKE_EVERY_RADIO_TEXT = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TakeEveryRadioText");
    private static final String TIME_FIELD_ACCESS_NAME = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_TimeFieldAccessName");
    private static final String DATE_FIELD_ACCESS_NAME = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_DateFieldAccessName");
    private static final String FREQUENCY_COMBO_ACCESS_NAME = NbBundle.getMessage(TimeCustomizer.class, (String)"TimeCustomizer_FrequencyComboAccessName");
    private static final DateFormat TIME_FORMAT = DateFormat.getTimeInstance();
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance();
    private static int defaultTextComponentHeight = -1;
    private Color TEXT_FOREGROUND;
    private JButton timeTakeAtButton;
    private JButton timeTakeAtDateButton;
    private JComboBox timeFrequencyCombo;
    private JLabel timeTakeAtLabel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton timeFrequencyRadio;
    private JRadioButton timeOnceRadio;
    private JSpinner timeFrequencySpinner;
    private JTextField timeTakeAtDateField;
    private JTextField timeTakeAtField;

    public TimeCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return -1;
    }

    public void setTimeCondition(TimedGlobalProfilingPoint.TimeCondition timeCondition) {
        this.timeTakeAtField.setText(TIME_FORMAT.format(new Date(timeCondition.getStartTime())));
        this.timeTakeAtDateField.setText(DATE_FORMAT.format(new Date(timeCondition.getStartTime())));
        this.timeOnceRadio.setSelected(!timeCondition.getRepeats());
        this.timeFrequencyRadio.setSelected(timeCondition.getRepeats());
        this.timeFrequencySpinner.setValue(timeCondition.getPeriodTime());
        switch (timeCondition.getPeriodUnits()) {
            case 1: {
                this.timeFrequencyCombo.setSelectedItem(UNITS_MINUTES);
                break;
            }
            case 2: {
                this.timeFrequencyCombo.setSelectedItem(UNITS_HOURS);
                break;
            }
        }
    }

    public TimedGlobalProfilingPoint.TimeCondition getTimeCondition() {
        TimedGlobalProfilingPoint.TimeCondition timeCondition = new TimedGlobalProfilingPoint.TimeCondition();
        Date date = null;
        try {
            date = TIME_FORMAT.parse(this.timeTakeAtField.getText());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Date date2 = null;
        try {
            date2 = DATE_FORMAT.parse(this.timeTakeAtDateField.getText());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date == null || date2 == null) {
            return null;
        }
        timeCondition.setStartTime(date.getTime() + date2.getTime() + (long)Calendar.getInstance().get(15));
        timeCondition.setRepeats(this.timeFrequencyRadio.isSelected());
        timeCondition.setPeriodTime((Integer)this.timeFrequencySpinner.getValue());
        if (this.timeFrequencyCombo.getSelectedItem() == UNITS_MINUTES) {
            timeCondition.setPeriodUnits(1);
        } else if (this.timeFrequencyCombo.getSelectedItem() == UNITS_HOURS) {
            timeCondition.setPeriodUnits(2);
        }
        return timeCondition;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timeTakeAtButton) {
            this.timeTakeAtField.setText(TIME_FORMAT.format(new Date(System.currentTimeMillis())));
        } else if (actionEvent.getSource() == this.timeTakeAtDateButton) {
            this.timeTakeAtDateField.setText(DATE_FORMAT.format(new Date(System.currentTimeMillis())));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TimeCustomizer timeCustomizer = new TimeCustomizer();
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(timeCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.timeFrequencyRadio) {
            this.timeFrequencySpinner.setEnabled(this.timeFrequencyRadio.isSelected());
            this.timeFrequencyCombo.setEnabled(this.timeFrequencyRadio.isSelected());
        }
    }

    private boolean checkDate() {
        try {
            Date date = DATE_FORMAT.parse(this.timeTakeAtDateField.getText());
            this.timeTakeAtDateField.setForeground(this.TEXT_FOREGROUND);
            return true;
        }
        catch (ParseException parseException) {
            this.timeTakeAtDateField.setForeground(Color.RED);
            return false;
        }
    }

    private boolean checkTime() {
        try {
            Date date = TIME_FORMAT.parse(this.timeTakeAtField.getText());
            this.timeTakeAtField.setForeground(this.TEXT_FOREGROUND);
            return true;
        }
        catch (ParseException parseException) {
            this.timeTakeAtField.setForeground(Color.RED);
            return false;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.timeTakeAtLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.timeTakeAtLabel, (String)TAKE_AT_LABEL_TEXT);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.timeTakeAtLabel, gridBagConstraints);
        this.timeTakeAtField = new JTextField(){

            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.timeTakeAtField.getAccessibleContext().setAccessibleName(TIME_FIELD_ACCESS_NAME);
        this.timeTakeAtLabel.setLabelFor(this.timeTakeAtField);
        this.timeTakeAtField.getDocument().addDocumentListener(this);
        this.timeTakeAtField.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.timeTakeAtField, gridBagConstraints);
        this.timeTakeAtButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeTakeAtButton, (String)NOW_BUTTON_TEXT);
        this.timeTakeAtButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)this.timeTakeAtButton, gridBagConstraints);
        this.timeTakeAtDateField = new JTextField(){

            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.timeTakeAtDateField.getAccessibleContext().setAccessibleName(DATE_FIELD_ACCESS_NAME);
        this.timeTakeAtDateField.getDocument().addDocumentListener(this);
        this.timeTakeAtDateField.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.timeTakeAtDateField, gridBagConstraints);
        this.timeTakeAtDateButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeTakeAtDateButton, (String)TODAY_BUTTON_TEXT);
        this.timeTakeAtDateButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.timeTakeAtDateButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)jPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.timeOnceRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeOnceRadio, (String)TAKE_ONCE_RADIO_TEXT);
        buttonGroup.add(this.timeOnceRadio);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.timeOnceRadio, gridBagConstraints);
        this.timeFrequencyRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.timeFrequencyRadio, (String)TAKE_EVERY_RADIO_TEXT);
        buttonGroup.add(this.timeFrequencyRadio);
        this.timeFrequencyRadio.setSelected(true);
        this.timeFrequencyRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.timeFrequencyRadio, gridBagConstraints);
        this.timeFrequencySpinner = new JExtendedSpinner(new SpinnerNumberModel(1, 1, 9999, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.timeFrequencySpinner, gridBagConstraints);
        this.timeFrequencyCombo = new JComboBox(new Object[]{UNITS_MINUTES, UNITS_HOURS}){

            public Dimension getPreferredSize() {
                return new Dimension(Math.min(super.getPreferredSize().width, 200), super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.timeFrequencyCombo.getAccessibleContext().setAccessibleName(FREQUENCY_COMBO_ACCESS_NAME);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.timeFrequencyCombo, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints);
        this.TEXT_FOREGROUND = this.timeTakeAtDateField.getForeground();
    }

    private void updateValidity() {
        boolean bl;
        boolean bl2 = this.checkTime();
        boolean bl3 = this.checkDate();
        boolean bl4 = bl = bl2 && bl3;
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }
}

