/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Dialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.GlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointWizard;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class InsertProfilingPointAction
extends NodeAction {
    private static final String ACTION_NAME = NbBundle.getMessage(InsertProfilingPointAction.class, (String)"InsertProfilingPointAction_ActionName");
    private static final String PROFILING_IN_PROGRESS_MSG = NbBundle.getMessage(InsertProfilingPointAction.class, (String)"InsertProfilingPointAction_ProfilingInProgressMsg");
    private static final String NO_PROJECT_MSG = NbBundle.getMessage(InsertProfilingPointAction.class, (String)"InsertProfilingPointAction_NoProjectMsg");

    public InsertProfilingPointAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(InsertProfilingPointAction.class);
    }

    public String getName() {
        return ACTION_NAME;
    }

    public void performAction(Project project) {
        if (ProfilingPointsManager.getDefault().isProfilingSessionInProgress()) {
            NetBeansProfiler.getDefaultNB().displayWarning(PROFILING_IN_PROGRESS_MSG);
            return;
        }
        if (ProjectUtilities.getOpenedProjects().length == 0) {
            NetBeansProfiler.getDefaultNB().displayWarning(NO_PROJECT_MSG);
            return;
        }
        ProfilingPointWizard profilingPointWizard = ProfilingPointWizard.getDefault();
        WizardDescriptor wizardDescriptor = profilingPointWizard.getWizardDescriptor(project);
        if (wizardDescriptor != null) {
            Dialog dialog = ProfilerDialogs.createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setVisible(true);
            ProfilingPoint profilingPoint = profilingPointWizard.finish();
            if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
                ProfilingPointsManager.getDefault().addProfilingPoint(profilingPoint);
                if (profilingPoint instanceof GlobalProfilingPoint) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (!ProfilingPointsWindow.getInstance().isOpened()) {
                                ProfilingPointsWindow.getInstance().open();
                                ProfilingPointsWindow.getInstance().requestVisible();
                            }
                        }
                    });
                }
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        this.performAction((Project)null);
    }
}

