/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.TriggeredTakeSnapshotProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.TriggeredTakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class TriggeredTakeSnapshotProfilingPoint
extends TriggeredGlobalProfilingPoint
implements PropertyChangeListener {
    private static final String NO_DATA_AVAILABLE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoDataAvailableMsg");
    private static final String NO_DATA_REMOTE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoDataRemoteMsg");
    private static final String NO_DATA_JDK_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoDataJdkMsg");
    private static final String ONE_HIT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoResultsString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderProjectString");
    private static final String HEADER_MODE_DATA_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderModeDataString");
    private static final String HEADER_MODE_DUMP_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderModeDumpString");
    private static final String HEADER_TARGET_PROJECT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderTargetProjectString");
    private static final String HEADER_TARGET_CUSTOM_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderTargetCustomString");
    private static final String HEADER_RESET_RESULTS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderResetResultsString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeaderHitsString");
    private static final String OPEN_SNAPSHOT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_OpenSnapshotString");
    private static final String USED_HEAP_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_UsedHeapResultString");
    private static final String HEAP_USAGE_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HeapUsageResultString");
    private static final String SURVGEN_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_SurvGenResultString");
    private static final String LOADED_CLASSES_RESULT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_LoadedClassesResultString");
    private static final String HIT_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_HitString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_SnapshotNotAvailableMsg");
    private static final String DATA_STRING = NbBundle.getMessage(TriggeredTakeSnapshotProfilingPoint.class, (String)"TriggeredTakeSnapshotProfilingPoint_DataString");
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private List<Result> results = new ArrayList<Result>();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TriggeredTakeSnapshotProfilingPoint(String string, Project project) {
        super(string, project);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public ProfilingPointFactory getFactory() {
        return TriggeredTakeSnapshotProfilingPointFactory.getDefault();
    }

    public void setResetResults(boolean bl) {
        if (this.resetResults == bl) {
            return;
        }
        this.resetResults = bl;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String string) {
        if (string == null || !new File(string).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(string))) {
            return;
        }
        String string2 = this.snapshotFile;
        this.snapshotFile = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, string2, string);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String string) {
        if (!string.equals(TARGET_PROJECT_KEY) && !string.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + string);
        }
        if (this.snapshotTarget.equals(string)) {
            return;
        }
        String string2 = this.snapshotTarget;
        this.snapshotTarget = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, string2, string);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String string) {
        if (string == null || !string.equals(TYPE_PROFDATA_KEY) && !string.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + string);
        }
        if (this.snapshotType.equals(string)) {
            return;
        }
        String string2 = this.snapshotType;
        this.snapshotType = string;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, string2, string);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    public boolean hasResults() {
        return !this.results.isEmpty();
    }

    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TriggeredTakeSnapshotProfilingPoint.this.hasReport()) {
                    TriggeredTakeSnapshotProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.hasReport()) {
            if (propertyChangeEvent.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    public void showResults(URL uRL) {
        Report report = this.getReport();
        report.open();
        report.requestActive();
    }

    protected String getResultsText() {
        if (this.hasResults()) {
            int n = this.results.size();
            return n == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatLocalProfilingPointTime(this.results.get(n - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, n, Utils.formatLocalProfilingPointTime(this.results.get(n - 1).getTimestamp()));
        }
        return NO_RESULTS_STRING;
    }

    protected void updateCustomizer(ValidityAwarePanel validityAwarePanel) {
        TriggeredTakeSnapshotCustomizer triggeredTakeSnapshotCustomizer = (TriggeredTakeSnapshotCustomizer)validityAwarePanel;
        triggeredTakeSnapshotCustomizer.setPPName(this.getName());
        triggeredTakeSnapshotCustomizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        triggeredTakeSnapshotCustomizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        triggeredTakeSnapshotCustomizer.setPPFile(this.getSnapshotFile());
        triggeredTakeSnapshotCustomizer.setPPResetResults(this.getResetResults());
        triggeredTakeSnapshotCustomizer.setTriggerCondition(this.getCondition());
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return IDEUtils.getProjectSettingsFolder(this.getProject(), true);
        }
        File file = new File(this.snapshotFile);
        file.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
    }

    void setValues(ValidityAwarePanel validityAwarePanel) {
        TriggeredTakeSnapshotCustomizer triggeredTakeSnapshotCustomizer = (TriggeredTakeSnapshotCustomizer)validityAwarePanel;
        this.setName(triggeredTakeSnapshotCustomizer.getPPName());
        this.setSnapshotType(triggeredTakeSnapshotCustomizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(triggeredTakeSnapshotCustomizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(triggeredTakeSnapshotCustomizer.getPPFile());
        this.setResetResults(triggeredTakeSnapshotCustomizer.getPPResetResults());
        this.setCondition(triggeredTakeSnapshotCustomizer.getTriggerCondition());
    }

    void hit(long l) {
        String string;
        long l2 = System.currentTimeMillis();
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            string = this.takeHeapdumpHit();
        } else {
            string = this.takeSnapshotHit();
            if (this.getResetResults()) {
                try {
                    ResultsManager.getDefault().reset();
                    TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
                    if (targetAppRunner.targetJVMIsAlive()) {
                        targetAppRunner.resetTimers();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
            }
        }
        this.results.add(new Result(l2, l, string));
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    void reset() {
        boolean bl = this.hasResults();
        this.results.clear();
        if (bl) {
            this.getChangeSupport().firePropertyChange("p_results", false, true);
        }
    }

    private String getCurrentHeapDumpFilename() {
        try {
            String string = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject fileObject = this.getSnapshotDirectory();
            return FileUtil.toFile((FileObject)fileObject).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)fileObject, (String)string, (String)"hprof") + "." + "hprof";
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private String takeHeapdumpHit() {
        TargetAppRunner targetAppRunner = Profiler.getDefault().getTargetAppRunner();
        if (targetAppRunner.getProfilingSessionStatus().remoteProfiling) {
            return NO_DATA_REMOTE_MSG;
        }
        if (!targetAppRunner.hasSupportedJDKForHeapDump()) {
            return NO_DATA_JDK_MSG;
        }
        String string = this.getCurrentHeapDumpFilename();
        if (string == null) {
            return NO_DATA_AVAILABLE_MSG;
        }
        boolean bl = false;
        try {
            bl = targetAppRunner.getProfilerClient().takeHeapDump(string);
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
        if (bl) {
            ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            try {
                return new File(string).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                ProfilerLogger.log((Exception)malformedURLException);
                return NO_DATA_AVAILABLE_MSG;
            }
        }
        return NO_DATA_AVAILABLE_MSG;
    }

    private static LoadedSnapshot takeSnapshot() {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String string = null;
        loadedSnapshot = TriggeredTakeSnapshotProfilingPoint.takeSnapshot();
        if (loadedSnapshot != null) {
            try {
                FileObject fileObject = this.getSnapshotDirectory();
                FileObject fileObject2 = fileObject.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, fileObject2);
                string = FileUtil.toFile((FileObject)fileObject2).toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            }
        }
        return string == null ? NO_DATA_AVAILABLE_MSG : string;
    }

    private static class Result {
        private final String resultString;
        private final long hitValue;
        private final long timestamp;

        public Result(long l, long l2, String string) {
            this.timestamp = l;
            this.hitValue = l2;
            this.resultString = string;
        }

        public long getHitValue() {
            return this.hitValue;
        }

        public String getResultString() {
            return this.resultString;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Report
    extends TopComponent {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        void refreshData() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getHeaderName());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderType());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderEnabled());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderProject());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderMode());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderTarget());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderResetResults());
            stringBuilder.append("<br>");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(stringBuilder.toString());
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!TriggeredTakeSnapshotProfilingPoint.this.hasResults()) {
                stringBuilder2.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
            } else {
                for (int i = 0; i < TriggeredTakeSnapshotProfilingPoint.this.results.size(); ++i) {
                    stringBuilder2.append("&nbsp;&nbsp;");
                    stringBuilder2.append(this.getDataResultItem(i));
                    stringBuilder2.append("<br>");
                }
            }
            this.dataArea.setText(stringBuilder2.toString());
        }

        void refreshProperties() {
            this.setName(TriggeredTakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TriggeredTakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        private String getDataResultItem(int n) {
            Result result = (Result)TriggeredTakeSnapshotProfilingPoint.this.results.get(n);
            String string = result.getResultString();
            String string2 = string.startsWith(TriggeredTakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + string + "'>" + OPEN_SNAPSHOT_STRING + "</a>" : string;
            String string3 = "";
            if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 2) {
                string3 = MessageFormat.format(USED_HEAP_RESULT_STRING, Float.valueOf((float)result.getHitValue() / 1048576.0f));
            } else if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 1) {
                string3 = MessageFormat.format(HEAP_USAGE_RESULT_STRING, result.getHitValue());
            } else if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 3) {
                string3 = MessageFormat.format(SURVGEN_RESULT_STRING, result.getHitValue());
            } else if (TriggeredTakeSnapshotProfilingPoint.this.getCondition().getMetric() == 4) {
                string3 = MessageFormat.format(LOADED_CLASSES_RESULT_STRING, result.getHitValue());
            }
            return MessageFormat.format(HIT_STRING, n + 1, Utils.formatLocalProfilingPointTime(result.getTimestamp()), string2, string3);
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, TriggeredTakeSnapshotProfilingPoint.this.isEnabled());
        }

        private String getHeaderHitsCount() {
            return MessageFormat.format(HEADER_HITS_STRING, TriggeredTakeSnapshotProfilingPoint.this.results.size());
        }

        private String getHeaderMode() {
            return TriggeredTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TriggeredTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? HEADER_MODE_DATA_STRING : HEADER_MODE_DUMP_STRING;
        }

        private String getHeaderName() {
            return "<h2><b>" + TriggeredTakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)TriggeredTakeSnapshotProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderResetResults() {
            return MessageFormat.format(HEADER_RESET_RESULTS_STRING, TriggeredTakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TriggeredTakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TriggeredTakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? HEADER_TARGET_PROJECT_STRING : MessageFormat.format(HEADER_TARGET_PROJECT_STRING, TriggeredTakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, TriggeredTakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.setOpaque(true);
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea();
            JScrollPane jScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)jScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    File file = null;
                    try {
                        file = new File(uRL.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                    final File file2 = file;
                    if (file2 != null && file2.exists()) {
                        if (TriggeredTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TriggeredTakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY)) {
                            LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)file2));
                            ResultsManager.getDefault().openSnapshot(loadedSnapshot);
                        } else if (TriggeredTakeSnapshotProfilingPoint.this.getSnapshotType().equals(TriggeredTakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                public void run() {
                                    HeapWalkerManager.getDefault().openHeapWalker(file2);
                                }
                            });
                        }
                    } else {
                        NetBeansProfiler.getDefaultNB().displayWarning(SNAPSHOT_NOT_AVAILABLE_MSG);
                    }
                }
            };
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder titledBorder = new TitledBorder(DATA_STRING);
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1));
            titledBorder.setTitleColor(UIManager.getColor("Label.foreground"));
            jScrollPane2.setBorder(titledBorder);
            jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane2.setBackground(UIUtils.getProfilerResultsBackground());
            jPanel.add((Component)jScrollPane2, "Center");
            this.add(jPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }
}

