/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class BrowserUtils {
    private static final String OUT_OF_MEMORY_MSG = NbBundle.getMessage(BrowserUtils.class, (String)"BrowserUtils_OutOfMemoryMsg");
    public static ImageIcon ICON_INSTANCE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/instance.png"));
    public static ImageIcon ICON_PRIMITIVE = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/primitive.png"));
    public static ImageIcon ICON_ARRAY = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/array.png"));
    public static ImageIcon ICON_PROGRESS = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/progress.png"));
    public static ImageIcon ICON_STATIC = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/static.png"));
    public static ImageIcon ICON_LOOP = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/loop.png"));
    public static ImageIcon ICON_GCROOT = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/gcRoot.png"));
    private static RequestProcessor requestProcessor = new RequestProcessor("HeapWalker Processor", 3);

    public static String getArrayItemType(String string) {
        int n = string.lastIndexOf("[");
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getFullNodeName(HeapWalkerNode heapWalkerNode) {
        if (heapWalkerNode.isRoot()) {
            return BrowserUtils.getNodeName(heapWalkerNode);
        }
        return BrowserUtils.getFullNodeName(heapWalkerNode.getParent()) + "." + BrowserUtils.getNodeName(heapWalkerNode);
    }

    public static GroupingInfo getGroupingInfo(int n) {
        int n2 = n;
        int n3 = HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE;
        int n4 = (int)Math.ceil((float)n2 / (float)n3);
        while (n4 > HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_THRESHOLD && n3 < HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_THRESHOLD) {
            n4 = (int)Math.ceil((float)n2 / (float)(n3 += HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE));
        }
        return new GroupingInfo(n4, n3);
    }

    public static HeapWalkerNode getRoot(HeapWalkerNode heapWalkerNode) {
        while (heapWalkerNode != null && !heapWalkerNode.isRoot()) {
            heapWalkerNode = heapWalkerNode.getParent();
        }
        return heapWalkerNode == null ? null : heapWalkerNode;
    }

    public static String getSimpleType(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        if (string.startsWith("<")) {
            return "<" + string.substring(n + 1);
        }
        return string.substring(n + 1);
    }

    public static boolean isStaticField(FieldValue fieldValue) {
        return fieldValue.getField().isStatic();
    }

    public static HeapWalkerNode computeChildrenToNearestGCRoot(InstanceNode instanceNode) {
        Instance instance = instanceNode.getInstance();
        Instance instance2 = instance.getNearestGCRootPointer();
        while (!instance.equals(instance2)) {
            HeapWalkerNode[] heapWalkerNodeArray;
            if (instance2 == null) {
                instanceNode = null;
                break;
            }
            if (instanceNode.currentlyHasChildren()) {
                heapWalkerNodeArray = instanceNode.getChildren();
            } else {
                heapWalkerNodeArray = instanceNode.getChildrenComputer().computeChildren();
                instanceNode.setChildren(heapWalkerNodeArray);
            }
            instanceNode = null;
            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                InstanceNode instanceNode2 = (InstanceNode)heapWalkerNodeArray[i];
                if (!instanceNode2.getInstance().equals(instance2)) continue;
                instanceNode = instanceNode2;
                break;
            }
            instance = instance2;
            instance2 = instance2.getNearestGCRootPointer();
        }
        return instanceNode;
    }

    public static ImageIcon createGCRootIcon(ImageIcon imageIcon) {
        return new ImageIcon(Utilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_GCROOT.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createLoopIcon(ImageIcon imageIcon) {
        return new ImageIcon(Utilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_LOOP.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createStaticIcon(ImageIcon imageIcon) {
        return new ImageIcon(Utilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_STATIC.getImage(), (int)0, (int)0));
    }

    public static HeapWalkerNode[] lazilyCreateChildren(final HeapWalkerNode heapWalkerNode, final ChildrenComputer childrenComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    public void run() {
                        if (heapWalkerNode instanceof AbstractHeapWalkerNode) {
                            boolean bl = false;
                            try {
                                HeapWalkerNode[] heapWalkerNodeArray = childrenComputer.computeChildren();
                                ((AbstractHeapWalkerNode)heapWalkerNode).changeChildren(heapWalkerNodeArray);
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                bl = true;
                                HeapWalkerNode[] heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createOOMNode(heapWalkerNode)};
                                ((AbstractHeapWalkerNode)heapWalkerNode).changeChildren(heapWalkerNodeArray);
                            }
                            HeapWalkerNode heapWalkerNode = BrowserUtils.getRoot(heapWalkerNode);
                            if (heapWalkerNode instanceof RootNode) {
                                ((RootNode)((Object)heapWalkerNode)).refreshView();
                            }
                            if (bl) {
                                NetBeansProfiler.getDefaultNB().displayError(OUT_OF_MEMORY_MSG);
                            }
                        }
                    }
                });
            }
        });
        return new HeapWalkerNode[]{HeapWalkerNodeFactory.createProgressNode(heapWalkerNode)};
    }

    public static void performTask(Runnable runnable) {
        requestProcessor.post(runnable);
    }

    private static String getNodeName(HeapWalkerNode heapWalkerNode) {
        String string = heapWalkerNode.getName();
        if (string.endsWith(")")) {
            string = string.substring(0, string.indexOf("(")).trim();
        }
        return string;
    }

    public static class GroupingInfo {
        public int collapseUnitSize;
        public int containersCount;

        GroupingInfo(int n, int n2) {
            this.containersCount = n;
            this.collapseUnitSize = n2;
        }
    }
}

