/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.AnalysisControllerUI;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisController
extends AbstractTopLevelController
implements NavigationHistoryManager.NavigationHistoryCapable {
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private HeapFragmentWalker heapFragmentWalker;
    private List<Rule> rules = null;
    private MemoryLint runningMemoryLint;
    private boolean analysisRunning = false;

    public AnalysisController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
    }

    public boolean isAnalysisRunning() {
        return this.analysisRunning;
    }

    @Override
    public NavigationHistoryManager.Configuration getCurrentConfiguration() {
        return new NavigationHistoryManager.Configuration();
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule>(MemoryLint.createRules());
        }
        return this.rules;
    }

    public void cancelAnalysis() {
        if (this.runningMemoryLint != null) {
            this.runningMemoryLint.interrupt();
            this.analysisRunning = false;
            this.runningMemoryLint = null;
        }
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        this.heapFragmentWalker.switchToHistoryAnalysisView();
    }

    public BoundedRangeModel performAnalysis(boolean[] blArray) {
        final ArrayList<Rule> arrayList = new ArrayList<Rule>();
        List<Rule> list = this.getRules();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            arrayList.add(list.get(i));
        }
        if (arrayList.size() > 0) {
            MemoryLint memoryLint;
            this.analysisRunning = true;
            this.runningMemoryLint = memoryLint = new MemoryLint(this.heapFragmentWalker.getHeapFragment());
            BrowserUtils.performTask(new Runnable(){

                public void run() {
                    try {
                        memoryLint.process(arrayList);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().log(65536, exception.getMessage());
                    }
                    AnalysisController.this.rules = null;
                    AnalysisController.this.analysisRunning = false;
                    AnalysisController.this.runningMemoryLint = null;
                    AnalysisControllerUI analysisControllerUI = (AnalysisControllerUI)AnalysisController.this.getPanel();
                    analysisControllerUI.displayNewRules();
                    if (!memoryLint.isInterruped()) {
                        analysisControllerUI.setResult(memoryLint.getResults());
                    }
                }
            });
            return memoryLint.getGlobalProgress();
        }
        return null;
    }

    public void showURL(URL uRL) {
        String string = uRL.toString();
        if (string.startsWith("file://instance/")) {
            string = string.substring("file://instance/".length());
            String[] stringArray = string.split("/");
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(stringArray[0]);
            if (javaClass != null) {
                List list = javaClass.getInstances();
                Instance instance = null;
                int n = Integer.parseInt(stringArray[1]);
                if (n <= list.size()) {
                    instance = (Instance)list.get(n - 1);
                }
                if (instance != null) {
                    this.heapFragmentWalker.getClassesController().showInstance(instance);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, stringArray[1], javaClass.getName()));
                }
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, stringArray[0]));
            }
        } else if (string.startsWith("file://class/")) {
            string = string.substring("file://class/".length());
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(string);
            if (javaClass != null) {
                this.heapFragmentWalker.getClassesController().showClass(javaClass);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, string));
            }
        }
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[0];
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((AnalysisControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new AnalysisControllerUI(this);
    }
}

