/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.panels.SelectRootMethodsForClassPanel;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class SelectRootMethodsAction
extends NodeAction {
    private static final String NO_CLASS_FOUND_MSG = NbBundle.getMessage(SelectRootMethodsAction.class, (String)"SelectRootMethodsAction_NoClassFoundMsg");

    public SelectRootMethodsAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(SelectRootMethodsAction.class, (String)"LBL_SelectRootMethodsAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        final DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return;
        }
        new NBSwingWorker(){
            String className = null;

            protected void doInBackground() {
                int n = SourceUtils.getCurrentOffsetInEditor();
                if (n == -1) {
                    return;
                }
                SourceUtils.ResolvedClass resolvedClass = SourceUtils.resolveClassAtPosition((FileObject)dataObject.getPrimaryFile(), (int)n, (boolean)true);
                if (resolvedClass != null && resolvedClass.getJClass() != null) {
                    this.className = resolvedClass.getVMClassName();
                }
                if (this.className == null) {
                    this.className = SourceUtils.getEnclosingClassName((FileObject)dataObject.getPrimaryFile(), (int)n);
                }
                if (this.className == null) {
                    this.className = SourceUtils.getToplevelClassName((FileObject)dataObject.getPrimaryFile());
                }
            }

            protected void done() {
                if (this.className != null) {
                    Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
                    ProfilingSettings profilingSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
                    ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings2 : profilingSettings) {
                        if (!Utils.isCPUSettings(profilingSettings2.getProfilingType())) continue;
                        arrayList.add(profilingSettings2);
                    }
                    ProfilingSettings profilingSettings3 = IDEUtils.selectSettings(project, 16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                    if (profilingSettings3 == null) {
                        return;
                    }
                    ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = SelectRootMethodsForClassPanel.getDefault().getRootMethods(project, this.className, profilingSettings3.getInstrumentationRootMethods());
                    if (sourceCodeSelectionArray == null) {
                        return;
                    }
                    profilingSettings3.addRootMethods(sourceCodeSelectionArray);
                    if (arrayList.contains(profilingSettings3)) {
                        ProfilingSettingsManager.getDefault().storeProfilingSettings((ProfilingSettings[])profilingSettings, profilingSettings3, project);
                    } else {
                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[((ProfilingSettings)profilingSettings).length + 1];
                        System.arraycopy(profilingSettings, 0, profilingSettingsArray, 0, ((ProfilingSettings)profilingSettings).length);
                        profilingSettingsArray[((ProfilingSettings)profilingSettings).length] = profilingSettings3;
                        ProfilingSettingsManager.getDefault().storeProfilingSettings(profilingSettingsArray, profilingSettings3, project);
                    }
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(NO_CLASS_FOUND_MSG);
                }
            }
        }.execute();
    }
}

