/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.DrillDownWindow;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.TelemetryOverviewPanel;
import org.netbeans.modules.profiler.TelemetryWindow;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

public final class ProfilerModule
extends ModuleInstall {
    private static final String QUESTION_DIALOG_CAPTION = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_QuestionDialogCaption");
    private static final String EXITING_FROM_PROFILE_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_ExitingFromProfileMessage");
    private static final String EXITING_FROM_ATTACH_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_ExitingFromAttachMessage");
    public static final String LIBS_DIR = "lib";

    public boolean closing() {
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)EXITING_FROM_PROFILE_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return false;
                }
                Profiler.getDefault().stopApp();
            } else {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)EXITING_FROM_ATTACH_MESSAGE, QUESTION_DIALOG_CAPTION, 0);
                if (ProfilerDialogs.notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return false;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        if (!ResultsManager.getDefault().ideClosing()) {
            return false;
        }
        ProfilingPointsManager.getDefault().ideClosing();
        if (LiveResultsWindow.hasDefault()) {
            LiveResultsWindow.getDefault().ideClosing();
        }
        return true;
    }

    public void restored() {
        super.restored();
        MiscUtils.setVerbosePrint();
        MiscUtils.deleteHeapTempFiles();
        Profiler.getDefault();
    }

    public void uninstalled() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int n = Profiler.getDefault().getProfilingState();
                    int n2 = Profiler.getDefault().getProfilingMode();
                    if (n == 8 || n == 4) {
                        if (n2 == 1) {
                            Profiler.getDefault().stopApp();
                        } else {
                            Profiler.getDefault().detachFromApp();
                        }
                    }
                    ProfilerControlPanel2.closeIfOpened();
                    TelemetryOverviewPanel.closeIfOpened();
                    DrillDownWindow.closeIfOpened();
                    LiveResultsWindow.closeIfOpened();
                    TelemetryWindow.closeIfOpened();
                    ThreadsWindow.closeIfOpened();
                    SnapshotResultsWindow.closeAllWindows();
                    HeapWalkerManager.getDefault().closeAllHeapWalkers();
                    ((NetBeansProfiler)Profiler.getDefault()).shutdown();
                    new ResetResultsAction().actionPerformed(null);
                }
            });
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
        super.uninstalled();
    }
}

